# 通知設計書 32-CacheManifestWriteFailure

## 概要

本ドキュメントは、Zigコンパイラにおける「CacheManifestWriteFailure」通知の設計書である。キャッシュマニフェストファイルへの書き込みが失敗した場合に発生する警告通知を定義する。

### 本通知の処理概要

CacheManifestWriteFailure通知は、Zigコンパイラがコンパイル結果のキャッシュマニフェストを保存する際に、ディスクI/Oエラーなどにより書き込みが失敗した場合に出力される警告メッセージである。この通知はコンパイル自体の成功には影響しないが、次回コンパイル時にキャッシュミスが発生する可能性を示唆する。

**業務上の目的・背景**：Zigコンパイラはビルド高速化のため、コンパイル結果をキャッシュする仕組みを持つ。キャッシュマニフェストはコンパイルの入力（ソースファイル、依存関係、コンパイルオプション等）のハッシュ情報を記録し、再コンパイルの必要性を判断するために使用される。マニフェストの書き込み失敗は、次回の不必要な再コンパイルにつながる可能性があるため、開発者に警告として通知される。

**通知の送信タイミング**：各種コンパイル処理（Cオブジェクトコンパイル、Cインポート、Win32リソースコンパイル、libc stubsビルドなど）の完了後、マニフェスト書き込み時にエラーが発生した場合に送信される。

**通知の受信者**：コンパイルを実行している開発者。log.warn経由でコンパイルログに出力される。

**通知内容の概要**：書き込み失敗の対象（コンパイル対象ファイル名など）とエラー名が含まれる。

**期待されるアクション**：通常は即座の対応は不要だが、ディスク容量不足やファイルシステムのパーミッション問題が疑われる場合は、ビルド環境の確認が推奨される。

## 通知種別

ログ出力（log.warn）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（警告ログ出力） |
| 優先度 | 低（コンパイル成功には影響しない） |
| リトライ | 無（リトライなしで処理続行） |

### 送信先決定ロジック

`log.warn`関数を通じて、compilationスコープのログとして出力される。ログレベルがwarn以上に設定されている場合に標準エラー出力に表示される。

## 通知テンプレート

### ログ出力形式

| 項目 | 内容 |
|-----|------|
| ログレベル | warn |
| ログスコープ | compilation |
| 形式 | テキスト |
| 色 | 黄色（stderr端末出力時） |

### 本文テンプレート

```
failed to write cache manifest when compiling '{対象ファイルパス}': {エラー名}
```

または

```
failed to write cache manifest for {対象処理}: {エラー名}
```

### 添付ファイル

添付ファイルなし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| src_path | コンパイル対象ファイルパス | CObject.src.src_path / Win32Resource.src | Yes |
| error_name | エラー種別名 | @errorName(err) | Yes |
| 処理種別 | 対象処理の説明文 | 固定文字列 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| Cオブジェクトコンパイル | updateCObject完了 | man.writeManifest()がエラーを返す | Cソースのコンパイル後 |
| Cインポート | cImport完了 | man.writeManifest()がエラーを返す | @cImport処理後 |
| Win32リソース | updateWin32Resource完了 | man.writeManifest()がエラーを返す | リソースコンパイル後 |
| glibcスタブ | buildSharedLib完了 | man.writeManifest()がエラーを返す | glibcビルド後 |
| FreeBSDスタブ | buildSharedLib完了 | man.writeManifest()がエラーを返す | FreeBSDビルド後 |
| NetBSDスタブ | buildSharedLib完了 | man.writeManifest()がエラーを返す | NetBSDビルド後 |
| OpenBSDスタブ | buildSharedLib完了 | man.writeManifest()がエラーを返す | OpenBSDビルド後 |
| mingwスタブ | buildDllImportLib完了 | man.writeManifest()がエラーを返す | mingwビルド後 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| writeManifest成功 | エラーが発生しない場合は警告は出力されない |
| have_exclusive_lock無効 | ロックを持っていない場合は書き込みを試みない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[コンパイル処理完了] --> B{exclusive lock保持?}
    B -->|No| C[マニフェスト書き込みスキップ]
    B -->|Yes| D[writeManifest呼び出し]
    D --> E{書き込み成功?}
    E -->|Yes| F[正常終了]
    E -->|No| G[log.warn出力]
    G --> H[処理続行]
    C --> F
    H --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| Cache.Manifest | キャッシュマニフェスト情報 | ハッシュ、ファイルリスト等を保持 |
| CObject | Cオブジェクト情報 | src.src_pathを参照 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ディスク容量不足 | キャッシュディレクトリの空き容量不足 | 警告出力し処理続行 |
| パーミッションエラー | 書き込み権限なし | 警告出力し処理続行 |
| I/Oエラー | その他のファイルシステムエラー | 警告出力し処理続行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（コンパイル時に即座に出力）

## セキュリティ考慮事項

- ログメッセージにはファイルパスが含まれるため、共有環境でのログ出力時には機密情報の露出に注意
- キャッシュディレクトリのパーミッション設定が適切であることを前提とする

## 備考

- この警告はコンパイルの成功には影響しない
- 次回コンパイル時にキャッシュミスが発生する可能性がある
- ビルドの再現性には影響しないが、ビルド時間に影響する可能性がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Cache.Manifestの構造とキャッシュシステムの概念を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Cache.zig | `lib/std/Build/Cache.zig` | Manifest構造体の定義、writeManifest関数 |

**読解のコツ**: Manifestはコンパイル入力のハッシュ情報を保持し、キャッシュヒット判定に使用される。

#### Step 2: エントリーポイントを理解する

writeManifestが呼び出される主要な箇所を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Compilation.zig | `src/Compilation.zig` | 6552行: Cオブジェクトコンパイル後 |
| 2-2 | Compilation.zig | `src/Compilation.zig` | 5930行: Cインポート後 |
| 2-3 | Compilation.zig | `src/Compilation.zig` | 6693行: Win32リソースコンパイル後（マニフェストファイル） |
| 2-4 | Compilation.zig | `src/Compilation.zig` | 6801行: Win32リソースコンパイル後（RCソース） |
| 2-5 | Compilation.zig | `src/Compilation.zig` | 3262行: 一般的なキャッシュ書き込み |

**主要処理フロー**:
1. **6547行**: have_exclusive_lockの確認
2. **6552行**: writeManifest()の呼び出し
3. **6553-6555行**: エラー時のlog.warn出力

#### Step 3: ライブラリビルドでの使用箇所

各種ライブラリスタブビルドでの使用箇所。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | glibc.zig | `src/libs/glibc.zig` | 1126行: glibcスタブビルド後 |
| 3-2 | freebsd.zig | `src/libs/freebsd.zig` | 982行: FreeBSDスタブビルド後 |
| 3-3 | netbsd.zig | `src/libs/netbsd.zig` | 636行: NetBSDスタブビルド後 |
| 3-4 | openbsd.zig | `src/libs/openbsd.zig` | 565行: OpenBSDスタブビルド後 |
| 3-5 | mingw.zig | `src/libs/mingw.zig` | 400行: mingw DLLインポートライブラリビルド後 |

**主要処理フロー**:
- **共通パターン**: `man.writeManifest() catch |err| { log.warn("failed to write cache manifest for {対象}: {s}", .{@errorName(err)}); };`

### プログラム呼び出し階層図

```
Compilation.update()
    │
    ├─ updateCObject()
    │      └─ man.writeManifest() catch log.warn(...)
    │
    ├─ cImport()
    │      └─ man.writeManifest() catch log.warn(...)
    │
    ├─ updateWin32Resource()
    │      └─ man.writeManifest() catch log.warn(...)
    │
    └─ libs/glibc.zig::buildSharedObjects()
           └─ man.writeManifest() catch log.warn(...)

（同様に freebsd.zig, netbsd.zig, openbsd.zig, mingw.zig）
```

### データフロー図

```
[入力]                     [処理]                          [出力]

コンパイル完了 ───▶ exclusive lock確認
                            │
                            ▼
                    writeManifest()呼び出し
                            │
        ┌───────────────────┴───────────────────┐
        ▼                                       ▼
    書き込み成功                            書き込み失敗
        │                                       │
        ▼                                       ▼
    通常終了                              log.warn出力
        │                                       │
        └────────────────┬─────────────────────┘
                         ▼
                   処理続行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Compilation.zig | `src/Compilation.zig` | ソース | Cオブジェクト/Cインポート/Win32リソースコンパイル |
| Cache.zig | `lib/std/Build/Cache.zig` | ソース | キャッシュシステム実装、Manifest構造体 |
| glibc.zig | `src/libs/glibc.zig` | ソース | glibcスタブビルド |
| freebsd.zig | `src/libs/freebsd.zig` | ソース | FreeBSDスタブビルド |
| netbsd.zig | `src/libs/netbsd.zig` | ソース | NetBSDスタブビルド |
| openbsd.zig | `src/libs/openbsd.zig` | ソース | OpenBSDスタブビルド |
| mingw.zig | `src/libs/mingw.zig` | ソース | mingw DLLインポートライブラリビルド |
