# 通知設計書 33-AstGenCacheStale

## 概要

本ドキュメントは、Zigコンパイラにおける「AstGenCacheStale」通知の設計書である。キャッシュされたZIR（Zig Intermediate Representation）コードが古くなり、再生成が必要な状態であることを示すデバッグログを定義する。

### 本通知の処理概要

AstGenCacheStale通知は、Zigコンパイラがソースファイルのコンパイル時にZIRキャッシュを確認した際、キャッシュが陳腐化（stale）していて再生成が必要な状態を検出した場合に出力されるデバッグメッセージである。キャッシュの有効性チェックの結果を開発者やコンパイラ開発者に伝える内部診断情報として機能する。

**業務上の目的・背景**：Zigコンパイラはインクリメンタルコンパイルの高速化のため、ソースファイルからZIR（中間表現）への変換結果をキャッシュする。しかし、ソースファイルが変更された場合やキャッシュのメタデータが一致しない場合、キャッシュは無効となり再生成が必要となる。本通知は、キャッシュが無効化された理由（stale状態）をデバッグログとして出力し、コンパイラの動作を追跡可能にする。

**通知の送信タイミング**：ソースファイルのAstGen処理時に、キャッシュファイルの読み込み・検証を行い、キャッシュがstale状態であると判定された場合に送信される。

**通知の受信者**：デバッグログを有効にしている開発者、またはコンパイラ開発者。

**通知内容の概要**：stale状態となったファイルのパス情報が含まれる。

**期待されるアクション**：通常は特別なアクションは不要。キャッシュミスが頻発する場合は、ビルドシステムの設定やファイルの変更頻度を確認する。

## 通知種別

デバッグログ出力（log.debug）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（デバッグログ出力） |
| 優先度 | 最低（デバッグ用途） |
| リトライ | 無 |

### 送信先決定ロジック

`log.debug`関数を通じて、zcuスコープのログとして出力される。デバッグログレベルが有効な場合のみ標準エラー出力に表示される。

## 通知テンプレート

### ログ出力形式

| 項目 | 内容 |
|-----|------|
| ログレベル | debug |
| ログスコープ | zcu |
| 形式 | テキスト |
| 色 | マゼンタ（stderr端末出力時） |

### 本文テンプレート

```
AstGen cache stale: {ファイルパス}
```

### 添付ファイル

添付ファイルなし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| file_path | 対象Zigソースファイルのパス | file.path.fmt(comp) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ファイル更新 | updateFile実行 | loadZirZoirCacheがstaleを返す | キャッシュ検証でstale判定 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| キャッシュヒット | loadZirZoirCacheがsuccessを返す場合 |
| デバッグログ無効 | ログレベルがdebug未満の場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[updateFile開始] --> B[キャッシュファイル読み込み]
    B --> C[loadZirZoirCache呼び出し]
    C --> D{キャッシュ状態?}
    D -->|success| E[キャッシュヒット - ログ出力]
    D -->|stale| F[log.debug: AstGen cache stale]
    D -->|truncated| G[log.warn: unexpected EOF]
    D -->|invalid| H[無効 - ログなし]
    E --> I[キャッシュ使用]
    F --> J[AstGen再実行]
    G --> J
    H --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| Zcu.File | ソースファイル情報 | path、stat、zirなどを保持 |
| Cache.File | キャッシュファイル | ZIRキャッシュの実体 |

## エラー処理

### エラーケース一覧

本通知自体はエラーではなく、情報提供のみ。

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（コンパイル時に即座に出力）

## セキュリティ考慮事項

- ログメッセージにはファイルパスが含まれるが、デバッグログは通常非公開環境でのみ有効化されるため、影響は限定的

## 備考

- `--time-report`オプション使用時は、キャッシュヒットでもAstGenが再実行される（パフォーマンス計測のため）
- ZONファイル（.zon）の場合も同様の通知が発生する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

キャッシュ状態を表す列挙型とファイル構造体を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PerThread.zig | `src/Zcu/PerThread.zig` | loadZirZoirCacheの戻り値型（success/stale/truncated/invalid） |
| 1-2 | Zcu.zig | `src/Zcu.zig` | File構造体の定義 |

**読解のコツ**: キャッシュ検証結果は列挙型で表現され、それぞれの状態に応じた処理が分岐する。

#### Step 2: エントリーポイントを理解する

キャッシュ検証とstale判定の流れを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PerThread.zig | `src/Zcu/PerThread.zig` | updateFile関数（79行目）がエントリーポイント |

**主要処理フロー**:
1. **223-226行**: loadZirZoirCacheの呼び出し
2. **227-235行**: 結果に応じた分岐処理
3. **234行**: stale状態でのlog.debug出力

#### Step 3: キャッシュ検証ロジック

loadZirZoirCache関数の内部処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PerThread.zig | `src/Zcu/PerThread.zig` | loadZirZoirCache関数の実装 |

**主要処理フロー**:
- ファイルのstat情報（サイズ、mtime、inode）を比較
- 一致しない場合はstaleを返す

### プログラム呼び出し階層図

```
Compilation.update()
    │
    └─ PerThread.updateFile()
           │
           ├─ loadZirZoirCache()
           │      └─ キャッシュ状態判定
           │
           ├─ (stale時) log.debug("AstGen cache stale: ...")
           │
           └─ (stale時) AstGen.generate() [再生成]
```

### データフロー図

```
[入力]                     [処理]                          [出力]

ソースファイル ───▶ stat情報取得
                            │
                            ▼
キャッシュファイル ───▶ キャッシュ検証
                            │
        ┌───────────────────┴───────────────────┐
        ▼                                       ▼
    stat一致                               stat不一致
        │                                       │
        ▼                                       ▼
    success                                  stale
        │                                       │
        ▼                                       ▼
    キャッシュ使用                        log.debug出力
                                               │
                                               ▼
                                          AstGen再実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PerThread.zig | `src/Zcu/PerThread.zig` | ソース | updateFile、loadZirZoirCacheの実装 |
| Zcu.zig | `src/Zcu.zig` | ソース | File構造体、saveZirCacheの実装 |
| AstGen.zig | `lib/std/zig/AstGen.zig` | ソース | ZIR生成処理 |
