# 通知設計書 34-AstGenCacheCached

## 概要

本ドキュメントは、Zigコンパイラにおける「AstGenCacheCached」通知の設計書である。キャッシュされたZIR（Zig Intermediate Representation）コードが有効であり、再利用可能な状態であることを示すデバッグログを定義する。

### 本通知の処理概要

AstGenCacheCached通知は、Zigコンパイラがソースファイルのコンパイル時にZIRキャッシュを確認した際、キャッシュが有効であり再生成なしで使用可能な状態を検出した場合に出力されるデバッグメッセージである。キャッシュヒットによる高速コンパイルが実現されていることを開発者やコンパイラ開発者に伝える内部診断情報として機能する。

**業務上の目的・背景**：Zigコンパイラはインクリメンタルコンパイルの高速化のため、ソースファイルからZIR（中間表現）への変換結果をキャッシュする。ソースファイルが変更されていない場合、キャッシュされたZIRを再利用することでAstGen処理をスキップし、ビルド時間を大幅に短縮できる。本通知は、キャッシュが有効活用されていることをデバッグログとして出力し、コンパイラの最適化動作を確認可能にする。

**通知の送信タイミング**：ソースファイルのAstGen処理時に、キャッシュファイルの読み込み・検証を行い、キャッシュが有効であると判定された場合に送信される。

**通知の受信者**：デバッグログを有効にしている開発者、またはコンパイラ開発者。

**通知内容の概要**：キャッシュヒットしたファイルのパス情報が含まれる。

**期待されるアクション**：通常は特別なアクションは不要。キャッシュヒット率を確認することで、ビルドシステムの効率を評価できる。

## 通知種別

デバッグログ出力（log.debug）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（デバッグログ出力） |
| 優先度 | 最低（デバッグ用途） |
| リトライ | 無 |

### 送信先決定ロジック

`log.debug`関数を通じて、zcuスコープのログとして出力される。デバッグログレベルが有効な場合のみ標準エラー出力に表示される。

## 通知テンプレート

### ログ出力形式

| 項目 | 内容 |
|-----|------|
| ログレベル | debug |
| ログスコープ | zcu |
| 形式 | テキスト |
| 色 | マゼンタ（stderr端末出力時） |

### 本文テンプレート

```
AstGen cached success: {ファイルパス}
```

### 添付ファイル

添付ファイルなし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| file_path | 対象Zigソースファイルのパス | file.path.fmt(comp) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ファイル更新 | updateFile実行 | loadZirZoirCacheがsuccessを返す | キャッシュ検証でhit判定 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| キャッシュミス | loadZirZoirCacheがsuccess以外を返す場合 |
| --time-report有効 | パフォーマンス計測のためキャッシュを無視する |
| デバッグログ無効 | ログレベルがdebug未満の場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[updateFile開始] --> B[キャッシュファイル読み込み]
    B --> C[loadZirZoirCache呼び出し]
    C --> D{キャッシュ状態?}
    D -->|success| E{--time-report有効?}
    D -->|その他| F[AstGen再実行へ]
    E -->|No| G[log.debug: AstGen cached success]
    E -->|Yes| H[キャッシュ無視 - AstGen再実行]
    G --> I[キャッシュからZIR使用]
    H --> J[AstGen再実行]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| Zcu.File | ソースファイル情報 | path、stat、zirなどを保持 |
| Cache.File | キャッシュファイル | ZIRキャッシュの実体 |

## エラー処理

### エラーケース一覧

本通知自体はエラーではなく、情報提供のみ。

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（コンパイル時に即座に出力）

## セキュリティ考慮事項

- ログメッセージにはファイルパスが含まれるが、デバッグログは通常非公開環境でのみ有効化されるため、影響は限定的

## 備考

- `--time-report`オプション使用時は、キャッシュヒットでもAstGenが再実行される（パフォーマンス計測のため）
- ZONファイル（.zon）の場合も同様の通知が発生する
- AstGen再実行時は "AstGen fresh success:" というメッセージが出力される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

キャッシュ状態を表す列挙型とファイル構造体を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PerThread.zig | `src/Zcu/PerThread.zig` | loadZirZoirCacheの戻り値型（success/stale/truncated/invalid） |
| 1-2 | Zcu.zig | `src/Zcu.zig` | File構造体の定義 |

**読解のコツ**: キャッシュ検証結果は列挙型で表現され、successの場合にキャッシュが使用される。

#### Step 2: エントリーポイントを理解する

キャッシュ検証とヒット判定の流れを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PerThread.zig | `src/Zcu/PerThread.zig` | updateFile関数（79行目）がエントリーポイント |

**主要処理フロー**:
1. **220-221行**: --time-reportオプションの確認（ignore_hit）
2. **223-226行**: loadZirZoirCacheの呼び出し
3. **227-230行**: success時の処理分岐
4. **229行**: キャッシュヒット時のlog.debug出力

#### Step 3: キャッシュ有効性判定

loadZirZoirCache関数の内部処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PerThread.zig | `src/Zcu/PerThread.zig` | loadZirZoirCache関数の実装 |

**主要処理フロー**:
- ファイルのstat情報（サイズ、mtime、inode）を比較
- 全て一致する場合はsuccessを返す

### プログラム呼び出し階層図

```
Compilation.update()
    │
    └─ PerThread.updateFile()
           │
           ├─ loadZirZoirCache()
           │      └─ キャッシュ状態判定
           │
           └─ (success時) log.debug("AstGen cached success: ...")
                   │
                   └─ キャッシュからZIRを使用（AstGenスキップ）
```

### データフロー図

```
[入力]                     [処理]                          [出力]

ソースファイル ───▶ stat情報取得
                            │
                            ▼
キャッシュファイル ───▶ キャッシュ検証
                            │
        ┌───────────────────┴───────────────────┐
        ▼                                       ▼
    stat一致                               stat不一致
        │                                       │
        ▼                                       ▼
    success                              stale/invalid
        │                                       │
        ├─────────────────┐                     ▼
        ▼                 ▼                AstGen再実行
   --time-report?    通常モード
        │                 │
        ▼                 ▼
   AstGen再実行    log.debug出力
                          │
                          ▼
                    キャッシュZIR使用
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PerThread.zig | `src/Zcu/PerThread.zig` | ソース | updateFile、loadZirZoirCacheの実装 |
| Zcu.zig | `src/Zcu.zig` | ソース | File構造体、saveZirCacheの実装 |
| AstGen.zig | `lib/std/zig/AstGen.zig` | ソース | ZIR生成処理 |
