# 通知設計書 35-compilation

## 概要

本ドキュメントは、Zigコンパイラにおける「compilation」スコープログの設計書である。コンパイル処理全般に関するログメッセージのスコープを定義する。

### 本通知の処理概要

compilationスコープログは、Zigコンパイラの中核であるCompilation.zig内で使用されるログスコープである。コンパイル処理全般に関する情報、警告、エラー、デバッグメッセージを分類・出力するために使用される。このスコープにより、コンパイル処理に関連するログをフィルタリング・識別することが可能となる。

**業務上の目的・背景**：Zigコンパイラは複数のサブシステム（AstGen、Sema、コード生成、リンカーなど）から構成されており、それぞれが異なるログスコープを使用する。compilationスコープは、これらのサブシステムを統合するコンパイル処理全体のログを担当し、キャッシュ管理、ジョブキューイング、Cオブジェクトコンパイル、Win32リソース処理などの横断的な処理のログを出力する。

**通知の送信タイミング**：Compilation.zig内の各処理ポイントで、対応するログレベル（debug/info/warn/err）に応じてログが出力される。

**通知の受信者**：開発者、コンパイラ開発者。ログレベル設定に応じて標準エラー出力に表示される。

**通知内容の概要**：キャッシュヒット/ミス情報、ジョブキュー状態、コンパイルエラー情報、警告メッセージなど、コンパイル処理全般に関する情報が含まれる。

**期待されるアクション**：ログメッセージの内容に応じて、エラー修正、設定調整、パフォーマンス最適化などを行う。

## 通知種別

スコープログ（std.log.scoped）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ログ出力） |
| 優先度 | ログレベルに依存 |
| リトライ | 無 |

### 送信先決定ロジック

`std.log.scoped(.compilation)`により生成されたログ関数を使用。Zigの標準ログシステムにより、ログレベルに応じてstderrに出力される。

## 通知テンプレート

### ログ出力形式

| 項目 | 内容 |
|-----|------|
| ログレベル | err / warn / info / debug |
| ログスコープ | compilation |
| 形式 | テキスト |
| 色 | レベル依存（err:赤、warn:黄、info:緑、debug:マゼンタ） |

### 出力例

```
debug(compilation): queuing a job to build compiler_rt_lib
debug(compilation): CacheMode.whole cache hit for {name}
warn(compilation): failed to write cache manifest: {error}
err(compilation): clang failed with stderr: {stderr}
```

### 添付ファイル

添付ファイルなし

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | ログレベル | 説明 |
|------------|----------------|-----------|------|
| ジョブキュー | ビルドジョブ追加 | debug | compiler_rt、ubsan_rt、libfuzzerなど |
| キャッシュ確認 | キャッシュヒット/ミス判定 | debug | CacheMode.whole時 |
| マニフェスト書き込み | 書き込み失敗 | warn | キャッシュマニフェストI/Oエラー |
| Cオブジェクト更新 | 更新開始 | debug | Cソースファイルのコンパイル |
| Clangエラー | Clangプロセス失敗 | err | Clangの診断メッセージ |
| Cインポート | verbose_cimport有効時 | info | Cヘッダーインポート処理 |
| 一時ファイル削除失敗 | ファイル削除エラー | warn | 一時ディレクトリのクリーンアップ |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ログレベル設定 | 設定されたログレベルより低い優先度のログは出力されない |

## 処理フロー

### ログスコープ使用パターン

```mermaid
flowchart TD
    A[Compilation処理開始] --> B{処理種別}
    B -->|キャッシュ確認| C[log.debug: cache hit/miss]
    B -->|ジョブキュー| D[log.debug: queuing job]
    B -->|Cオブジェクト| E[log.debug: updating C object]
    B -->|エラー発生| F{エラー種別}
    F -->|I/Oエラー| G[log.warn: failed to ...]
    F -->|Clangエラー| H[log.err: clang failed]
    F -->|致命的| I[std.process.fatal]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

## エラー処理

### エラーケース一覧

スコープログ自体はエラーを発生させない。エラーメッセージの出力のみを行う。

### リトライ仕様

N/A

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ログメッセージにはファイルパス、エラーメッセージなどが含まれる可能性がある
- 本番環境ではログレベルを適切に設定してデバッグ情報の露出を制限することを推奨

## 備考

- スコープログはZigの標準ライブラリのログシステムを使用
- `ZIG_LOG`環境変数でスコープごとのログレベルを制御可能
- 例: `ZIG_LOG=compilation:debug` で compilationスコープのデバッグログを有効化

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ログスコープの定義を理解する

compilationスコープの定義箇所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Compilation.zig | `src/Compilation.zig` | 11行目: `const log = std.log.scoped(.compilation);` |

**読解のコツ**: `std.log.scoped`はZig標準ライブラリの関数で、指定されたスコープ名でログ関数群を生成する。

#### Step 2: ログ使用箇所を理解する

各ログレベルの使用例を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Compilation.zig | `src/Compilation.zig` | 2687行: ジョブキューのdebugログ |
| 2-2 | Compilation.zig | `src/Compilation.zig` | 3003行: キャッシュヒットのdebugログ |
| 2-3 | Compilation.zig | `src/Compilation.zig` | 3263行: マニフェスト書き込み失敗のwarnログ |
| 2-4 | Compilation.zig | `src/Compilation.zig` | 6461行: Clangエラーのerrログ |

**主要ログパターン**:
- **debug**: 内部状態の追跡（キャッシュ、ジョブ、更新処理）
- **info**: verbose_cimport時の情報出力
- **warn**: 非致命的エラー（I/O失敗、クリーンアップ失敗）
- **err**: 外部プロセスエラー（Clang、rcなど）

### プログラム呼び出し階層図

```
Compilation.zig
    │
    ├─ log = std.log.scoped(.compilation) [11行目]
    │
    ├─ log.debug() 使用箇所
    │      ├─ queuing a job to build ... [2687-2715行]
    │      ├─ CacheMode.whole cache hit/miss [3003, 3012行]
    │      ├─ updating C object [6236行]
    │      └─ updating win32 resource [6591行]
    │
    ├─ log.info() 使用箇所
    │      └─ verbose_cimport時 [5773, 5828, 5876行]
    │
    ├─ log.warn() 使用箇所
    │      ├─ failed to write cache manifest [3263, 5931, 6553, 6693, 6801行]
    │      └─ failed to delete [2873, 2894, 5848, 6406, 6410行]
    │
    └─ log.err() 使用箇所
           ├─ clang failed [6456, 6461, 6465, 6469行]
           └─ zig rc failed [6875, 6880, 6884行]
```

### データフロー図

```
[入力]                     [処理]                          [出力]

処理イベント ───▶ ログレベル判定 ───▶ ログメッセージ生成
                            │
                            ▼
                    スコープ付加
                    (compilation)
                            │
                            ▼
                    stderr出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Compilation.zig | `src/Compilation.zig` | ソース | compilationスコープの主な使用ファイル |
| log.zig | `lib/std/log.zig` | 標準ライブラリ | ログシステムの実装 |
