# 通知設計書 36-zcu

## 概要

本ドキュメントは、Zigコンパイラにおける「zcu」スコープログの設計書である。Zig Compilation Unit（ZCU）処理に関するログメッセージのスコープを定義する。

### 本通知の処理概要

zcuスコープログは、Zigコンパイラの中核モジュールであるZcu.zigおよびZcu/PerThread.zigで使用されるログスコープである。Zig Compilation Unit（ZCU）は単一のコンパイル単位を表し、インクリメンタルコンパイル、依存関係追跡、AstGen処理などの重要な機能を担当する。

**業務上の目的・背景**：インクリメンタルコンパイルでは、ソースファイルの変更による依存関係の再計算が頻繁に行われる。zcuスコープログは、どの依存関係が更新されたか（outdated）、最新状態か（up-to-date）、または更新の可能性があるか（potentially outdated）を追跡するためのデバッグ情報を提供する。これにより、コンパイラ開発者はインクリメンタルコンパイルの動作を詳細に分析できる。

**通知の送信タイミング**：依存関係の状態変更時、ファイル更新確認時、AstGenキャッシュ処理時などに出力される。

**通知の受信者**：コンパイラ開発者。デバッグログレベルが有効な場合にstderrに出力される。

**通知内容の概要**：依存関係の状態遷移、キャッシュ状態、型・ユニットの参照情報などが含まれる。

**期待されるアクション**：インクリメンタルコンパイルの動作分析、パフォーマンス最適化、バグ調査に使用する。

## 通知種別

スコープログ（std.log.scoped）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ログ出力） |
| 優先度 | ログレベルに依存 |
| リトライ | 無 |

### 送信先決定ロジック

`std.log.scoped(.zcu)`により生成されたログ関数を使用。Zigの標準ログシステムにより、ログレベルに応じてstderrに出力される。

## 通知テンプレート

### ログ出力形式

| 項目 | 内容 |
|-----|------|
| ログレベル | debug / warn |
| ログスコープ | zcu |
| 形式 | テキスト |
| 色 | レベル依存（warn:黄、debug:マゼンタ） |

### 出力例

```
debug(zcu): outdated dependee: {dependee}
debug(zcu): up-to-date dependee: {dependee}
debug(zcu): AstGen cache stale: {file_path}
debug(zcu): AstGen cached success: {file_path}
warn(zcu): unable to write cached ZIR code for {file}: {error}
```

### 添付ファイル

添付ファイルなし

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | ログレベル | 説明 |
|------------|----------------|-----------|------|
| 依存関係更新 | markDependeeOutdated | debug | 依存先が更新された |
| 依存関係最新 | markDependeeUpToDate | debug | 依存先が最新状態 |
| 依存関係PO | markPotentiallyOutdated | debug | 更新可能性あり |
| 解析対象検索 | findOutdatedToAnalyze | debug | 再解析対象の決定 |
| AstGenキャッシュ | loadZirZoirCache | debug | キャッシュヒット/ミス |
| ZIR保存失敗 | saveZirCache | warn | キャッシュ書き込み失敗 |
| 型処理 | resolveReferences | debug | 型の参照解決 |
| ユニット処理 | resolveReferences | debug | 解析ユニットの参照解決 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ログレベル設定 | 設定されたログレベルより低い優先度のログは出力されない |

## 処理フロー

### ログスコープ使用パターン

```mermaid
flowchart TD
    A[ZCU処理] --> B{処理種別}
    B -->|依存関係追跡| C[log.debug: outdated/up-to-date]
    B -->|AstGen| D[log.debug: cache stale/cached]
    B -->|参照解決| E[log.debug: handle type/unit]
    B -->|キャッシュ保存失敗| F[log.warn: unable to write]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| InternPool.Dependee | 依存関係表現 | outdated/up-to-date判定 |
| AnalUnit | 解析単位 | 再解析対象の追跡 |

## エラー処理

### エラーケース一覧

スコープログ自体はエラーを発生させない。

### リトライ仕様

N/A

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ログメッセージにはファイルパス、型名などが含まれる可能性がある
- デバッグログは開発環境でのみ有効化することを推奨

## 備考

- zcuスコープはZcu.zigとZcu/PerThread.zigの両方で使用される
- インクリメンタルコンパイルのデバッグに特に有用

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ログスコープの定義を理解する

zcuスコープの定義箇所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Zcu.zig | `src/Zcu.zig` | 16行目: `const log = std.log.scoped(.zcu);` |
| 1-2 | PerThread.zig | `src/Zcu/PerThread.zig` | 12行目: `const log = std.log.scoped(.zcu);` |

**読解のコツ**: 両ファイルで同じスコープを使用することで、ZCU関連のログが統一的に管理される。

#### Step 2: 依存関係追跡ログを理解する

インクリメンタルコンパイルの依存関係追跡ログを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Zcu.zig | `src/Zcu.zig` | 3066行: markDependeeOutdated |
| 2-2 | Zcu.zig | `src/Zcu.zig` | 3112行: markDependeeUpToDate |
| 2-3 | Zcu.zig | `src/Zcu.zig` | 3168行: markPotentiallyOutdated |
| 2-4 | Zcu.zig | `src/Zcu.zig` | 3202-3268行: findOutdatedToAnalyze |

**主要ログパターン**:
- `outdated dependee`: 依存先が更新された
- `up-to-date dependee`: 依存先が最新
- `outdated ready`: 再解析準備完了
- `po`: potentially outdated状態

#### Step 3: AstGenキャッシュログを理解する

AstGen処理でのキャッシュ関連ログを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PerThread.zig | `src/Zcu/PerThread.zig` | 229行: AstGen cached success |
| 3-2 | PerThread.zig | `src/Zcu/PerThread.zig` | 234行: AstGen cache stale |
| 3-3 | PerThread.zig | `src/Zcu/PerThread.zig` | 278行: unable to write cached ZIR |

### プログラム呼び出し階層図

```
Zcu.zig
    │
    ├─ log = std.log.scoped(.zcu) [16行目]
    │
    ├─ 依存関係追跡
    │      ├─ markDependeeOutdated() [3066行]
    │      │      └─ log.debug("outdated dependee: ...")
    │      ├─ markDependeeUpToDate() [3112行]
    │      │      └─ log.debug("up-to-date dependee: ...")
    │      └─ markPotentiallyOutdated() [3168行]
    │             └─ log.debug("po ...")
    │
    └─ 参照解決
           └─ resolveReferences() [4052行〜]
                  └─ log.debug("handle type/unit: ...")

Zcu/PerThread.zig
    │
    ├─ log = std.log.scoped(.zcu) [12行目]
    │
    └─ AstGen処理
           ├─ log.debug("AstGen cached success: ...") [229行]
           ├─ log.debug("AstGen cache stale: ...") [234行]
           └─ log.warn("unable to write cached ZIR: ...") [278行]
```

### データフロー図

```
[入力]                     [処理]                          [出力]

依存関係変更 ───▶ 状態判定 ───▶ log.debug出力
                            │
AstGen要求 ───▶ キャッシュ確認 ───▶ log.debug出力
                            │
キャッシュ保存 ───▶ I/O処理 ───▶ (失敗時) log.warn出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Zcu.zig | `src/Zcu.zig` | ソース | ZCUメイン処理、依存関係追跡 |
| PerThread.zig | `src/Zcu/PerThread.zig` | ソース | スレッドごとの処理、AstGen |
| InternPool.zig | `src/InternPool.zig` | ソース | Dependee、AnalUnit定義 |
