# 通知設計書 37-link

## 概要

本ドキュメントは、Zigコンパイラにおける「link」スコープログの設計書である。リンカー処理に関するログメッセージのスコープを定義する。

### 本通知の処理概要

linkスコープログは、Zigコンパイラのリンカー処理を担当する複数のファイルで使用されるログスコープである。ELF、MachO、COFF、Wasmなど、各種バイナリフォーマットのリンク処理に関する情報、警告、エラー、デバッグメッセージを出力する。

**業務上の目的・背景**：リンカーはコンパイルの最終段階でオブジェクトファイルを結合し、実行可能ファイルや共有ライブラリを生成する。リンク処理は複雑であり、シンボル解決、再配置、セクション配置など多くの処理が含まれる。linkスコープログは、これらの処理の状態をデバッグ・診断するための情報を提供する。

**通知の送信タイミング**：リンク処理の各段階（シンボル解決、ptrace操作、メモリ割り当てなど）で出力される。

**通知の受信者**：開発者、コンパイラ開発者。ログレベル設定に応じて標準エラー出力に表示される。

**通知内容の概要**：シンボル解決状態、ptrace操作結果、ライブラリ検索状態、行番号更新などが含まれる。

**期待されるアクション**：リンクエラーのデバッグ、シンボル解決問題の調査、パフォーマンス最適化に使用する。

## 通知種別

スコープログ（std.log.scoped）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ログ出力） |
| 優先度 | ログレベルに依存 |
| リトライ | 無 |

### 送信先決定ロジック

`std.log.scoped(.link)`により生成されたログ関数を使用。多数のlink/*.zigファイルで使用される。

## 通知テンプレート

### ログ出力形式

| 項目 | 内容 |
|-----|------|
| ログレベル | err / warn / debug |
| ログスコープ | link |
| 形式 | テキスト |
| 色 | レベル依存 |

### 出力例

```
debug(link): getGlobalSymbol '{symbol_name}' (expected in '{lib_name}')
debug(link): memory allocation failure
warn(link): ptrace failure: {error}
err(link): update line number failed: {error}
```

### 添付ファイル

添付ファイルなし

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | ログレベル | 説明 |
|------------|----------------|-----------|------|
| シンボル解決 | getGlobalSymbol | debug | グローバルシンボルの検索 |
| メモリ割り当て失敗 | alloc failure | debug | リンカーのメモリ確保失敗 |
| ptrace操作 | ptrace call | warn | ptrace操作の失敗 |
| アタッチ失敗 | attach/detach | warn | プロセスアタッチの失敗 |
| 行番号更新 | updateLineNumber | err | デバッグ情報更新の失敗 |
| ライブラリ検索 | findSystemLibrary | err | システムライブラリ検索 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ログレベル設定 | 設定されたログレベルより低い優先度のログは出力されない |

## 処理フロー

### ログスコープ使用パターン

```mermaid
flowchart TD
    A[リンク処理] --> B{処理種別}
    B -->|シンボル解決| C[log.debug: getGlobalSymbol]
    B -->|ptrace| D[log.warn: ptrace failure]
    B -->|デバッグ情報| E[log.err: update line number]
    B -->|ライブラリ検索| F[log.err: unable to find]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

## エラー処理

### エラーケース一覧

スコープログ自体はエラーを発生させない。

### リトライ仕様

N/A

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ログメッセージにはシンボル名、ライブラリパスなどが含まれる可能性がある
- デバッグログは開発環境でのみ有効化することを推奨

## 備考

- linkスコープは多数のファイル（link.zig、link/Elf.zig、link/MachO.zigなど）で使用される
- 31個以上のファイルでこのスコープが使用されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ログスコープの定義を理解する

linkスコープの定義箇所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | link.zig | `src/link.zig` | 9行目: `const log = std.log.scoped(.link);` |

**読解のコツ**: linkスコープは複数のファイルで定義されるが、すべて同じスコープ名を使用する。

#### Step 2: 主要なログ使用箇所を理解する

各リンカー実装でのログ使用を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | link.zig | `src/link.zig` | 367行: memory allocation failure |
| 2-2 | link.zig | `src/link.zig` | 632行: ptrace failure |
| 2-3 | link.zig | `src/link.zig` | 759行: getGlobalSymbol |
| 2-4 | link.zig | `src/link.zig` | 1580行: update line number failed |
| 2-5 | link.zig | `src/link.zig` | 2014行: unable to find system library |

**主要ログパターン**:
- **debug**: シンボル解決、メモリ割り当て
- **warn**: ptrace操作失敗、アタッチ失敗
- **err**: 行番号更新失敗、ライブラリ検索失敗

### プログラム呼び出し階層図

```
link.zig
    │
    ├─ log = std.log.scoped(.link) [9行目]
    │
    ├─ log.debug() 使用箇所
    │      ├─ memory allocation failure [367行]
    │      └─ getGlobalSymbol [759行]
    │
    ├─ log.warn() 使用箇所
    │      ├─ ptrace failure [632, 701行]
    │      └─ attaching/detaching failed [637, 717行]
    │
    └─ log.err() 使用箇所
           ├─ update line number failed [1580行]
           └─ unable to find system library [2014行]

link/Elf.zig, link/MachO.zig, ... (多数のファイル)
    └─ 各フォーマット固有のログ出力
```

### データフロー図

```
[入力]                     [処理]                          [出力]

リンク要求 ───▶ シンボル解決 ───▶ log.debug出力
                            │
                            ▼
                    オブジェクト結合
                            │
                            ▼
                    再配置処理
                            │
                    (エラー時)
                            ▼
                    log.warn/err出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| link.zig | `src/link.zig` | ソース | リンカー共通処理 |
| Elf.zig | `src/link/Elf.zig` | ソース | ELFフォーマット処理 |
| MachO.zig | `src/link/MachO.zig` | ソース | Mach-Oフォーマット処理 |
| Coff.zig | `src/link/Coff.zig` | ソース | COFFフォーマット処理 |
| Wasm.zig | `src/link/Wasm.zig` | ソース | WebAssembly処理 |
| SpirV.zig | `src/link/SpirV.zig` | ソース | SPIR-V処理 |
