# 通知設計書 38-codegen

## 概要

本ドキュメントは、Zigコンパイラにおける「codegen」スコープログの設計書である。コード生成処理に関するログメッセージのスコープを定義する。

### 本通知の処理概要

codegenスコープログは、Zigコンパイラのコード生成（Code Generation）処理を担当する複数のファイルで使用されるログスコープである。AIR（Analyzed Intermediate Representation）からマシンコードへの変換、LLVM IR生成、SPIR-V生成など、各種バックエンドでのコード生成処理に関する情報を出力する。

**業務上の目的・背景**：コード生成はコンパイルの後半段階で行われ、意味解析済みの中間表現を各ターゲットアーキテクチャに適したマシンコードに変換する。codegenスコープログは、シンボル生成、値の低レベル変換、型処理などの詳細な動作をデバッグするための情報を提供する。

**通知の送信タイミング**：コード生成処理の各段階（シンボル生成、値変換、参照解決など）で出力される。

**通知の受信者**：コンパイラ開発者。デバッグログレベルが有効な場合にstderrに出力される。

**通知内容の概要**：生成対象のシンボル、型、値の情報などが含まれる。

**期待されるアクション**：コード生成のデバッグ、最適化、バグ調査に使用する。

## 通知種別

スコープログ（std.log.scoped）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ログ出力） |
| 優先度 | ログレベルに依存 |
| リトライ | 無 |

### 送信先決定ロジック

`std.log.scoped(.codegen)`により生成されたログ関数を使用。codegen.zig、codegen/llvm.zig、各アーキテクチャ固有のCodeGen.zigで使用される。

## 通知テンプレート

### ログ出力形式

| 項目 | 内容 |
|-----|------|
| ログレベル | debug |
| ログスコープ | codegen |
| 形式 | テキスト |
| 色 | マゼンタ（debug） |

### 出力例

```
debug(codegen): generateLazySymbol: kind = {kind}, ty = {type}
debug(codegen): generateSymbol: val = {value}
debug(codegen): lowerUavRef: ty = {type}
debug(codegen): genNavRef({nav_name})
debug(codegen): lowerValue(@as({type}, {value}))
```

### 添付ファイル

添付ファイルなし

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | ログレベル | 説明 |
|------------|----------------|-----------|------|
| 遅延シンボル生成 | generateLazySymbol | debug | 遅延シンボルの生成開始 |
| シンボル生成 | generateSymbol | debug | シンボルの生成 |
| UAV参照 | lowerUavRef | debug | ユニークアドレス値の参照 |
| Nav参照 | genNavRef | debug | ナビゲーション参照の生成 |
| 値変換 | lowerValue | debug | 高レベル値から低レベル表現への変換 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ログレベル設定 | debugレベルが無効な場合は出力されない |

## 処理フロー

### ログスコープ使用パターン

```mermaid
flowchart TD
    A[コード生成開始] --> B{生成対象}
    B -->|遅延シンボル| C[log.debug: generateLazySymbol]
    B -->|シンボル| D[log.debug: generateSymbol]
    B -->|参照| E[log.debug: genNavRef]
    B -->|値変換| F[log.debug: lowerValue]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| InternPool.Index | 型・値のインデックス | シンボル生成時に参照 |
| InternPool.Nav | ナビゲーション情報 | Nav参照時に使用 |

## エラー処理

### エラーケース一覧

スコープログ自体はエラーを発生させない。

### リトライ仕様

N/A

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ログメッセージには型名、シンボル名などが含まれる可能性がある
- デバッグログは開発環境でのみ有効化することを推奨

## 備考

- codegenスコープは複数のバックエンド（LLVM、x86_64、AArch64、SPIR-V、Wasmなど）で使用される
- 各バックエンド固有のログも同じスコープに出力される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ログスコープの定義を理解する

codegenスコープの定義箇所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | codegen.zig | `src/codegen.zig` | 6行目: `const log = std.log.scoped(.codegen);` |

**読解のコツ**: codegenスコープは中央のcodegen.zigと各バックエンドの両方で使用される。

#### Step 2: 主要なログ使用箇所を理解する

コード生成の各段階でのログ使用を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | codegen.zig | `src/codegen.zig` | 246行: generateLazySymbol |
| 2-2 | codegen.zig | `src/codegen.zig` | 317行: generateSymbol |
| 2-3 | codegen.zig | `src/codegen.zig` | 764行: lowerUavRef |
| 2-4 | codegen.zig | `src/codegen.zig` | 910行: genNavRef |
| 2-5 | codegen.zig | `src/codegen.zig` | 1057行: lowerValue |

**主要ログパターン**:
- **generateLazySymbol**: 遅延評価されるシンボルの生成
- **generateSymbol**: 値からシンボルへの変換
- **lowerUavRef**: ユニークアドレス値の参照解決
- **genNavRef**: ナビゲーション参照の生成
- **lowerValue**: 高レベル値の低レベル表現への変換

### プログラム呼び出し階層図

```
codegen.zig
    │
    ├─ log = std.log.scoped(.codegen) [6行目]
    │
    └─ log.debug() 使用箇所
           ├─ generateLazySymbol() [246行]
           │      └─ log.debug("generateLazySymbol: kind = {}, ty = {}")
           │
           ├─ generateSymbol() [317行]
           │      └─ log.debug("generateSymbol: val = {}")
           │
           ├─ lowerUavRef() [764行]
           │      └─ log.debug("lowerUavRef: ty = {}")
           │
           ├─ genNavRef() [910行]
           │      └─ log.debug("genNavRef({})")
           │
           └─ lowerValue() [1057行]
                  └─ log.debug("lowerValue(@as({}, {}))")
```

### データフロー図

```
[入力]                     [処理]                          [出力]

AIR ───▶ コード生成開始
              │
              ▼
        シンボル生成要求
              │
              ▼
        log.debug: generateSymbol
              │
              ▼
        値の低レベル変換
              │
              ▼
        log.debug: lowerValue
              │
              ▼
        マシンコード出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| codegen.zig | `src/codegen.zig` | ソース | コード生成共通処理 |
| llvm.zig | `src/codegen/llvm.zig` | ソース | LLVMバックエンド |
| x86_64/CodeGen.zig | `src/codegen/x86_64/CodeGen.zig` | ソース | x86_64バックエンド |
| aarch64/CodeGen.zig | `src/codegen/aarch64/CodeGen.zig` | ソース | AArch64バックエンド |
| wasm/CodeGen.zig | `src/codegen/wasm/CodeGen.zig` | ソース | WebAssemblyバックエンド |
| spirv/CodeGen.zig | `src/codegen/spirv/CodeGen.zig` | ソース | SPIR-Vバックエンド |
| sparc64/CodeGen.zig | `src/codegen/sparc64/CodeGen.zig` | ソース | SPARC64バックエンド |
