# 通知設計書 39-sema

## 概要

本ドキュメントは、Zigコンパイラにおける「sema」スコープログの設計書である。意味解析（Semantic Analysis）処理に関するログメッセージのスコープを定義する。

### 本通知の処理概要

semaスコープログは、Zigコンパイラの意味解析を担当するSema.zigで使用されるログスコープである。意味解析はコンパイルの中核となる処理であり、型チェック、コンパイル時評価、安全性チェックの生成などを行う。このスコープは、意味解析処理の詳細なデバッグ情報を提供する。

**業務上の目的・背景**：意味解析はZIR（Zig Intermediate Representation）をAIR（Analyzed Intermediate Representation）に変換する処理であり、Zigコンパイラの「心臓部」と呼ばれる。型推論、コンパイル時関数実行、エラーセットの推論など、複雑な処理が行われる。semaスコープログは、これらの処理の動作を追跡するためのデバッグ情報を提供する。

**通知の送信タイミング**：意味解析処理の各段階（外部関数シンボル解決、ファイル読み込みなど）で出力される。

**通知の受信者**：コンパイラ開発者。ログレベル設定に応じて標準エラー出力に表示される。

**通知内容の概要**：外部関数のライブラリ情報、ファイル読み込み状態などが含まれる。

**期待されるアクション**：意味解析のデバッグ、コンパイルエラーの調査、パフォーマンス最適化に使用する。

## 通知種別

スコープログ（std.log.scoped）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ログ出力） |
| 優先度 | ログレベルに依存 |
| リトライ | 無 |

### 送信先決定ロジック

`std.log.scoped(.sema)`により生成されたログ関数を使用。主にSema.zigで使用される。

## 通知テンプレート

### ログ出力形式

| 項目 | 内容 |
|-----|------|
| ログレベル | debug / warn |
| ログスコープ | sema |
| 形式 | テキスト |
| 色 | レベル依存 |

### 出力例

```
debug(sema): extern fn symbol expected in lib '{lib_name}'
warn(sema): unable to load {file}: {error}
```

### 添付ファイル

添付ファイルなし

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | ログレベル | 説明 |
|------------|----------------|-----------|------|
| 外部関数解決 | extern fn処理 | debug | 外部関数のライブラリ指定 |
| ファイル読み込み | ファイル処理 | warn | ファイル読み込み失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ログレベル設定 | 設定されたログレベルより低い優先度のログは出力されない |

## 処理フロー

### ログスコープ使用パターン

```mermaid
flowchart TD
    A[意味解析開始] --> B{処理種別}
    B -->|外部関数| C[log.debug: extern fn symbol]
    B -->|ファイル処理| D{読み込み結果}
    D -->|失敗| E[log.warn: unable to load]
    D -->|成功| F[処理続行]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| Zir | 入力中間表現 | 意味解析の入力 |
| Air | 出力中間表現 | 意味解析の出力 |

## エラー処理

### エラーケース一覧

スコープログ自体はエラーを発生させない。

### リトライ仕様

N/A

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ログメッセージにはライブラリ名、ファイルパスなどが含まれる可能性がある
- デバッグログは開発環境でのみ有効化することを推奨

## 備考

- Sema.zigはZigコンパイラの「心臓部」であり、非常に大規模なファイル
- 意味解析はコンパイル時間の大部分を占めることがある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ログスコープの定義を理解する

semaスコープの定義箇所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Sema.zig | `src/Sema.zig` | 13行目: `const log = std.log.scoped(.sema);` |

**読解のコツ**: Sema.zigは非常に大規模なファイルであり、意味解析の全処理を含む。

#### Step 2: 主要なログ使用箇所を理解する

意味解析での主要なログ使用を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Sema.zig | `src/Sema.zig` | 9153行: extern fn symbol expected |
| 2-2 | Sema.zig | `src/Sema.zig` | 16665行: unable to load（1つ目） |
| 2-3 | Sema.zig | `src/Sema.zig` | 16693行: unable to load（2つ目） |

**主要ログパターン**:
- **debug**: 外部関数のシンボル解決情報
- **warn**: ファイル読み込み失敗

### プログラム呼び出し階層図

```
Sema.zig
    │
    ├─ log = std.log.scoped(.sema) [13行目]
    │
    ├─ log.debug() 使用箇所
    │      └─ extern fn symbol expected in lib [9153行]
    │
    └─ log.warn() 使用箇所
           ├─ unable to load {file} [16665行]
           └─ unable to load {file} [16693行]
```

### データフロー図

```
[入力]                     [処理]                          [出力]

ZIR ───▶ 意味解析開始
              │
              ▼
        型チェック
              │
              ▼
        外部関数解決
              │
              ▼
        log.debug: extern fn symbol
              │
              ▼
        コンパイル時評価
              │
              ▼
        AIR生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Sema.zig | `src/Sema.zig` | ソース | 意味解析の主実装 |
| Zir.zig | `lib/std/zig/Zir.zig` | 標準ライブラリ | ZIR定義 |
| Air.zig | `src/Air.zig` | ソース | AIR定義 |
| Type.zig | `src/Type.zig` | ソース | 型システム |
| Value.zig | `src/Value.zig` | ソース | 値表現 |
