# 通知設計書 4-debug

## 概要

本ドキュメントは、Zigコンパイラにおけるdebugログ通知の設計を記述するものである。

### 本通知の処理概要

本通知は、Zigコンパイラのコンパイル処理中にデバッグ目的でのみ有用なメッセージをログとして出力する機能である。

**業務上の目的・背景**：コンパイラ開発者やデバッグ時に内部処理の詳細情報を確認するために必要である。デバッグログはリリースビルドでは通常出力されず、開発・デバッグ時にのみ有効化される。

**通知の送信タイミング**：コンパイル処理中の内部状態変化時に出力される。具体的には、ジョブキュー追加、キャッシュヒット/ミス、レジスタ割り当て/解放、リンカー処理の詳細などのイベント発生時にトリガーされる。

**通知の受信者**：コンパイラを開発・デバッグしているエンジニア。ログは標準エラー出力（stderr）に出力される。

**通知内容の概要**：内部処理の詳細状態、レジスタ操作、キャッシュ状態、シンボル解決などの技術的な情報が含まれる。ログはANSIカラーコードによりマゼンタ色で表示され、視覚的にデバッグ情報であることを示す。

**期待されるアクション**：開発者はデバッグメッセージを確認し、内部処理の流れを追跡して問題の原因を特定する。通常のユーザーには不要な情報であり、アクションは不要。

## 通知種別

ログ通知（標準エラー出力）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 最低 |
| リトライ | 無し |

### 送信先決定ロジック

ログ出力は固定で標準エラー出力（stderr）に送信される。`std.log.scoped(.xxx).debug`または`log.debug`関数を通じて出力される。

## 通知テンプレート

### ログ出力の場合

| 項目 | 内容 |
|-----|------|
| 出力先 | stderr |
| 色 | マゼンタ色（ANSI escape code使用） |
| 形式 | テキスト |

### 本文テンプレート

```
debug: {メッセージ}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | ログ通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | デバッグメッセージ | 各処理からの引数 | Yes |
| register | レジスタ情報 | レジスタマネージャ | No |
| cache_mode | キャッシュモード | Compilation構造体 | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | ジョブキュー追加 | ジョブ追加時 | compiler_rt_lib, ubsan_rt等のビルドジョブ |
| 内部処理 | キャッシュヒット/ミス | キャッシュ判定時 | CacheMode.whole時のキャッシュ状態 |
| 内部処理 | Cオブジェクト更新 | 更新開始時 | Cソースファイルのコンパイル開始 |
| 内部処理 | Win32リソース更新 | 更新開始時 | リソースファイルのコンパイル開始 |
| 内部処理 | レジスタ操作 | ロック/アンロック時 | レジスタ割り当て管理 |
| 内部処理 | シンボル解決 | 解決時 | グローバルシンボルの取得 |
| 内部処理 | アトム処理 | 処理時 | ELFリンカーのアトム操作 |
| 内部処理 | メモリ割り当て失敗 | 失敗時 | アロケータエラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| デバッグビルドでない場合 | リリースビルドではdebugログは通常出力されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[内部イベント発生] --> B{デバッグ有効?}
    B -->|有効| C[log.debug呼び出し]
    B -->|無効| D[スキップ]
    C --> E[フォーマット文字列展開]
    E --> F[ANSIカラーコード付与]
    F --> G[stderr出力]
    G --> H[処理継続]
    D --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | ログ通知のためDB参照なし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | ログ通知のためDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 出力失敗 | stderrへの書き込み失敗 | 処理継続（デバッグログのため） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（コンパイル処理中は常時出力可能、ただしデバッグビルド時のみ）

## セキュリティ考慮事項

- デバッグメッセージにファイルパスやシンボル名が含まれる場合があるが、これはユーザーの作業環境情報であり、外部送信されない
- デバッグログは開発者向けであり、リリースビルドでは通常無効化される
- ログ出力は標準エラー出力のみで、ネットワーク経由での送信は行われない

## 備考

- ログスコープ（.compilation, .link, .register_manager等）によって出力元を識別可能
- ANSIカラーコードによりマゼンタ色で表示されるため、ターミナル上で視認性が高い
- リリースビルドでは通常無効化されるため、パフォーマンスへの影響は最小限

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Zigのログシステムは標準ライブラリの`std.log`モジュールを使用している。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | std/log.zig | Zig標準ライブラリ | ログレベルの定義とscopedログの仕組み |

**読解のコツ**: `std.log.scoped`はコンパイル時にログスコープを生成する関数である。debugレベルは最低優先度であり、リリースビルドでは出力されない。

#### Step 2: エントリーポイントを理解する

各モジュールでのlog変数の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Compilation.zig | `src/Compilation.zig` | 11行目: log = std.log.scoped(.compilation) |
| 2-2 | link.zig | `src/link.zig` | 9行目: log = std.log.scoped(.link) |
| 2-3 | register_manager.zig | `src/register_manager.zig` | log変数定義 |

**主要処理フロー**:
1. **2687行目 (Compilation.zig)**: `log.debug("queuing a job to build compiler_rt_lib", .{});` - ジョブキュー追加
2. **3003行目 (Compilation.zig)**: `log.debug("CacheMode.whole cache hit for {s}", .{comp.root_name});` - キャッシュヒット

#### Step 3: デバッグログ呼び出し箇所

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Compilation.zig | `src/Compilation.zig` | 2687-2722, 2935, 3003, 3012, 6236, 6591, 7865行目 |
| 3-2 | link.zig | `src/link.zig` | 367, 759行目 |
| 3-3 | register_manager.zig | `src/register_manager.zig` | 152-367行目 |
| 3-4 | link/Elf/Atom.zig | `src/link/Elf/Atom.zig` | 145, 225, 246, 319, 620行目 |

**主要処理フロー**:
- **2687-2722行目**: ジョブキュー追加のデバッグ出力
- **2935行目**: Compilation.update開始のデバッグ出力
- **152-367行目 (register_manager.zig)**: レジスタ操作のデバッグ出力

### プログラム呼び出し階層図

```
std.log.scoped(.compilation)
    │
    ├─ log.debug(format, args)
    │      └─ std.log.log (内部ログ処理)
    │              └─ stderr.write (デバッグビルド時のみ)
    │
    └─ 各処理での内部イベント
           ├─ ジョブキュー管理
           ├─ キャッシュ判定
           ├─ レジスタ割り当て
           └─ リンカー処理
```

### データフロー図

```
[入力]               [処理]                    [出力]

内部イベント ───▶ log.debug(format, args) ───▶ stderr（マゼンタ色表示）
    │                    │                     （デバッグビルド時のみ）
    │                    └─ 処理継続
    │
    └─ format: フォーマット文字列
    └─ args: 可変長引数（デバッグ情報）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Compilation.zig | `src/Compilation.zig` | ソース | コンパイル処理のメイン、log.debug多数使用 |
| link.zig | `src/link.zig` | ソース | リンカー処理、linkスコープのログ使用 |
| register_manager.zig | `src/register_manager.zig` | ソース | レジスタ管理、詳細なデバッグログ |
| link/Elf/Atom.zig | `src/link/Elf/Atom.zig` | ソース | ELFアトム処理 |
