# 通知設計書 40-incremental_debug_server

## 概要

本ドキュメントは、Zigコンパイラにおける「incremental_debug_server」スコープログの設計書である。インクリメンタルデバッグサーバー処理に関するログメッセージのスコープを定義する。

### 本通知の処理概要

incremental_debug_serverスコープログは、Zigコンパイラのインクリメンタルデバッグサーバー（IncrementalDebugServer.zig）で使用されるログスコープである。このサーバーは`--debug-incremental` CLIフラグで有効化され、インクリメンタルコンパイルの問題をデバッグするためのTCPベースのREPLインターフェースを提供する。

**業務上の目的・背景**：インクリメンタルコンパイルは、変更されたファイルのみを再コンパイルすることでビルド時間を短縮する機能である。しかし、依存関係の追跡や状態管理は複雑であり、バグが発生しやすい。インクリメンタルデバッグサーバーは、開発者やコンパイラ開発者がコンパイラの内部状態をリアルタイムで調査できるようにするデバッグツールである。

**通知の送信タイミング**：サーバー起動、クライアント接続/切断、接続エラー発生時などに出力される。

**通知の受信者**：コンパイラ開発者。ログレベル設定に応じて標準エラー出力に表示される。

**通知内容の概要**：クライアント接続情報、エラー情報、サーバー状態などが含まれる。

**期待されるアクション**：サーバー動作の監視、接続問題の診断、インクリメンタルコンパイルのデバッグに使用する。

## 通知種別

スコープログ（std.log.scoped）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ログ出力） |
| 優先度 | ログレベルに依存 |
| リトライ | 無 |

### 送信先決定ロジック

`std.log.scoped(.incremental_debug_server)`により生成されたログ関数を使用。IncrementalDebugServer.zigでのみ使用される。

## 通知テンプレート

### ログ出力形式

| 項目 | 内容 |
|-----|------|
| ログレベル | info / warn / err |
| ログスコープ | incremental_debug_server |
| 形式 | テキスト |
| 色 | レベル依存 |

### 出力例

```
info(incremental_debug_server): client '{address}' connected
info(incremental_debug_server): client '{address}' disconnected
warn(incremental_debug_server): client disconnected during accept
err(incremental_debug_server): listen failed ({error}); closing server
err(incremental_debug_server): accept failed ({error})
err(incremental_debug_server): failed to serve '{address}' ({error})
```

### 添付ファイル

添付ファイルなし

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | ログレベル | 説明 |
|------------|----------------|-----------|------|
| クライアント接続 | accept成功 | info | クライアントの接続成功 |
| クライアント切断 | 正常切断 | info | クライアントの正常切断 |
| 接続中断 | accept中の切断 | warn | accept処理中のクライアント切断 |
| リッスン失敗 | listen失敗 | err | サーバーのリッスン開始失敗 |
| accept失敗 | accept失敗 | err | 接続受け入れ失敗 |
| サービス失敗 | serve失敗 | err | クライアントへのサービス提供失敗 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| サーバー無効 | --debug-incrementalフラグが指定されていない場合 |
| ログレベル設定 | 設定されたログレベルより低い優先度のログは出力されない |

## 処理フロー

### ログスコープ使用パターン

```mermaid
flowchart TD
    A[サーバー起動] --> B[listen開始]
    B --> C{listen成功?}
    C -->|No| D[log.err: listen failed]
    C -->|Yes| E[accept待機]
    E --> F{accept成功?}
    F -->|エラー| G{エラー種別}
    G -->|ConnectionAborted| H[log.warn: client disconnected during accept]
    G -->|その他| I[log.err: accept failed]
    F -->|成功| J[log.info: client connected]
    J --> K[サービス提供]
    K --> L{サービス結果}
    L -->|正常切断| M[log.info: client disconnected]
    L -->|エラー| N[log.err: failed to serve]
```

## データベース参照・更新仕様

### 参照テーブル一覧

本通知はデータベースを使用しない。

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| Zcu | コンパイル単位情報 | 内部状態の参照 |
| IncrementalDebugState | デバッグ状態 | 追加の追跡状態 |

## エラー処理

### エラーケース一覧

スコープログ自体はエラーを発生させない。サーバーエラーの診断情報を出力する。

### リトライ仕様

N/A

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- デバッグサーバーはローカルホスト（::1）のポート7623でリッスンする
- コンパイラの内部状態にアクセスできるため、信頼できる環境でのみ使用すること
- `--debug-incremental`フラグはデバッグ拡張が有効な場合のみ利用可能

## 備考

- デバッグサーバーはtelnetでアクセス可能: `telnet "::1" 7623`
- サーバー有効時はRSS（メモリ使用量）が通常より高くなる
- REPLコマンドには'help'で一覧を表示可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ログスコープの定義を理解する

incremental_debug_serverスコープの定義箇所を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 449行目: `const log = std.log.scoped(.incremental_debug_server);` |

**読解のコツ**: このファイルはデバッグ拡張が有効な場合にのみコンパイルされる。

#### Step 2: サーバー処理の流れを理解する

サーバーの起動から終了までのログ出力を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 49行目: log.err listen failed |
| 2-2 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 59行目: log.warn client disconnected during accept |
| 2-3 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 63行目: log.err accept failed |
| 2-4 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 68行目: log.info client connected |
| 2-5 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 96行目: log.err failed to serve |
| 2-6 | IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | 100行目: log.info client disconnected |

**主要ログパターン**:
- **info**: 正常な接続/切断イベント
- **warn**: 予期された異常（accept中の切断など）
- **err**: サーバーエラー（listen失敗、accept失敗など）

### プログラム呼び出し階層図

```
IncrementalDebugServer.zig
    │
    ├─ log = std.log.scoped(.incremental_debug_server) [449行目]
    │
    ├─ spawn()
    │      └─ runServer()
    │             │
    │             ├─ listen()
    │             │      └─ (失敗時) log.err("listen failed")
    │             │
    │             └─ accept loop
    │                    │
    │                    ├─ (接続時) log.info("client connected")
    │                    │
    │                    ├─ serveStream()
    │                    │      └─ (エラー時) log.err("failed to serve")
    │                    │
    │                    └─ (切断時) log.info("client disconnected")
    │
    └─ handleCommand()
           └─ REPLコマンド処理
```

### データフロー図

```
[入力]                     [処理]                          [出力]

--debug-incremental ───▶ サーバー起動
                              │
                              ▼
                         listen開始
                              │
                    (失敗時) │ ───▶ log.err
                              │
                              ▼
                         accept待機
                              │
                    (接続時) │ ───▶ log.info: connected
                              │
                              ▼
                         コマンド処理
                              │
                    (エラー時) │ ───▶ log.err: failed to serve
                              │
                              ▼
                         接続終了
                              │
                              ▼
                         log.info: disconnected
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IncrementalDebugServer.zig | `src/IncrementalDebugServer.zig` | ソース | デバッグサーバー実装 |
| Zcu.zig | `src/Zcu.zig` | ソース | IncrementalDebugState定義 |
| Compilation.zig | `src/Compilation.zig` | ソース | サーバー起動の呼び出し元 |
