# 通知設計書 5-LinkFailure

## 概要

本ドキュメントは、Zigコンパイラにおけるリンカーエラー（LinkFailure）通知の設計を記述するものである。

### 本通知の処理概要

本通知は、Zigコンパイラのリンク処理中に発生したエラーをDiagnostics（診断）システムを通じて収集・報告する機能である。

**業務上の目的・背景**：リンク処理中にエラーが発生した場合、ユーザーに対してエラーの原因と対処方法を明確に伝達するために必要である。リンカーエラーは、シンボル未解決、ライブラリ不足、オブジェクトファイル不正など様々な原因で発生する。

**通知の送信タイミング**：リンク処理中にエラー条件が検出された時点でDiagsシステムにエラーが追加され、`error.LinkFailure`が返される。最終的なエラー出力はコンパイル完了時にErrorBundleとして統合・出力される。

**通知の受信者**：コンパイラを実行しているユーザー。エラーメッセージは最終的に標準エラー出力（stderr）に出力される。

**通知内容の概要**：エラーメッセージ、エラーに関連するソース位置情報（オプション）、追加のノート（検索パスなど）が含まれる。

**期待されるアクション**：ユーザーはエラーメッセージを確認し、リンカー設定の修正、必要なライブラリの追加、ソースコードの修正などを行う。

## 通知種別

診断メッセージ（ErrorBundle経由での出力）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（エラー蓄積後にバッチ出力） |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

エラーメッセージは`link.Diags`構造体に蓄積され、最終的に`Compilation.getAllErrorsAlloc()`によってErrorBundleに変換されて出力される。

## 通知テンプレート

### エラー出力の場合

| 項目 | 内容 |
|-----|------|
| 出力先 | stderr（ErrorBundle経由） |
| 形式 | 構造化エラーメッセージ |

### 本文テンプレート

```
error: {エラーメッセージ}
note: {追加情報（オプション）}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | 診断メッセージのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| msg | エラーメッセージ | format引数で生成 | Yes |
| source_location | ソース位置情報 | Diags.SourceLocation | No |
| notes | 追加ノート | ErrorWithNotes | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| リンク処理 | Diags.fail呼び出し | エラー発生時 | 汎用リンカーエラー |
| リンク処理 | Diags.failSourceLocation呼び出し | エラー発生時 | ソース位置付きエラー |
| リンク処理 | Diags.failParse呼び出し | パースエラー時 | リンカースクリプト等のパースエラー |
| リンク処理 | diags.hasErrors()がtrue | エラー蓄積後 | 蓄積されたエラーの確認 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | エラー発生時は常にDiagsに追加される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[リンクエラー発生] --> B[Diags.fail/addError呼び出し]
    B --> C[メッセージフォーマット]
    C --> D[Diags.msgsに追加]
    D --> E[error.LinkFailure返却]
    E --> F[呼び出し元でエラーハンドリング]
    F --> G[Compilation.getAllErrorsAlloc]
    G --> H[ErrorBundle生成]
    H --> I[stderr出力]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 診断メッセージのためDB参照なし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 診断メッセージのためDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| OutOfMemory | メッセージ生成時のメモリ不足 | setAllocFailure()で記録 |
| LinkFailure | 各種リンクエラー | Diagsにエラー追加後に返却 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（リンク処理中は常時発生可能）

## セキュリティ考慮事項

- エラーメッセージにファイルパスやシンボル名が含まれる場合があるが、これはユーザーの作業環境情報であり、外部送信されない
- エラー出力は標準エラー出力のみで、ネットワーク経由での送信は行われない

## 備考

- LinkFailureはZigのerror型として定義されており、関数の戻り値として使用される
- Diagsシステムはスレッドセーフであり、mutexで保護されている
- LLDからのエラー出力もDiags.lldに蓄積される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Diags構造体の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | link.zig | `src/link.zig` | 33-385行目: Diags構造体の定義 |

**読解のコツ**: Diagsは以下の主要フィールドを持つ：
- `msgs`: エラーメッセージのリスト
- `flags`: 各種フラグ（no_entry_point_found, missing_libc等）
- `lld`: LLDからのエラーリスト
- `mutex`: スレッドセーフのためのmutex

#### Step 2: エントリーポイントを理解する

fail関数とaddError関数の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | link.zig | `src/link.zig` | 213-217行目: fail関数 |
| 2-2 | link.zig | `src/link.zig` | 219-223行目: failSourceLocation関数 |
| 2-3 | link.zig | `src/link.zig` | 225-228行目: addError関数 |

**主要処理フロー**:
1. **213行目**: `fail` - エラーを追加して`error.LinkFailure`を返す
2. **215行目**: `addError(diags, format, args);` - エラーメッセージの追加
3. **216行目**: `return error.LinkFailure;` - エラー値の返却

#### Step 3: エラー使用箇所

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | link/Elf/Object.zig | `src/link/Elf/Object.zig` | 285, 831, 846行目: ELFオブジェクトでのエラー返却 |
| 3-2 | link/Elf/relocatable.zig | `src/link/Elf/relocatable.zig` | 26, 152, 158, 204行目: 再配置可能オブジェクトでのエラー |
| 3-3 | link/MachO.zig | `src/link/MachO.zig` | 493行目: MachOリンカーでのエラー |
| 3-4 | Compilation.zig | `src/Compilation.zig` | 3399, 3413行目: LinkFailureのハンドリング |

**主要処理フロー**:
- **3399行目 (Compilation.zig)**: `error.LinkFailure => {}` - エラーは既に報告済みとしてスキップ

### プログラム呼び出し階層図

```
link.Diags.fail(format, args)
    │
    ├─ addError(diags, format, args)
    │      └─ addErrorSourceLocation(diags, .none, format, args)
    │              └─ std.fmt.allocPrint(gpa, format, args)
    │              └─ diags.msgs.append(gpa, msg)
    │
    └─ return error.LinkFailure
           │
           └─ 呼び出し元でハンドリング
                  │
                  └─ Compilation.getAllErrorsAlloc()
                         └─ ErrorBundle生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

リンクエラー ───▶ Diags.fail() ───▶ error.LinkFailure
    │                    │
    │                    └─ Diags.msgsに蓄積
    │
    └─ format: フォーマット文字列
    └─ args: 可変長引数

                         │
                         ▼

             Compilation.getAllErrorsAlloc()
                         │
                         ▼

                 ErrorBundle（stderr出力）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| link.zig | `src/link.zig` | ソース | Diags構造体の定義、fail/addError関数 |
| Compilation.zig | `src/Compilation.zig` | ソース | getAllErrorsAlloc、LinkFailureハンドリング |
| link/Elf/Object.zig | `src/link/Elf/Object.zig` | ソース | ELFオブジェクト処理でのLinkFailure使用 |
| link/Elf/relocatable.zig | `src/link/Elf/relocatable.zig` | ソース | 再配置可能オブジェクト処理 |
| link/MachO.zig | `src/link/MachO.zig` | ソース | MachOリンカー処理 |
| link/Queue.zig | `src/link/Queue.zig` | ソース | リンクキュー処理 |
| link/Elf/ZigObject.zig | `src/link/Elf/ZigObject.zig` | ソース | Zigオブジェクト処理 |
