# 通知設計書 8-ErrorMsg

## 概要

本ドキュメントは、Zigコンパイラにおけるコンパイルエラーメッセージ（ErrorMsg）の設計を記述するものである。

### 本通知の処理概要

本通知は、Zigコンパイラのコンパイル処理（意味解析、コード生成等）中に検出されたエラーを表現するデータ構造とその報告機能である。

**業務上の目的・背景**：コンパイル処理中に検出された意味的エラー（型の不一致、未定義シンボルなど）をユーザーに対して明確に報告するために必要である。ErrorMsgはソース位置情報、エラーメッセージ、追加のノート、参照トレースを含む構造化されたエラー表現を提供する。

**通知の送信タイミング**：意味解析（Sema）、コード生成（codegen）、型解析などの処理中にエラーが検出された時点でErrorMsgが生成され、failed_analysis、failed_codegen、failed_typesなどのマップに蓄積される。

**通知の受信者**：コンパイラを実行しているユーザー。エラーメッセージは最終的に標準エラー出力（stderr）に出力される。

**通知内容の概要**：ソース位置情報（LazySrcLoc）、エラーメッセージ本文、追加のノート（オプション）、参照トレースルート（オプション）が含まれる。

**期待されるアクション**：ユーザーはエラーメッセージとソース位置を確認し、該当箇所のソースコードを修正する。

## 通知種別

エラーバンドル（ErrorBundle経由での出力）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（エラー蓄積後にバッチ出力） |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

エラーメッセージは`Zcu.ErrorMsg`構造体として生成され、`Zcu.failed_analysis`、`Zcu.failed_codegen`、`Zcu.failed_types`などのマップに蓄積される。最終的に`Compilation.getAllErrorsAlloc()`によってErrorBundleに変換されて出力される。

## 通知テンプレート

### エラー出力の場合

| 項目 | 内容 |
|-----|------|
| 出力先 | stderr（ErrorBundle経由） |
| 形式 | 構造化エラーメッセージ |

### 本文テンプレート

```
{ファイルパス}:{行}:{列}: error: {エラーメッセージ}
{ソース行}
        ^
note: {追加情報}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | エラーメッセージのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| src_loc | ソース位置情報 | LazySrcLoc構造体 | Yes |
| msg | エラーメッセージ | 各解析処理から | Yes |
| notes | 追加ノート | ErrorMsg配列 | No |
| reference_trace_root | 参照トレースルート | AnalUnit.Optional | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 意味解析 | Sema処理中のエラー | エラー検出時 | 型エラー、未定義シンボル等 |
| コード生成 | codegen処理中のエラー | エラー検出時 | コード生成固有エラー |
| 型解析 | 型解決中のエラー | エラー検出時 | 型に関するエラー |
| エクスポート | エクスポート処理のエラー | エラー検出時 | シンボルエクスポートエラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| skip_analysis_this_update | AstGenエラーにより意味解析がスキップされた場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[解析エラー発生] --> B[ErrorMsg.create呼び出し]
    B --> C[gpa.create(ErrorMsg)]
    C --> D[ErrorMsg.init]
    D --> E[failed_analysis/failed_codegenに追加]
    E --> F[Compilation.getAllErrorsAlloc]
    F --> G[addModuleErrorMsg呼び出し]
    G --> H[ErrorBundle生成]
    H --> I[stderr出力]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | エラーメッセージのためDB参照なし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | エラーメッセージのためDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| OutOfMemory | メッセージ生成時のメモリ不足 | エラーを伝播 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（コンパイル処理中は常時発生可能）

## セキュリティ考慮事項

- エラーメッセージにファイルパスやソースコード断片が含まれるが、これはユーザーの作業環境情報であり、外部送信されない
- エラー出力は標準エラー出力のみで、ネットワーク経由での送信は行われない

## 備考

- ErrorMsgはZcu（Zig Compilation Unit）モジュールで定義されている
- ErrorMsgのメモリはgpa（汎用アロケータ）で管理され、destroyメソッドで解放される
- reference_trace_rootはインクリメンタルコンパイル時の参照追跡に使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ErrorMsg構造体の定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Zcu.zig | `src/Zcu.zig` | 1217-1258行目: ErrorMsg構造体の定義 |

**読解のコツ**: ErrorMsgは以下のフィールドを持つ：
- `src_loc`: LazySrcLoc - ソース位置情報
- `msg`: []const u8 - エラーメッセージ
- `notes`: []ErrorMsg - 追加のノート
- `reference_trace_root`: AnalUnit.Optional - 参照トレースルート

#### Step 2: エントリーポイントを理解する

ErrorMsgの生成関数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Zcu.zig | `src/Zcu.zig` | 1223-1234行目: create関数 |
| 2-2 | Zcu.zig | `src/Zcu.zig` | 1243-1248行目: init関数 |
| 2-3 | Zcu.zig | `src/Zcu.zig` | 1238-1241行目: destroy関数 |
| 2-4 | Zcu.zig | `src/Zcu.zig` | 1250-1257行目: deinit関数 |

**主要処理フロー**:
1. **1223行目**: `create` - ErrorMsgの生成（allocate + init）
2. **1230行目**: `gpa.create(ErrorMsg)` - メモリ確保
3. **1232行目**: `ErrorMsg.init(gpa, src_loc, format, args)` - 初期化
4. **1246行目**: `std.fmt.allocPrint(gpa, format, args)` - メッセージ文字列生成

#### Step 3: 使用箇所

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Zcu.zig | `src/Zcu.zig` | 180行目: failed_analysis - 解析失敗マップ |
| 3-2 | Zcu.zig | `src/Zcu.zig` | 188行目: failed_codegen - コード生成失敗マップ |
| 3-3 | Zcu.zig | `src/Zcu.zig` | 189行目: failed_types - 型解決失敗マップ |
| 3-4 | Zcu.zig | `src/Zcu.zig` | 242行目: failed_exports - エクスポート失敗マップ |
| 3-5 | Zcu.zig | `src/Zcu.zig` | 4583行目: codegenFail関数 |

**主要処理フロー**:
- **4583行目**: `Zcu.ErrorMsg.create(zcu.gpa, zcu.navSrcLoc(nav_index), format, args)` - コード生成エラー生成

### プログラム呼び出し階層図

```
Zcu.ErrorMsg.create(gpa, src_loc, format, args)
    │
    ├─ gpa.create(ErrorMsg)
    │      └─ メモリ確保
    │
    └─ ErrorMsg.init(gpa, src_loc, format, args)
           │
           └─ std.fmt.allocPrint(gpa, format, args)
                  └─ メッセージ文字列生成

        │
        ▼

failed_analysis/failed_codegen/failed_typesに追加

        │
        ▼

Compilation.getAllErrorsAlloc()
    │
    └─ addModuleErrorMsg(zcu, bundle, error_msg, ...)
           │
           └─ ErrorBundle.addRootErrorMessage(...)
```

### データフロー図

```
[入力]               [処理]                    [出力]

src_loc ───────▶ ErrorMsg.create() ───▶ *ErrorMsg
format + args           │
                       └─ failed_* マップに蓄積

                         │
                         ▼

             Compilation.getAllErrorsAlloc()
                         │
                         ▼

                 ErrorBundle（stderr出力）
                 file.zig:10:5: error: message
                 note: additional info
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Zcu.zig | `src/Zcu.zig` | ソース | ErrorMsg構造体の定義、failed_*マップ |
| Compilation.zig | `src/Compilation.zig` | ソース | getAllErrorsAlloc、ErrorBundle生成 |
| Sema.zig | `src/Sema.zig` | ソース | 意味解析でのErrorMsg生成 |
