# 通知設計書 9-ErrorBundle

## 概要

本ドキュメントは、Zigコンパイラにおけるエラーバンドル（ErrorBundle）の設計を記述するものである。

### 本通知の処理概要

本通知は、Zigコンパイラのコンパイル処理中に発生した複数のエラーメッセージを統合・管理し、最終的にユーザーに出力する機能である。

**業務上の目的・背景**：コンパイル処理中に発生する複数のエラー（意味解析エラー、リンカーエラー、ZIR/ZOIRエラーなど）を統一的に収集・管理し、構造化された形式でユーザーに報告するために必要である。ErrorBundleは全エラーの集約点として機能する。

**通知の送信タイミング**：`Compilation.getAllErrorsAlloc()`が呼び出された時点で、蓄積された全エラーがErrorBundleに変換される。これはコンパイル処理の完了時に行われる。

**通知の受信者**：コンパイラを実行しているユーザー。エラーメッセージは最終的に標準エラー出力（stderr）に出力される。

**通知内容の概要**：すべてのコンパイルエラー（failed_c_objects、failed_win32_resources、link_diags、misc_failures、failed_analysis、failed_codegen、failed_types、failed_files、failed_exports、cimport_errors等）が統合されたエラーバンドル。

**期待されるアクション**：ユーザーは出力されたエラーメッセージを確認し、各エラーに対応したソースコードの修正を行う。

## 通知種別

エラーバンドル（統合エラー出力）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（全エラー収集後にバッチ出力） |
| 優先度 | 高 |
| リトライ | 無し |

### 送信先決定ロジック

`Compilation.getAllErrorsAlloc()`が以下のソースからエラーを収集してErrorBundleを構築する：
1. failed_c_objects - Cオブジェクトコンパイルエラー
2. failed_win32_resources - Win32リソースエラー
3. link_diags.lld - LLDリンカーエラー
4. misc_failures - その他のエラー
5. zcu.failed_imports - インポートエラー
6. zcu.failed_files - AstGen/ZonGenエラー
7. zcu.failed_analysis - 意味解析エラー
8. zcu.failed_codegen - コード生成エラー
9. zcu.failed_exports - エクスポートエラー
10. zcu.cimport_errors - Cインポートエラー

## 通知テンプレート

### エラー出力の場合

| 項目 | 内容 |
|-----|------|
| 出力先 | stderr |
| 形式 | 構造化エラーメッセージ |

### 本文テンプレート

```
{ファイルパス}:{行}:{列}: error: {エラーメッセージ}
{ソース行}
        ^
note: {追加情報}

{ファイルパス}:{行}:{列}: error: {別のエラーメッセージ}
...
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | エラーバンドルのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| errors | エラーメッセージリスト | 各failed_*マップ | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コンパイル完了 | getAllErrorsAlloc呼び出し | 常時 | コンパイル完了時に全エラー収集 |
| ビルドサーバー | serveUpdateResults呼び出し | サーバーモード時 | インクリメンタルビルド時のエラー報告 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | getAllErrorsAllocは常にErrorBundleを返す |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Compilation.update完了] --> B[getAllErrorsAlloc呼び出し]
    B --> C[ErrorBundle.Wip初期化]
    C --> D[failed_c_objects収集]
    D --> E[failed_win32_resources収集]
    E --> F[link_diags.lld収集]
    F --> G[misc_failures収集]
    G --> H[zcu関連エラー収集]
    H --> I[ErrorBundle.toOwnedBundle]
    I --> J[stderr出力]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | エラーバンドルのためDB参照なし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | エラーバンドルのためDB更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| OutOfMemory | ErrorBundle構築時のメモリ不足 | エラーを返却 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（コンパイル完了時に出力）

## セキュリティ考慮事項

- エラーメッセージにファイルパスやソースコード断片が含まれるが、これはユーザーの作業環境情報であり、外部送信されない
- エラー出力は標準エラー出力のみで、ネットワーク経由での送信は行われない

## 備考

- ErrorBundleはstd.zig.ErrorBundleとして定義されている
- ErrorBundle.Wipは構築中のバンドルを表す
- toOwnedBundle()で最終的なErrorBundleが生成される
- errorMessageCount()でエラー数を取得できる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ErrorBundleの定義を確認する（標準ライブラリ）。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Compilation.zig | `src/Compilation.zig` | 13行目: ErrorBundle import |

**読解のコツ**: ErrorBundleはstd.zig.ErrorBundleとして定義されており、Wipは構築中の状態を表す。

#### Step 2: エントリーポイントを理解する

getAllErrorsAlloc関数の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Compilation.zig | `src/Compilation.zig` | 3950-4000行目: getAllErrorsAlloc関数の前半 |
| 2-2 | Compilation.zig | `src/Compilation.zig` | 4000行目以降: getAllErrorsAllocのZCUエラー収集 |

**主要処理フロー**:
1. **3955-3957行目**: `bundle: ErrorBundle.Wip` - バンドル初期化
2. **3959-3961行目**: `failed_c_objects`からエラー収集
3. **3963-3965行目**: `failed_win32_resources`からエラー収集
4. **3967-3980行目**: `link_diags.lld`からエラー収集
5. **3981-3992行目**: `misc_failures`とメモリ割り当て失敗の収集
6. **3994行目以降**: ZCU関連エラーの収集

#### Step 3: 使用箇所

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | main.zig | `src/main.zig` | 4308行目: serveUpdateResultsでの使用 |
| 3-2 | main.zig | `src/main.zig` | 4628行目: updateModuleでの使用 |
| 3-3 | main.zig | `src/main.zig` | 5667行目: サーバーモードでの使用 |
| 3-4 | Compilation.zig | `src/Compilation.zig` | 4333行目: anyErrorsでの使用 |
| 3-5 | Compilation.zig | `src/Compilation.zig` | 7942行目: サブコンパイルでの使用 |

**主要処理フロー**:
- **4628行目 (main.zig)**: `var errors = try comp.getAllErrorsAlloc();` - エラー収集
- **4631行目 (main.zig)**: `if (errors.errorMessageCount() > 0)` - エラー数チェック

### プログラム呼び出し階層図

```
Compilation.getAllErrorsAlloc()
    │
    ├─ ErrorBundle.Wip.init(gpa)
    │
    ├─ failed_c_objects.values()
    │      └─ diag_bundle.addToErrorBundle(io, &bundle)
    │
    ├─ failed_win32_resources.values()
    │      └─ bundle.addBundleAsRoots(error_bundle)
    │
    ├─ link_diags.lld.items
    │      └─ bundle.addRootErrorMessage(...)
    │
    ├─ misc_failures.values()
    │      └─ bundle.addRootErrorMessage(...)
    │
    ├─ zcu (if exists)
    │      ├─ failed_imports
    │      ├─ failed_files
    │      ├─ failed_analysis
    │      ├─ failed_codegen
    │      ├─ failed_exports
    │      └─ cimport_errors
    │
    └─ bundle.toOwnedBundle()
           └─ ErrorBundle返却
```

### データフロー図

```
[入力]                    [処理]                    [出力]

failed_c_objects ───▶
                     ┐
failed_win32_resources ─┤
                     │
link_diags.lld ─────┤    getAllErrorsAlloc() ───▶ ErrorBundle
                     │
misc_failures ──────┤
                     │
zcu.*_errors ───────┘
                                                      │
                                                      ▼
                                              stderr出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Compilation.zig | `src/Compilation.zig` | ソース | getAllErrorsAlloc関数の定義 |
| main.zig | `src/main.zig` | ソース | ErrorBundleの使用（出力） |
| Zcu.zig | `src/Zcu.zig` | ソース | failed_*マップの定義 |
| link.zig | `src/link.zig` | ソース | link_diagsの定義 |
