---
generated_at: 2026-02-01 18:25:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-AstGenError

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Zcu.zig` 207-214行目 - failed_filesマップの定義とコメント
- E-02: `src/Zcu.zig` 915-920行目 - retryable_failureステータスの定義
- E-03: `src/Zcu.zig` 921-922行目 - astgen_failureステータスの定義
- E-04: `src/Zcu.zig` 926-927行目 - successステータスの定義
- E-05: `src/Zcu.zig` 279-282行目 - skip_analysis_this_updateフラグ
- E-06: `src/Compilation.zig` 4042-4045行目 - failed_filesのソート処理
- E-07: `src/Compilation.zig` 4047-4048行目 - alive_filesチェック
- E-08: `src/Compilation.zig` 4055-4057行目 - リトライ可能エラーの処理
- E-09: `src/Compilation.zig` 4068-4072行目 - ZIR/ZOIRエラーの追加
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 11行目 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | failed_filesはFile.Indexをキー、?[]u8を値とするマップである | E-01 | ○ |
| C-02 | retryable_failureはファイルシステムエラーを示す | E-02 | ○ |
| C-03 | astgen_failureはパース/AstGen失敗を示す | E-03 | ○ |
| C-04 | successでもZIR/ZOIRエラーがある場合がある | E-04 | ○ |
| C-05 | AstGenエラー時にskip_analysis_this_updateがtrueになる | E-05 | ○ |
| C-06 | failed_filesはファイルパスでソートされる | E-06 | ○ |
| C-07 | alive_filesに含まれないファイルはスキップされる | E-07 | ○ |
| C-08 | リトライ可能エラーはaddWholeFileErrorで追加される | E-08 | ○ |
| C-09 | 非リトライエラーはaddZir/ZoirErrorMessagesで追加される | E-09 | ○ |
| C-10 | 通知種別はエラーバンドルである | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] AstGen処理フロー（Zcu/PerThread.zig）の確認
- [ ] リトライ可能エラーの再試行タイミングの確認
- [ ] ZIR/ZOIRエラー形式の確認
