---
generated_at: 2026-02-01 17:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：11-ImportError

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **エラーメッセージテンプレート**：実際の出力形式の確認が必要
  2. **送信タイミングの詳細**：AstGen後の正確なフェーズ確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Zcu.zig` 236-241行目 - failed_imports配列定義
- E-02: `src/Zcu.zig` 207-214行目 - failed_filesの説明コメント
- E-03: `src/Zcu.zig` 215-233行目 - インポートエラーの詳細説明コメント
- E-04: `src/Compilation.zig` 700-710行目 - isIllegalZigImport関数
- E-05: `src/Zcu.zig` 279-282行目 - skip_analysis_this_updateフラグ
- E-06: `src/Zcu/PerThread.zig` - updateFile関数
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 12行目 - ImportError定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | failed_importsは構造体配列として定義 | E-01 | ○ |
| C-02 | kindはfile_outside_module_rootとillegal_zig_importの2種類 | E-01 | ○ |
| C-03 | file_index, import_string, import_token, kindの4フィールド | E-01 | ○ |
| C-04 | モジュールルート外へのインポートがエラー | E-03 | ○ |
| C-05 | global_cache/b/が予約ディレクトリ | E-03, E-04 | ○ |
| C-06 | AstGen後、Sema前にエラー発生 | E-03, E-05 | ○ |
| C-07 | エラー発生時にskip_analysis_this_updateがtrue | E-05 | ○ |
| C-08 | エラーは毎回のupdateでクリア・再計算 | E-03 | ○ |
| C-09 | Zcu.import_tableでインポート管理 | E-06 | ○ |
| C-10 | isIllegalZigImport関数でパス検証 | E-04 | ○ |
| C-11 | isNested関数で包含関係チェック | E-04 | ○ |
| C-12 | エラーはエラーバンドルとして集約される | E-07 | ○ |
| C-13 | リトライなし（致命的エラー） | E-05 | ○ |
| C-14 | 参照トレース情報が含まれる場合がある | E-03 | ○ |
| C-15 | getAllErrorsAlloc関数でエラー収集 | E-07 | ○ |
| C-16 | 標準エラー出力に表示 | E-07 | ○ |
| C-17 | エラーメッセージテンプレートの正確な形式 | **根拠なし** | △ |
| C-18 | セキュリティ考慮事項（CI/CDログ） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- エラーメッセージの正確なフォーマット文字列
  - 候補：src/Zcu.zig内のエラー生成コード / lib/std/zig/ErrorBundle.zig
- CI/CDログに関するセキュリティガイドライン
  - 候補：公式ドキュメント / セキュリティポリシー文書（存在しない可能性あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - failed_importsの基本構造・フィールド定義
- 0: 低リスク - エラー種別の列挙
- 1: 中リスク - エラーメッセージの正確な表示形式
- 1: 中リスク - セキュリティ関連の記述

## 6) レビュアーチェックリスト（最小）
- [ ] E-01（Zcu.zig 236-241行目）でfailed_importsの構造を確認
- [ ] E-04（Compilation.zig 700-710行目）でisIllegalZigImportのロジック確認
- [ ] エラーメッセージの実際の出力形式を実行確認
- [ ] セキュリティ考慮事項の妥当性を組織ポリシーと照合
