---
generated_at: 2026-02-01 17:48:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：12-AnalysisError

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **エラーメッセージテンプレートの詳細形式**：実際の出力確認が必要
  2. **セキュリティ考慮事項**：組織ポリシーとの整合性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Zcu.zig` 178-182行目 - analysis_in_progress, failed_analysis, transitive_failed_analysis定義
- E-02: `src/Zcu.zig` 261-265行目 - retryable_failures定義
- E-03: `src/Zcu.zig` 179-180行目 - failed_analysisのコメント説明
- E-04: `src/Zcu.zig` 181-182行目 - transitive_failed_analysisのコメント説明
- E-05: `src/Compilation.zig` 968-999行目 - Job union定義
- E-06: `src/Zcu.zig` 250-256行目 - outdated関連マップ定義
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` 13行目 - AnalysisError定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | failed_analysisはAnalUnitをキーとするマップ | E-01 | ○ |
| C-02 | 値はErrorMsgへのポインタ | E-03 | ○ |
| C-03 | transitive_failed_analysisで推移的失敗を追跡 | E-04 | ○ |
| C-04 | retryable_failuresでリトライ可能エラーを管理 | E-02 | ○ |
| C-05 | analysis_in_progressで解析中ユニットを追跡 | E-01 | ○ |
| C-06 | Semaフェーズでエラー発生 | E-05, E-07 | ○ |
| C-07 | analyze_comptime_unitジョブでcomptime解析 | E-05 | ○ |
| C-08 | analyze_funcジョブで関数解析 | E-05 | ○ |
| C-09 | ErrorMsgのメモリはAnalUnitが所有 | E-03 | ○ |
| C-10 | outdatedになったAnalUnitのエラーはクリア | E-06 | ○ |
| C-11 | 参照トレース情報が含まれる場合がある | E-07 | ○ |
| C-12 | reference_trace設定で出力量制御可能 | E-07 | ○ |
| C-13 | 型エラー、未定義参照、comptime失敗がエラー種別 | E-07 | ○ |
| C-14 | リトライは次回update時に1回 | E-02 | ○ |
| C-15 | getAllErrorsAllocでエラー収集 | E-07 | ○ |
| C-16 | 標準エラー出力に表示 | E-07 | ○ |
| C-17 | InternPoolでAnalUnit型定義 | E-01 | ○ |
| C-18 | 循環参照検出にanalysis_in_progress使用 | E-01 | ○ |
| C-19 | エラーメッセージテンプレートの正確な形式 | **根拠なし** | △ |
| C-20 | セキュリティ考慮事項（ソースコード露出） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- エラーメッセージの正確なフォーマット文字列
  - 候補：src/Sema.zig内のエラー生成コード / lib/std/zig/ErrorBundle.zig
- セキュリティガイドライン
  - 候補：公式ドキュメント / 組織セキュリティポリシー

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - failed_analysisの基本構造定義
- 0: 低リスク - transitive_failed_analysisの役割
- 0: 低リスク - retryable_failuresの仕組み
- 1: 中リスク - エラーメッセージの正確な表示形式
- 1: 中リスク - セキュリティ関連の記述

## 6) レビュアーチェックリスト（最小）
- [ ] E-01（Zcu.zig 178-182行目）でfailed_analysisとtransitive_failed_analysisの構造を確認
- [ ] E-02（Zcu.zig 261-265行目）でretryable_failuresの仕組みを確認
- [ ] E-05（Compilation.zig 968-999行目）でJob unionの解析ジョブを確認
- [ ] エラーメッセージの実際の出力形式を実行確認
- [ ] セキュリティ考慮事項の妥当性を組織ポリシーと照合
