---
generated_at: 2026-02-01 18:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：15-UnrecognizedExtension

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **エラーメッセージの正確な形式**：実際の出力確認
  2. **大文字小文字の区別ルール**：具体的な実装確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Compilation.zig` 933-946行目 - LangToExtマッピング定義
- E-02: `src/main.zig` 396-425行目 - サポートファイルタイプのヘルプ
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` 16行目 - UnrecognizedExtension定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LangToExtでサポート拡張子を定義 | E-01 | ○ |
| C-02 | -x langオプションで種別指定可能 | E-01, E-02 | ○ |
| C-03 | .zig, .o, .a, .so等をサポート | E-02 | ○ |
| C-04 | リンク入力ファイル処理時に発生 | E-03 | ○ |
| C-05 | FileExt enumで拡張子種別定義 | E-01 | ○ |
| C-06 | link.Diags.failでエラー報告 | E-03 | ○ |
| C-07 | fatalで初期化時エラー報告 | E-03 | ○ |
| C-08 | リトライなし | E-03 | ○ |
| C-09 | c, c-header, c++等の言語名サポート | E-01 | ○ |
| C-10 | assembler, assembler-with-cppサポート | E-01 | ○ |
| C-11 | LLVM拡張機能が必要な拡張子あり | E-02 | ○ |
| C-12 | ファイルパスがメッセージに含まれる | E-03 | ○ |
| C-13 | エラーメッセージの正確な形式 | **根拠なし** | △ |
| C-14 | 大文字小文字の具体的区別ルール | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- エラーメッセージの正確なフォーマット文字列
  - 候補：src/main.zig内のエラー生成コード / src/link.zig
- 大文字小文字の区別ルールの詳細
  - 候補：src/Compilation.zig内のFileExt判定ロジック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - LangToExtマッピングの基本構造
- 0: 低リスク - サポートファイルタイプのリスト
- 1: 中リスク - エラーメッセージの正確な表示形式
- 1: 中リスク - 大文字小文字の扱い

## 6) レビュアーチェックリスト（最小）
- [ ] E-01（Compilation.zig 933-946行目）でLangToExtマッピング確認
- [ ] E-02（main.zig 396-425行目）でサポートファイルタイプ確認
- [ ] 実際のUnrecognizedExtensionエラー出力形式を確認
- [ ] 大文字小文字の扱いを実行確認（.C vs .c）
