---
generated_at: 2026-02-01 18:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：16-LinkerScriptParseError

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **サポートOUTPUT_FORMATの完全リスト**：追加形式の有無確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/link/LdScript.zig` 1-19行目 - LdScript構造体とError定義
- E-02: `src/link/LdScript.zig` 21-86行目 - parse関数
- E-03: `src/link/LdScript.zig` 42-47行目 - invalid tokenエラー
- E-04: `src/link/LdScript.zig` 67-80行目 - unexpected tokenエラー
- E-05: `src/link/LdScript.zig` 93-112行目 - Command列挙型
- E-06: `src/link/LdScript.zig` 158-160行目 - OUTPUT_FORMAT解析
- E-07: `src/link.zig` 347-356行目 - Diags.failParse関数
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 17行目 - LinkerScriptParseError定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Error型はLinkFailure, UnknownCpuArch, OutOfMemory | E-01 | ○ |
| C-02 | parse関数でトークン化と構文解析 | E-02 | ○ |
| C-03 | invalid tokenでエラー報告 | E-03 | ○ |
| C-04 | unexpected tokenでエラー報告 | E-04 | ○ |
| C-05 | Command: output_format, input, group, as_needed | E-05 | ○ |
| C-06 | elf64-x86-64をx86_64に変換 | E-06 | ○ |
| C-07 | elf64-littleaarch64をaarch64に変換 | E-06 | ○ |
| C-08 | Diags.failParseでエラー報告 | E-07 | ○ |
| C-09 | パス情報をnoteとして追加 | E-07 | ○ |
| C-10 | 行番号と列番号をエラーに含む | E-03, E-04 | ○ |
| C-11 | トークン内容をエラーに含む | E-03, E-04 | ○ |
| C-12 | コメントと改行はスキップ | E-02 | ○ |
| C-13 | Tokenizerでトークン化 | E-02 | ○ |
| C-14 | LinkFailure返却でリンク中断 | E-01, E-07 | ○ |
| C-15 | リトライなし | E-08 | ○ |
| C-16 | その他のOUTPUT_FORMAT形式サポート | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- elf32形式等の追加サポート有無
  - 候補：src/link/LdScript.zig内の他のパターンマッチ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Error型の定義
- 0: 低リスク - parse関数の基本構造
- 0: 低リスク - Command列挙型
- 0: 低リスク - エラー報告形式
- 1: 中リスク - サポートOUTPUT_FORMATの完全性

## 6) レビュアーチェックリスト（最小）
- [ ] E-01（LdScript.zig 1-19行目）でError定義確認
- [ ] E-02（LdScript.zig 21-86行目）でparse関数確認
- [ ] E-03, E-04でエラー報告フォーマット確認
- [ ] E-06（LdScript.zig 158-160行目）でOUTPUT_FORMATパターン確認
- [ ] E-07（link.zig 347-356行目）でDiags.failParse確認
