---
generated_at: 2026-02-01 18:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：18-CacheHit

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **CacheMode.wholeの詳細動作**：具体的なコード確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Compilation.zig` 192行目 - last_update_was_cache_hit定義
- E-02: `src/Zcu.zig` 84-87行目 - global_zir_cache, local_zir_cache定義
- E-03: `src/Zcu/PerThread.zig` 124-126行目 - キャッシュチェックログ
- E-04: `src/Zcu/PerThread.zig` 228-230行目 - キャッシュ成功ログ
- E-05: `src/Zcu/PerThread.zig` 348-402行目 - loadZirZoirCache関数
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 19行目 - CacheHit定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | last_update_was_cache_hitでキャッシュヒット追跡 | E-01 | ○ |
| C-02 | local_zir_cacheでローカルキャッシュ管理 | E-02 | ○ |
| C-03 | global_zir_cacheでグローバルキャッシュ管理 | E-02 | ○ |
| C-04 | log.debugでキャッシュチェックログ出力 | E-03 | ○ |
| C-05 | AstGen cached successログ出力 | E-04 | ○ |
| C-06 | loadZirZoirCacheでキャッシュ読み込み | E-05 | ○ |
| C-07 | メタデータ比較でstale判定 | E-05 | ○ |
| C-08 | ログスコープは.zcu | E-03, E-04 | ○ |
| C-09 | ファイルパスがログに含まれる | E-03, E-04 | ○ |
| C-10 | キャッシュダイジェストがログに含まれる | E-03 | ○ |
| C-11 | --time-reportでキャッシュヒットでも処理継続 | E-06 | ○ |
| C-12 | ZIRとZOIRで別々にキャッシュ管理 | E-05 | ○ |
| C-13 | success, invalid, truncated, staleの判定結果 | E-05 | ○ |
| C-14 | stat情報でメタデータ比較 | E-05 | ○ |
| C-15 | CacheMode.wholeの詳細動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- CacheMode.wholeモードでの全体キャッシュヒット判定
  - 候補：src/Compilation.zig内のCacheUse関連コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - キャッシュフラグの定義
- 0: 低リスク - ログ出力フォーマット
- 0: 低リスク - loadZirZoirCache関数
- 1: 中リスク - CacheMode.wholeの動作

## 6) レビュアーチェックリスト（最小）
- [ ] E-01（Compilation.zig 192行目）でlast_update_was_cache_hit確認
- [ ] E-02（Zcu.zig 84-87行目）でキャッシュディレクトリ確認
- [ ] E-03, E-04（PerThread.zig）でログ出力確認
- [ ] E-05（PerThread.zig 348-402行目）でloadZirZoirCache確認
- [ ] CacheMode.wholeの動作を必要に応じて確認
