---
generated_at: 2026-02-01 18:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：19-CacheMiss

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **invalidケースの詳細動作**：具体的なコード確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Zcu/PerThread.zig` 354行目 - loadZirZoirCache戻り値enum
- E-02: `src/Zcu/PerThread.zig` 131-144行目 - メタデータ比較
- E-03: `src/Zcu/PerThread.zig` 233-234行目 - stale/truncatedログ
- E-04: `src/Zcu/PerThread.zig` 246-304行目 - 再生成処理
- E-05: `src/Zcu/PerThread.zig` 304行目 - fresh successログ
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 20行目 - CacheMiss定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | loadZirZoirCacheはsuccess/invalid/truncated/staleを返す | E-01 | ○ |
| C-02 | メタデータ比較でsize, mtime, inodeをチェック | E-02 | ○ |
| C-03 | metadata changedログ出力 | E-02 | ○ |
| C-04 | stale時にlog.debug出力 | E-03 | ○ |
| C-05 | truncated時にlog.warn出力 | E-03 | ○ |
| C-06 | Ast.parseで再解析 | E-04 | ○ |
| C-07 | AstGen.generateでZIR再生成 | E-04 | ○ |
| C-08 | ZonGen.generateでZOIR再生成 | E-04 | ○ |
| C-09 | fresh successログ出力 | E-05 | ○ |
| C-10 | ログスコープは.zcu | E-03 | ○ |
| C-11 | never_loadedステータスで初回コンパイル | E-02 | ○ |
| C-12 | success/astgen_failureステータスで変更チェック | E-02 | ○ |
| C-13 | キャッシュミス時は自動再生成 | E-04 | ○ |
| C-14 | truncatedはファイルシステム問題を示唆 | E-06 | ○ |
| C-15 | ファイルパスがログに含まれる | E-03 | ○ |
| C-16 | invalidケースの詳細動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- invalidケースの具体的なログ出力有無
  - 候補：src/Zcu/PerThread.zig内のinvalid処理パス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - loadZirZoirCache戻り値
- 0: 低リスク - メタデータ比較ロジック
- 0: 低リスク - stale/truncatedログ
- 1: 中リスク - invalidケースの動作

## 6) レビュアーチェックリスト（最小）
- [ ] E-01（PerThread.zig 354行目）でloadZirZoirCache戻り値確認
- [ ] E-02（PerThread.zig 131-144行目）でメタデータ比較確認
- [ ] E-03（PerThread.zig 233-234行目）でログ出力確認
- [ ] E-04（PerThread.zig 246-304行目）で再生成処理確認
- [ ] invalidケースのログ出力を確認
