---
generated_at: 2026-02-01 18:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：20-JobQueued

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **ジョブ追加時のログ出力有無**：具体的なコード確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Compilation.zig` 300-328行目 - QueuedJobs構造体定義
- E-02: `src/Compilation.zig` 127-135行目 - work_queues配列定義
- E-03: `src/Compilation.zig` 968-999行目 - Job union定義
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 21行目 - JobQueued定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QueuedJobsはboolフラグの構造体 | E-01 | ○ |
| C-02 | compiler_rt_lib, compiler_rt_objフラグあり | E-01 | ○ |
| C-03 | ubsan_rt_lib, ubsan_rt_objフラグあり | E-01 | ○ |
| C-04 | fuzzer_libフラグあり | E-01 | ○ |
| C-05 | work_queuesはDeque配列 | E-02 | ○ |
| C-06 | Job unionで各種ジョブを表現 | E-03 | ○ |
| C-07 | codegen_func, link_nav等のジョブあり | E-03 | ○ |
| C-08 | analyze_comptime_unit, analyze_funcあり | E-03 | ○ |
| C-09 | Job.Tagでステージ決定 | E-03 | ○ |
| C-10 | musl/glibc CRTファイル用フラグあり | E-01 | ○ |
| C-11 | 共有オブジェクト用フラグあり | E-01 | ○ |
| C-12 | デフォルト値はfalse | E-01 | ○ |
| C-13 | フラグ設定でジョブキュー | E-04 | ○ |
| C-14 | ジョブ追加時のログ出力有無 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ジョブ追加時の具体的なログ出力の有無
  - 候補：src/Compilation.zig内のジョブ追加処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - QueuedJobs構造体の定義
- 0: 低リスク - work_queues配列の定義
- 0: 低リスク - Job unionの定義
- 1: 中リスク - ログ出力の有無

## 6) レビュアーチェックリスト（最小）
- [ ] E-01（Compilation.zig 300-328行目）でQueuedJobs確認
- [ ] E-02（Compilation.zig 127-135行目）でwork_queues確認
- [ ] E-03（Compilation.zig 968-999行目）でJob union確認
- [ ] ジョブ追加時のログ出力を確認
