---
generated_at: 2026-02-01 18:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：21-ClientConnected

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/IncrementalDebugServer.zig` 1-9行目（ファイルヘッダーコメント）
- E-02: `src/IncrementalDebugServer.zig` 16-28行目（構造体定義）
- E-03: `src/IncrementalDebugServer.zig` 35行目（ポート番号定義）
- E-04: `src/IncrementalDebugServer.zig` 36-41行目（spawn関数）
- E-05: `src/IncrementalDebugServer.zig` 42-110行目（runServer関数）
- E-06: `src/IncrementalDebugServer.zig` 45行目（IPv6ループバックアドレス）
- E-07: `src/IncrementalDebugServer.zig` 68行目（log.info接続通知）
- E-08: `src/IncrementalDebugServer.zig` 449行目（ログスコープ定義）
- E-09: `src/IncrementalDebugServer.zig` 11-14行目（comptime条件チェック）
- E-10: `src/Zcu.zig` 314-368行目（IncrementalDebugState定義）
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 22行目（通知定義）
- E-12: `src/IncrementalDebugServer.zig` 59行目（ConnectionAborted処理）
- E-13: `src/IncrementalDebugServer.zig` 63行目（accept失敗処理）
- E-14: `src/IncrementalDebugServer.zig` 100行目（切断処理）
- E-15: `src/IncrementalDebugServer.zig` 159-192行目（helpコマンド）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TCPポート7623でデバッグサーバーがリッスンする | E-03 | ○ |
| C-02 | IPv6ループバックアドレス（::1）のみでリッスン | E-06 | ○ |
| C-03 | 接続成功時にlog.infoで通知を出力 | E-07 | ○ |
| C-04 | ログスコープは.incremental_debug_server | E-08 | ○ |
| C-05 | シングルスレッドビルドでは利用不可 | E-09 | ○ |
| C-06 | enable_debug_extensionsが必要 | E-09 | ○ |
| C-07 | spawn関数でサーバーを開始 | E-04 | ○ |
| C-08 | runServer関数がメインループ | E-05 | ○ |
| C-09 | ConnectionAborted時はwarn出力して続行 | E-12 | ○ |
| C-10 | その他accept失敗時はerr出力してサーバー終了 | E-13 | ○ |
| C-11 | 切断時はlog.info出力 | E-14 | ○ |
| C-12 | helpコマンドでコマンド一覧表示 | E-15 | ○ |
| C-13 | IncrementalDebugStateで追加状態追跡 | E-10 | ○ |
| C-14 | 通知一覧に定義されている | E-11 | ○ |
| C-15 | telnetでREPL操作が可能 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] E-07の行番号68が実際のlog.info出力箇所と一致するか確認
- [ ] ポート番号7623が実際のconst portと一致するか確認
- [ ] ログスコープ名が正確か確認
