---
generated_at: 2026-02-01 18:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-OutdatedDependee

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Zcu.zig` 253-260行目（outdated/potentially_outdated/outdated_ready定義）
- E-02: `src/Compilation.zig` 5693行目（embed_file変更時の呼び出し）
- E-03: `src/Zcu/PerThread.zig` 443行目（zon_file変更時の呼び出し）
- E-04: `src/Zcu/PerThread.zig` 694-697行目（解析結果変更時の呼び出し）
- E-05: `docs/code-to-docs/通知一覧/通知一覧.csv` 26行目（通知定義）
- E-06: `src/Zcu.zig` markDependeeOutdated関数
- E-07: `src/Zcu.zig` markTransitiveDependersPotentiallyOutdated関数
- E-08: `src/InternPool.zig` dependencyIterator関数
- E-09: `src/Zcu.zig` 182行目（transitive_failed_analysis定義）
- E-10: `src/Zcu/PerThread.zig` 640行目（outdated.swapRemove呼び出し）
- E-11: `src/Zcu/PerThread.zig` 801行目（potentially_outdated.swapRemove呼び出し）
- E-12: `src/Zcu.zig` 3215-3218行目（outdated_ready処理）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | outdatedマップにAnalUnitを追加 | E-01, E-06 | ○ |
| C-02 | embed_file変更時にmarkDependeeOutdated呼び出し | E-02 | ○ |
| C-03 | zon_file変更時にmarkDependeeOutdated呼び出し | E-03 | ○ |
| C-04 | 解析結果変更時にmarkDependeeOutdated呼び出し | E-04 | ○ |
| C-05 | 通知一覧に定義されている | E-05 | ○ |
| C-06 | dependencyIteratorで依存元を列挙 | E-08 | ○ |
| C-07 | 推移的依存元はPOマーク | E-07 | ○ |
| C-08 | PO count=0でoutdated_readyに追加 | E-12 | ○ |
| C-09 | swapRemoveでoutdatedから削除 | E-10 | ○ |
| C-10 | potentially_outdatedからの遷移 | E-11 | ○ |
| C-11 | transitive_failed_analysisとの関連 | E-09 | ○ |
| C-12 | .not_marked_poと.marked_poの使い分け | E-02, E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] markDependeeOutdated関数のシグネチャ確認
- [ ] outdated/potentially_outdated/outdated_readyの型確認
- [ ] dependencyIteratorの戻り値型確認
