---
generated_at: 2026-02-01 18:25:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-UpToDateDependee

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Zcu.zig` 253行目（potentially_outdatedマップ定義）
- E-02: `src/Zcu/PerThread.zig` 694-698行目（any_changedに基づく分岐）
- E-03: `src/Zcu.zig` markPoDependeeUpToDate関数
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 27行目（通知定義）
- E-05: `src/Zcu/PerThread.zig` 697行目（markPoDependeeUpToDate呼び出し）
- E-06: `src/InternPool.zig` dependencyIterator関数
- E-07: `src/Zcu.zig` 256行目（outdatedマップ定義との対比）
- E-08: `src/Zcu/PerThread.zig` 640行目（potentially_outdated.swapRemove）
- E-09: `src/Zcu.zig` 3200-3204行目（findOutdatedToAnalyzeでのPO処理）
- E-10: `src/Zcu/PerThread.zig` 630行目（ensureMemoizedStateUpToDate関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | potentially_outdatedマップでPO状態管理 | E-01 | ○ |
| C-02 | any_changed==falseでmarkPoDependeeUpToDate呼び出し | E-02, E-05 | ○ |
| C-03 | 通知一覧に定義されている | E-04 | ○ |
| C-04 | dependencyIteratorで依存元を列挙 | E-06 | ○ |
| C-05 | POカウントを減少させる | E-03 | ○ |
| C-06 | カウント0で削除 | E-03 | ○ |
| C-07 | outdatedマップとの使い分け | E-07 | ○ |
| C-08 | swapRemoveで削除操作 | E-08 | ○ |
| C-09 | findOutdatedToAnalyzeでPO処理 | E-09 | ○ |
| C-10 | ensureMemoizedStateUpToDateが呼び出し元 | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] markPoDependeeUpToDate関数のシグネチャ確認
- [ ] any_changed分岐の正確性確認
- [ ] POカウント減少ロジックの確認
