---
generated_at: 2026-02-01 18:30:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-PotentiallyOutdated

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Zcu.zig` 253行目（potentially_outdatedマップ定義）
- E-02: `src/Zcu.zig` markTransitiveDependersPotentiallyOutdated関数
- E-03: `src/Zcu.zig` 3180-3274行目（findOutdatedToAnalyze関数）
- E-04: `src/Zcu.zig` 3200-3204行目（outdated_readyが空の場合の処理）
- E-05: `src/Zcu.zig` 3278-3293行目（flushRetryableFailures関数）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 28行目（通知定義）
- E-07: `src/InternPool.zig` dependencyIterator関数
- E-08: `src/Zcu.zig` 256行目（outdatedマップ定義）
- E-09: `src/Zcu/PerThread.zig` 640行目（outdated.swapRemove）
- E-10: `src/Zcu/PerThread.zig` 801行目（potentially_outdated.swapRemove）
- E-11: `src/Zcu.zig` 3243-3266行目（POユニット選択のヒューリスティック）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | potentially_outdatedマップでPO状態管理 | E-01 | ○ |
| C-02 | markTransitiveDependersPotentiallyOutdatedでPOマーク | E-02 | ○ |
| C-03 | findOutdatedToAnalyzeでPO処理 | E-03, E-04 | ○ |
| C-04 | flushRetryableFailuresからも呼び出し | E-05 | ○ |
| C-05 | 通知一覧に定義されている | E-06 | ○ |
| C-06 | dependencyIteratorで依存元を列挙 | E-07 | ○ |
| C-07 | outdatedマップとの使い分け | E-08 | ○ |
| C-08 | swapRemoveでoutdatedから削除 | E-09 | ○ |
| C-09 | swapRemoveでPOから削除 | E-10 | ○ |
| C-10 | ヒューリスティックでPOユニット選択 | E-11 | ○ |
| C-11 | PO countは依存先の数を示す | E-01, E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] markTransitiveDependersPotentiallyOutdated関数のシグネチャ確認
- [ ] findOutdatedToAnalyzeのPO処理ロジック確認
- [ ] 再帰的なPOマークの実装確認
