---
generated_at: 2026-02-01 18:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-TransitiveAnalysisFailure

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Zcu.zig` 180-182行目（failed_analysis/transitive_failed_analysis定義）
- E-02: `src/Zcu/PerThread.zig` 674-681行目（ensureMemoizedStateUpToDateでの処理）
- E-03: `src/Zcu/PerThread.zig` 678行目（transitive_failed_analysis.put）
- E-04: `src/Zcu/PerThread.zig` 679行目（log.debug出力）
- E-05: `src/Type.zig` 3848-3853行目（resolveStructLayoutでの処理）
- E-06: `src/Type.zig` 3851行目（transitive_failed_analysis.put）
- E-07: `src/IncrementalDebugServer.zig` 288-290行目（デバッグ表示）
- E-08: `docs/code-to-docs/通知一覧/通知一覧.csv` 29行目（通知定義）
- E-09: `src/Zcu.zig` 641行目（transitive_failed_analysis.swapRemove）
- E-10: `src/Zcu.zig` 181行目（failed_analysisの値が*ErrorMsg）
- E-11: `src/Zcu.zig` 182行目（transitive_failed_analysisの値がvoid）
- E-12: `src/Zcu/PerThread.zig` 675行目（failed_analysis.contains確認）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | transitive_failed_analysisマップで管理 | E-01, E-11 | ○ |
| C-02 | failed_analysis.containsがfalseの場合に追加 | E-02, E-12 | ○ |
| C-03 | transitive_failed_analysis.putで追加 | E-03, E-06 | ○ |
| C-04 | log.debugでマーク情報を出力 | E-04 | ○ |
| C-05 | Type.zigでも同様のパターン | E-05, E-06 | ○ |
| C-06 | デバッグサーバーで"(transitive)"表示 | E-07 | ○ |
| C-07 | 通知一覧に定義されている | E-08 | ○ |
| C-08 | swapRemoveでクリア | E-09 | ○ |
| C-09 | failed_analysisは*ErrorMsgを保持 | E-10 | ○ |
| C-10 | transitive_failed_analysisはvoidを保持 | E-11 | ○ |
| C-11 | error.AnalysisFailをキャッチして処理 | E-02 | ○ |
| C-12 | 冗長なエラー報告を避ける目的 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] failed_analysisとtransitive_failed_analysisの型の違い確認
- [ ] エラーハンドリングのパターン確認
- [ ] デバッグ表示の文言確認
