---
generated_at: 2026-02-01 12:20:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-AstGenCacheStale

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Zcu/PerThread.zig` 234行（log.debug "AstGen cache stale:"出力）
- E-02: `src/Zcu/PerThread.zig` 12行（log = std.log.scoped(.zcu)）
- E-03: `src/Zcu/PerThread.zig` 223-235行（キャッシュ状態判定の分岐処理）
- E-04: `src/Zcu/PerThread.zig` 79行（updateFile関数定義）
- E-05: `src/Zcu/PerThread.zig` 229行（log.debug "AstGen cached success:"）
- E-06: `src/Zcu/PerThread.zig` 233行（log.warn "unexpected EOF"）
- E-07: `src/Zcu/PerThread.zig` 220-221行（--time-report時のキャッシュヒット無視）
- E-08: `src/Zcu/PerThread.zig` 273-291行（zig/zonモードに応じたAstGen/ZonGen処理）
- E-09: `src/Zcu/PerThread.zig` 304行（log.debug "AstGen fresh success:"）
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 33行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | log.debugでAstGen cache staleが出力される | E-01 | ○ |
| C-02 | ログスコープはzcuである | E-02 | ○ |
| C-03 | loadZirZoirCacheがstaleを返した場合に通知される | E-03 | ○ |
| C-04 | updateFile関数がエントリーポイントである | E-04 | ○ |
| C-05 | キャッシュヒット時はsuccess状態となる | E-05 | ○ |
| C-06 | truncated時はlog.warnで警告が出る | E-06 | ○ |
| C-07 | --time-reportオプション時はキャッシュヒットでもAstGenが再実行される | E-07 | ○ |
| C-08 | ZONファイルの場合も同様の処理が行われる | E-08 | ○ |
| C-09 | 再生成成功時はfresh successログが出力される | E-09 | ○ |
| C-10 | 通知一覧での定義と一致 | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] loadZirZoirCache関数のstale判定ロジックが正確に文書化されているか確認
- [ ] ZONファイル処理時のキャッシュ動作が同様であることを確認
