---
generated_at: 2026-02-01 12:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-zcu

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Zcu.zig` 16行（log = std.log.scoped(.zcu)）
- E-02: `src/Zcu/PerThread.zig` 12行（log = std.log.scoped(.zcu)）
- E-03: `src/Zcu.zig` 3066行（log.debug: outdated dependee）
- E-04: `src/Zcu.zig` 3112行（log.debug: up-to-date dependee）
- E-05: `src/Zcu.zig` 3168行（log.debug: potentially outdated）
- E-06: `src/Zcu.zig` 3202-3268行（findOutdatedToAnalyze）
- E-07: `src/Zcu/PerThread.zig` 229行（log.debug: AstGen cached success）
- E-08: `src/Zcu/PerThread.zig` 234行（log.debug: AstGen cache stale）
- E-09: `src/Zcu/PerThread.zig` 278行（log.warn: unable to write cached ZIR）
- E-10: `src/Zcu.zig` 4052行（log.debug: handle type）
- E-11: `src/Zcu.zig` 4187行（log.debug: handle unit）
- E-12: `docs/code-to-docs/通知一覧/通知一覧.csv` 36行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | zcuスコープはZcu.zigで定義される | E-01 | ○ |
| C-02 | zcuスコープはPerThread.zigでも定義される | E-02 | ○ |
| C-03 | 依存先更新時にoutdated dependeeログが出力される | E-03 | ○ |
| C-04 | 依存先最新時にup-to-date dependeeログが出力される | E-04 | ○ |
| C-05 | 更新可能性時にpotentially outdatedログが出力される | E-05 | ○ |
| C-06 | 再解析対象検索時にfindOutdatedToAnalyzeログが出力される | E-06 | ○ |
| C-07 | AstGenキャッシュヒット時にcached successログが出力される | E-07 | ○ |
| C-08 | AstGenキャッシュstale時にcache staleログが出力される | E-08 | ○ |
| C-09 | ZIRキャッシュ保存失敗時にwarnログが出力される | E-09 | ○ |
| C-10 | 型処理時にhandle typeログが出力される | E-10 | ○ |
| C-11 | ユニット処理時にhandle unitログが出力される | E-11 | ○ |
| C-12 | 通知一覧での定義と一致 | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 依存関係追跡のログパターンが正確に文書化されているか確認
- [ ] AstGenキャッシュ処理のログパターンが正確に文書化されているか確認
