---
generated_at: 2026-02-01 12:55:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-codegen

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/codegen.zig` 6行（log = std.log.scoped(.codegen)）
- E-02: `src/codegen.zig` 246行（log.debug: generateLazySymbol）
- E-03: `src/codegen.zig` 317行（log.debug: generateSymbol）
- E-04: `src/codegen.zig` 764行（log.debug: lowerUavRef）
- E-05: `src/codegen.zig` 910行（log.debug: genNavRef）
- E-06: `src/codegen.zig` 1057行（log.debug: lowerValue）
- E-07: Grepによる検索結果（6ファイルでcodegenスコープ使用）
- E-08: `src/codegen/llvm.zig` でのlog.scoped(.codegen)定義
- E-09: `src/codegen/spirv/CodeGen.zig` でのlog.scoped(.codegen)定義
- E-10: `docs/code-to-docs/通知一覧/通知一覧.csv` 38行目（通知定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | codegenスコープはcodegen.zigで定義される | E-01 | ○ |
| C-02 | generateLazySymbolでdebugログが出力される | E-02 | ○ |
| C-03 | generateSymbolでdebugログが出力される | E-03 | ○ |
| C-04 | lowerUavRefでdebugログが出力される | E-04 | ○ |
| C-05 | genNavRefでdebugログが出力される | E-05 | ○ |
| C-06 | lowerValueでdebugログが出力される | E-06 | ○ |
| C-07 | 複数のバックエンドファイルでcodegenスコープが使用される | E-07 | ○ |
| C-08 | LLVMバックエンドでcodegenスコープが使用される | E-08 | ○ |
| C-09 | SPIR-Vバックエンドでcodegenスコープが使用される | E-09 | ○ |
| C-10 | 通知一覧での定義と一致 | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各バックエンド固有のログ出力パターンを確認
- [ ] ログメッセージの形式が一貫しているか確認
