---
generated_at: 2026-02-01 13:00:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-sema

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Sema.zig` 13行（log = std.log.scoped(.sema)）
- E-02: `src/Sema.zig` 9153行（log.debug: extern fn symbol expected in lib）
- E-03: `src/Sema.zig` 16665行（log.warn: unable to load）
- E-04: `src/Sema.zig` 16693行（log.warn: unable to load）
- E-05: `src/Sema.zig` 1-7行（ファイルヘッダコメント: "Semantic analysis of ZIR"）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 39行目（通知定義）
- E-07: Grepによる検索結果（Sema.zigで1ファイルのみsemaスコープ使用）
- E-08: `src/Sema.zig` インポート部（Zir、Airの参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | semaスコープはSema.zigで定義される | E-01 | ○ |
| C-02 | 外部関数シンボル解決時にdebugログが出力される | E-02 | ○ |
| C-03 | ファイル読み込み失敗時にwarnログが出力される | E-03, E-04 | ○ |
| C-04 | Sema.zigは意味解析の主実装である | E-05 | ○ |
| C-05 | 意味解析はZIRをAIRに変換する | E-05, E-08 | ○ |
| C-06 | semaスコープはSema.zigでのみ使用される | E-07 | ○ |
| C-07 | Sema.zigは非常に大規模なファイルである | ファイルサイズ | ○ |
| C-08 | 通知一覧での定義と一致 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Sema.zig内のログ使用箇所が網羅的に文書化されているか確認
- [ ] 意味解析の主要な処理フローとログ出力の関係を確認
