---
generated_at: 2026-02-01 18:10:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-SourceLocationError

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/link.zig` 43-46行目 - SourceLocation union型の定義
- E-02: `src/link.zig` 219-223行目 - failSourceLocation関数
- E-03: `src/link.zig` 230-240行目 - addErrorSourceLocation関数
- E-04: `src/link.zig` 242-250行目 - addErrorLockedFallible関数（source_location付き）
- E-05: `src/link/Wasm.zig` 572行目 - WasmリンカーでのfailSourceLocation呼び出し
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 8行目 - 通知定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SourceLocationはunion(enum)型で定義される | E-01 | ○ |
| C-02 | SourceLocationは.noneと.wasmのバリアントを持つ | E-01 | ○ |
| C-03 | failSourceLocationはaddErrorSourceLocationを呼び出す | E-02 | ○ |
| C-04 | failSourceLocationはerror.LinkFailureを返す | E-02 | ○ |
| C-05 | addErrorSourceLocationはソース位置付きでDiagsに追加する | E-03, E-04 | ○ |
| C-06 | WasmリンカーでfailSourceLocationが使用される | E-05 | ○ |
| C-07 | 通知種別は診断メッセージである | E-06 | ○ |
| C-08 | ファイル・行・列情報を含む | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Wasm以外のリンカーでのSourceLocation使用有無の確認
- [ ] ErrorBundleでのソース位置表示フォーマットの確認
- [ ] SourceLocationの拡張可能性の確認
