---
generated_at: 2026-02-01 18:25:00
metrics:
  claims_total: 35
  claims_with_evidence: 30
  claims_without_evidence: 5
confidence_derived: 0.86
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：30 / 35、根拠なし：5
- 優先レビュー（高）
  1. **NFT-005（メモリ使用量テスト）**：具体的な閾値4GBの根拠不足
  2. **NFT-006（キャッシュヒット率テスト）**：95%という数値の根拠不足
  3. **NFT-012（長時間稼働テスト）**：24時間という数値の根拠不足
  4. **NFT-032（巨大ソースファイル処理）**：100万行という閾値の根拠不足
  5. **NFT-035（リンク時間テスト）**：30秒という閾値の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/main.zig` - メインエントリポイント、コマンドライン処理、スレッド設定
- E-02: `src/tracy.zig` - Tracyプロファイラ統合、メモリアロケーショントラッキング
- E-03: `src/Compilation.zig` - コンパイル処理、キャッシュ管理、タイマー機能
- E-04: `CMakeLists.txt` - ビルド設定、LLVM 21依存関係、静的/動的リンク設定
- E-05: `README.md` - ビルド手順、テスト手順、LLDB連携説明
- E-06: `src/codegen/` - 各アーキテクチャ向けコード生成（x86_64, aarch64, riscv64, wasm等）
- E-07: `src/libs/` - libc実装（glibc, musl, wasi_libc, mingw等）
- E-08: `src/link/` - リンカ実装（Elf, MachO, Coff, Wasm）
- E-09: `test/` - テストスイート（behavior, cases, standalone, incremental等）
- E-10: `src/crash_report.zig` - クラッシュレポート生成機能
- E-11: `src/Package/` - パッケージ管理、フェッチ、マニフェスト処理
- E-12: `src/fmt.zig` - コードフォーマッタ
- E-13: `.forgejo/` - CI/CD設定
- E-14: `src/InternPool.zig` - 内部データ構造管理
- E-15: `src/Sema.zig` - セマンティック解析
- E-16: `build.zig` - Zigビルドシステム設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | シングルファイルコンパイル時間テスト | E-01, E-03 | ○ |
| C-02 | 大規模プロジェクトコンパイル時間テスト | E-03, E-16 | ○ |
| C-03 | マルチスレッドコンパイル性能（-jオプション、60MBスタック） | E-01（thread_stack_size = 60 << 20） | ○ |
| C-04 | インクリメンタルコンパイル性能 | E-01, E-03（debug_incremental） | ○ |
| C-05 | コンパイル時メモリ使用量（4GB閾値） | E-01（debug_allocator）, E-03 | △ |
| C-06 | キャッシュヒット率テスト（95%閾値） | E-03（CacheUse, last_update_was_cache_hit） | △ |
| C-07 | LLVM最適化性能（-flto） | E-01, E-04 | ○ |
| C-08 | Tracyプロファイリング統合 | E-02（enable_tracy, TracyAllocator） | ○ |
| C-09 | クロスコンパイル安定性 | E-01（targets command）, E-06 | ○ |
| C-10 | エラー回復（ErrorBundle） | E-03（ErrorBundle, misc_failures） | ○ |
| C-11 | メモリ不足時の動作 | E-03（alloc_failure_occurred） | ○ |
| C-12 | 長時間稼働テスト（24時間閾値） | E-01（--watch）, E-03 | △ |
| C-13 | 不正入力ファイル処理 | E-01（ast-check command） | ○ |
| C-14 | コンパイル時実行の安全性 | E-15（Sema） | ○ |
| C-15 | パッケージ検証（ハッシュ） | E-11（Package/Fetch.zig） | ○ |
| C-16 | スタックプロテクタ機能 | E-01, src/Package/Module.zig（stack_protector） | ○ |
| C-17 | 位置独立実行可能ファイル（PIE） | E-01（-fPIE）, E-04（ZIG_PIE） | ○ |
| C-18 | Thread Sanitizer統合 | E-03（libtsan）, E-07（libtsan.zig） | ○ |
| C-19 | C言語サニタイザ統合 | E-03（ubsan_rt_lib, ubsan_rt_obj） | ○ |
| C-20 | LLVMバージョン互換性（21.x） | E-04（find_package(llvm 21)） | ○ |
| C-21 | Clang連携互換性 | E-01（-fclang）, E-04（find_package(clang 21)） | ○ |
| C-22 | マルチOS対応 | E-04（CMakeLists.txt）, E-05 | ○ |
| C-23 | マルチアーキテクチャ対応 | E-06（x86_64, aarch64, riscv64, sparc64, wasm） | ○ |
| C-24 | libc互換性 | E-07（glibc.zig, musl.zig, wasi_libc.zig, mingw.zig等） | ○ |
| C-25 | WebAssembly対応 | E-06（wasm/）, E-08（Wasm.zig） | ○ |
| C-26 | LLDB互換性 | E-05（LLDB fork説明）, E-08（Dwarf.zig） | ○ |
| C-27 | テストスイート実行 | E-09（test/behavior, test/cases, test/standalone） | ○ |
| C-28 | Autodoc生成 | E-01（-femit-docs, std command）, E-05 | ○ |
| C-29 | コードフォーマット | E-12（fmt.zig）, E-01（fmt command） | ○ |
| C-30 | CI統合 | E-13（.forgejo/） | ○ |
| C-31 | 並列ビルド | E-03（mutex） | ○ |
| C-32 | 巨大ソースファイル処理（100万行閾値） | E-14（InternPool） | △ |
| C-33 | クラッシュレポート生成 | E-10（crash_report.zig, panic, debug） | ○ |
| C-34 | エラートレース出力 | E-03（reference_trace） | ○ |
| C-35 | リンク時間（30秒閾値） | E-08（link/, Lld.zig） | △ |

## 4) 不足情報（Unknown / Missing）
- **NFT-005のメモリ使用量閾値4GB**: コード内に具体的な閾値定義なし。運用要件または実測値に基づく設定が必要
  - 候補：実機テスト / ベンチマーク計測 / 運用チームへの確認
- **NFT-006のキャッシュヒット率95%**: コード内に目標値の定義なし。実測値に基づく設定が必要
  - 候補：CI実行ログ分析 / 開発チームへの確認
- **NFT-012の24時間稼働**: 具体的なSLA定義なし
  - 候補：運用要件定義書 / SLA文書
- **NFT-032の100万行閾値**: 具体的なスケーラビリティ要件の定義なし
  - 候補：大規模Zigプロジェクトの実例調査
- **NFT-035のリンク時間30秒**: 具体的な性能目標の定義なし
  - 候補：ベンチマーク計測 / CI実行時間分析

## 5) リスクフラグ（レビュー観点）
- **リスクレベル1（中リスク）**: NFT-005, NFT-006, NFT-012, NFT-032, NFT-035の閾値は推測値であり、実際の運用要件と乖離している可能性がある
- **リスクレベル0（低リスク）**: その他のテストケースはコードベースから直接根拠を確認できる
- **要注意**: セキュリティ関連テスト（NFT-013〜NFT-019）はコンパイラの安全性に直結するため、重点的なレビューを推奨

## 6) レビュアーチェックリスト（最小）
- [ ] NFT-005: メモリ使用量4GBの閾値は実際の運用環境で妥当か確認
- [ ] NFT-006: キャッシュヒット率95%の目標値が現実的か確認
- [ ] NFT-012: 24時間稼働の要件がプロジェクトのSLAと整合しているか確認
- [ ] NFT-032: 100万行ファイルのテストが実際に必要か確認
- [ ] NFT-035: リンク時間30秒の目標値が妥当か確認
- [ ] セキュリティテスト（NFT-013〜NFT-019）の網羅性が十分か確認
- [ ] クロスコンパイル対象アーキテクチャの優先度が正しいか確認
- [ ] CI/CD統合テストがForgejo環境で動作するか確認
