---
generated_at: 2026-02-01 18:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 28
  claims_without_evidence: 7
confidence_derived: 0.80
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：28 / 35、根拠なし：7
- 優先レビュー（高）
  1. **インクリメンタルコンパイルの目標時間**：具体的な数値目標の根拠なし
  2. **稼働率・RTO/RPO要件**：スタンドアロンツールのため該当なしとしたが、確認必要
  3. **ZIRキャッシュの詳細仕様**：実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `build.zig` - ビルド設定、スタックサイズ、max_rss設定
- E-02: `build.zig.zon` - パッケージ依存関係定義
- E-03: `.forgejo/workflows/ci.yaml` - CIパイプライン設定、タイムアウト値
- E-04: `src/main.zig` - メインエントリ、スレッドスタックサイズ、ログ設定
- E-05: `src/Compilation.zig` - コンパイル設定、キャッシュ管理、verbose設定
- E-06: `src/tracy.zig` - Tracy統合、プロファイリング機能
- E-07: `src/Package/Module.zig` - モジュール設定、サニタイザ、最適化モード
- E-08: `src/Package/Fetch.zig` - パッケージフェッチ、グローバルキャッシュ
- E-09: `src/print_env.zig` - 環境変数、キャッシュディレクトリ設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CIデバッグビルドタイムアウト180分 | E-03 | ○ |
| C-02 | CIリリースビルドタイムアウト120分 | E-03 | ○ |
| C-03 | 並列ジョブ数はCPUコア数がデフォルト | E-04 | ○ |
| C-04 | スレッドスタックサイズ60MB | E-04 (`thread_stack_size = 60 << 20`) | ○ |
| C-05 | コンパイラスタックサイズ46MB | E-01 (`stack_size = 46 * 1024 * 1024`) | ○ |
| C-06 | コンパイラmax_rss 7.9GB | E-01 (`max_rss = 7_900_000_000`) | ○ |
| C-07 | behaviorテストmax_rss 3.29GB(Linux x86_64) | E-01 | ○ |
| C-08 | stdテストmax_rss 8.27GB(macOS aarch64) | E-01 | ○ |
| C-09 | unit_tests max_rss 2.5GB | E-01 | ○ |
| C-10 | インクリメンタルコンパイル秒以内 | **根拠なし** | △ |
| C-11 | スレッドサニタイザサポート | E-07 (`sanitize_thread`) | ○ |
| C-12 | Cサニタイザサポート | E-07 (`sanitize_c`) | ○ |
| C-13 | デバッグアロケータによるメモリリーク検出 | E-04 (`DebugAllocator`) | ○ |
| C-14 | mem_leak_framesデフォルト4 | E-01, E-04 | ○ |
| C-15 | Valgrind統合サポート | E-01 (`valgrind`オプション) | ○ |
| C-16 | Debug/ReleaseSafe/ReleaseFast/ReleaseSmallモード | E-07 | ○ |
| C-17 | グローバルキャッシュによるパッケージ共有 | E-08, E-09 | ○ |
| C-18 | LLVMバックエンドサポート | E-01 (`enable_llvm`) | ○ |
| C-19 | Cバックエンドサポート | E-01 (`only_c`オプション) | ○ |
| C-20 | 複数アーキテクチャサポート | E-03 (CIジョブ一覧) | ○ |
| C-21 | 実験的ターゲット(m68k,csky,arc,xtensa) | E-01 (`llvm_has_m68k`等) | ○ |
| C-22 | zig fmtによるコードフォーマット | E-01 (`fmt`ステップ) | ○ |
| C-23 | Forgejoワークフロー使用 | E-03 | ○ |
| C-24 | Tracy統合プロファイリング | E-01, E-06 | ○ |
| C-25 | タイムレポート機能 | E-05 (`TimeReport`, `time_report`) | ○ |
| C-26 | グローバルキャッシュディレクトリ設定 | E-09 (`ZIG_GLOBAL_CACHE_DIR`) | ○ |
| C-27 | verbose_cc等の詳細出力オプション | E-05 | ○ |
| C-28 | セマンティックバージョニング0.16.0 | E-01 (`zig_version`) | ○ |
| C-29 | 稼働率要件 | **根拠なし** | △ |
| C-30 | RTO/RPO要件 | **根拠なし** | △ |
| C-31 | ZIRキャッシュ詳細仕様 | **根拠なし** | △ |
| C-32 | UBサニタイザサポート | E-05 (`ubsan_rt_strat`) | ○ |
| C-33 | リンカスナップショット機能 | E-01 (`enable_link_snapshots`) | ○ |
| C-34 | 参照トレース機能 | E-05 (`reference_trace`) | ○ |
| C-35 | WebAssembly制限事項 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **インクリメンタルコンパイルの具体的な性能目標**
  - 候補：ベンチマーク結果 / 設計書 / ロードマップ文書
- **可用性要件（稼働率、RTO、RPO）の正式定義**
  - 候補：運用マニュアル / サービスレベル定義書（該当なしの可能性高）
- **ZIRキャッシュの詳細仕様**
  - 候補：src/Zcu/PerThread.zig の詳細分析 / 内部設計ドキュメント
- **WebAssemblyターゲットの具体的な制限事項リスト**
  - 候補：ドキュメント / GitHub Issues / 言語リファレンス

## 5) リスクフラグ（レビュー観点）
- **リスク1（中リスク）**：インクリメンタルコンパイルの性能目標が未定義。開発中機能のため、実際の性能は変動する可能性あり
- **リスク0（低リスク）**：CIタイムアウト値は実測値ベースであり、環境依存で変動する可能性あり
- **リスク0（低リスク）**：max_rss値はOS/アーキテクチャごとに異なる設定がされており、適切にチューニングされている
- **リスク1（中リスク）**：実験的ターゲットのサポートはLLVM依存であり、将来的に変更される可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] CIタイムアウト値が実際の運用環境と整合しているか確認
- [ ] max_rss設定値が現在のコードベースで有効か確認
- [ ] インクリメンタルコンパイルの性能要件について開発チームに確認
- [ ] 可用性要件の「該当なし」判断が適切か確認
- [ ] 実験的ターゲットのサポート状況が最新か確認
- [ ] Tracy統合の詳細設定オプションが網羅されているか確認
- [ ] WebAssemblyターゲットの制限事項について追加調査
