# 非機能要件定義書

## 概要

本ドキュメントは、Zigプログラミング言語コンパイラプロジェクトの非機能要件を定義します。Zigは、システムプログラミング向けの汎用言語であり、高性能、安全性、可読性を重視した設計となっています。本プロジェクトはセルフホスティングコンパイラであり、複数のターゲットプラットフォームに対応したクロスコンパイル機能を提供します。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| インクリメンタルコンパイル | 秒以内 | `-fincremental`オプション使用時 |
| デバッグビルド | 180分以内（CI基準） | aarch64-linux-debug等のCIジョブのタイムアウト設定 |
| リリースビルド | 120分以内（CI基準） | aarch64-linux-release等のCIジョブのタイムアウト設定 |
| 大規模テストスイート | 360分以内（最大） | x86_64-linux-debug-llvm等の複合テストのタイムアウト設定 |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 並列ジョブ数 | CPUコア数 | `-j<N>`オプションで制限可能、デフォルトは全コア使用 |
| スレッドスタックサイズ | 60MB | `thread_stack_size = 60 << 20` |
| コンパイラスタックサイズ | 46MB | `stack_size = 46 * 1024 * 1024` |

### メモリ使用量制限

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| コンパイラ最大RSS | 7.9GB | `max_rss = 7_900_000_000` |
| behaviorテスト（Linux x86_64） | 3.29GB | OS/アーキテクチャ依存 |
| stdテスト（macOS aarch64） | 8.27GB | OS/アーキテクチャ依存 |
| unit_tests最大RSS | 2.5GB | `max_rss = 2_500_000_000` |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | - | コンパイラツールとして必要に応じて起動・停止 |
| 計画停止時間 | - | スタンドアロンツールのため該当なし |
| 障害復旧時間（RTO） | - | スタンドアロンツールのため該当なし |
| 目標復旧時点（RPO） | - | グローバルキャッシュにより中間成果物を保持 |

### マルチプラットフォーム対応

| プラットフォーム | サポート状況 |
| --- | --- |
| x86_64-linux | サポート（Debug/Release） |
| aarch64-linux | サポート（Debug/Release） |
| x86_64-windows | サポート（Debug/Release） |
| aarch64-macos | サポート（Debug/Release） |
| x86_64-freebsd | サポート（Debug/Release） |
| x86_64-openbsd | サポート（Debug/Release） |
| loongarch64-linux | サポート（Debug/Release） |
| powerpc64le-linux | サポート（Debug/Release） |
| riscv64-linux | サポート（Debug/Release） |
| s390x-linux | サポート（Debug/Release） |

## セキュリティ要件

### サニタイザサポート

| 機能 | 説明 | 設定方法 |
| --- | --- | --- |
| スレッドサニタイザ | データ競合の検出 | `sanitize_thread`オプション、`-sanitize-thread`フラグ |
| Cサニタイザ | Cコードの未定義動作検出 | `sanitize_c`オプション |
| UBサニタイザ | 未定義動作の検出 | `ubsan_rt_strat`設定 |

### メモリ安全性

| 機能 | 説明 | 設定方法 |
| --- | --- | --- |
| デバッグアロケータ | メモリリーク検出 | `debug_gpa`オプション、`DebugAllocator` |
| メモリリークフレーム数 | スタックトレース深度 | `mem_leak_frames`オプション（デフォルト: Debug時4） |
| Valgrind統合 | メモリ検査ツール統合 | `valgrind`オプション |

### ビルドモード別安全性

| モード | 最適化 | 安全性チェック |
| --- | --- | --- |
| Debug | オフ | オン |
| ReleaseSafe | オン | オン |
| ReleaseFast | オン | オフ |
| ReleaseSmall | サイズ最適化 | オフ |

## 拡張性要件

### モジュール構成

- モジュールシステムによる依存関係管理
- `build.zig.zon`によるパッケージ依存関係の宣言的定義
- グローバルパッケージキャッシュによる依存パッケージの共有

### バックエンド拡張性

| バックエンド | 説明 | オプション |
| --- | --- | --- |
| LLVM | LLVMベースのコード生成 | `-fllvm`/`-fno-llvm` |
| 自己ホスト | Zig独自のコード生成 | デフォルト |
| Cバックエンド | Cソースコード出力 | `-ofmt=c` |
| SPIR-V | GPUシェーダー向け | `-ofmt=spirv` |
| WebAssembly | WASM出力 | `-ofmt=wasm` |

### ターゲット拡張

- 複数のCPUアーキテクチャサポート（x86_64, aarch64, riscv64, wasm32等）
- 複数のOS対応（Linux, Windows, macOS, FreeBSD, OpenBSD, NetBSD等）
- 実験的ターゲット対応（m68k, csky, arc, xtensa）

## 保守性要件

### コード品質

| 項目 | 説明 | ツール/設定 |
| --- | --- | --- |
| フォーマット | 統一されたコードスタイル | `zig fmt`コマンド |
| テストカバレッジ | 広範なテストスイート | behavior, compiler-rt, std, unit tests |
| CI/CD | 継続的インテグレーション | Forgejoワークフロー |

### デバッグ機能

| 機能 | 説明 | 有効化方法 |
| --- | --- | --- |
| デバッグログ | スコープ付きログ出力 | `--debug-log`、`-Dlog`オプション |
| リンカスナップショット | リンカ状態の保存 | `-Dlink-snapshot`オプション |
| 参照トレース | エラー参照の追跡 | `-freference-trace`オプション |
| デバッグ拡張 | 開発者向けコマンド | `-Ddebug-extensions`オプション |

### バージョン管理

- セマンティックバージョニング（現在: 0.16.0）
- Gitタグベースのバージョン管理
- 開発ビルドの自動バージョン生成

## 運用・監視要件

### パフォーマンス監視

| 機能 | 説明 | 設定方法 |
| --- | --- | --- |
| Tracy統合 | プロファイリングツール統合 | `-Dtracy`オプション |
| Tracy Callstack | コールスタック情報取得 | `-Dtracy-callstack`オプション |
| Tracy Allocation | メモリ割り当て追跡 | `-Dtracy-allocation`オプション |
| タイムレポート | 処理時間計測 | `--time-report`オプション |

### キャッシュ管理

| 項目 | 説明 | パス設定 |
| --- | --- | --- |
| グローバルキャッシュ | パッケージ・ビルド成果物の共有キャッシュ | `--global-cache-dir`、`ZIG_GLOBAL_CACHE_DIR`環境変数 |
| ローカルキャッシュ | プロジェクト固有のキャッシュ | `--cache-dir`オプション |
| ZIRキャッシュ | コンパイル中間表現のキャッシュ | 自動管理 |

### 詳細出力オプション

| オプション | 説明 |
| --- | --- |
| `verbose_cc` | Clang引数の出力 |
| `verbose_air` | AIR中間表現の出力 |
| `verbose_llvm_ir` | LLVM IR出力 |
| `verbose_llvm_bc` | LLVM Bitcode出力 |
| `verbose_cimport` | Cインポート詳細 |
| `verbose_link` | リンク詳細 |

## 備考

### CIタイムアウト設定一覧

| ジョブ | タイムアウト（分） |
| --- | --- |
| aarch64-linux-debug | 180 |
| aarch64-linux-release | 120 |
| aarch64-macos-debug | 180 |
| aarch64-macos-release | 120 |
| loongarch64-linux-debug | 240 |
| loongarch64-linux-release | 180 |
| powerpc64le-linux-debug | 360 |
| powerpc64le-linux-release | 240 |
| riscv64-linux-debug | 660 |
| riscv64-linux-release | 540 |
| s390x-linux-debug | 360 |
| s390x-linux-release | 300 |
| x86_64-freebsd-debug | 120 |
| x86_64-freebsd-release | 120 |
| x86_64-linux-debug | 180 |
| x86_64-linux-debug-llvm | 360 |
| x86_64-linux-release | 360 |
| x86_64-openbsd-debug | 120 |
| x86_64-openbsd-release | 120 |
| x86_64-windows-debug | 180 |
| x86_64-windows-release | 180 |

### 制限事項

- WebAssemblyターゲットでの一部機能制限
- 実験的ターゲット（m68k, csky, arc, xtensa）はLLVM拡張が必要
- インクリメンタルコンパイルは開発中の機能
