# ECシステム運用管理システム インフラ設計書

## 1. システム概要

本システムは、ECサイトの運用管理を効率化するためのWebアプリケーションです。主な機能として以下が含まれます：

- 在庫管理（WMSとの連携、リアルタイム在庫同期）
- システム監視（アラート検知、監視レポート生成）
- 顧客通知管理（メール送信、マイページ通知）
- 注文・決済・配送管理（ステータス同期、配送業者連携）
- 外部システム連携（接続設定管理、データマッピング）

## 2. インフラ構成図

```
                                    +-------------------+
                                    |   Route 53        |
                                    | (DNS管理)         |
                                    +--------+----------+
                                             |
                                    +--------v----------+
                                    |   CloudFront      |
                                    | (CDN)             |
                                    +--------+----------+
                                             |
+-------------------+            +--------v----------+
|  WAF              |----------->|   ALB             |
| (Webアプリケーション|            | (負荷分散)         |
|  ファイアウォール)  |            +--------+----------+
+-------------------+                     |
                                 +--------v----------+
                                 |   Auto Scaling    |
                                 |   Group           |
                                 +--------+----------+
                                          |
                        +----------------+----------------+
                        |                                 |
               +--------v----------+            +---------v---------+
               |   EC2 (Web/App)   |            |   EC2 (Web/App)   |
               |                   |            |                   |
               +--------+----------+            +---------+---------+
                        |                                 |
                        +-----------------+---------------+
                                          |
          +----------------------------+--+--+----------------------------+
          |                            |     |                            |
+---------v---------+         +--------v----------+            +---------v---------+
|   RDS             |         |   ElastiCache     |            |   Amazon SQS      |
| (データベース)     |         | (キャッシュ)       |            | (メッセージキュー) |
+-------------------+         +-------------------+            +-------------------+
          |
+---------v---------+
|   Aurora          |
| (読み取りレプリカ) |
+-------------------+

                    +-------------------+            +-------------------+
                    |   S3              |            |   CloudWatch      |
                    | (ファイルストレージ)|            | (監視・ロギング)   |
                    +-------------------+            +-------------------+

                    +-------------------+            +-------------------+
                    |   Lambda          |            |   AWS SES         |
                    | (サーバーレス処理) |            | (メール送信)       |
                    +-------------------+            +-------------------+

                    +-------------------+            +-------------------+
                    |   AWS Secrets     |            |   EventBridge     |
                    |   Manager         |            | (スケジュール実行) |
                    +-------------------+            +-------------------+
```

## 3. コンポーネント詳細

### 3.1 ネットワーク・セキュリティ

#### Amazon Route 53
- 用途: DNSサービス、ドメイン管理
- 役割: システムへのアクセスを適切なエンドポイントに誘導

#### Amazon CloudFront
- 用途: コンテンツ配信ネットワーク(CDN)
- 役割: 静的コンテンツのキャッシュ、配信高速化、DDoS対策

#### AWS WAF
- 用途: Webアプリケーションファイアウォール
- 役割: XSS、SQLインジェクションなどの攻撃からの保護

#### Application Load Balancer (ALB)
- 用途: トラフィック負荷分散
- 役割: HTTPSターミネーション、ヘルスチェック、複数AZへのトラフィック分散

### 3.2 コンピューティング

#### Amazon EC2 (Auto Scaling Group)
- 用途: Webサーバー、アプリケーションサーバー
- インスタンスタイプ: t3.medium（初期推奨）
- 構成: 複数のアベイラビリティゾーンに分散
- スケーリング: CPU使用率70%を超えた場合に自動スケールアウト

#### AWS Lambda
- 用途: サーバーレス関数
- 役割:
  - 在庫データ検証（No.2）
  - 異常検知アラート生成（No.6）
  - 監視レポート生成（No.8）
  - 注文ステータス同期（No.17）
  - 支払状況検証（No.19）

### 3.3 データストア

#### Amazon RDS (Aurora MySQL)
- 用途: リレーショナルデータベース
- 構成: マルチAZ配置、読み取りレプリカ
- データ: 注文情報、在庫情報、顧客情報、アラート情報、監視データ等

#### Amazon ElastiCache (Redis)
- 用途: インメモリキャッシュ
- 役割: セッション管理、頻繁にアクセスされるデータのキャッシュ

#### Amazon S3
- 用途: オブジェクトストレージ
- 役割: 
  - 監視レポートの保存
  - メールテンプレートの保存
  - ログファイルの長期保存

### 3.4 メッセージング・通知

#### Amazon SQS
- 用途: メッセージキュー
- 役割:
  - 在庫同期処理のキュー管理
  - メール送信処理のキュー管理
  - 外部システム連携処理のキュー管理

#### Amazon SES
- 用途: メール送信サービス
- 役割: 発送完了メール等の顧客通知メール送信（No.13）

### 3.5 監視・運用

#### Amazon CloudWatch
- 用途: モニタリング、ロギング
- 役割:
  - システムメトリクス収集
  - アラート通知
  - ログ集約管理
  - ダッシュボード表示（No.11）

#### AWS EventBridge
- 用途: イベント駆動型処理のスケジューリング
- 役割:
  - リアルタイム在庫同期バッチ実行（No.1）
  - 監視レポート生成バッチ実行（No.8）
  - 注文ステータス同期バッチ実行（No.17）

### 3.6 セキュリティ・認証

#### AWS Secrets Manager
- 用途: 機密情報管理
- 役割: 外部システム連携の認証情報、API鍵の安全な管理（No.12）

## 4. 環境構成

### 4.1 環境分離

以下の環境を分離して構築します：

- 開発環境（Development）
- テスト環境（Staging）
- 本番環境（Production）

各環境は独立したAWSアカウントまたはVPC内に構築し、データの分離を徹底します。

### 4.2 ネットワーク構成

- VPC: 各環境ごとに独立したVPC
- サブネット:
  - パブリックサブネット: ALB配置用（複数AZ）
  - プライベートサブネット: EC2、RDS配置用（複数AZ）
- セキュリティグループ:
  - ALB: 80/443ポートのみ外部公開
  - EC2: ALBからの通信のみ許可
  - RDS: EC2からの通信のみ許可

## 5. スケーラビリティ設計

### 5.1 水平スケーリング
- EC2: Auto Scaling Groupによる自動スケール
- RDS: 読み取りレプリカによる読み取り負荷分散

### 5.2 垂直スケーリング
- EC2: インスタンスタイプの変更（負荷に応じて）
- RDS: インスタンスクラスの変更（データ量に応じて）

## 6. 高可用性設計

### 6.1 冗長化
- 複数のアベイラビリティゾーンにリソースを分散配置
- ALBによる負荷分散とフェイルオーバー
- RDSのマルチAZ配置

### 6.2 バックアップ戦略
- RDS: 自動バックアップ（毎日、保持期間7日）
- EC2: AMIバックアップ（週次）
- S3: バージョニング有効化
- データエクスポート: 重要データの定期エクスポート（日次）

## 7. セキュリティ設計

### 7.1 ネットワークセキュリティ
- VPC設計: プライベートサブネットでのシステム稼働
- WAF: Webアプリケーション保護
- セキュリティグループ: 最小権限の原則に基づく設定

### 7.2 データセキュリティ
- 転送中の暗号化: HTTPS通信の強制
- 保存時の暗号化: RDS、S3のデータ暗号化
- 機密情報: Secrets Managerでの管理

### 7.3 認証・認可
- IAM: 最小権限の原則に基づくロール設定
- MFA: 管理者アクセス時の多要素認証強制

## 8. 運用設計

### 8.1 監視体制
- CloudWatch: システムメトリクスの監視
- アラート設定:
  - CPU使用率: 80%超過で通知
  - メモリ使用率: 80%超過で通知
  - ディスク使用率: 80%超過で通知
  - RDSコネクション: 80%超過で通知
  - API応答時間: 3秒超過で通知
  - エラーレート: 5%超過で通知

### 8.2 ログ管理
- CloudWatch Logs: 集中ログ管理
- ログ保持期間: 30日（CloudWatch Logs）、365日（S3アーカイブ）

### 8.3 バッチ処理管理
- EventBridge: スケジュール実行
- 実行監視: CloudWatch Logsでの実行結果確認
- 失敗時通知: SNSによる管理者通知

## 9. コスト最適化

### 9.1 コスト削減策
- リザーブドインスタンス: 安定稼働するEC2、RDSに適用
- Auto Scaling: 負荷に応じたリソース調整
- S3ライフサイクル: 古いデータの低コストストレージへの自動移行

### 9.2 コスト監視
- AWS Cost Explorer: 定期的なコスト分析
- Budget: 予算アラートの設定

## 10. 導入・移行計画

### 10.1 導入フェーズ
1. インフラ基盤構築（VPC、サブネット等）
2. コア機能の実装（在庫同期、監視機能）
3. 外部連携機能の実装（WMS連携、配送業者連携）
4. 通知機能の実装（メール送信、マイページ通知）

### 10.2 テスト計画
- 単体テスト: 各コンポーネントの機能検証
- 統合テスト: 外部システム連携の検証
- 負荷テスト: 高負荷時の動作検証
- 障害復旧テスト: フェイルオーバー、バックアップリストア検証

## 11. 災害復旧計画

### 11.1 RTO/RPO目標
- Recovery Time Objective (RTO): 4時間以内
- Recovery Point Objective (RPO): 24時間以内

### 11.2 DR戦略
- バックアップ復旧: RDSスナップショット、S3データの別リージョン複製
- パイロットライト: 別リージョンに最小限の環境を維持
