# ECサイト運用マニュアル

## 目次
1. [はじめに](#はじめに)
2. [商品登録～公開](#商品登録公開)
   1. [商品マスタ作成](#商品マスタ作成)
   2. [商品情報入力](#商品情報入力)
   3. [管理コード割り当て](#管理コード割り当て)
   4. [商品画像のアップロード](#商品画像のアップロード)
   5. [在庫数の登録/連携](#在庫数の登録連携)
3. [注文受付～発送](#注文受付発送)
   1. [受注データ確認](#受注データ確認)
   2. [支払ステータス確認](#支払ステータス確認)
   3. [出荷ステータスの付与](#出荷ステータスの付与)
   4. [納品書・送り状の発行](#納品書送り状の発行)
   5. [発送完了メールの自動送信](#発送完了メールの自動送信)
4. [返品・キャンセル対応](#返品キャンセル対応)
   1. [返品・交換の承認/否認処理](#返品交換の承認否認処理)
   2. [在庫の返却処理・ステータス反映](#在庫の返却処理ステータス反映)
   3. [返金処理](#返金処理)
   4. [顧客対応完了メールの送信](#顧客対応完了メールの送信)
5. [システム連携](#システム連携)
   1. [リアルタイム在庫同期システム](#リアルタイム在庫同期システム)
   2. [統合監視ダッシュボード](#統合監視ダッシュボード)

## はじめに

本マニュアルは、ECサイト運営における主要な業務プロセスとシステム操作方法を解説します。EC運営チーム、撮影・商品情報チーム、物流担当、カスタマーサポート担当者向けに作成されています。

## 商品登録～公開

### 商品マスタ作成

**作業担当**: EC運営チーム  
**作業頻度**: 週15回  
**作業時間**: 5分/件

1. 管理画面にログイン
2. 「商品管理」→「商品マスタ」を選択
3. 「新規作成」ボタンをクリック
4. 必要な基本情報を入力（商品カテゴリ、商品分類など）
5. 「保存」をクリックして商品マスタを作成

### 商品情報入力

**作業担当**: EC運営チーム  
**作業頻度**: 週15回  
**作業時間**: 10分/件

1. 作成した商品マスタを選択
2. 「商品情報」タブを選択
3. 以下の情報を入力：
   - 商品名
   - 価格情報（定価、販売価格）
   - 商品説明文
   - 商品スペック
   - 販売期間（設定する場合）
4. 「保存」をクリック

### 管理コード割り当て

**作業担当**: EC運営チーム  
**作業頻度**: 週15回  
**作業時間**: 5分/件

1. 対象商品の編集画面を開く
2. 「管理情報」タブを選択
3. 以下のコードを割り当て：
   - 商品管理コード
   - JANコード（ある場合）
   - SKUコード（バリエーション別）
4. 「保存」をクリック

### 商品画像のアップロード

**作業担当**: EC運営チーム  
**作業頻度**: 週15回  
**作業時間**: 30分/件

1. 対象商品の編集画面を開く
2. 「画像管理」タブを選択
3. 「画像追加」ボタンをクリック
4. アップロードする画像ファイルを選択
5. 画像情報を入力：
   - 画像タイトル
   - 代替テキスト
   - 表示順序
6. メイン画像とサブ画像の順序を指定
7. サムネイル画像の設定を調整
8. 「保存」をクリック
9. プレビュー機能で表示確認を行う

### 在庫数の登録/連携

**作業担当**: EC運営チーム  
**作業頻度**: 週1回  
**作業時間**: 5分/件

1. 「在庫管理」メニューを選択
2. 対象商品を検索
3. 現在の在庫数を確認
4. 「在庫数更新」ボタンをクリック
5. 新しい在庫数を入力
6. 「保存」をクリック
7. リアルタイム在庫同期システムの稼働状況を確認

**注意**: リアルタイム在庫同期システムにより、WMSとECシステム間の在庫は自動的に同期されます。異常値検知・アラート機能により、在庫不整合は自動的に検知されます。

## 注文受付～発送

### 受注データ確認

**作業担当**: EC運営チーム  
**作業頻度**: 週25回  
**作業時間**: 20分/件

1. 「受注管理」メニューを選択
2. 「新規受注一覧」を表示
3. 各注文の内容を確認：
   - 注文商品
   - 数量
   - 配送先情報
   - 支払方法
4. 不正注文チェックを実施：
   - 不自然な大量注文
   - 配送先と請求先の著しい不一致
   - 過去の不正履歴との照合

### 支払ステータス確認

**作業担当**: EC運営チーム  
**作業頻度**: 週25回  
**作業時間**: 15分/件

1. 「受注管理」→「支払い状況」を選択
2. 支払方法別にステータスを確認：
   - クレジット決済（約70%）: 決済完了確認
   - コンビニ/銀行振込（約30%）: 入金確認

### 出荷ステータスの付与

**作業担当**: EC運営チーム  
**作業頻度**: 週25回  
**作業時間**: 5分/件

1. 「受注管理」→「出荷管理」を選択
2. 支払完了済みの注文を選択
3. 「出荷準備中」ステータスに変更
4. 「保存」をクリック

### 納品書・送り状の発行

**作業担当**: EC運営チーム  
**作業頻度**: 週25回  
**作業時間**: 20分/件

1. 「出荷管理」→「伝票発行」を選択
2. 発送方法を判断（宅配便/メール便/その他）
3. 該当する出荷準備中の注文を選択
4. 「納品書発行」ボタンをクリック
5. 納品書データをCSV形式で出力
6. 「送り状データ出力」ボタンをクリック
7. 配送業者システムに適合するフォーマットでデータ出力
8. WMSへのデータ連携を実行
9. 発送後、ステータスを「発送済み」に更新

### 発送完了メールの自動送信

**作業担当**: ECシステム（自動処理）  
**作業頻度**: 週25回  
**作業時間**: 1分/件

1. 出荷ステータスが「発送済み」に変更されると自動送信
2. メールテンプレート：
   - お客様情報
   - 注文番号
   - 発送日
   - 配送業者名
   - 追跡番号
   - 商品明細

## 返品・キャンセル対応

### 返品・交換の承認/否認処理

**作業担当**: カスタマーサポート(CS)  
**作業頻度**: 週30回  
**作業時間**: 15分/件

1. お客様からの問い合わせを受信
2. 「カスタマーサポート」→「返品・交換申請」を選択
3. 該当する注文情報を検索
4. 発送ステータスを確認
5. 返品可否の判断を実施：
   - 返品理由の確認
   - 商品状態の確認
   - 返品期間内かどうか
6. 判断結果に基づいて対応：
   - 承認（約80%）: 返送方法と返送先を案内
   - 否認（約20%）: 丁寧に理由を説明

### 在庫の返却処理・ステータス反映

**作業担当**: 物流担当  
**作業頻度**: 週15回  
**作業時間**: 20分/件

1. 返送された商品を受領・検品
2. 商品状態の判定：
   - 良品（約70%）: 再販可能
   - 不良品（約30%）: 廃棄または修理
3. 良品の場合：
   - 「在庫管理」→「返品処理」を選択
   - 該当商品のバーコードをスキャン
   - 「在庫再登録」を実行
4. 不良品の場合：
   - 「在庫管理」→「不良品処理」を選択
   - 処理区分を選択（廃棄/修理/その他）
   - 理由を記録

### 返金処理

**作業担当**: カスタマーサポート(CS)  
**作業頻度**: 週15回  
**作業時間**: 15分/件

1. 「返品管理」→「返金処理」を選択
2. 該当する返品申請を検索
3. 返金方法を確認（元の支払い方法に準じる）
4. 返金額を入力：
   - 商品代金
   - 送料（返品理由により判断）
   - 手数料
5. ポイント・クーポン処理：
   - 使用ポイントの返還
   - 付与ポイントの取り消し
   - クーポンの再発行/無効化

### 顧客対応完了メールの送信

**作業担当**: カスタマーサポート(CS)  
**作業頻度**: 週15回  
**作業時間**: 1分/件（自動）

1. 「返品管理」→「顧客連絡」を選択
2. 該当する返品申請を選択
3. 「対応完了メール送信」ボタンをクリック
4. メール内容を確認：
   - 返金金額
   - 返金方法
   - 返金完了予定日
   - お問い合わせ先
5. 「送信」をクリック
6. チケットクローズ処理を実行

## システム連携

### リアルタイム在庫同期システム

**作業担当**: システム連携基盤（自動処理）

1. WMS在庫データとECシステム在庫データの自動同期
2. 同期頻度: リアルタイム（在庫変動時）
3. 同期対象:
   - 商品ID
   - 在庫数
   - 在庫ステータス
   - ロケーション情報

### 統合監視ダッシュボード

**作業担当**: システム連携基盤  
**作業頻度**: 週1回  
**作業時間**: 5分/件

1. 「システム管理」→「統合監視ダッシュボード」を選択
2. 以下の項目を確認：
   - システム間連携状況
   - 在庫同期エラー
   - API連携エラー
   - 処理パフォーマンス
3. 異常検知アラートの確認
4. 監視結果レポートの生成

**注意**: 手動による異常値チェックは、自動異常値検知・アラート機能により不要になりました。ただし、定期的な監視ダッシュボードの確認は継続してください。
