# ECシステム バッチ設計書

## 概要・目的

本ドキュメントは、ECサイト運営システムにおけるバッチ処理の設計仕様を定義するものである。在庫管理、注文処理、決済処理、通知管理、監視機能などの自動化処理に関する仕様を記載し、システムの安定稼働と業務効率化を図ることを目的とする。

バッチ処理は、定期的な処理や大量データ処理を自動化することで、手動操作の負担軽減、処理の正確性向上、システム全体の整合性維持を実現する。特に「リアルタイム在庫同期」「注文ステータス同期」「監視レポート生成」などの機能は、ECサイト運営において重要な役割を果たす。

## バッチ一覧

| No | 機能名 | 機能概要 | 実行頻度 | 実行時刻 | 依存関係 |
|----|-------|---------|---------|---------|---------|
| 1 | リアルタイム在庫同期 | WMSと連携して在庫データをリアルタイムに同期する | 5分毎 | 24時間 | WMS接続設定 |
| 2 | 在庫データ検証 | 同期された在庫データの整合性を検証する | 1時間毎 | 24時間 | リアルタイム在庫同期 |
| 3 | 在庫同期ログ記録 | 在庫同期処理の実行ログを記録する | 5分毎 | 24時間 | リアルタイム在庫同期 |
| 4 | 異常検知アラート生成 | 在庫データや連携処理の異常を自動検知してアラートを生成する | 10分毎 | 24時間 | 在庫データ検証 |
| 5 | 監視レポート生成 | システム監視データを集計し、定期的にレポートを生成する | 1日1回 | 06:00 | 異常検知アラート生成、在庫同期ログ記録 |
| 6 | 注文ステータス同期 | 外部システムとの注文ステータス情報を同期する | 15分毎 | 24時間 | なし |
| 7 | 支払状況検証 | 注文の支払状況を定期的に検証する | 1時間毎 | 24時間 | 注文ステータス同期 |
| 8 | 出荷ステータス管理 | 注文の出荷ステータスを管理する | 30分毎 | 08:00-20:00 | 注文ステータス同期 |
| 9 | 発送完了メール送信 | 注文商品の発送完了時に顧客へメールを自動送信する | 30分毎 | 08:00-20:00 | 出荷ステータス管理 |
| 10 | マイページ更新通知 | 顧客マイページの情報更新時に通知を生成する | 30分毎 | 24時間 | 注文ステータス同期、出荷ステータス管理 |

## 各バッチ詳細

### 1. リアルタイム在庫同期

#### 1-1 機能概要

WMSと連携して在庫データをリアルタイムに同期する（Create/Update）機能。定期的に在庫データを取得し、ECシステムの在庫情報を最新状態に保つ。異常データの検出時はアラートを発行する。

#### 1-2 処理フロー

1. WMSへの接続確立
2. 前回同期時刻以降に更新された在庫データの取得
3. データマッピング設定に基づくデータ変換
4. ECシステムの在庫データ更新
   - 新規商品の場合：在庫レコード作成
   - 既存商品の場合：在庫数更新
5. 同期結果のログ記録
6. 処理完了通知

#### 1-3 入力データ仕様

| データソース | 項目名 | データ型 | 説明 |
|-------------|-------|---------|------|
| WMS在庫データ | SKU/JANコード | 文字列 | 商品識別コード |
| WMS在庫データ | 商品名 | 文字列 | 商品の名称 |
| WMS在庫データ | 在庫数 | 整数 | 現在の在庫数量 |
| WMS在庫データ | ロケーションコード | 文字列 | 倉庫内の保管場所 |
| WMS在庫データ | 更新日時 | 日時 | 在庫情報の最終更新日時 |
| データマッピング設定 | 変換ルール | オブジェクト | WMSとECシステム間のデータ項目対応 |

#### 1-4 出力データ仕様

| データ先 | 項目名 | データ型 | 説明 |
|---------|-------|---------|------|
| ECシステム在庫データ | 商品ID | 文字列 | ECシステム内の商品識別子 |
| ECシステム在庫データ | SKU/JANコード | 文字列 | 商品識別コード |
| ECシステム在庫データ | 在庫数 | 整数 | 現在の在庫数量 |
| ECシステム在庫データ | ステータス | 文字列 | 在庫状態（在庫あり/品切れ/入荷待ち等） |
| ECシステム在庫データ | 更新日時 | 日時 | 在庫情報の最終更新日時 |
| 在庫同期ログ | 処理ID | 文字列 | 同期処理の一意識別子 |
| 在庫同期ログ | 開始時刻 | 日時 | 処理開始時刻 |
| 在庫同期ログ | 終了時刻 | 日時 | 処理終了時刻 |
| 在庫同期ログ | 処理結果 | 文字列 | 成功/失敗 |
| 在庫同期ログ | 処理件数 | 整数 | 同期した商品数 |
| 在庫同期ログ | エラー情報 | 文字列 | エラーが発生した場合の詳細情報 |

#### 1-5 エラー処理

| エラーコード | エラー内容 | 対応方法 |
|------------|----------|---------|
| E001 | WMS接続エラー | 接続設定を確認し、リトライ実行。3回失敗で管理者通知 |
| E002 | データ取得エラー | WMSのAPI状態を確認し、リトライ実行。3回失敗で管理者通知 |
| E003 | データ変換エラー | データマッピング設定を確認し、エラーログ記録後、次の商品処理へ進む |
| E004 | DB更新エラー | トランザクションロールバック後、リトライ実行。3回失敗で管理者通知 |
| E005 | 異常データ検出 | アラート発行し、該当商品のみ同期をスキップ |

#### 1-6 実行条件

- 実行頻度：5分毎
- 実行時間：24時間
- 前提条件：WMS接続設定が正しく構成されていること
- 排他制御：同一バッチの多重起動を防止するためのロック機構を実装

#### 1-7 ログ出力仕様

| ログレベル | 出力内容 | 出力タイミング |
|----------|---------|--------------|
| INFO | 処理開始 | バッチ処理開始時 |
| INFO | 処理件数 | データ取得完了時 |
| INFO | 処理完了 | バッチ処理完了時 |
| WARN | 在庫数の大幅変動検出 | 前回比で±30%以上の変動がある場合 |
| ERROR | 接続エラー | WMSとの接続に失敗した場合 |
| ERROR | データ更新エラー | DBへの更新に失敗した場合 |
| DEBUG | 詳細処理内容 | 開発モード時のみ出力 |

#### 1-8 リトライ設計

- 最大リトライ回数：3回
- リトライ間隔：初回30秒、以降は倍々で増加（30秒→1分→2分）
- リトライ対象エラー：接続エラー、データ取得エラー、DB更新エラー
- リトライ上限超過時：アラート発行と管理者通知

### 2. 在庫データ検証

#### 2-1 機能概要

同期された在庫データの整合性を検証する（Read）機能。在庫数の急激な変動や異常値を検出し、問題がある場合はアラートを発行する。

#### 2-2 処理フロー

1. 最新の在庫データ取得
2. 前回検証時の在庫データ取得
3. 異常値検出ロジックの適用
   - 在庫数の急激な変動チェック
   - ゼロ在庫から大量在庫への変化チェック
   - 販売実績と在庫減少の整合性チェック
4. 異常値検出時のフラグ設定
5. 検証結果の記録
6. 異常検出時のアラート発行

#### 2-3 入力データ仕様

| データソース | 項目名 | データ型 | 説明 |
|-------------|-------|---------|------|
| ECシステム在庫データ | 商品ID | 文字列 | ECシステム内の商品識別子 |
| ECシステム在庫データ | SKU/JANコード | 文字列 | 商品識別コード |
| ECシステム在庫データ | 在庫数 | 整数 | 現在の在庫数量 |
| ECシステム在庫データ | 更新日時 | 日時 | 在庫情報の最終更新日時 |
| 在庫履歴データ | 商品ID | 文字列 | ECシステム内の商品識別子 |
| 在庫履歴データ | 在庫数 | 整数 | 過去の在庫数量 |
| 在庫履歴データ | 記録日時 | 日時 | 履歴が記録された日時 |
| 注文データ | 商品ID | 文字列 | 注文された商品ID |
| 注文データ | 数量 | 整数 | 注文数量 |
| 注文データ | 注文日時 | 日時 | 注文が発生した日時 |

#### 2-4 出力データ仕様

| データ先 | 項目名 | データ型 | 説明 |
|---------|-------|---------|------|
| 在庫検証結果 | 検証ID | 文字列 | 検証処理の一意識別子 |
| 在庫検証結果 | 実行日時 | 日時 | 検証を実行した日時 |
| 在庫検証結果 | 検証商品数 | 整数 | 検証対象となった商品数 |
| 在庫検証結果 | 異常検出数 | 整数 | 異常が検出された商品数 |
| 異常検出データ | 商品ID | 文字列 | 異常が検出された商品ID |
| 異常検出データ | 異常タイプ | 文字列 | 検出された異常の種類 |
| 異常検出データ | 現在値 | 整数 | 現在の在庫数 |
| 異常検出データ | 前回値 | 整数 | 前回の在庫数 |
| 異常検出データ | 変動率 | 小数 | 在庫数の変動率 |
| 異常検出データ | 検出日時 | 日時 | 異常を検出した日時 |

#### 2-5 エラー処理

| エラーコード | エラー内容 | 対応方法 |
|------------|----------|---------|
| E101 | データ取得エラー | DBアクセスを確認し、リトライ実行。3回失敗で管理者通知 |
| E102 | 検証処理エラー | エラーログ記録後、次の検証項目へ進む |
| E103 | 履歴データ不足 | 警告ログ記録し、利用可能なデータのみで検証実行 |
| E104 | アラート発行失敗 | エラーログ記録後、管理者へ別経路で通知 |

#### 2-6 実行条件

- 実行頻度：1時間毎
- 実行時間：24時間
- 前提条件：リアルタイム在庫同期が正常に実行されていること
- 排他制御：同一バッチの多重起動を防止するためのロック機構を実装

#### 2-7 ログ出力仕様

| ログレベル | 出力内容 | 出力タイミング |
|----------|---------|--------------|
| INFO | 検証開始 | バッチ処理開始時 |
| INFO | 検証結果サマリー | 検証完了時 |
| WARN | 異常値検出 | 異常値が検出された場合 |
| ERROR | データ取得エラー | データ取得に失敗した場合 |
| ERROR | 検証処理エラー | 検証ロジック実行中にエラーが発生した場合 |
| DEBUG | 詳細検証内容 | 開発モード時のみ出力 |

#### 2-8 リトライ設計

- 最大リトライ回数：3回
- リトライ間隔：初回30秒、以降は倍々で増加（30秒→1分→2分）
- リトライ対象エラー：データ取得エラー
- リトライ上限超過時：アラート発行と管理者通知

### 3. 在庫同期ログ記録

#### 3-1 機能概要

在庫同期処理の実行ログを記録する（Create）機能。同期の開始/終了時刻、処理件数、エラー情報などを保存し、トラブルシューティングに活用する。

#### 3-2 処理フロー

1. 在庫同期処理の開始ログ記録
2. 処理中の重要イベントログ記録
3. エラー発生時の詳細情報記録
4. 処理完了時の結果サマリー記録
5. ログデータのDB保存
6. 長期保存ログのアーカイブ処理

#### 3-3 入力データ仕様

| データソース | 項目名 | データ型 | 説明 |
|-------------|-------|---------|------|
| リアルタイム在庫同期 | 処理ID | 文字列 | 同期処理の一意識別子 |
| リアルタイム在庫同期 | 開始時刻 | 日時 | 処理開始時刻 |
| リアルタイム在庫同期 | 終了時刻 | 日時 | 処理終了時刻 |
| リアルタイム在庫同期 | 処理結果 | 文字列 | 成功/失敗 |
| リアルタイム在庫同期 | 処理件数 | 整数 | 同期した商品数 |
| リアルタイム在庫同期 | エラー情報 | 文字列 | エラーが発生した場合の詳細情報 |
| システム情報 | サーバー名 | 文字列 | 処理を実行したサーバー名 |
| システム情報 | プロセスID | 整数 | 実行プロセスのID |

#### 3-4 出力データ仕様

| データ先 | 項目名 | データ型 | 説明 |
|---------|-------|---------|------|
| 在庫同期ログ | ログID | 文字列 | ログの一意識別子 |
| 在庫同期ログ | 処理ID | 文字列 | 同期処理の一意識別子 |
| 在庫同期ログ | ログレベル | 文字列 | INFO/WARN/ERROR/DEBUG |
| 在庫同期ログ | タイムスタンプ | 日時 | ログが記録された日時 |
| 在庫同期ログ | メッセージ | 文字列 | ログメッセージ内容 |
| 在庫同期ログ | 詳細情報 | JSON | 詳細な処理情報（処理件数、エラー詳細など） |
| 在庫同期ログ | サーバー名 | 文字列 | 処理を実行したサーバー名 |
| 在庫同期ログ | プロセスID | 整数 | 実行プロセスのID |

#### 3-5 エラー処理

| エラーコード | エラー内容 | 対応方法 |
|------------|----------|---------|
| E201 | ログ記録失敗 | ファイルシステムにフォールバックしてログ記録。3回失敗で管理者通知 |
| E202 | DB接続エラー | 一時ファイルに記録し、接続回復後に再登録 |
| E203 | ディスク容量不足 | 古いログの自動アーカイブ実行後、再試行 |
| E204 | アーカイブ処理失敗 | エラーログ記録後、管理者通知 |

#### 3-6 実行条件

- 実行頻度：5分毎（リアルタイム在庫同期と連動）
- 実行時間：24時間
- 前提条件：リアルタイム在庫同期の実行に連動して実行
- ログローテーション：1週間分のログをアクティブ保持、それ以前はアーカイブ

#### 3-7 ログ出力仕様

| ログレベル | 出力内容 | 出力タイミング |
|----------|---------|--------------|
| INFO | ログ記録開始 | バッチ処理開始時 |
| INFO | ログ記録完了 | バッチ処理完了時 |
| WARN | ディスク容量警告 | 残り容量が20%を下回った場合 |
| ERROR | ログ記録失敗 | ログのDB保存に失敗した場合 |
| ERROR | アーカイブ処理失敗 | 古いログのアーカイブに失敗した場合 |
| DEBUG | 詳細処理内容 | 開発モード時のみ出力 |

#### 3-8 リトライ設計

- 最大リトライ回数：3回
- リトライ間隔：初回15秒、以降は倍々で増加（15秒→30秒→1分）
- リトライ対象エラー：ログ記録失敗、DB接続エラー
- リトライ上限超過時：ファイルシステムへのフォールバックと管理者通知

### 4. 異常検知アラート生成

#### 4-1 機能概要

在庫データや連携処理の異常を自動検知してアラートを生成する（Create）機能。在庫数の急激な変動、連携エラー、タイムアウトなどを検知し、担当者に通知する。

#### 4-2 処理フロー

1. 監視対象データの収集
   - 在庫データ検証結果
   - 在庫同期ログ
   - システム接続状態
2. 異常検知ルールの適用
   - 閾値ベースの検知
   - パターン認識による検知
   - 統計的異常検知
3. 異常判定時のアラート生成
4. アラート重要度の判定
5. 通知先の決定
6. アラート送信（メール、SMS、システム内通知）
7. アラート履歴の記録

#### 4-3 入力データ仕様

| データソース | 項目名 | データ型 | 説明 |
|-------------|-------|---------|------|
| 在庫検証結果 | 検証ID | 文字列 | 検証処理の一意識別子 |
| 在庫検証結果 | 異常検出データ | JSON | 検出された異常データ一覧 |
| 在庫同期ログ | 処理ID | 文字列 | 同期処理の一意識別子 |
| 在庫同期ログ | エラー情報 | 文字列 | エラーが発生した場合の詳細情報 |
| システム状態 | コンポーネントID | 文字列 | 監視対象コンポーネントの識別子 |
| システム状態 | ステータス | 文字列 | 正常/警告/エラー |
| システム状態 | 応答時間 | 整数 | ミリ秒単位の応答時間 |
| アラート設定 | 閾値 | JSON | 各種アラート発生の閾値設定 |
| アラート設定 | 通知先 | JSON | アラート種別ごとの通知先設定 |

#### 4-4 出力データ仕様

| データ先 | 項目名 | データ型 | 説明 |
|---------|-------|---------|------|
| アラート | アラートID | 文字列 | アラートの一意識別子 |
| アラート | 発生日時 | 日時 | アラートが発生した日時 |
| アラート | 重要度 | 文字列 | 高/中/低 |
| アラート | タイプ | 文字列 | 在庫異常/連携エラー/システム異常など |
| アラート | タイトル | 文字列 | アラートの概要タイトル |
| アラート | 内容 | 文字列 | アラートの詳細内容 |
| アラート | 対象ID | 文字列 | 問題が発生した対象の識別子 |
| アラート | ステータス | 文字列 | 未確認/確認済/対応中/解決済 |
| アラート | 担当者 | 文字列 | 対応担当者のID |
| 通知 | 通知ID | 文字列 | 通知の一意識別子 |
| 通知 | アラートID | 文字列 | 関連するアラートのID |
| 通知 | 通知先 | 文字列 | メールアドレスやユーザーIDなど |
| 通知 | 通知方法 | 文字列 | メール/SMS/システム内通知 |
| 通知 | 送信状態 | 文字列 | 送信済/失敗 |
| 通知 | 送信日時 | 日時 | 通知を送信した日時 |

#### 4-5 エラー処理

| エラーコード | エラー内容 | 対応方法 |
|------------|----------|---------|
| E301 | データ取得エラー | ログ記録後、利用可能なデータのみで処理継続 |
| E302 | ルール適用エラー | デフォルトルールを適用して処理継続 |
| E303 | アラート生成失敗 | エラーログ記録後、次のアラート処理へ進む |
| E304 | 通知送信失敗 | 代替通知手段で再試行、全て失敗時は管理者へ直接通知 |

#### 4-6 実行条件

- 実行頻度：10分毎
- 実行時間：24時間
- 前提条件：在庫データ検証が正常に実行されていること
- アラート抑制：同一内容のアラートは1時間以内に1回のみ通知

#### 4-7 ログ出力仕様

| ログレベル | 出力内容 | 出力タイミング |
|----------|---------|--------------|
| INFO | 処理開始 | バッチ処理開始時 |
| INFO | アラート生成 | アラートが生成された時 |
| INFO | 通知送信 | 通知が送信された時 |
| INFO | 処理完了 | バッチ処理完了時 |
| WARN | 通知送信リトライ | 通知送信に失敗しリトライする時 |
| ERROR | データ取得エラー | 監視データの取得に失敗した場合 |
| ERROR | 通知送信失敗 | 全てのリトライ後も通知送信に失敗した場合 |
| DEBUG | 詳細処理内容 | 開発モード時のみ出力 |

#### 4-8 リトライ設計

- 最大リトライ回数：3回
- リトライ間隔：初回1分、以降は倍々で増加（1分→2分→4分）
- リトライ対象エラー：通知送信失敗
- リトライ上限超過時：代替通知手段（別チャネル）での通知と管理者への報告

### 5. 監視レポート生成

#### 5-1 機能概要

システム監視データを集計し、定期的にレポートを生成する（Create）機能。在庫同期の成功率、エラー発生率、処理時間などの統計情報をまとめる。

#### 5-2 処理フロー

1. 監視データの収集
   - 在庫同期ログ
   - アラート履歴
   - システム状態履歴
   - パフォーマンス指標
2. データの集計・分析
   - 日次/週次/月次の統計計算
   - トレンド分析
   - 異常値の要約
3. レポートテンプレートの適用
4. グラフ・チャートの生成
5. レポートの保存
6. レポート通知の送信

#### 5-3 入力データ仕様

| データソース | 項目名 | データ型 | 説明 |
|-------------|-------|---------|------|
| 在庫同期ログ | 処理ID | 文字列 | 同期処理の一意識別子 |
| 在庫同期ログ | 処理結果 | 文字列 | 成功/失敗 |
| 在庫同期ログ | 処理時間 | 整数 | 処理にかかった時間（ミリ秒） |
| 在庫同期ログ | 処理件数 | 整数 | 同期した商品数 |
| アラート履歴 | アラートID | 文字列 | アラートの一意識別子 |
| アラート履歴 | 発生日時 | 日時 | アラートが発生した日時 |
| アラート履歴 | 重要度 | 文字列 | 高/中/低 |
| アラート履歴 | タイプ | 文字列 | アラートの種類 |
| システム状態履歴 | コンポーネントID | 文字列 | システムコンポーネントの識別子 |
| システム状態履歴 | 記録時刻 | 日時 | 状態が記録された時刻 |
| システム状態履歴 | ステータス | 文字列 | 正常/警告/エラー |
| システム状態履歴 | 応答時間 | 整数 | ミリ秒単位の応答時間 |
| レポート設定 | レポートタイプ | 文字列 | 日次/週次/月次 |
| レポート設定 | 対象期間 | 日時範囲 | レポート対象期間 |
| レポート設定 | 通知先 | JSON | レポート送信先のリスト |

#### 5-4 出力データ仕様

| データ先 | 項目名 | データ型 | 説明 |
|---------|-------|---------|------|
| 監視レポート | レポートID | 文字列 | レポートの一意識別子 |
| 監視レポート | 作成日時 | 日時 | レポートが生成された日時 |
| 監視レポート | レポートタイプ | 文字列 | 日次/週次/月次 |
| 監視レポート | 対象期間 | 日時範囲 | レポート対象期間 |
| 監視レポート | タイトル | 文字列 | レポートのタイトル |
| 監視レポート | 概要 | 文字列 | レポートの要約テキスト |
| 監視レポート | 詳細データ | JSON | 集計・分析結果の詳細データ |
| 監視レポート | グラフデータ | JSON | グラフ描画用のデータセット |
| 監視レポート | ファイルパス | 文字列 | 生成されたPDF/Excel等のファイルパス |
| 通知 | 通知ID | 文字列 | 通知の一意識別子 |
| 通知 | レポートID | 文字列 | 関連するレポートのID |
| 通知 | 通知先 | 文字列 | メールアドレスやユーザーIDなど |
| 通知 | 送信状態 | 文字列 | 送信済/失敗 |
| 通知 | 送信日時 | 日時 | 通知を送信した日時 |

#### 5-5 エラー処理

| エラーコード | エラー内容 | 対応方法 |
|------------|----------|---------|
| E401 | データ取得エラー | 部分的なデータで処理継続、不足データを明記 |
| E402 | 集計処理エラー | エラーログ記録後、次の集計項目へ進む |
| E403 | グラフ生成エラー | テキスト形式のデータのみでレポート作成 |
| E404 | レポート保存エラー | 一時ディレクトリに保存後、管理者通知 |
| E405 | 通知送信エラー | 代替通知手段で再試行 |

#### 5-6 実行条件

- 実行頻度：1日1回
- 実行時刻：06:00
- 前提条件：異常検知アラート生成、在庫同期ログ記録が正常に実行されていること
- レポート保持期間：日次レポート90日、週次レポート1年、月次レポート5年

#### 5-7 ログ出力仕様

| ログレベル | 出力内容 | 出力タイミング |
|----------|---------|--------------|
| INFO | 処理開始 | バッチ処理開始時 |
| INFO | データ収集完了 | データ収集完了時 |
| INFO | レポート生成完了 | レポート生成完了時 |
| INFO | 通知送信完了 | 通知送信完了時 |
| WARN | 不完全なデータ | 一部データが欠損している場合 |
| ERROR | データ取得エラー | 監視データの取得に失敗した場合 |
| ERROR | レポート生成エラー | レポート生成に失敗した場合 |
| ERROR | 通知送信失敗 | レポート通知の送信に失敗した場合 |
| DEBUG | 詳細処理内容 | 開発モード時のみ出力 |

#### 5-8 リトライ設計

- 最大リトライ回数：3回
- リトライ間隔：初回5分、以降は倍々で増加（5分→10分→20分）
- リトライ対象エラー：データ取得エラー、レポート保存エラー、通知送信エラー
- リトライ上限超過時：管理者への通知と次回実行時の再試行フラグ設定

### 6. 注文ステータス同期

#### 6-1 機能概要

外部システムとの注文ステータス情報を同期する（Update）機能。支払状況、出荷状況などの最新情報を取得・更新し、ECシステム内の注文情報を最新化する。

#### 6-2 処理フロー

1. 同期対象注文データの特定
   - 新規注文
   - ステータス変更済み注文
   - 同期対象時間内の注文
2. 外部システムへの接続確立
3. 注文ステータス情報の取得
4. データの整合性検証
5. ECシステム内の注文ステータス更新
6. 顧客マイページ情報の更新
7. 同期結果のログ記録

#### 6-3 入力データ仕様

| データソース | 項目名 | データ型 | 説明 |
|-------------|-------|---------|------|
| 注文データ | 注文ID | 文字列 | 注文の一意識別子 |
| 注文データ | 顧客ID | 文字列 | 注文した顧客の識別子 |
| 注文データ | 注文日時 | 日時 | 注文が発生した日時 |
| 注文データ | 注文ステータス | 文字列 | 現在の注文ステータス |
| 注文データ | 最終更新日時 | 日時 | 注文情報が最後に更新された日時 |
| 決済システム | 注文ID | 文字列 | 注文の一意識別子 |
| 決済システム | 支払ステータス | 文字列 | 支払いの状態（未払い/支払済/返金済など） |
| 決済システム | 支払方法 | 文字列 | クレジット/コンビニ/銀行振込など |
| 決済システム | 支払日時 | 日時 | 支払いが完了した日時 |
| 配送システム | 注文ID | 文字列 | 注文の一意識別子 |
| 配送システム | 出荷ステータス | 文字列 | 出荷の状態（準備中/発送済/配達完了など） |
| 配送システム | 追跡番号 | 文字列 | 配送業者の追跡番号 |
| 配送システム | 出荷日時 | 日時 | 商品が出荷された日時 |
| 配送システム | 配達予定日 | 日時 | 配達予定日 |

#### 6-4 出力データ仕様

| データ先 | 項目名 | データ型 | 説明 |
|---------|-------|---------|------|
| 注文データ | 注文ID | 文字列 | 注文の一意識別子 |
| 注文データ | 注文ステータス | 文字列 | 更新後の注文ステータス |
| 注文データ | 支払ステータス | 文字列 | 更新後の支払ステータス |
| 注文データ | 出荷ステータス | 文字列 | 更新後の出荷ステータス |
| 注文データ | 追跡番号 | 文字列 | 配送業者の追跡番号 |
| 注文データ | 配達予定日 | 日時 | 更新された配達予定日 |
| 注文データ | 最終更新日時 | 日時 | 情報を更新した日時 |
| 顧客マイページ | 注文ID | 文字列 | 注文の一意識別子 |
| 顧客マイページ | 表示ステータス | 文字列 | 顧客向けの表示ステータス |
| 顧客マイページ | 追跡情報 | JSON | 配送追跡に関する情報 |
| 同期ログ | 処理ID | 文字列 | 同期処理の一意識別子 |
| 同期ログ | 開始時刻 | 日時 | 処理開始時刻 |
| 同期ログ | 終了時刻 | 日時 | 処理終了時刻 |
| 同期ログ | 処理結果 | 文字列 | 成功/失敗 |
| 同期ログ | 処理件数 | 整数 | 同期した注文数 |
| 同期ログ | 更新件数 | 整数 | 実際に更新された注文数 |
| 同期ログ | エラー情報 | 文字列 | エラーが発生した場合の詳細情報 |

#### 6-5 エラー処理

| エラーコード | エラー内容 | 対応方法 |
|------------|----------|---------|
| E501 | 外部システム接続エラー | 接続設定を確認し、リトライ実行。3回失敗で管理者通知 |
| E502 | データ取得エラー | 外部システムのAPI状態を確認し、リトライ実行 |
| E503 | データ不整合エラー | エラーログ記録後、管理者確認フラグを設定 |
| E504 | DB更新エラー | トランザクションロールバック後、リトライ実行 |
| E505 | マイページ更新エラー | エラーログ記録後、次回同期時に再試行フラグ設定 |

#### 6-6 実行条件

- 実行頻度：15分毎
- 実行時間：24時間
- 前提条件：外部システム（決済システム、配送システム）との接続設定が正しく構成されていること
- 同期対象：直近24時間内の新規注文および未完了の注文

#### 6-7 ログ出力仕様

| ログレベル | 出力内容 | 出力タイミング |
|----------|---------|--------------|
| INFO | 処理開始 | バッチ処理開始時 |
| INFO | 同期対象件数 | 同期対象データ特定時 |
| INFO | 更新件数 | データ更新完了時 |
| INFO | 処理完了 | バッチ処理完了時 |
| WARN | データ不整合検出 | データの不整合を検出した場合 |
| ERROR | 接続エラー | 外部システムとの接続に失敗した場合 |
| ERROR | データ更新エラー | DBへの更新に失敗した場合 |
| DEBUG | 詳細処理内容 | 開発モード時のみ出力 |

#### 6-8 リトライ設計

- 最大リトライ回数：3回
- リトライ間隔：初回30秒、以降は倍々で増加（30秒→1分→2分）
- リトライ対象エラー：接続エラー、データ取得エラー、DB更新エラー
- リトライ上限超過時：アラート発行と管理者通知

### 7. 支払状況検証

#### 7-1 機能概要

注文の支払状況を定期的に検証する（Read）機能。支払期限切れ、入金不足、二重入金などの異常を検出し、必要に応じて対応フラグを立てる。

#### 7-2 処理フロー

1. 検証対象注文データの取得
   - 未払いステータスの注文
   - 支払期限間近の注文
   - 入金確認中ステータスの注文
2. 決済システムとの接続確立
3. 最新の支払情報取得
4. 支払状況の検証
   - 期限切れチェック
   - 入金額チェック
   - 二重入金チェック
5. 異常検出時の対応フラグ設定
6. 検証結果の記録

#### 7-3 入力データ仕様

| データソース | 項目名 | データ型 | 説明 |
|-------------|-------|---------|------|
| 注文データ | 注文ID | 文字列 | 注文の一意識別子 |
| 注文データ | 顧客ID | 文字列 | 注文した顧客の識別子 |
| 注文データ | 注文日時 | 日時 | 注文が発生した日時 |
| 注文データ | 注文金額 | 小数 | 注文の合計金額 |
| 注文データ | 支払ステータス | 文字列 | 現在の支払ステータス |
| 注文データ | 支払期限 | 日時 | 支払いの期限日時 |
| 決済システム | 注文ID | 文字列 | 注文の一意識別子 |
| 決済システム | 支払ステータス | 文字列 | 支払いの状態 |
| 決済システム | 入金額 | 小数 | 実際に入金された金額 |
| 決済システム | 入金日時 | 日時 | 入金が確認された日時 |
| 決済システム | 決済ID | 文字列 | 決済処理の一意識別子 |
| 支払検証設定 | 通知期限 | 整数 | 支払期限前の通知を送る日数 |
| 支払検証設定 | 許容差額 | 小数 | 入金額の許容誤差範囲 |

#### 7-4 出力データ仕様

| データ先 | 項目名 | データ型 | 説明 |
|---------|-------|---------|------|
| 注文データ | 注文ID | 文字列 | 注文の一意識別子 |
| 注文データ | 支払ステータス | 文字列 | 更新後の支払ステータス |
| 注文データ | 支払確認日時 | 日時 | 支払いが確認された日時 |
| 注文データ | 対応フラグ | 文字列 | 必要な対応を示すフラグ |
| 注文データ | 備考 | 文字列 | 検証結果に関する備考 |
| 支払検証結果 | 検証ID | 文字列 | 検証処理の一意識別子 |
| 支払検証結果 | 実行日時 | 日時 | 検証を実行した日時 |
| 支払検証結果 | 検証注文数 | 整数 | 検証対象となった注文数 |
| 支払検証結果 | 異常検出数 | 整数 | 異常が検出された注文数 |
| 異常検出データ | 注文ID | 文字列 | 異常が検出された注文ID |
| 異常検出データ | 異常タイプ | 文字列 | 検出された異常の種類 |
| 異常検出データ | 詳細情報 | JSON | 異常の詳細情報 |
| 異常検出データ | 検出日時 | 日時 | 異常を検出した日時 |
| 通知キュー | 通知タイプ | 文字列 | 支払期限通知/入金確認通知など |
| 通知キュー | 注文ID | 文字列 | 関連する注文ID |
| 通知キュー | 顧客ID | 文字列 | 通知先顧客ID |
| 通知キュー | 内容 | JSON | 通知内容のデータ |

#### 7-5 エラー処理

| エラーコード | エラー内容 | 対応方法 |
|------------|----------|---------|
| E601 | 決済システム接続エラー | 接続設定を確認し、リトライ実行。3回失敗で管理者通知 |
| E602 | データ取得エラー | 決済システムのAPI状態を確認し、リトライ実行 |
| E603 | データ不整合エラー | エラーログ記録後、管理者確認フラグを設定 |
| E604 | DB更新エラー | トランザクションロールバック後、リトライ実行 |
| E605 | 通知キュー登録エラー | エラーログ記録後、次回実行時に再試行フラグ設定 |

#### 7-6 実行条件

- 実行頻度：1時間毎
- 実行時間：24時間
- 前提条件：注文ステータス同期が正常に実行されていること
- 検証対象：
  - 未払いステータスの全注文
  - 支払期限が48時間以内の注文
  - 直近24時間以内に入金があった注文

#### 7-7 ログ出力仕様

| ログレベル | 出力内容 | 出力タイミング |
|----------|---------|--------------|
| INFO | 検証開始 | バッチ処理開始時 |
| INFO | 検証対象件数 | 検証対象データ特定時 |
| INFO | 検証結果サマリー | 検証完了時 |
| WARN | 支払期限切れ検出 | 支払期限切れの注文を検出した場合 |
| WARN | 入金額不一致検出 | 注文金額と入金額が一致しない場合 |
| WARN | 二重入金検出 | 二重入金を検出した場合 |
| ERROR | 接続エラー | 決済システムとの接続に失敗した場合 |
| ERROR | データ更新エラー | DBへの更新に失敗した場合 |
| DEBUG | 詳細検証内容 | 開発モード時のみ出力 |

#### 7-8 リトライ設計

- 最大リトライ回数：3回
- リトライ間隔：初回1分、以降は倍々で増加（1分→2分→4分）
- リトライ対象エラー：接続エラー、データ取得エラー、DB更新エラー
- リトライ上限超過時：アラート発行と管理者通知

### 8. 出荷ステータス管理

#### 8-1 機能概要

注文の出荷ステータスを管理する（Create/Update）機能。倉庫での処理状況、配送業者への引き渡し状況などを記録・更新する。

#### 8-2 処理フロー

1. 管理対象注文データの取得
   - 出荷準備中ステータスの注文
   - 出荷済みステータスの注文
   - 配送中ステータスの注文
2. WMSとの接続確立
3. 最新の出荷情報取得
4. 配送業者システムとの接続確立
5. 最新の配送状況取得
6. 出荷ステータスの更新
7. 顧客マイページ情報の更新
8. 発送完了メール送信キューへの登録（該当する場合）
9. 処理結果の記録

#### 8-3 入力データ仕様

| データソース | 項目名 | データ型 | 説明 |
|-------------|-------|---------|------|
| 注文データ | 注文ID | 文字列 | 注文の一意識別子 |
| 注文データ | 顧客ID | 文字列 | 注文した顧客の識別子 |
| 注文データ | 出荷ステータス | 文字列 | 現在の出荷ステータス |
| 注文データ | 最終更新日時 | 日時 | 出荷情報が最後に更新された日時 |
| WMS | 注文ID | 文字列 | 注文の一意識別子 |
| WMS | 出荷ステータス | 文字列 | 倉庫内での処理状況 |
| WMS | ピッキング完了日時 | 日時 | ピッキングが完了した日時 |
| WMS | 梱包完了日時 | 日時 | 梱包が完了した日時 |
| WMS | 出荷完了日時 | 日時 | 出荷が完了した日時 |
| 配送業者システム | 追跡番号 | 文字列 | 配送業者の追跡番号 |
| 配送業者システム | 配送ステータス | 文字列 | 配送の現在状況 |
| 配送業者システム | 最終更新日時 | 日時 | 配送情報が最後に更新された日時 |
| 配送業者システム | 配達予定日 | 日時 | 配達予定日 |
| 配送業者システム | 配達完了日時 | 日時 | 配達が完了した日時 |

#### 8-4 出力データ仕様

| データ先 | 項目名 | データ型 | 説明 |
|---------|-------|---------|------|
| 注文データ | 注文ID | 文字列 | 注文の一意識別子 |
| 注文データ | 出荷ステータス | 文字列 | 更新後の出荷ステータス |
| 注文データ | 追跡番号 | 文字列 | 配送業者の追跡番号 |
| 注文データ | 配送業者コード | 文字列 | 配送業者の識別コード |
| 注文データ | 出荷日時 | 日時 | 商品が出荷された日時 |
| 注文データ | 配達予定日 | 日時 | 配達予定日 |
| 注文データ | 配達完了日時 | 日時 | 配達が完了した日時 |
| 注文データ | 最終更新日時 | 日時 | 情報を更新した日時 |
| 顧客マイページ | 注文ID | 文字列 | 注文の一意識別子 |
| 顧客マイページ | 表示ステータス | 文字列 | 顧客向けの表示ステータス |
| 顧客マイページ | 追跡情報 | JSON | 配送追跡に関する情報 |
| 発送完了メールキュー | メールID | 文字列 | メールの一意識別子 |
| 発送完了メールキュー | 注文ID | 文字列 | 関連する注文ID |
| 発送完了メールキュー | 顧客ID | 文字列 | 送信先顧客ID |
| 発送完了メールキュー | テンプレートID | 文字列 | 使用するメールテンプレートのID |
| 発送完了メールキュー | 置換データ | JSON | メール内容の置換用データ |
| 発送完了メールキュー | 登録日時 | 日時 | キューに登録された日時 |
| 処理ログ | 処理ID | 文字列 | 処理の一意識別子 |
| 処理ログ | 開始時刻 | 日時 | 処理開始時刻 |
| 処理ログ | 終了時刻 | 日時 | 処理終了時刻 |
| 処理ログ | 処理結果 | 文字列 | 成功/失敗 |
| 処理ログ | 処理件数 | 整数 | 処理した注文数 |
| 処理ログ | 更新件数 | 整数 | 実際に更新された注文数 |
| 処理ログ | エラー情報 | 文字列 | エラーが発生した場合の詳細情報 |

#### 8-5 エラー処理

| エラーコード | エラー内容 | 対応方法 |
|------------|----------|---------|
| E701 | WMS接続エラー | 接続設定を確認し、リトライ実行。3回失敗で管理者通知 |
| E702 | 配送業者システム接続エラー | 接続設定を確認し、リトライ実行。3回失敗で管理者通知 |
| E703 | データ取得エラー | 外部システムのAPI状態を確認し、リトライ実行 |
| E704 | データ不整合エラー | エラーログ記録後、管理者確認フラグを設定 |
| E705 | DB更新エラー | トランザクションロールバック後、リトライ実行 |
| E706 | メールキュー登録エラー | エラーログ記録後、次回実行時に再試行フラグ設定 |

#### 8-6 実行条件

- 実行頻度：30分毎
- 実行時間：08:00-20:00
- 前提条件：注文ステータス同期が正常に実行されていること
- 管理対象：
  - 支払い確認済みで出荷前の注文
  - 出荷済みで配達完了前の注文
  - 直近7日以内の注文

#### 8-7 ログ出力仕様

| ログレベル | 出力内容 | 出力タイミング |
|----------|---------|--------------|
| INFO | 処理開始 | バッチ処理開始時 |
| INFO | 処理対象件数 | 処理対象データ特定時 |
| INFO | WMS接続完了 | WMSとの接続確立時 |
| INFO | 配送業者接続完了 | 配送業者システムとの接続確立時 |
| INFO | ステータス更新 | 出荷ステータス更新時 |
| INFO | メールキュー登録 | 発送完了メールキュー登録時 |
| INFO | 処理完了 | バッチ処理完了時 |
| WARN | データ不整合検出 | データの不整合を検出した場合 |
| ERROR | 接続エラー | 外部システムとの接続に失敗した場合 |
| ERROR | データ更新エラー | DBへの更新に失敗した場合 |
| ERROR | メールキュー登録失敗 | メールキューへの登録に失敗した場合 |
| DEBUG | 詳細処理内容 | 開発モード時のみ出力 |

#### 8-8 リトライ設計

- 最大リトライ回数：3回
- リトライ間隔：初回1分、以降は倍々で増加（1分→2分→4分）
- リトライ対象エラー：接続エラー、データ取得エラー、DB更新エラー、メールキュー登録エラー
- リトライ上限超過時：アラート発行と管理者通知

### 9. 発送完了メール送信

#### 9-1 機能概要

注文商品の発送完了時に顧客へメールを自動送信する（Create）機能。配送業者の伝票番号登録後に発送完了メールを生成し、顧客のメールアドレス宛に送信する。テンプレートに基づき、注文情報、配送情報を含める。

#### 9-2 処理フロー

1. 発送完了メールキューからの送信対象データ取得
2. 注文詳細情報の取得
3. 顧客情報の取得
4. メールテンプレートの取得
5. テンプレートへのデータ適用
6. メール本文の生成
7. メール送信
8. 送信結果の記録
9. マイページ通知の登録

#### 9-3 入力データ仕様

| データソース | 項目名 | データ型 | 説明 |
|-------------|-------|---------|------|
| 発送完了メールキュー | メールID | 文字列 | メールの一意識別子 |
| 発送完了メールキュー | 注文ID | 文字列 | 関連する注文ID |
| 発送完了メールキュー | 顧客ID | 文字列 | 送信先顧客ID |
| 発送完了メールキュー | テンプレートID | 文字列 | 使用するメールテンプレートのID |
| 発送完了メールキュー | 置換データ | JSON | メール内容の置換用データ |
| 発送完了メールキュー | 登録日時 | 日時 | キューに登録された日時 |
| 注文データ | 注文ID | 文字列 | 注文の一意識別子 |
| 注文データ | 注文日時 | 日時 | 注文が発生した日時 |
| 注文データ | 商品リスト | JSON | 注文された商品のリスト |
| 注文データ | 配送情報 | JSON | 配送に関する情報 |
| 注文データ | 追跡番号 | 文字列 | 配送業者の追跡番号 |
| 注文データ | 配送業者コード | 文字列 | 配送業者の識別コード |
| 顧客データ | 顧客ID | 文字列 | 顧客の一意識別子 |
| 顧客データ | メールアドレス | 文字列 | 顧客のメールアドレス |
| 顧客データ | 氏名 | 文字列 | 顧客の氏名 |
| 顧客データ | 言語設定 | 文字列 | 顧客の希望言語 |
| メールテンプレート | テンプレートID | 文字列 | テンプレートの一意識別子 |
| メールテンプレート | 件名 | 文字列 | メールの件名テンプレート |
| メールテンプレート | 本文 | 文字列 | メールの本文テンプレート |
| メールテンプレート | 言語 | 文字列 | テンプレートの言語 |

#### 9-4 出力データ仕様

| データ先 | 項目名 | データ型 | 説明 |
|---------|-------|---------|------|
| 送信メール | 送信ID | 文字列 | メール送信の一意識別子 |
| 送信メール | 宛先 | 文字列 | 送信先メールアドレス |
| 送信メール | 件名 | 文字列 | 生成されたメール件名 |
| 送信メール | 本文 | 文字列 | 生成されたメール本文 |
| 送信メール | 添付ファイル | バイナリ | 添付ファイルデータ（存在する場合） |
| 送信メール | 送信日時 | 日時 | メールを送信した日時 |
| 通知履歴 | 通知ID | 文字列 | 通知の一意識別子 |
| 通知履歴 | 顧客ID | 文字列 | 通知先顧客ID |
| 通知履歴 | 注文ID | 文字列 | 関連する注文ID |
| 通知履歴 | 通知タイプ | 文字列 | 発送完了通知 |
| 通知履歴 | 送信日時 | 日時 | 通知を送信した日時 |
| 通知履歴 | 送信結果 | 文字列 | 成功/失敗 |
| 通知履歴 | チャネル | 文字列 | メール |
| マイページ通知 | 通知ID | 文字列 | 通知の一意識別子 |
| マイページ通知 | 顧客ID | 文字列 | 通知先顧客ID |
| マイページ通知 | 注文ID | 文字列 | 関連する注文ID |
| マイページ通知 | タイトル | 文字列 | 通知のタイトル |
| マイページ通知 | 内容 | 文字列 | 通知の内容 |
| マイページ通知 | 作成日時 | 日時 | 通知を作成した日時 |
| マイページ通知 | 既読フラグ | 真偽値 | 顧客が通知を既読したかどうか |
| 処理ログ | 処理ID | 文字列 | 処理の一意識別子 |
| 処理ログ | 開始時刻 | 日時 | 処理開始時刻 |
| 処理ログ | 終了時刻 | 日時 | 処理終了時刻 |
| 処理ログ | 処理結果 | 文字列 | 成功/失敗 |
| 処理ログ | 処理件数 | 整数 | 処理したメール数 |
| 処理ログ | 送信成功件数 | 整数 | 正常に送信できたメール数 |
| 処理ログ | 送信失敗件数 | 整数 | 送信に失敗したメール数 |
| 処理ログ | エラー情報 | 文字列 | エラーが発生した場合の詳細情報 |

#### 9-5 エラー処理

| エラーコード | エラー内容 | 対応方法 |
|------------|----------|---------|
| E801 | データ取得エラー | DBアクセスを確認し、リトライ実行。3回失敗で管理者通知 |
| E802 | テンプレート不正 | デフォルトテンプレートを使用し、管理者に通知 |
| E803 | メール生成エラー | エラーログ記録後、次のメール処理へ進む |
| E804 | メール送信エラー | リトライ実行。3回失敗で送信失敗として記録 |
| E805 | 通知履歴記録エラー | エラーログ記録後、処理継続 |
| E806 | マイページ通知登録エラー | エラーログ記録後、次回実行時に再試行フラグ設定 |

#### 9-6 実行条件

- 実行頻度：30分毎
- 実行時間：08:00-20:00
- 前提条件：出荷ステータス管理が正常に実行されていること
- 送信対象：発送完了メールキューに登録された未送信のメール

#### 9-7 ログ出力仕様

| ログレベル | 出力内容 | 出力タイミング |
|----------|---------|--------------|
| INFO | 処理開始 | バッチ処理開始時 |
| INFO | 送信対象件数 | 送信対象データ特定時 |
| INFO | メール送信 | メール送信完了時 |
| INFO | マイページ通知登録 | マイページ通知登録時 |
| INFO | 処理完了 | バッチ処理完了時 |
| WARN | テンプレート不正 | テンプレートに問題がある場合 |
| ERROR | データ取得エラー | データ取得に失敗した場合 |
| ERROR | メール送信失敗 | メール送信に失敗した場合 |
| ERROR | マイページ通知登録失敗 | マイページ通知の登録に失敗した場合 |
| DEBUG | 詳細処理内容 | 開発モード時のみ出力 |

#### 9-8 リトライ設計

- 最大リトライ回数：3回
- リトライ間隔：初回1分、以降は倍々で増加（1分→2分→4分）
- リトライ対象エラー：データ取得エラー、メール送信エラー
- リトライ上限超過時：送信失敗としてログ記録し、管理者通知

### 10. マイページ更新通知

#### 10-1 機能概要

顧客マイページの情報更新時に通知を生成する（Create）機能。注文ステータス変更、発送情報更新などの際に、顧客マイページに通知を表示する。

#### 10-2 処理フロー

1. 通知対象データの特定
   - 注文ステータス変更データ
   - 出荷ステータス変更データ
   - 支払ステータス変更データ
2. 顧客情報の取得
3. 通知テンプレートの取得
4. 通知内容の生成
5. マイページ通知の登録
6. プッシュ通知の送信（設定がある場合）
7. 処理結果の記録

#### 10-3 入力データ仕様

| データソース | 項目名 | データ型 | 説明 |
|-------------|-------|---------|------|
| 注文データ変更履歴 | 履歴ID | 文字列 | 変更履歴の一意識別子 |
| 注文データ変更履歴 | 注文ID | 文字列 | 関連する注文ID |
| 注文データ変更履歴 | 変更項目 | 文字列 | 変更された項目名 |
| 注文データ変更履歴 | 変更前値 | 文字列 | 変更前の値 |
| 注文データ変更履歴 | 変更後値 | 文字列 | 変更後の値 |
| 注文データ変更履歴 | 変更日時 | 日時 | 変更が発生した日時 |
| 注文データ | 注文ID | 文字列 | 注文の一意識別子 |
| 注文データ | 顧客ID | 文字列 | 注文した顧客の識別子 |
| 注文データ | 注文日時 | 日時 | 注文が発生した日時 |
| 注文データ | 注文ステータス | 文字列 | 現在の注文ステータス |
| 注文データ | 出荷ステータス | 文字列 | 現在の出荷ステータス |
| 注文データ | 支払ステータス | 文字列 | 現在の支払ステータス |
| 顧客データ | 顧客ID | 文字列 | 顧客の一意識別子 |
| 顧客データ | 通知設定 | JSON | 顧客の通知設定情報 |
| 顧客データ | プッシュ通知トークン | 文字列 | モバイルアプリのプッシュ通知用トークン |
| 通知テンプレート | テンプレートID | 文字列 | テンプレートの一意識別子 |
| 通知テンプレート | 通知タイプ | 文字列 | 通知の種類 |
| 通知テンプレート | タイトル | 文字列 | 通知のタイトルテンプレート |
| 通知テンプレート | 内容 | 文字列 | 通知の内容テンプレート |
| 通知テンプレート | 言語 | 文字列 | テンプレートの言語 |

#### 10-4 出力データ仕様

| データ先 | 項目名 | データ型 | 説明 |
|---------|-------|---------|------|
| マイページ通知 | 通知ID | 文字列 | 通知の一意識別子 |
| マイページ通知 | 顧客ID | 文字列 | 通知先顧客ID |
| マイページ通知 | 注文ID | 文字列 | 関連する注文ID |
| マイページ通知 | 通知タイプ | 文字列 | 通知の種類 |
| マイページ通知 | タイトル | 文字列 | 通知のタイトル |
| マイページ通知 | 内容 | 文字列 | 通知の内容 |
| マイページ通知 | 作成日時 | 日時 | 通知を作成した日時 |
| マイページ通知 | 既読フラグ | 真偽値 | 顧客が通知を既読したかどうか |
| マイページ通知 | 有効期限 | 日時 | 通知の表示期限 |
| プッシュ通知 | 通知ID | 文字列 | 通知の一意識別子 |
| プッシュ通知 | 顧客ID | 文字列 | 通知先顧客ID |
| プッシュ通知 | デバイストークン | 文字列 | プッシュ通知送信先デバイスのトークン |
| プッシュ通知 | タイトル | 文字列 | 通知のタイトル |
| プッシュ通知 | 内容 | 文字列 | 通知の内容 |
| プッシュ通知 | データ | JSON | 通知に含める追加データ |
| プッシュ通知 | 送信日時 | 日時 | 通知を送信した日時 |
| プッシュ通知 | 送信結果 | 文字列 | 成功/失敗 |
| 通知履歴 | 履歴ID | 文字列 | 履歴の一意識別子 |
| 通知履歴 | 通知ID | 文字列 | 関連する通知ID |
| 通知履歴 | 顧客ID | 文字列 | 通知先顧客ID |
| 通知履歴 | チャネル | 文字列 | マイページ/プッシュ通知 |
| 通知履歴 | 送信日時 | 日時 | 通知を送信した日時 |
| 通知履歴 | 送信結果 | 文字列 | 成功/失敗 |
| 処理ログ | 処理ID | 文字列 | 処理の一意識別子 |
| 処理ログ | 開始時刻 | 日時 | 処理開始時刻 |
| 処理ログ | 終了時刻 | 日時 | 処理終了時刻 |
| 処理ログ | 処理結果 | 文字列 | 成功/失敗 |
| 処理ログ | 処理件数 | 整数 | 処理した通知数 |
| 処理ログ | 生成成功件数 | 整数 | 正常に生成できた通知数 |
| 処理ログ | 生成失敗件数 | 整数 | 生成に失敗した通知数 |
| 処理ログ | エラー情報 | 文字列 | エラーが発生した場合の詳細情報 |

#### 10-5 エラー処理

| エラーコード | エラー内容 | 対応方法 |
|------------|----------|---------|
| E901 | データ取得エラー | DBアクセスを確認し、リトライ実行。3回失敗で管理者通知 |
| E902 | テンプレート不正 | デフォルトテンプレートを使用し、管理者に通知 |
| E903 | 通知生成エラー | エラーログ記録後、次の通知処理へ進む |
| E904 | マイページ通知登録エラー | リトライ実行。3回失敗で登録失敗として記録 |
| E905 | プッシュ通知送信エラー | エラーログ記録後、処理継続 |
| E906 | 通知履歴記録エラー | エラーログ記録後、処理継続 |

#### 10-6 実行条件

- 実行頻度：30分毎
- 実行時間：24時間
- 前提条件：注文ステータス同期、出荷ステータス管理が正常に実行されていること
- 通知対象：前回実行時以降に変更があった注文関連データ

#### 10-7 ログ出力仕様

| ログレベル | 出力内容 | 出力タイミング |
|----------|---------|--------------|
| INFO | 処理開始 | バッチ処理開始時 |
| INFO | 通知対象件数 | 通知対象データ特定時 |
| INFO | マイページ通知登録 | マイページ通知登録時 |
| INFO | プッシュ通知送信 | プッシュ通知送信時 |
| INFO | 処理完了 | バッチ処理完了時 |
| WARN | テンプレート不正 | テンプレートに問題がある場合 |
| ERROR | データ取得エラー | データ取得に失敗した場合 |
| ERROR | 通知登録失敗 | マイページ通知の登録に失敗した場合 |
| ERROR | プッシュ通知送信失敗 | プッシュ通知の送信に失敗した場合 |
| DEBUG | 詳細処理内容 | 開発モード時のみ出力 |

#### 10-8 リトライ設計

- 最大リトライ回数：3回
- リトライ間隔：初回30秒、以降は倍々で増加（30秒→1分→2分）
- リトライ対象エラー：データ取得エラー、マイページ通知登録エラー
- リトライ上限超過時：登録失敗としてログ記録し、管理者通知

## 追加バッチ処理

### 11. 支払方法別処理分岐

#### 11-1 機能概要

注文の支払方法に応じて適切な処理フローに分岐させる（Read）機能。クレジットカード決済、コンビニ決済、銀行振込など、支払方法ごとに異なる処理を実行する。

#### 11-2 処理フロー

1. 処理対象注文データの取得
2. 支払方法の判定
3. 支払方法別の処理実行
   - クレジットカード決済：決済処理確認
   - コンビニ決済：支払期限設定と案内メール送信
   - 銀行振込：振込先情報メール送信
4. 処理結果の記録と次処理への引き継ぎ

#### 11-3 入力データ仕様

| データソース | 項目名 | データ型 | 説明 |
|-------------|-------|---------|------|
| 注文データ | 注文ID | 文字列 | 注文の一意識別子 |
| 注文データ | 顧客ID | 文字列 | 注文した顧客の識別子 |
| 注文データ | 注文日時 | 日時 | 注文が発生した日時 |
| 注文データ | 支払方法 | 文字列 | 選択された支払方法 |
| 注文データ | 注文金額 | 小数 | 注文の合計金額 |
| 注文データ | 通貨 | 文字列 | 注文の通貨単位 |
| 支払方法マスタ | 支払方法コード | 文字列 | 支払方法の識別コード |
| 支払方法マスタ | 処理タイプ | 文字列 | 処理すべきフロータイプ |
| 支払方法マスタ | 設定情報 | JSON | 支払方法ごとの設定情報 |

#### 11-4 出力データ仕様

| データ先 | 項目名 | データ型 | 説明 |
|---------|-------|---------|------|
| 注文データ | 注文ID | 文字列 | 注文の一意識別子 |
| 注文データ | 処理フラグ | 文字列 | 処理状態を示すフラグ |
| 注文データ | 処理日時 | 日時 | 処理を実行した日時 |
| 支払処理キュー | キューID | 文字列 | 処理キューの一意識別子 |
| 支払処理キュー | 注文ID | 文字列 | 関連する注文ID |
| 支払処理キュー | 処理タイプ | 文字列 | 実行すべき処理タイプ |
| 支払処理キュー | パラメータ | JSON | 処理に必要なパラメータ |
| 支払処理キュー | 登録日時 | 日時 | キューに登録された日時 |
| 支払処理キュー | 優先度 | 整数 | 処理の優先順位 |
| 通知キュー | 通知タイプ | 文字列 | 支払い方法通知など |
| 通知キュー | 注文ID | 文字列 | 関連する注文ID |
| 通知キュー | 顧客ID | 文字列 | 通知先顧客ID |
| 通知キュー | 内容 | JSON | 通知内容のデータ |
| 処理ログ | 処理ID | 文字列 | 処理の一意識別子 |
| 処理ログ | 開始時刻 | 日時 | 処理開始時刻 |
| 処理ログ | 終了時刻 | 日時 | 処理終了時刻 |
| 処理ログ | 処理結果 | 文字列 | 成功/失敗 |
| 処理ログ | 処理件数 | 整数 | 処理した注文数 |
| 処理ログ | エラー情報 | 文字列 | エラーが発生した場合の詳細情報 |

#### 11-5 エラー処理

| エラーコード | エラー内容 | 対応方法 |
|------------|----------|---------|
| E1001 | データ取得エラー | DBアクセスを確認し、リトライ実行。3回失敗で管理者通知 |
| E1002 | 支払方法不明 | デフォルト処理を適用し、管理者確認フラグを設定 |
| E1003 | 処理キュー登録エラー | リトライ実行。3回失敗で管理者通知 |
| E1004 | 通知キュー登録エラー | エラーログ記録後、処理継続 |
| E1005 | DB更新エラー | トランザクションロールバック後、リトライ実行 |

#### 11-6 実行条件

- 実行頻度：10分毎
- 実行時間：24時間
- 前提条件：なし
- 処理対象：新規注文および支払い処理が必要な注文

#### 11-7 ログ出力仕様

| ログレベル | 出力内容 | 出力タイミング |
|----------|---------|--------------|
| INFO | 処理開始 | バッチ処理開始時 |
| INFO | 処理対象件数 | 処理対象データ特定時 |
| INFO | 支払方法判定 | 支払方法の判定時 |
| INFO | 処理キュー登録 | 処理キュー登録時 |
| INFO | 処理完了 | バッチ処理完了時 |
| WARN | 支払方法不明 | 未定義の支払方法が検出された場合 |
| ERROR | データ取得エラー | データ取得に失敗した場合 |
| ERROR | キュー登録エラー | 処理キューの登録に失敗した場合 |
| ERROR | データ更新エラー | DBへの更新に失敗した場合 |
| DEBUG | 詳細処理内容 | 開発モード時のみ出力 |

#### 11-8 リトライ設計

- 最大リトライ回数：3回
- リトライ間隔：初回30秒、以降は倍々で増加（30秒→1分→2分）
- リトライ対象エラー：データ取得エラー、処理キュー登録エラー、DB更新エラー
- リトライ上限超過時：アラート発行と管理者通知

### 12. 自動化ワークフロー管理

#### 12-1 機能概要

業務プロセスの自動化ワークフローを管理する（Create/Read/Update/Delete）機能。注文処理、在庫同期、通知送信などの業務フローを定義し、条件に基づく自動実行を設定する。

#### 12-2 処理フロー

1. 登録済みワークフロー定義の取得
2. 実行条件の評価
3. 実行対象ワークフローの特定
4. ワークフロー実行エンジンの起動
5. タスクの順次実行
6. 分岐条件の評価と次タスクの決定
7. 実行結果の記録
8. 次のワークフローへの引き継ぎ

#### 12-3 入力データ仕様

| データソース | 項目名 | データ型 | 説明 |
|-------------|-------|---------|------|
| ワークフロー定義 | ワークフローID | 文字列 | ワークフローの一意識別子 |
| ワークフロー定義 | ワークフロー名 | 文字列 | ワークフローの名称 |
| ワークフロー定義 | 説明 | 文字列 | ワークフローの説明 |
| ワークフロー定義 | バージョン | 文字列 | ワークフロー定義のバージョン |
| ワークフロー定義 | 実行条件 | JSON | ワークフローを実行する条件 |
| ワークフロー定義 | タスク定義 | JSON | 実行すべきタスクの定義 |
| ワークフロー定義 | 分岐条件 | JSON | タスク間の分岐条件 |
| ワークフロー定義 | スケジュール | JSON | 実行スケジュール設定 |
| ワークフロー定義 | 有効フラグ | 真偽値 | ワークフローが有効かどうか |
| 業務データ | データID | 文字列 | 業務データの一意識別子 |
| 業務データ | データタイプ | 文字列 | データの種類 |
| 業務データ | データ内容 | JSON | 実際の業務データ |
| 業務データ | 作成日時 | 日時 | データが作成された日時 |
| 業務データ | 更新日時 | 日時 | データが最後に更新された日時 |

#### 12-4 出力データ仕様

| データ先 | 項目名 | データ型 | 説明 |
|---------|-------|---------|------|
| ワークフロー実行履歴 | 実行ID | 文字列 | 実行の一意識別子 |
| ワークフロー実行履歴 | ワークフローID | 文字列 | 実行したワークフローのID |
| ワークフロー実行履歴 | 開始時刻 | 日時 | 実行開始時刻 |
| ワークフロー実行履歴 | 終了時刻 | 日時 | 実行終了時刻 |
| ワークフロー実行履歴 | 実行結果 | 文字列 | 成功/失敗/一部成功 |
| ワークフロー実行履歴 | 実行パラメータ | JSON | 実行時に使用したパラメータ |
| タスク実行履歴 | タスクID | 文字列 | タスクの一意識別子 |
| タスク実行履歴 | 実行ID | 文字列 | 関連するワークフロー実行ID |
| タスク実行履歴 | タスク名 | 文字列 | 実行したタスクの名称 |
| タスク実行履歴 | 開始時刻 | 日時 | タスク実行開始時刻 |
| タスク実行履歴 | 終了時刻 | 日時 | タスク実行終了時刻 |
| タスク実行履歴 | 実行結果 | 文字列 | 成功/失敗 |
| タスク実行履歴 | 入力データ | JSON | タスクの入力データ |
| タスク実行履歴 | 出力データ | JSON | タスクの出力データ |
| タスク実行履歴 | エラー情報 | 文字列 | エラーが発生した場合の詳細情報 |
| 業務データ | データID | 文字列 | 業務データの一意識別子 |
| 業務データ | データタイプ | 文字列 | データの種類 |
| 業務データ | データ内容 | JSON | 更新された業務データ |
| 業務データ | 更新日時 | 日時 | データを更新した日時 |
| 処理ログ | 処理ID | 文字列 | 処理の一意識別子 |
| 処理ログ | 開始時刻 | 日時 | 処理開始時刻 |
| 処理ログ | 終了時刻 | 日時 | 処理終了時刻 |
| 処理ログ | 処理結果 | 文字列 | 成功/失敗 |
| 処理ログ | 処理件数 | 整数 | 処理したワークフロー数 |
| 処理ログ | エラー情報 | 文字列 | エラーが発生した場合の詳細情報 |

#### 12-5 エラー処理

| エラーコード | エラー内容 | 対応方法 |
|------------|----------|---------|
| E1101 | ワークフロー定義取得エラー | DBアクセスを確認し、リトライ実行。3回失敗で管理者通知 |
| E1102 | 実行条件評価エラー | エラーログ記録後、次のワークフローへ進む |
| E1103 | タスク実行エラー | エラーログ記録後、ワークフロー定義の設定に従って次のアクションを決定 |
| E1104 | 分岐条件評価エラー | デフォルトパスを使用し、エラーログを記録 |
| E1105 | DB更新エラー | トランザクションロールバック後、リトライ実行 |
| E1106 | ワークフロー実行タイムアウト | 実行を強制終了し、タイムアウトとして記録 |

#### 12-6 実行条件

- 実行頻度：5分毎
- 実行時間：24時間
- 前提条件：なし
- 処理対象：実行条件を満たす登録済みワークフロー

#### 12-7 ログ出力仕様

| ログレベル | 出力内容 | 出力タイミング |
|----------|---------|--------------|
| INFO | 処理開始 | バッチ処理開始時 |
| INFO | ワークフロー実行開始 | ワークフロー実行開始時 |
| INFO | タスク実行開始 | タスク実行開始時 |
| INFO | タスク実行完了 | タスク実行完了時 |
| INFO | ワークフロー実行完了 | ワークフロー実行完了時 |
| INFO | 処理完了 | バッチ処理完了時 |
| WARN | 実行条件評価警告 | 実行条件の評価に問題がある場合 |
| WARN | タスク実行警告 | タスク実行中に警告が発生した場合 |
| ERROR | ワークフロー定義エラー | ワークフロー定義に問題がある場合 |
| ERROR | タスク実行エラー | タスク実行に失敗した場合 |
| ERROR | データ更新エラー | DBへの更新に失敗した場合 |
| DEBUG | 詳細処理内容 | 開発モード時のみ出力 |

#### 12-8 リトライ設計

- 最大リトライ回数：3回
- リトライ間隔：初回1分、以降は倍々で増加（1分→2分→4分）
- リトライ対象エラー：ワークフロー定義取得エラー、DB更新エラー、一部のタスク実行エラー
- リトライ上限超過時：アラート発行と管理者通知
- タスク別リトライ設定：ワークフロー定義内でタスクごとに個別のリトライ設定が可能