# ECシステム画面設計書

## 概要・目的

本ドキュメントは、ECサイト運営システムの画面設計を定義するものです。ECサイト運営に必要な各機能の画面仕様、表示項目、入力仕様、およびメッセージ仕様を示し、開発チームが一貫した理解のもとで実装を進めるための基準となります。

本システムは、商品登録から注文処理、発送管理、返品・キャンセル対応までの一連のECサイト運営業務をサポートし、特に以下の機能を重視しています：

1. リアルタイム在庫同期による在庫管理の正確性向上
2. 注文から発送までのステータス管理の効率化
3. 顧客通知の自動化と履歴管理
4. システム監視とアラート機能による安定運用

## 画面遷移図

```mermaid
graph TD
    %% システムダッシュボード関連
    Dashboard[システムダッシュボード画面] --> OrderStatus[注文ステータス管理画面]
    Dashboard --> MailTemplate[メールテンプレート管理画面]
    Dashboard --> NotifyHistory[顧客通知履歴画面]
    
    %% 在庫管理関連
    StockSync[リアルタイム在庫同期画面] --> StockSyncSetting[在庫同期設定画面]
    StockSync --> StockSyncLog[在庫同期ログ画面]
    StockSync --> MonitorDashboard[統合監視ダッシュボード画面]
    StockSyncSetting --> DataMapping[データマッピング設定画面]
    StockSyncLog --> AlertManage[アラート管理画面]
    
    %% 監視ダッシュボード関連
    MonitorDashboard --> StockSync
    MonitorDashboard --> AlertManage
    MonitorDashboard --> ReportScreen[監視レポート画面]
    MonitorDashboard --> SystemStatus[システム状態確認画面]
    SystemStatus --> ConnectionManage[接続管理画面]
    ConnectionManage --> DataMapping
    
    %% 注文管理関連
    OrderStatus --> OrderTracking[注文追跡画面]
    OrderStatus --> PaymentStatus[支払状況確認画面]
    OrderStatus --> ShipmentStatus[出荷ステータス管理画面]
    OrderTracking --> PaymentProcess[支払方法別処理画面]
    OrderTracking --> OrderStatus
    PaymentProcess --> PaymentStatus
    PaymentProcess --> ShipmentStatus
    PaymentProcess --> OrderStatus
    PaymentStatus --> ShipmentStatus
    PaymentStatus --> OrderStatus
    ShipmentStatus --> MailSend[発送完了メール送信画面]
    ShipmentStatus --> OrderStatus
    
    %% 通知管理関連
    MailSend --> NotifyHistory
    MailSend --> MailTemplate
    NotifyHistory --> CustomerSupport[顧客問い合わせ対応画面]
    NotifyHistory --> Dashboard
    CustomerSupport --> OrderTracking
    CustomerSupport --> NotifyHistory
    CustomerSupport --> Dashboard
    
    %% レジェンド
    classDef dashboard fill:#f9f,stroke:#333,stroke-width:2px;
    classDef stockManage fill:#bbf,stroke:#333,stroke-width:1px;
    classDef orderManage fill:#bfb,stroke:#333,stroke-width:1px;
    classDef notifyManage fill:#ffb,stroke:#333,stroke-width:1px;
    classDef systemManage fill:#bff,stroke:#333,stroke-width:1px;
    
    class Dashboard,MonitorDashboard dashboard;
    class StockSync,StockSyncSetting,StockSyncLog stockManage;
    class OrderStatus,OrderTracking,PaymentProcess,PaymentStatus,ShipmentStatus orderManage;
    class MailSend,NotifyHistory,CustomerSupport,MailTemplate notifyManage;
    class SystemStatus,ConnectionManage,DataMapping,AlertManage,ReportScreen systemManage;
```

## 各画面詳細

### 1. システムダッシュボード画面

#### 1-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 1-1-1 | ヘッダー情報 | 常時 | ログインユーザー名、現在日時、ロゴ |
| 1-1-2 | 注文統計 | 常時 | 本日の注文件数、前日比、週間推移グラフ |
| 1-1-3 | 在庫アラート | 条件付き | 在庫切れ/在庫少商品の一覧（5件まで表示） |
| 1-1-4 | システム状態 | 常時 | 主要システムコンポーネントの稼働状況 |
| 1-1-5 | 未処理タスク | 条件付き | 承認待ち返品、未発送注文など要対応事項 |
| 1-1-6 | メニュー | 常時 | 各機能へのナビゲーションメニュー |
| 1-1-7 | 通知エリア | 条件付き | システムからの重要通知（最大3件） |

#### 1-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 1-2-1 | 日付範囲選択 | プルダウン | - | × | 今日 | 表示データの日付範囲を選択 |
| 1-2-2 | 更新ボタン | ボタン | - | - | - | ダッシュボードデータを最新化 |
| 1-2-3 | 詳細表示リンク | リンク | - | - | - | 各セクションの詳細画面へ遷移 |

#### 1-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 1-3-1 | データ更新中です。しばらくお待ちください。 | 更新ボタン押下時 | 情報 |
| 1-3-2 | 重要なアラートがあります。確認してください。 | 未確認の重要アラート存在時 | 警告 |
| 1-3-3 | システム接続エラーが発生しています。管理者に連絡してください。 | システム接続障害時 | エラー |

### 2. リアルタイム在庫同期画面

#### 2-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 2-1-1 | 在庫同期ステータス | 常時 | 現在の同期状態（正常/警告/エラー） |
| 2-1-2 | 最終同期日時 | 常時 | 最後に在庫同期が完了した日時 |
| 2-1-3 | 同期対象システム | 常時 | 連携しているシステム名（WMSなど） |
| 2-1-4 | 同期統計情報 | 常時 | 今日の同期回数、成功率、エラー率 |
| 2-1-5 | 在庫変動リスト | 常時 | 直近の在庫数変動があった商品一覧 |
| 2-1-6 | エラーログ | 条件付き | 同期エラーが発生した場合のログ情報 |

#### 2-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 2-2-1 | 手動同期ボタン | ボタン | - | - | - | 手動で在庫同期を実行 |
| 2-2-2 | 同期設定ボタン | ボタン | - | - | - | 在庫同期設定画面へ遷移 |
| 2-2-3 | ログ表示ボタン | ボタン | - | - | - | 在庫同期ログ画面へ遷移 |
| 2-2-4 | 商品検索 | テキスト | 50文字以内 | × | - | 特定商品の在庫状況を検索 |
| 2-2-5 | 同期範囲選択 | チェックボックス | - | × | すべて選択 | 同期対象カテゴリを選択 |

#### 2-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 2-3-1 | 在庫同期を開始しました。 | 手動同期ボタン押下時 | 情報 |
| 2-3-2 | 在庫同期が完了しました。 | 同期完了時 | 成功 |
| 2-3-3 | 在庫同期中にエラーが発生しました。ログを確認してください。 | 同期エラー発生時 | エラー |
| 2-3-4 | 〇〇件の在庫データが更新されました。 | 同期成功時 | 情報 |
| 2-3-5 | 接続タイムアウトが発生しました。ネットワーク状況を確認してください。 | 接続タイムアウト時 | 警告 |

### 3. 在庫同期設定画面

#### 3-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 3-1-1 | 同期スケジュール | 常時 | 現在設定されている同期実行スケジュール |
| 3-1-2 | 同期対象システム | 常時 | 連携対象システム一覧 |
| 3-1-3 | 同期設定パラメータ | 常時 | タイムアウト値、再試行回数などの設定値 |
| 3-1-4 | データマッピング概要 | 常時 | 現在のデータマッピング設定の概要 |
| 3-1-5 | エラーハンドリング設定 | 常時 | エラー発生時の処理方法設定 |

#### 3-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 3-2-1 | 同期間隔 | プルダウン | - | ○ | 15分 | 自動同期の実行間隔を設定 |
| 3-2-2 | タイムアウト値 | 数値 | 5〜300秒 | ○ | 60秒 | 同期処理のタイムアウト時間 |
| 3-2-3 | 再試行回数 | 数値 | 0〜10回 | ○ | 3回 | エラー時の再試行回数 |
| 3-2-4 | 同期対象選択 | チェックボックス | - | ○ | すべて選択 | 同期対象とするデータ種別 |
| 3-2-5 | マッピング設定ボタン | ボタン | - | - | - | データマッピング設定画面へ遷移 |
| 3-2-6 | 保存ボタン | ボタン | - | - | - | 設定内容を保存 |
| 3-2-7 | キャンセルボタン | ボタン | - | - | - | 変更をキャンセル |

#### 3-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 3-3-1 | 設定を保存しました。 | 保存成功時 | 成功 |
| 3-3-2 | 必須項目が入力されていません。 | 必須項目未入力時 | エラー |
| 3-3-3 | タイムアウト値は5〜300秒の範囲で入力してください。 | 入力値範囲外時 | 警告 |
| 3-3-4 | 現在の設定では同期処理に負荷がかかる可能性があります。 | 短い同期間隔設定時 | 警告 |

### 4. データマッピング設定画面

#### 4-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 4-1-1 | マッピングリスト | 常時 | 現在設定されているマッピングルール一覧 |
| 4-1-2 | WMSデータ項目 | 常時 | WMSシステムのデータ項目一覧 |
| 4-1-3 | ECデータ項目 | 常時 | ECシステムのデータ項目一覧 |
| 4-1-4 | 変換ルール | 常時 | データ変換のためのルール設定 |

#### 4-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 4-2-1 | WMS項目選択 | プルダウン | - | ○ | - | マッピング元のWMS項目を選択 |
| 4-2-2 | EC項目選択 | プルダウン | - | ○ | - | マッピング先のEC項目を選択 |
| 4-2-3 | 変換ルール | テキスト | 1000文字以内 | × | - | データ変換のためのルール式 |
| 4-2-4 | デフォルト値 | テキスト | 100文字以内 | × | - | データ欠損時のデフォルト値 |
| 4-2-5 | 追加ボタン | ボタン | - | - | - | マッピングを追加 |
| 4-2-6 | 削除ボタン | ボタン | - | - | - | 選択したマッピングを削除 |
| 4-2-7 | 保存ボタン | ボタン | - | - | - | 設定内容を保存 |
| 4-2-8 | キャンセルボタン | ボタン | - | - | - | 変更をキャンセル |

#### 4-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 4-3-1 | マッピング設定を保存しました。 | 保存成功時 | 成功 |
| 4-3-2 | マッピング項目を選択してください。 | 項目未選択時 | エラー |
| 4-3-3 | 変換ルールの構文が正しくありません。 | 不正なルール構文時 | エラー |
| 4-3-4 | このマッピングを削除してもよろしいですか？ | 削除ボタン押下時 | 確認 |

### 5. 在庫同期ログ画面

#### 5-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 5-1-1 | ログID | 常時 | ログの一意識別子 |
| 5-1-2 | 実行日時 | 常時 | 同期処理が実行された日時 |
| 5-1-3 | 処理結果 | 常時 | 成功/警告/エラーのステータス |
| 5-1-4 | 処理件数 | 常時 | 同期処理された商品件数 |
| 5-1-5 | 処理時間 | 常時 | 同期処理にかかった時間（秒） |
| 5-1-6 | エラー内容 | 条件付き | エラー発生時のメッセージ内容 |
| 5-1-7 | 対象システム | 常時 | 同期対象となったシステム名 |

#### 5-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 5-2-1 | 日付範囲 | 日付選択 | - | × | 過去7日間 | ログ検索の日付範囲 |
| 5-2-2 | 処理結果フィルタ | チェックボックス | - | × | すべて選択 | 表示するログの処理結果を選択 |
| 5-2-3 | 検索ボタン | ボタン | - | - | - | 指定条件でログを検索 |
| 5-2-4 | エクスポートボタン | ボタン | - | - | - | ログをCSV形式でエクスポート |
| 5-2-5 | 詳細表示ボタン | ボタン | - | - | - | 選択したログの詳細を表示 |

#### 5-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 5-3-1 | 検索条件に一致するログが見つかりませんでした。 | 検索結果0件時 | 情報 |
| 5-3-2 | ログのエクスポートが完了しました。 | エクスポート完了時 | 成功 |
| 5-3-3 | ログのエクスポートに失敗しました。 | エクスポート失敗時 | エラー |
| 5-3-4 | 検索結果が多すぎます。検索条件を絞り込んでください。 | 検索結果1000件超過時 | 警告 |

### 6. アラート管理画面

#### 6-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 6-1-1 | アラートID | 常時 | アラートの一意識別子 |
| 6-1-2 | 発生日時 | 常時 | アラートが発生した日時 |
| 6-1-3 | 重要度 | 常時 | 高/中/低の重要度レベル |
| 6-1-4 | アラート種別 | 常時 | 在庫異常/システムエラーなどの種別 |
| 6-1-5 | メッセージ | 常時 | アラートの内容説明 |
| 6-1-6 | 対応状況 | 常時 | 未対応/対応中/対応済みのステータス |
| 6-1-7 | 担当者 | 条件付き | アラート対応担当者名 |

#### 6-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 6-2-1 | 日付範囲 | 日付選択 | - | × | 過去24時間 | アラート検索の日付範囲 |
| 6-2-2 | 重要度フィルタ | チェックボックス | - | × | すべて選択 | 表示するアラートの重要度を選択 |
| 6-2-3 | 対応状況フィルタ | チェックボックス | - | × | すべて選択 | 表示するアラートの対応状況を選択 |
| 6-2-4 | 検索ボタン | ボタン | - | - | - | 指定条件でアラートを検索 |
| 6-2-5 | 対応状況更新 | プルダウン | - | ○ | 現在の状況 | アラートの対応状況を更新 |
| 6-2-6 | 担当者割当 | プルダウン | - | × | - | アラート対応の担当者を割り当て |
| 6-2-7 | コメント追加 | テキスト | 500文字以内 | × | - | アラート対応のコメントを追加 |
| 6-2-8 | 更新ボタン | ボタン | - | - | - | アラート情報を更新 |

#### 6-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 6-3-1 | アラート情報を更新しました。 | 更新成功時 | 成功 |
| 6-3-2 | 対応状況を選択してください。 | 対応状況未選択時 | エラー |
| 6-3-3 | 検索条件に一致するアラートが見つかりませんでした。 | 検索結果0件時 | 情報 |
| 6-3-4 | 未対応の重要アラートが〇件あります。 | 未対応重要アラート存在時 | 警告 |

### 7. 監視レポート画面

#### 7-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 7-1-1 | レポート種別 | 常時 | 日次/週次/月次などのレポート種別 |
| 7-1-2 | 対象期間 | 常時 | レポートの対象となる期間 |
| 7-1-3 | 在庫同期成功率 | 常時 | 期間内の在庫同期成功率のグラフ |
| 7-1-4 | 処理時間推移 | 常時 | 同期処理時間の推移グラフ |
| 7-1-5 | エラー発生率 | 常時 | 種類別のエラー発生率グラフ |
| 7-1-6 | システム負荷状況 | 常時 | 期間内のシステム負荷状況グラフ |
| 7-1-7 | 詳細データ表 | 常時 | 各指標の詳細数値データ表 |

#### 7-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 7-2-1 | レポート種別選択 | プルダウン | - | ○ | 日次 | 表示するレポートの種別を選択 |
| 7-2-2 | 日付範囲 | 日付選択 | - | ○ | 過去7日間 | レポートの対象期間を選択 |
| 7-2-3 | 表示項目選択 | チェックボックス | - | × | すべて選択 | レポートに表示する項目を選択 |
| 7-2-4 | 表示ボタン | ボタン | - | - | - | 指定条件でレポートを表示 |
| 7-2-5 | エクスポートボタン | ボタン | - | - | - | レポートをPDF/CSV形式でエクスポート |
| 7-2-6 | 印刷ボタン | ボタン | - | - | - | レポートを印刷 |

#### 7-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 7-3-1 | レポートを生成しています。しばらくお待ちください。 | レポート生成中 | 情報 |
| 7-3-2 | レポートの生成が完了しました。 | レポート生成完了時 | 成功 |
| 7-3-3 | レポートの生成に失敗しました。 | レポート生成失敗時 | エラー |
| 7-3-4 | 選択された期間のデータが存在しません。 | 対象期間データなし時 | 警告 |
| 7-3-5 | レポートのエクスポートが完了しました。 | エクスポート完了時 | 成功 |

### 8. 統合監視ダッシュボード画面

#### 8-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 8-1-1 | システム概況 | 常時 | 全体的なシステム状態の概要 |
| 8-1-2 | 重要アラート | 条件付き | 未対応の重要アラート一覧（最大5件） |
| 8-1-3 | 在庫同期状況 | 常時 | 直近の在庫同期状況と成功率 |
| 8-1-4 | システムパフォーマンス | 常時 | CPU/メモリ/ディスク使用率などのグラフ |
| 8-1-5 | 接続状態 | 常時 | 外部システムとの接続状態表示 |
| 8-1-6 | 処理キュー状態 | 常時 | 各処理キューの待機件数と処理速度 |
| 8-1-7 | 監視対象一覧 | 常時 | 監視対象システム/サービスの一覧と状態 |

#### 8-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 8-2-1 | 更新間隔 | プルダウン | - | × | 30秒 | ダッシュボードの自動更新間隔 |
| 8-2-2 | 表示項目設定 | チェックボックス | - | × | すべて選択 | ダッシュボードに表示する項目 |
| 8-2-3 | 更新ボタン | ボタン | - | - | - | ダッシュボードを手動で更新 |
| 8-2-4 | アラート確認ボタン | ボタン | - | - | - | アラート管理画面へ遷移 |
| 8-2-5 | レポート表示ボタン | ボタン | - | - | - | 監視レポート画面へ遷移 |
| 8-2-6 | システム状態確認ボタン | ボタン | - | - | - | システム状態確認画面へ遷移 |

#### 8-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 8-3-1 | ダッシュボードを更新しています。 | 更新中 | 情報 |
| 8-3-2 | 〇個の重要なアラートがあります。確認してください。 | 重要アラート存在時 | 警告 |
| 8-3-3 | システム監視に問題が発生しています。 | 監視システム異常時 | エラー |
| 8-3-4 | すべてのシステムが正常に動作しています。 | 全システム正常時 | 成功 |

### 9. システム状態確認画面

#### 9-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 9-1-1 | コンポーネント名 | 常時 | システムコンポーネントの名称 |
| 9-1-2 | 稼働状態 | 常時 | 正常/警告/エラーの状態表示 |
| 9-1-3 | 応答時間 | 常時 | コンポーネントの応答時間（ミリ秒） |
| 9-1-4 | 最終確認時刻 | 常時 | 最後に状態を確認した時刻 |
| 9-1-5 | エラー情報 | 条件付き | エラー発生時の詳細情報 |
| 9-1-6 | 稼働率 | 常時 | 過去24時間の稼働率（%） |
| 9-1-7 | 状態履歴 | 常時 | 過去の状態変化のタイムライン |

#### 9-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 9-2-1 | コンポーネント選択 | チェックボックス | - | × | すべて選択 | 表示するコンポーネントを選択 |
| 9-2-2 | 状態フィルタ | チェックボックス | - | × | すべて選択 | 表示するコンポーネント状態を選択 |
| 9-2-3 | 更新ボタン | ボタン | - | - | - | システム状態を最新化 |
| 9-2-4 | 詳細表示ボタン | ボタン | - | - | - | 選択したコンポーネントの詳細を表示 |
| 9-2-5 | 接続設定ボタン | ボタン | - | - | - | 接続管理画面へ遷移 |
| 9-2-6 | 履歴期間 | プルダウン | - | × | 24時間 | 表示する状態履歴の期間 |

#### 9-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 9-3-1 | システム状態を更新しています。 | 更新中 | 情報 |
| 9-3-2 | 〇個のコンポーネントでエラーが発生しています。 | エラー状態コンポーネント存在時 | 警告 |
| 9-3-3 | すべてのコンポーネントが正常に動作しています。 | 全コンポーネント正常時 | 成功 |
| 9-3-4 | コンポーネント情報の取得に失敗しました。 | 情報取得失敗時 | エラー |

### 10. 接続管理画面

#### 10-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 10-1-1 | 接続ID | 常時 | 接続設定の一意識別子 |
| 10-1-2 | 接続名 | 常時 | 接続設定の名称 |
| 10-1-3 | 接続先システム | 常時 | 接続先システム名 |
| 10-1-4 | 接続URL | 常時 | 接続先のURL |
| 10-1-5 | 認証方式 | 常時 | Basic/OAuth/APIキーなどの認証方式 |
| 10-1-6 | 接続状態 | 常時 | 接続の有効/無効状態 |
| 10-1-7 | 最終接続日時 | 常時 | 最後に接続が確立された日時 |

#### 10-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 10-2-1 | 接続名 | テキスト | 50文字以内 | ○ | - | 接続設定の名称 |
| 10-2-2 | 接続先システム | プルダウン | - | ○ | - | 接続先システムを選択 |
| 10-2-3 | 接続URL | テキスト | 200文字以内 | ○ | - | 接続先のURL |
| 10-2-4 | 認証方式 | プルダウン | - | ○ | Basic認証 | 認証方式を選択 |
| 10-2-5 | ユーザー名 | テキスト | 50文字以内 | △ | - | 認証用ユーザー名（認証方式による） |
| 10-2-6 | パスワード | パスワード | - | △ | - | 認証用パスワード（認証方式による） |
| 10-2-7 | APIキー | テキスト | 100文字以内 | △ | - | 認証用APIキー（認証方式による） |
| 10-2-8 | タイムアウト | 数値 | 5〜300秒 | ○ | 60秒 | 接続タイムアウト時間 |
| 10-2-9 | 有効/無効 | スイッチ | - | ○ | 有効 | 接続設定の有効/無効を切り替え |
| 10-2-10 | 保存ボタン | ボタン | - | - | - | 接続設定を保存 |
| 10-2-11 | キャンセルボタン | ボタン | - | - | - | 変更をキャンセル |
| 10-2-12 | 接続テストボタン | ボタン | - | - | - | 設定した接続をテスト |
| 10-2-13 | 削除ボタン | ボタン | - | - | - | 接続設定を削除 |

#### 10-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 10-3-1 | 接続設定を保存しました。 | 保存成功時 | 成功 |
| 10-3-2 | 接続テストに成功しました。 | 接続テスト成功時 | 成功 |
| 10-3-3 | 接続テストに失敗しました。詳細: [エラー内容] | 接続テスト失敗時 | エラー |
| 10-3-4 | 必須項目が入力されていません。 | 必須項目未入力時 | エラー |
| 10-3-5 | この接続設定を削除してもよろしいですか？ | 削除ボタン押下時 | 確認 |
| 10-3-6 | URLの形式が正しくありません。 | 不正なURL形式時 | エラー |

### 11. 注文ステータス管理画面

#### 11-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 11-1-1 | 注文ID | 常時 | 注文の一意識別子 |
| 11-1-2 | 注文日時 | 常時 | 注文が発生した日時 |
| 11-1-3 | 顧客情報 | 常時 | 顧客名、ID、メールアドレスなど |
| 11-1-4 | 注文金額 | 常時 | 注文の合計金額 |
| 11-1-5 | 支払状況 | 常時 | 未払い/支払済み/キャンセルなどの状態 |
| 11-1-6 | 出荷状況 | 常時 | 未出荷/出荷準備中/出荷済みなどの状態 |
| 11-1-7 | 商品リスト | 常時 | 注文に含まれる商品の一覧 |
| 11-1-8 | ステータス更新履歴 | 常時 | 注文ステータスの変更履歴 |

#### 11-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 11-2-1 | 注文ID検索 | テキスト | 50文字以内 | × | - | 注文IDで検索 |
| 11-2-2 | 顧客名検索 | テキスト | 50文字以内 | × | - | 顧客名で検索 |
| 11-2-3 | 日付範囲 | 日付選択 | - | × | 過去7日間 | 注文日の日付範囲 |
| 11-2-4 | 支払状況フィルタ | チェックボックス | - | × | すべて選択 | 表示する支払状況を選択 |
| 11-2-5 | 出荷状況フィルタ | チェックボックス | - | × | すべて選択 | 表示する出荷状況を選択 |
| 11-2-6 | 検索ボタン | ボタン | - | - | - | 指定条件で注文を検索 |
| 11-2-7 | 支払状況更新 | プルダウン | - | ○ | 現在の状況 | 選択した注文の支払状況を更新 |
| 11-2-8 | 出荷状況更新 | プルダウン | - | ○ | 現在の状況 | 選択した注文の出荷状況を更新 |
| 11-2-9 | 更新ボタン | ボタン | - | - | - | ステータス変更を保存 |
| 11-2-10 | 注文詳細ボタン | ボタン | - | - | - | 注文の詳細情報を表示 |

#### 11-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 11-3-1 | ステータスを更新しました。 | 更新成功時 | 成功 |
| 11-3-2 | ステータスの更新に失敗しました。 | 更新失敗時 | エラー |
| 11-3-3 | 検索条件に一致する注文が見つかりませんでした。 | 検索結果0件時 | 情報 |
| 11-3-4 | 未処理の注文が〇件あります。 | 未処理注文存在時 | 警告 |

### 12. 注文追跡画面

#### 12-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 12-1-1 | 注文ID | 常時 | 注文の一意識別子 |
| 12-1-2 | 注文日時 | 常時 | 注文が発生した日時 |
| 12-1-3 | 顧客情報 | 常時 | 顧客名、連絡先情報 |
| 12-1-4 | 配送先住所 | 常時 | 商品の配送先住所 |
| 12-1-5 | 商品リスト | 常時 | 注文に含まれる商品の一覧と状態 |
| 12-1-6 | 支払情報 | 常時 | 支払方法、支払状況 |
| 12-1-7 | 出荷情報 | 常時 | 出荷日、配送業者、追跡番号 |
| 12-1-8 | 配送状況 | 常時 | 配送の現在地、予定到着日 |
| 12-1-9 | ステータス履歴 | 常時 | 注文処理の各段階の履歴 |

#### 12-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 12-2-1 | 注文ID検索 | テキスト | 50文字以内 | × | - | 注文IDで検索 |
| 12-2-2 | 追跡番号検索 | テキスト | 50文字以内 | × | - | 配送追跡番号で検索 |
| 12-2-3 | 検索ボタン | ボタン | - | - | - | 指定条件で注文を検索 |
| 12-2-4 | ステータス更新ボタン | ボタン | - | - | - | 注文ステータス管理画面へ遷移 |
| 12-2-5 | 配送情報更新ボタン | ボタン | - | - | - | 配送業者から最新の配送情報を取得 |
| 12-2-6 | 顧客通知ボタン | ボタン | - | - | - | 顧客へステータス更新を通知 |
| 12-2-7 | 問題報告ボタン | ボタン | - | - | - | 配送問題を報告 |

#### 12-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 12-3-1 | 配送情報を更新しました。 | 配送情報更新成功時 | 成功 |
| 12-3-2 | 配送情報の更新に失敗しました。 | 配送情報更新失敗時 | エラー |
| 12-3-3 | 顧客に通知を送信しました。 | 顧客通知送信成功時 | 成功 |
| 12-3-4 | 問題報告を送信しました。担当者が対応します。 | 問題報告送信時 | 情報 |
| 12-3-5 | 指定された注文が見つかりません。 | 検索結果なし時 | エラー |

### 13. 支払方法別処理画面

#### 13-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 13-1-1 | 支払方法一覧 | 常時 | システムで利用可能な支払方法一覧 |
| 13-1-2 | 処理フロー図 | 常時 | 各支払方法の処理フロー図 |
| 13-1-3 | 処理設定情報 | 常時 | 各支払方法の処理設定情報 |
| 13-1-4 | 処理統計 | 常時 | 支払方法別の処理件数、成功率など |
| 13-1-5 | エラー情報 | 条件付き | 処理エラーの発生状況と詳細 |

#### 13-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 13-2-1 | 支払方法選択 | プルダウン | - | ○ | - | 設定する支払方法を選択 |
| 13-2-2 | 処理タイプ選択 | ラジオボタン | - | ○ | 自動 | 自動/手動の処理タイプを選択 |
| 13-2-3 | 自動承認条件 | チェックボックス | - | △ | すべて選択 | 自動承認する条件を選択 |
| 13-2-4 | 承認待ち期間 | 数値 | 1〜30日 | △ | 7日 | 支払承認待ちの最大期間 |
| 13-2-5 | リマインダー送信 | チェックボックス | - | × | オン | 支払リマインダーの送信有無 |
| 13-2-6 | リマインダー間隔 | 数値 | 1〜7日 | △ | 3日 | リマインダー送信の間隔 |
| 13-2-7 | 保存ボタン | ボタン | - | - | - | 設定内容を保存 |
| 13-2-8 | キャンセルボタン | ボタン | - | - | - | 変更をキャンセル |
| 13-2-9 | テストボタン | ボタン | - | - | - | 設定した処理フローをテスト |

#### 13-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 13-3-1 | 処理設定を保存しました。 | 保存成功時 | 成功 |
| 13-3-2 | 処理設定の保存に失敗しました。 | 保存失敗時 | エラー |
| 13-3-3 | テスト処理が成功しました。 | テスト成功時 | 成功 |
| 13-3-4 | テスト処理に失敗しました。詳細: [エラー内容] | テスト失敗時 | エラー |
| 13-3-5 | 必須項目が入力されていません。 | 必須項目未入力時 | エラー |

### 14. 支払状況確認画面

#### 14-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 14-1-1 | 注文ID | 常時 | 注文の一意識別子 |
| 14-1-2 | 注文日時 | 常時 | 注文が発生した日時 |
| 14-1-3 | 顧客情報 | 常時 | 顧客名、連絡先情報 |
| 14-1-4 | 注文金額 | 常時 | 注文の合計金額 |
| 14-1-5 | 支払方法 | 常時 | クレジットカード/銀行振込などの支払方法 |
| 14-1-6 | 支払状況 | 常時 | 未払い/支払済み/キャンセルなどの状態 |
| 14-1-7 | 支払期限 | 条件付き | 支払いの期限日時（該当する場合） |
| 14-1-8 | 決済ID | 条件付き | 決済システムでの取引ID |
| 14-1-9 | 異常フラグ | 条件付き | 支払いに関する異常がある場合のフラグ |

#### 14-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 14-2-1 | 注文ID検索 | テキスト | 50文字以内 | × | - | 注文IDで検索 |
| 14-2-2 | 顧客名検索 | テキスト | 50文字以内 | × | - | 顧客名で検索 |
| 14-2-3 | 日付範囲 | 日付選択 | - | × | 過去7日間 | 注文日の日付範囲 |
| 14-2-4 | 支払状況フィルタ | チェックボックス | - | × | すべて選択 | 表示する支払状況を選択 |
| 14-2-5 | 支払方法フィルタ | チェックボックス | - | × | すべて選択 | 表示する支払方法を選択 |
| 14-2-6 | 検索ボタン | ボタン | - | - | - | 指定条件で注文を検索 |
| 14-2-7 | 支払状況更新 | プルダウン | - | ○ | 現在の状況 | 選択した注文の支払状況を更新 |
| 14-2-8 | 更新ボタン | ボタン | - | - | - | 支払状況変更を保存 |
| 14-2-9 | 決済再確認ボタン | ボタン | - | - | - | 決済システムで状態を再確認 |
| 14-2-10 | リマインダー送信ボタン | ボタン | - | - | - | 支払いリマインダーを送信 |

#### 14-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 14-3-1 | 支払状況を更新しました。 | 更新成功時 | 成功 |
| 14-3-2 | 支払状況の更新に失敗しました。 | 更新失敗時 | エラー |
| 14-3-3 | 決済システムとの再確認が完了しました。 | 再確認成功時 | 成功 |
| 14-3-4 | リマインダーを送信しました。 | リマインダー送信成功時 | 成功 |
| 14-3-5 | リマインダーの送信に失敗しました。 | リマインダー送信失敗時 | エラー |
| 14-3-6 | 支払期限切れの注文が〇件あります。 | 期限切れ注文存在時 | 警告 |

### 15. 出荷ステータス管理画面

#### 15-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 15-1-1 | 注文ID | 常時 | 注文の一意識別子 |
| 15-1-2 | 注文日時 | 常時 | 注文が発生した日時 |
| 15-1-3 | 顧客情報 | 常時 | 顧客名、連絡先情報 |
| 15-1-4 | 配送先住所 | 常時 | 商品の配送先住所 |
| 15-1-5 | 商品リスト | 常時 | 注文に含まれる商品の一覧 |
| 15-1-6 | 出荷状況 | 常時 | 未出荷/出荷準備中/出荷済みなどの状態 |
| 15-1-7 | 配送業者 | 常時 | 選択された配送業者名 |
| 15-1-8 | 追跡番号 | 条件付き | 配送の追跡番号（出荷済みの場合） |
| 15-1-9 | 出荷日 | 条件付き | 実際に出荷された日付（出荷済みの場合） |

#### 15-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 15-2-1 | 注文ID検索 | テキスト | 50文字以内 | × | - | 注文IDで検索 |
| 15-2-2 | 顧客名検索 | テキスト | 50文字以内 | × | - | 顧客名で検索 |
| 15-2-3 | 日付範囲 | 日付選択 | - | × | 過去7日間 | 注文日の日付範囲 |
| 15-2-4 | 出荷状況フィルタ | チェックボックス | - | × | すべて選択 | 表示する出荷状況を選択 |
| 15-2-5 | 検索ボタン | ボタン | - | - | - | 指定条件で注文を検索 |
| 15-2-6 | 出荷状況更新 | プルダウン | - | ○ | 現在の状況 | 選択した注文の出荷状況を更新 |
| 15-2-7 | 配送業者選択 | プルダウン | - | ○ | - | 配送業者を選択 |
| 15-2-8 | 追跡番号入力 | テキスト | 50文字以内 | △ | - | 配送追跡番号を入力 |
| 15-2-9 | 出荷日入力 | 日付選択 | - | △ | 今日 | 出荷日を入力 |
| 15-2-10 | 更新ボタン | ボタン | - | - | - | 出荷情報変更を保存 |
| 15-2-11 | 一括更新ボタン | ボタン | - | - | - | 選択した複数注文を一括更新 |
| 15-2-12 | 納品書発行ボタン | ボタン | - | - | - | 選択した注文の納品書を発行 |
| 15-2-13 | 送り状発行ボタン | ボタン | - | - | - | 選択した注文の送り状を発行 |
| 15-2-14 | メール送信ボタン | ボタン | - | - | - | 発送完了メール送信画面へ遷移 |

#### 15-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 15-3-1 | 出荷情報を更新しました。 | 更新成功時 | 成功 |
| 15-3-2 | 出荷情報の更新に失敗しました。 | 更新失敗時 | エラー |
| 15-3-3 | 納品書を発行しました。 | 納品書発行成功時 | 成功 |
| 15-3-4 | 送り状を発行しました。 | 送り状発行成功時 | 成功 |
| 15-3-5 | 〇件の注文を一括更新しました。 | 一括更新成功時 | 成功 |
| 15-3-6 | 追跡番号は必須です。 | 追跡番号未入力時 | エラー |
| 15-3-7 | 未出荷の注文が〇件あります。 | 未出荷注文存在時 | 警告 |

### 16. 発送完了メール送信画面

#### 16-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 16-1-1 | 注文ID | 常時 | メール送信対象の注文ID |
| 16-1-2 | 顧客情報 | 常時 | 顧客名、メールアドレスなど |
| 16-1-3 | 配送情報 | 常時 | 配送業者、追跡番号など |
| 16-1-4 | メールテンプレート | 常時 | 選択されたメールテンプレート |
| 16-1-5 | メールプレビュー | 常時 | 送信前のメール内容プレビュー |
| 16-1-6 | 送信履歴 | 条件付き | 過去の送信履歴（該当する場合） |

#### 16-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 16-2-1 | 注文ID選択 | プルダウン | - | ○ | - | メール送信対象の注文IDを選択 |
| 16-2-2 | テンプレート選択 | プルダウン | - | ○ | 発送完了 | 使用するメールテンプレートを選択 |
| 16-2-3 | 件名編集 | テキスト | 100文字以内 | ○ | テンプレート既定値 | メールの件名を編集 |
| 16-2-4 | 本文編集 | リッチテキスト | 10000文字以内 | ○ | テンプレート既定値 | メールの本文を編集 |
| 16-2-5 | CCアドレス | テキスト | 100文字以内 | × | - | CCに含めるメールアドレス |
| 16-2-6 | BCCアドレス | テキスト | 100文字以内 | × | - | BCCに含めるメールアドレス |
| 16-2-7 | 添付ファイル | ファイル選択 | 最大5MB | × | - | メールに添付するファイル |
| 16-2-8 | プレビューボタン | ボタン | - | - | - | メールプレビューを更新 |
| 16-2-9 | 送信ボタン | ボタン | - | - | - | メールを送信 |
| 16-2-10 | キャンセルボタン | ボタン | - | - | - | メール作成をキャンセル |
| 16-2-11 | テンプレート管理ボタン | ボタン | - | - | - | メールテンプレート管理画面へ遷移 |

#### 16-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 16-3-1 | メールを送信しました。 | 送信成功時 | 成功 |
| 16-3-2 | メールの送信に失敗しました。 | 送信失敗時 | エラー |
| 16-3-3 | プレビューを更新しました。 | プレビュー更新時 | 情報 |
| 16-3-4 | 必須項目が入力されていません。 | 必須項目未入力時 | エラー |
| 16-3-5 | 添付ファイルのサイズが大きすぎます。 | 添付ファイル容量超過時 | 警告 |
| 16-3-6 | メールアドレスの形式が正しくありません。 | 不正なメールアドレス形式時 | エラー |

### 17. メールテンプレート管理画面

#### 17-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 17-1-1 | テンプレートID | 常時 | テンプレートの一意識別子 |
| 17-1-2 | テンプレート名 | 常時 | テンプレートの名称 |
| 17-1-3 | 用途 | 常時 | テンプレートの使用目的 |
| 17-1-4 | 件名 | 常時 | 設定されたメール件名 |
| 17-1-5 | 最終更新日 | 常時 | テンプレートが最後に更新された日時 |
| 17-1-6 | 更新者 | 常時 | テンプレートを最後に更新したユーザー |
| 17-1-7 | 使用言語 | 常時 | テンプレートの対応言語 |

#### 17-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 17-2-1 | テンプレート検索 | テキスト | 50文字以内 | × | - | テンプレート名や用途で検索 |
| 17-2-2 | 言語フィルタ | プルダウン | - | × | すべて | 表示する言語を選択 |
| 17-2-3 | 検索ボタン | ボタン | - | - | - | 指定条件でテンプレートを検索 |
| 17-2-4 | 新規作成ボタン | ボタン | - | - | - | 新しいテンプレートを作成 |
| 17-2-5 | テンプレート名 | テキスト | 50文字以内 | ○ | - | テンプレートの名称を入力 |
| 17-2-6 | 用途 | プルダウン | - | ○ | - | テンプレートの使用目的を選択 |
| 17-2-7 | 言語 | プルダウン | - | ○ | 日本語 | テンプレートの言語を選択 |
| 17-2-8 | 件名 | テキスト | 100文字以内 | ○ | - | メールの件名を入力 |
| 17-2-9 | 本文 | リッチテキスト | 10000文字以内 | ○ | - | メールの本文を入力 |
| 17-2-10 | 変数一覧 | 表示のみ | - | - | - | テンプレートで使用可能な変数一覧 |
| 17-2-11 | 保存ボタン | ボタン | - | - | - | テンプレートを保存 |
| 17-2-12 | キャンセルボタン | ボタン | - | - | - | 編集をキャンセル |
| 17-2-13 | 削除ボタン | ボタン | - | - | - | テンプレートを削除 |
| 17-2-14 | プレビューボタン | ボタン | - | - | - | テンプレートのプレビューを表示 |
| 17-2-15 | 複製ボタン | ボタン | - | - | - | 既存テンプレートを複製 |

#### 17-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 17-3-1 | テンプレートを保存しました。 | 保存成功時 | 成功 |
| 17-3-2 | テンプレートの保存に失敗しました。 | 保存失敗時 | エラー |
| 17-3-3 | テンプレートを削除しました。 | 削除成功時 | 成功 |
| 17-3-4 | テンプレートの削除に失敗しました。 | 削除失敗時 | エラー |
| 17-3-5 | このテンプレートを削除してもよろしいですか？ | 削除ボタン押下時 | 確認 |
| 17-3-6 | 必須項目が入力されていません。 | 必須項目未入力時 | エラー |
| 17-3-7 | テンプレートを複製しました。 | 複製成功時 | 成功 |

### 18. 顧客通知履歴画面

#### 18-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 18-1-1 | 通知ID | 常時 | 通知の一意識別子 |
| 18-1-2 | 送信日時 | 常時 | 通知が送信された日時 |
| 18-1-3 | 顧客情報 | 常時 | 顧客名、メールアドレスなど |
| 18-1-4 | 通知種別 | 常時 | メール/マイページ通知などの種別 |
| 18-1-5 | 通知内容 | 常時 | 通知の件名や概要 |
| 18-1-6 | 関連注文ID | 条件付き | 通知に関連する注文ID（該当する場合） |
| 18-1-7 | 開封状況 | 常時 | 開封済み/未開封の状態（メールの場合） |
| 18-1-8 | 送信者 | 常時 | 通知を送信したユーザーまたはシステム |

#### 18-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 18-2-1 | 顧客ID検索 | テキスト | 50文字以内 | × | - | 顧客IDで検索 |
| 18-2-2 | 顧客名検索 | テキスト | 50文字以内 | × | - | 顧客名で検索 |
| 18-2-3 | 注文ID検索 | テキスト | 50文字以内 | × | - | 関連する注文IDで検索 |
| 18-2-4 | 日付範囲 | 日付選択 | - | × | 過去30日間 | 通知送信日の日付範囲 |
| 18-2-5 | 通知種別フィルタ | チェックボックス | - | × | すべて選択 | 表示する通知種別を選択 |
| 18-2-6 | 開封状況フィルタ | チェックボックス | - | × | すべて選択 | 表示する開封状況を選択 |
| 18-2-7 | 検索ボタン | ボタン | - | - | - | 指定条件で通知を検索 |
| 18-2-8 | 詳細表示ボタン | ボタン | - | - | - | 選択した通知の詳細を表示 |
| 18-2-9 | 再送信ボタン | ボタン | - | - | - | 選択した通知を再送信 |
| 18-2-10 | エクスポートボタン | ボタン | - | - | - | 通知履歴をCSV形式でエクスポート |

#### 18-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 18-3-1 | 通知を再送信しました。 | 再送信成功時 | 成功 |
| 18-3-2 | 通知の再送信に失敗しました。 | 再送信失敗時 | エラー |
| 18-3-3 | 検索条件に一致する通知が見つかりませんでした。 | 検索結果0件時 | 情報 |
| 18-3-4 | 通知履歴をエクスポートしました。 | エクスポート成功時 | 成功 |
| 18-3-5 | 通知履歴のエクスポートに失敗しました。 | エクスポート失敗時 | エラー |

### 19. 顧客問い合わせ対応画面

#### 19-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 19-1-1 | 問い合わせID | 常時 | 問い合わせの一意識別子 |
| 19-1-2 | 受付日時 | 常時 | 問い合わせを受け付けた日時 |
| 19-1-3 | 顧客情報 | 常時 | 顧客名、連絡先情報など |
| 19-1-4 | 問い合わせ種別 | 常時 | 注文/返品/商品など問い合わせの種別 |
| 19-1-5 | 問い合わせ内容 | 常時 | 顧客からの問い合わせ内容 |
| 19-1-6 | 関連注文ID | 条件付き | 問い合わせに関連する注文ID |
| 19-1-7 | 対応状況 | 常時 | 未対応/対応中/対応済みのステータス |
| 19-1-8 | 担当者 | 常時 | 問い合わせ対応の担当者名 |
| 19-1-9 | 対応履歴 | 常時 | 過去の対応内容の履歴 |

#### 19-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 19-2-1 | 問い合わせID検索 | テキスト | 50文字以内 | × | - | 問い合わせIDで検索 |
| 19-2-2 | 顧客名検索 | テキスト | 50文字以内 | × | - | 顧客名で検索 |
| 19-2-3 | 注文ID検索 | テキスト | 50文字以内 | × | - | 関連する注文IDで検索 |
| 19-2-4 | 日付範囲 | 日付選択 | - | × | 過去30日間 | 問い合わせ受付日の日付範囲 |
| 19-2-5 | 問い合わせ種別フィルタ | チェックボックス | - | × | すべて選択 | 表示する問い合わせ種別を選択 |
| 19-2-6 | 対応状況フィルタ | チェックボックス | - | × | すべて選択 | 表示する対応状況を選択 |
| 19-2-7 | 検索ボタン | ボタン | - | - | - | 指定条件で問い合わせを検索 |
| 19-2-8 | 対応状況更新 | プルダウン | - | ○ | 現在の状況 | 問い合わせの対応状況を更新 |
| 19-2-9 | 担当者割当 | プルダウン | - | ○ | 現在の担当者 | 問い合わせの担当者を割り当て |
| 19-2-10 | 対応内容入力 | リッチテキスト | 10000文字以内 | × | - | 対応内容を入力 |
| 19-2-11 | 更新ボタン | ボタン | - | - | - | 対応情報を更新 |
| 19-2-12 | 返信ボタン | ボタン | - | - | - | 顧客へ返信メールを送信 |
| 19-2-13 | 注文詳細ボタン | ボタン | - | - | - | 関連する注文の詳細を表示 |
| 19-2-14 | 通知履歴ボタン | ボタン | - | - | - | 顧客への通知履歴を表示 |

#### 19-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 19-3-1 | 対応情報を更新しました。 | 更新成功時 | 成功 |
| 19-3-2 | 対応情報の更新に失敗しました。 | 更新失敗時 | エラー |
| 19-3-3 | 返信メールを送信しました。 | 返信メール送信成功時 | 成功 |
| 19-3-4 | 返信メールの送信に失敗しました。 | 返信メール送信失敗時 | エラー |
| 19-3-5 | 未対応の問い合わせが〇件あります。 | 未対応問い合わせ存在時 | 警告 |
| 19-3-6 | 検索条件に一致する問い合わせが見つかりませんでした。 | 検索結果0件時 | 情報 |

### 20. 返品・交換管理画面

#### 20-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 20-1-1 | 返品ID | 常時 | 返品・交換の一意識別子 |
| 20-1-2 | 申請日時 | 常時 | 返品・交換が申請された日時 |
| 20-1-3 | 顧客情報 | 常時 | 顧客名、連絡先情報など |
| 20-1-4 | 関連注文ID | 常時 | 返品・交換に関連する注文ID |
| 20-1-5 | 返品理由 | 常時 | 顧客が選択した返品・交換理由 |
| 20-1-6 | 返品商品 | 常時 | 返品・交換対象の商品情報 |
| 20-1-7 | 処理タイプ | 常時 | 返品/交換/返金などの処理タイプ |
| 20-1-8 | 承認状況 | 常時 | 承認/否認/保留などの状態 |
| 20-1-9 | 返送状況 | 条件付き | 返送商品の受領状況（承認時） |
| 20-1-10 | 返金状況 | 条件付き | 返金処理の状況（返金時） |

#### 20-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 20-2-1 | 返品ID検索 | テキスト | 50文字以内 | × | - | 返品IDで検索 |
| 20-2-2 | 注文ID検索 | テキスト | 50文字以内 | × | - | 関連する注文IDで検索 |
| 20-2-3 | 顧客名検索 | テキスト | 50文字以内 | × | - | 顧客名で検索 |
| 20-2-4 | 日付範囲 | 日付選択 | - | × | 過去30日間 | 申請日の日付範囲 |
| 20-2-5 | 処理タイプフィルタ | チェックボックス | - | × | すべて選択 | 表示する処理タイプを選択 |
| 20-2-6 | 承認状況フィルタ | チェックボックス | - | × | すべて選択 | 表示する承認状況を選択 |
| 20-2-7 | 検索ボタン | ボタン | - | - | - | 指定条件で返品・交換を検索 |
| 20-2-8 | 承認状況更新 | プルダウン | - | ○ | 現在の状況 | 返品・交換の承認状況を更新 |
| 20-2-9 | 返送状況更新 | プルダウン | - | △ | - | 返送商品の受領状況を更新 |
| 20-2-10 | 商品状態選択 | プルダウン | - | △ | - | 返送商品の状態を選択 |
| 20-2-11 | 返金額入力 | 数値 | 0以上 | △ | 商品金額 | 返金する金額を入力 |
| 20-2-12 | 返金方法選択 | プルダウン | - | △ | 元の支払方法 | 返金方法を選択 |
| 20-2-13 | コメント入力 | テキスト | 500文字以内 | × | - | 処理に関するコメントを入力 |
| 20-2-14 | 更新ボタン | ボタン | - | - | - | 返品・交換情報を更新 |
| 20-2-15 | 顧客通知ボタン | ボタン | - | - | - | 処理状況を顧客に通知 |
| 20-2-16 | 在庫更新ボタン | ボタン | - | - | - | 返品商品の在庫状態を更新 |

#### 20-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 20-3-1 | 返品・交換情報を更新しました。 | 更新成功時 | 成功 |
| 20-3-2 | 返品・交換情報の更新に失敗しました。 | 更新失敗時 | エラー |
| 20-3-3 | 顧客に通知を送信しました。 | 通知送信成功時 | 成功 |
| 20-3-4 | 在庫情報を更新しました。 | 在庫更新成功時 | 成功 |
| 20-3-5 | 返金処理を開始しました。 | 返金処理開始時 | 情報 |
| 20-3-6 | 返金処理が完了しました。 | 返金処理完了時 | 成功 |
| 20-3-7 | 返金処理に失敗しました。 | 返金処理失敗時 | エラー |
| 20-3-8 | 承認には返金額の入力が必要です。 | 返金額未入力で承認時 | 警告 |
| 20-3-9 | 未処理の返品・交換申請が〇件あります。 | 未処理申請存在時 | 警告 |

### 21. 在庫同期設定画面

#### 21-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| 21-1-1 | 同期スケジュール | 常時 | 現在設定されている同期実行スケジュール |
| 21-1-2 | 同期対象システム | 常時 | 連携対象システム一覧 |
| 21-1-3 | 同期設定パラメータ | 常時 | タイムアウト値、再試行回数などの設定値 |
| 21-1-4 | データマッピング概要 | 常時 | 現在のデータマッピング設定の概要 |
| 21-1-5 | エラーハンドリング設定 | 常時 | エラー発生時の処理方法設定 |
| 21-1-6 | 異常検知閾値設定 | 常時 | 在庫異常を検知する閾値設定 |
| 21-1-7 | 通知設定 | 常時 | エラー発生時の通知先設定 |

#### 21-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 入力制限 | 必須 | 初期値 | 説明 |
|--------|--------|----------|----------|------|--------|------|
| 21-2-1 | 同期間隔 | プルダウン | - | ○ | 15分 | 自動同期の実行間隔を設定 |
| 21-2-2 | タイムアウト値 | 数値 | 5〜300秒 | ○ | 60秒 | 同期処理のタイムアウト時間 |
| 21-2-3 | 再試行回数 | 数値 | 0〜10回 | ○ | 3回 | エラー時の再試行回数 |
| 21-2-4 | 再試行間隔 | 数値 | 1〜60分 | ○ | 5分 | 再試行の間隔 |
| 21-2-5 | 同期対象選択 | チェックボックス | - | ○ | すべて選択 | 同期対象とするデータ種別 |
| 21-2-6 | 在庫変動閾値 | 数値 | 0〜100% | ○ | 30% | 異常とみなす在庫変動率 |
| 21-2-7 | 通知先メール | テキスト | 100文字以内 | ○ | - | エラー通知先メールアドレス |
| 21-2-8 | 通知方法 | チェックボックス | - | ○ | メール | 通知方法（メール/システム通知など） |
| 21-2-9 | マッピング設定ボタン | ボタン | - | - | - | データマッピング設定画面へ遷移 |
| 21-2-10 | 保存ボタン | ボタン | - | - | - | 設定内容を保存 |
| 21-2-11 | キャンセルボタン | ボタン | - | - | - | 変更をキャンセル |
| 21-2-12 | テスト実行ボタン | ボタン | - | - | - | 設定内容でテスト同期を実行 |

#### 21-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|--------------|----------|------|
| 21-3-1 | 設定を保存しました。 | 保存成功時 | 成功 |
| 21-3-2 | 設定の保存に失敗しました。 | 保存失敗時 | エラー |
| 21-3-3 | テスト同期を実行しています。 | テスト実行開始時 | 情報 |
| 21-3-4 | テスト同期が完了しました。結果: [成功/失敗] | テスト実行完了時 | 情報/エラー |
| 21-3-5 | 必須項目が入力されていません。 | 必須項目未入力時 | エラー |
| 21-3-6 | タイムアウト値は5〜300秒の範囲で入力してください。 | 入力値範囲外時 | 警告 |
| 21-3-7 | 現在の設定では同期処理に負荷がかかる可能性があります。 | 短い同期間隔設定時 | 警告 |
| 21-3-8 | メールアドレスの形式が正しくありません。 | 不正なメールアドレス形式時 | エラー |

以上が、ECシステムの主要画面の詳細設計になります。各画面は、業務フローに基づいて必要な機能を備え、ユーザーが効率的にECサイト運営を行えるよう設計されています。また、自動化可能な処理については適切に自動化し、人的ミスを減らしながらも柔軟な運用が可能となっています。
