# ECサイト運営システム 論理データモデル

以下に、ECサイト運営システムの論理データモデルをmermaid記法で示します。このモデルは添付された業務フロー、機能要件、画面一覧に基づいて作成しています。

```mermaid
erDiagram
    商品 ||--o{ 商品画像 : "持つ"
    商品 ||--o{ SKU : "構成する"
    商品 ||--o{ 商品カテゴリマッピング : "分類される"
    カテゴリ ||--o{ 商品カテゴリマッピング : "含む"
    商品 ||--o{ 在庫 : "持つ"
    SKU ||--|| 在庫 : "持つ"
    在庫 ||--o{ 在庫履歴 : "記録する"
    在庫 ||--o{ 在庫同期ログ : "同期する"
    在庫 ||--o{ ロケーション : "配置される"
    ロケーション ||--|| 倉庫 : "所属する"
    注文 ||--o{ 注文明細 : "含む"
    注文明細 }o--|| SKU : "参照する"
    顧客 ||--o{ 注文 : "行う"
    注文 ||--|| 支払情報 : "持つ"
    注文 ||--o{ 配送情報 : "持つ"
    配送情報 ||--|| 配送業者 : "利用する"
    注文 ||--o{ 注文ステータス履歴 : "持つ"
    注文 ||--o{ 返品 : "発生する"
    返品 ||--|| 返金 : "伴う"
    返品 ||--o{ 返品商品 : "含む"
    返品商品 }o--|| SKU : "参照する"
    顧客 ||--o{ 問合せ : "行う"
    問合せ ||--o{ 問合せ対応履歴 : "持つ"
    通知 ||--o{ 通知履歴 : "記録する"
    通知 }o--|| 顧客 : "送信先"
    通知 }o--|| メールテンプレート : "使用する"
    システム監視 ||--o{ アラート : "生成する"
    システム監視 ||--o{ 監視レポート : "生成する"
    接続設定 ||--o{ データマッピング設定 : "持つ"
    ワークフロー定義 ||--o{ ワークフロー実行履歴 : "実行される"

    商品 {
        string 商品ID PK
        string 商品コード UK
        string JANコード
        string 商品名
        string 商品説明
        text 商品詳細説明
        decimal 販売価格
        date 販売開始日
        date 販売終了日
        boolean 公開フラグ
        date 作成日時
        date 更新日時
    }

    商品画像 {
        string 商品画像ID PK
        string 商品ID FK
        string 画像URL
        string 画像タイプ "メイン/サブ/サムネイル等"
        int 表示順序
        date アップロード日時
    }

    SKU {
        string SKUID PK
        string 商品ID FK
        string SKUコード UK
        string カラー
        string サイズ
        string その他属性
        decimal 追加価格 "基本価格からの追加額"
        boolean 販売可能フラグ
        date 作成日時
        date 更新日時
    }

    カテゴリ {
        string カテゴリID PK
        string カテゴリ名
        string 親カテゴリID FK "NULL=ルートカテゴリ"
        int 表示順序
        boolean 表示フラグ
    }

    商品カテゴリマッピング {
        string マッピングID PK
        string 商品ID FK
        string カテゴリID FK
        date 作成日時
    }

    在庫 {
        string 在庫ID PK
        string SKUID FK
        int 在庫数量
        int 引当数量 "注文確保済み数量"
        int 発注中数量
        date 最終更新日時
    }

    在庫履歴 {
        string 在庫履歴ID PK
        string 在庫ID FK
        int 変更前数量
        int 変更後数量
        string 変更理由
        string 関連注文ID "入出庫の原因となった注文ID"
        string 担当者ID
        date 変更日時
    }

    在庫同期ログ {
        string 同期ログID PK
        string 同期バッチID "同一実行のグループID"
        string 在庫ID FK
        int 同期前数量
        int 同期後数量
        string 同期ステータス "成功/失敗"
        string エラーメッセージ
        date 同期日時
    }

    ロケーション {
        string ロケーションID PK
        string 在庫ID FK
        string 倉庫ID FK
        string ロケーションコード "棚番号等"
        int 数量
        date 登録日時
        date 更新日時
    }

    倉庫 {
        string 倉庫ID PK
        string 倉庫名
        string 住所
        string 連絡先
        boolean 有効フラグ
    }

    注文 {
        string 注文ID PK
        string 顧客ID FK
        string 注文番号 UK
        decimal 商品合計金額
        decimal 送料
        decimal 税額
        decimal 割引額
        decimal 決済手数料
        decimal 注文合計金額
        string 注文ステータス "受付/支払済/出荷済/配送中/完了/キャンセル等"
        string 支払方法
        string 注文チャネル "PC/スマホ/アプリ等"
        string 備考
        date 注文日時
        date 更新日時
    }

    注文明細 {
        string 注文明細ID PK
        string 注文ID FK
        string SKUID FK
        int 数量
        decimal 単価
        decimal 小計
        string ステータス "通常/キャンセル/返品等"
        date 作成日時
    }

    顧客 {
        string 顧客ID PK
        string メールアドレス UK
        string 氏名
        string 氏名カナ
        string 郵便番号
        string 住所
        string 電話番号
        date 生年月日
        boolean メール受信許可フラグ
        date 登録日時
        date 最終ログイン日時
        date 更新日時
    }

    支払情報 {
        string 支払情報ID PK
        string 注文ID FK
        string 支払方法 "クレジットカード/コンビニ/銀行振込等"
        string 支払ステータス "未払/支払済/返金等"
        string 決済ID "外部決済システムの識別子"
        decimal 支払金額
        date 支払期限
        date 支払日時
        date 更新日時
    }

    配送情報 {
        string 配送情報ID PK
        string 注文ID FK
        string 配送業者ID FK
        string 配送方法
        string 伝票番号
        string 配送ステータス "準備中/出荷済/配送中/完了等"
        string 配送先氏名
        string 配送先郵便番号
        string 配送先住所
        string 配送先電話番号
        date 出荷日
        date 配送予定日
        date 配送完了日
        date 更新日時
    }

    配送業者 {
        string 配送業者ID PK
        string 配送業者名
        string APIキー
        string APIエンドポイント
        boolean 有効フラグ
        date 作成日時
        date 更新日時
    }

    注文ステータス履歴 {
        string 履歴ID PK
        string 注文ID FK
        string 変更前ステータス
        string 変更後ステータス
        string 変更理由
        string 担当者ID
        date 変更日時
    }

    返品 {
        string 返品ID PK
        string 注文ID FK
        string 返品理由
        string 返品ステータス "申請/承認/否認/返送中/検品中/完了等"
        decimal 返品金額
        string 担当者ID
        date 申請日時
        date 承認日時
        date 返品完了日時
    }

    返金 {
        string 返金ID PK
        string 返品ID FK
        decimal 返金金額
        string 返金方法
        string 返金ステータス "処理中/完了/失敗"
        string 決済ID "外部決済システムの識別子"
        string 担当者ID
        date 返金処理日時
        date 更新日時
    }

    返品商品 {
        string 返品商品ID PK
        string 返品ID FK
        string SKUID FK
        int 数量
        string 商品状態 "良品/不良品"
        string 不良理由
        boolean 在庫戻し済フラグ
        date 登録日時
    }

    問合せ {
        string 問合せID PK
        string 顧客ID FK "未ログイン時はNULL可"
        string 問合せ種別
        string 問合せ内容
        string 問合せステータス "未対応/対応中/解決済"
        string 関連注文ID "注文に関する問合せの場合"
        date 問合せ日時
        date 更新日時
    }

    問合せ対応履歴 {
        string 対応履歴ID PK
        string 問合せID FK
        string 対応内容
        string 対応者ID
        boolean 顧客返信フラグ "顧客からの返信かどうか"
        date 対応日時
    }

    通知 {
        string 通知ID PK
        string 通知種別 "発送完了/返品承認/返金完了等"
        string 通知タイトル
        string 通知本文
        string メールテンプレートID FK
        date 作成日時
    }

    通知履歴 {
        string 通知履歴ID PK
        string 通知ID FK
        string 顧客ID FK
        string 送信先 "メールアドレス等"
        string 通知ステータス "送信済/失敗/開封済"
        string 関連注文ID
        date 送信日時
        date 開封日時
    }

    メールテンプレート {
        string テンプレートID PK
        string テンプレート名
        string テンプレート種別 "発送完了/返品承認/返金完了等"
        string 件名
        text 本文
        boolean 有効フラグ
        date 作成日時
        date 更新日時
    }

    システム監視 {
        string 監視ID PK
        string 監視項目名
        string 監視対象 "在庫同期/決済処理/配送連携等"
        string 監視条件
        string アラート閾値
        boolean 有効フラグ
        date 作成日時
        date 更新日時
    }

    アラート {
        string アラートID PK
        string 監視ID FK
        string アラート種別
        string 重要度 "高/中/低"
        string アラート内容
        string ステータス "未確認/確認済/対応中/解決済"
        string 担当者ID
        date 発生日時
        date 確認日時
        date 解決日時
    }

    監視レポート {
        string レポートID PK
        string レポート種別
        string レポート名
        string レポートデータ "JSON形式等"
        date 集計開始日時
        date 集計終了日時
        date 生成日時
    }

    接続設定 {
        string 接続ID PK
        string 接続名
        string 接続先種別 "WMS/決済システム/配送業者等"
        string エンドポイントURL
        string 認証情報 "暗号化して保存"
        int タイムアウト値
        int リトライ回数
        boolean 有効フラグ
        date 作成日時
        date 更新日時
    }

    データマッピング設定 {
        string マッピングID PK
        string 接続ID FK
        string ソースフィールド
        string ターゲットフィールド
        string 変換ルール
        string デフォルト値
        boolean 必須フラグ
        date 作成日時
        date 更新日時
    }

    ワークフロー定義 {
        string ワークフローID PK
        string ワークフロー名
        string 処理種別 "在庫同期/注文処理/返品処理等"
        text ワークフロー定義 "JSON形式等"
        string トリガー条件
        boolean 有効フラグ
        date 作成日時
        date 更新日時
    }

    ワークフロー実行履歴 {
        string 実行ID PK
        string ワークフローID FK
        string 実行ステータス "成功/失敗/実行中"
        string 実行結果
        string エラー内容
        int 処理件数
        date 開始日時
        date 終了日時
    }
```

## エンティティの説明

### 1. 商品関連

#### 商品
ECサイトで販売される商品の基本情報を管理するエンティティ。商品名、説明、価格などの共通属性を持ち、複数のSKU（Stock Keeping Unit）を持つことができる。

#### 商品画像
商品に関連する画像情報を管理するエンティティ。メイン画像、サブ画像、サムネイル画像など複数の画像を商品ごとに管理し、表示順序も保持する。

#### SKU
商品のバリエーション（サイズ、カラーなど）を管理するエンティティ。在庫管理の最小単位となり、各SKUごとに在庫数を管理する。

#### カテゴリ
商品を分類するためのカテゴリ情報を管理するエンティティ。階層構造を持ち、親子関係を表現できる。

#### 商品カテゴリマッピング
商品とカテゴリの多対多の関連を管理するエンティティ。一つの商品が複数のカテゴリに属することを可能にする。

### 2. 在庫関連

#### 在庫
各SKUの在庫数量を管理するエンティティ。実在庫数、引当数量（注文確保済み）、発注中数量などを保持する。

#### 在庫履歴
在庫数量の変更履歴を記録するエンティティ。入荷、出荷、返品などによる在庫変動を追跡する。

#### 在庫同期ログ
WMSとECシステム間の在庫同期処理の履歴を記録するエンティティ。同期の成功/失敗、同期前後の数量などを記録する。

#### ロケーション
倉庫内の商品保管場所を管理するエンティティ。SKUごとの保管場所（棚番号など）を管理し、ピッキング効率化に寄与する。

#### 倉庫
商品を保管する物理的な倉庫の情報を管理するエンティティ。複数倉庫での在庫管理に対応する。

### 3. 注文関連

#### 注文
顧客からの注文情報を管理するエンティティ。注文日時、金額、ステータスなどの基本情報を保持する。

#### 注文明細
注文に含まれる商品（SKU）の詳細情報を管理するエンティティ。商品ごとの数量、単価、小計などを保持する。

#### 顧客
ECサイトを利用する顧客の情報を管理するエンティティ。個人情報、連絡先情報などを保持する。

#### 支払情報
注文に関連する支払い情報を管理するエンティティ。支払方法、支払ステータス、支払日時などを記録する。

#### 配送情報
注文商品の配送に関する情報を管理するエンティティ。配送先、配送方法、伝票番号、配送ステータスなどを保持する。

#### 配送業者
配送サービスを提供する業者の情報を管理するエンティティ。配送業者名、API連携情報などを保持する。

#### 注文ステータス履歴
注文ステータスの変更履歴を記録するエンティティ。ステータス変更の日時、理由、担当者などを追跡する。

### 4. 返品・返金関連

#### 返品
顧客からの返品申請と処理を管理するエンティティ。返品理由、ステータス、返品金額などを保持する。

#### 返金
返品に伴う返金処理を管理するエンティティ。返金金額、返金方法、処理状況などを記録する。

#### 返品商品
返品される商品（SKU）の詳細情報を管理するエンティティ。返品数量、商品状態、在庫戻し状況などを保持する。

### 5. カスタマーサポート関連

#### 問合せ
顧客からの問い合わせを管理するエンティティ。問い合わせ内容、種別、ステータスなどを保持する。

#### 問合せ対応履歴
問い合わせに対する対応履歴を記録するエンティティ。対応内容、対応者、対応日時などを追跡する。

### 6. 通知関連

#### 通知
システムから顧客への通知内容を管理するエンティティ。通知種別、タイトル、本文などを保持する。

#### 通知履歴
顧客への通知送信履歴を記録するエンティティ。送信先、送信状態、開封状況などを追跡する。

#### メールテンプレート
通知メールのテンプレートを管理するエンティティ。種別ごとのテンプレート内容、件名、本文などを保持する。

### 7. システム監視関連

#### システム監視
監視対象と監視条件を管理するエンティティ。監視項目、監視条件、アラート閾値などを設定する。

#### アラート
システム監視によって検出された異常を記録するエンティティ。アラート種別、重要度、対応状況などを管理する。

#### 監視レポート
システム監視の結果を集計したレポートを管理するエンティティ。レポート種別、集計期間、生成日時などを保持する。

### 8. システム連携関連

#### 接続設定
外部システム（WMS、決済システム、配送業者システムなど）との接続情報を管理するエンティティ。接続先URL、認証情報、タイムアウト設定などを保持する。

#### データマッピング設定
外部システムとのデータ項目マッピングを管理するエンティティ。フィールド間の対応関係、変換ルールなどを定義する。

### 9. ワークフロー関連

#### ワークフロー定義
業務プロセスの自動化ワークフローを定義するエンティティ。処理内容、トリガー条件などを保持する。

#### ワークフロー実行履歴
ワークフローの実行結果を記録するエンティティ。実行ステータス、処理件数、開始・終了日時などを追跡する。

このデータモデルは、ECサイト運営の主要な業務プロセス（商品登録、在庫管理、注文処理、配送管理、返品・返金処理、カスタマーサポート）をカバーし、添付された業務フロー図に示された各アクションとシステム連携を実現するために必要なエンティティと関連を定義しています。
