# ECサイトセキュリティ設計書

## 1. 概要

本設計書は、ECサイトにおけるセキュリティ要件と対策を定義するものです。ユーザー情報や決済情報などの機密データを適切に保護し、サイバー攻撃からシステムを防御するための設計指針を提供します。

## 2. セキュリティ基本方針

### 2.1 基本原則

1. 多層防御（Defense in Depth）の原則に基づき、複数の防御層を構築
2. 最小権限の原則に基づき、必要最小限のアクセス権限を付与
3. 機密データの暗号化による保護
4. セキュリティ監視と検知の常時実施
5. インシデント対応計画の策定と定期的な訓練

### 2.2 コンプライアンス要件

- PCI DSS（Payment Card Industry Data Security Standard）への準拠
- 個人情報保護法への対応
- GDPR（EU一般データ保護規則）への対応（グローバル展開時）

## 3. ネットワークセキュリティ設計

### 3.1 VPC設計

#### 3.1.1 サブネット分離
- パブリックサブネット：ALB、NAT Gateway、踏み台サーバー
- プライベートサブネット（アプリケーション層）：EC2インスタンス、Fargate
- プライベートサブネット（データ層）：RDS、ElastiCache、OpenSearch

#### 3.1.2 セキュリティグループ設計

| セキュリティグループ | インバウンドルール | アウトバウンドルール |
|-----------------|----------------|-----------------|
| ALB-SG | HTTPS(443) from 0.0.0.0/0 | HTTP(80), HTTPS(443) to APP-SG |
| APP-SG | HTTP(80), HTTPS(443) from ALB-SG | HTTPS(443) to 0.0.0.0/0, MySQL(3306) to DB-SG, Redis(6379) to CACHE-SG |
| DB-SG | MySQL(3306) from APP-SG | なし |
| CACHE-SG | Redis(6379) from APP-SG | なし |
| SEARCH-SG | HTTPS(443) from APP-SG | なし |
| ADMIN-SG | SSH(22) from 踏み台サーバー | HTTPS(443) to 0.0.0.0/0 |

#### 3.1.3 ネットワークACL設計
パブリックサブネットとプライベートサブネットの境界に適用し、不正なトラフィックをブロック

### 3.2 WAFとShield設定

#### 3.2.1 AWS WAF設定
- SQLインジェクション対策ルール
- クロスサイトスクリプティング（XSS）対策ルール
- レートベース制限ルール（IPアドレスごとのリクエスト数制限）
- 地域ブロックルール（不要な国からのアクセスをブロック）

#### 3.2.2 AWS Shield設定
- Shield Standard：基本的なDDoS保護（デフォルト有効）
- Shield Advanced：大規模DDoS攻撃への追加保護（オプション）

### 3.3 通信暗号化

- CloudFrontとALB間：TLS 1.2以上
- ALBとEC2間：TLS 1.2以上
- EC2とRDS間：TLS 1.2以上
- バックアップデータ転送：暗号化通信

## 4. アプリケーションセキュリティ設計

### 4.1 認証・認可

#### 4.1.1 認証設計
- Amazon Cognitoを使用したユーザー認証
- 多要素認証（MFA）のオプション提供
- パスワードポリシー：
  - 最低8文字以上
  - 大文字・小文字・数字・特殊文字を含む
  - 前回から一定数以上の文字が変更されていること
  - パスワード使い回し禁止（過去5回分）

#### 4.1.2 認可設計
- ロールベースアクセス制御（RBAC）の実装
- JWT（JSON Web Token）によるステートレス認証
- セッション管理：
  - セッションタイムアウト：30分（非アクティブ時）
  - セッション有効期限：24時間（最大）
  - セッションID再利用防止

#### 4.1.3 OAuth連携
- SNSアカウント連携（Facebook、Google、Appleなど）
- OAuthスコープの最小化

### 4.2 入力検証と出力エンコーディング

#### 4.2.1 入力検証
- サーバーサイドでの入力値検証
- クライアントサイドでの入力値検証（UXのため、セキュリティ対策としては補助的）
- 特殊文字のサニタイズ処理

#### 4.2.2 出力エンコーディング
- HTMLエンコーディング
- JavaScript エンコーディング
- URL エンコーディング
- レビュー・Q&A表示時のXSS対策

### 4.3 APIセキュリティ

- API Gatewayによるリクエスト検証
- APIキー管理
- レート制限の実装
- CORS（Cross-Origin Resource Sharing）設定

## 5. データセキュリティ設計

### 5.1 保存データの暗号化

#### 5.1.1 データベース暗号化
- RDSの保存時暗号化（AWS KMSによる暗号化）
- DynamoDBの保存時暗号化
- ElastiCacheの暗号化

#### 5.1.2 ストレージ暗号化
- S3バケットのサーバーサイド暗号化（SSE-KMS）
- EBSボリュームの暗号化

#### 5.1.3 バックアップデータの暗号化
- RDSバックアップの暗号化
- S3クロスリージョンレプリケーションの暗号化

### 5.2 機密データ処理

#### 5.2.1 クレジットカード情報の処理
- クレジットカード情報の非保持化（決済代行サービスの利用）
- トークナイゼーション（カード情報をトークンに置き換え）
- PCI DSS準拠の決済処理フロー

#### 5.2.2 個人情報の保護
- 個人識別情報（PII）の暗号化
- データマスキング（表示制限）
- アクセスログの記録

#### 5.2.3 データ分類と取り扱い
| データ分類 | 例 | 暗号化要件 | アクセス制限 |
|----------|---|----------|------------|
| 機密情報 | クレジットカード情報、パスワード | 強力な暗号化（AES-256）| 厳格なアクセス制限 |
| 個人情報 | 氏名、住所、電話番号 | 暗号化必須 | 業務上必要な役割のみ |
| 一般情報 | 商品情報、レビュー | 暗号化推奨 | 一般的なアクセス制御 |
| 公開情報 | 商品画像、商品説明 | 暗号化不要 | アクセス制限なし |

## 6. IAMとアクセス制御

### 6.1 AWSアカウント管理

- マルチアカウント戦略（開発、ステージング、本番環境の分離）
- AWS Organizationsによる一元管理
- サービスコントロールポリシー（SCP）の適用

### 6.2 IAMポリシー設計

#### 6.2.1 IAMロール設計

| ロール名 | 用途 | 権限スコープ |
|--------|-----|-----------|
| EC2AppRole | アプリケーションサーバー用 | S3読み取り、SQS送受信、DynamoDB読み書き |
| LambdaProcessingRole | 非同期処理用Lambda | S3読み書き、SQS受信、SNS発行 |
| AdminRole | 管理者用 | 必要最小限の管理権限 |
| MonitoringRole | 監視用 | 読み取り専用 + CloudWatch書き込み |

#### 6.2.2 IAMポリシー
- 最小権限の原則に基づくポリシー設計
- リソースレベルのアクセス制限
- 条件付きアクセス（特定のIPからのみなど）

### 6.3 シークレット管理

- AWS Secrets Managerによる認証情報管理
- データベース認証情報の自動ローテーション（90日ごと）
- APIキーの安全な管理

## 7. 監視とログ管理

### 7.1 セキュリティ監視

#### 7.1.1 AWS GuardDuty
- 脅威検出の有効化
- 異常な API コールの検出
- 不審なネットワークトラフィックの監視

#### 7.1.2 Amazon Inspector
- EC2インスタンスの脆弱性スキャン
- コンテナイメージのセキュリティ評価

#### 7.1.3 AWS Security Hub
- セキュリティアラートの一元管理
- コンプライアンス状況の可視化

### 7.2 ログ管理

#### 7.2.1 CloudTrail設定
- 全リージョンでのログ記録
- S3バケットへの長期保存（暗号化）
- ログファイルの整合性検証

#### 7.2.2 CloudWatch Logs設定
- アプリケーションログの集約
- メトリクスフィルターによるアラート設定
- ログの保持期間：1年

#### 7.2.3 アプリケーションログ
- アクセスログ（ユーザーID、IPアドレス、タイムスタンプ、操作内容）
- エラーログ（例外情報、スタックトレース）
- 監査ログ（重要操作の記録）

### 7.3 アラート設定

| アラート名 | 条件 | 重要度 | 通知先 |
|----------|-----|-------|-------|
| 認証失敗 | 5分以内に同一IPから5回以上の失敗 | 高 | セキュリティチーム |
| API異常呼び出し | 通常の10倍以上の頻度 | 高 | セキュリティチーム |
| S3バケット設定変更 | バケットポリシー変更 | 高 | セキュリティチーム、運用チーム |
| RDS設定変更 | セキュリティグループ変更 | 中 | 運用チーム |
| リソース使用率 | CPU/メモリ使用率90%以上 | 中 | 運用チーム |

## 8. インシデント対応

### 8.1 インシデント対応計画

#### 8.1.1 インシデント検知
- セキュリティアラートの監視体制
- ユーザー報告の受付窓口

#### 8.1.2 インシデント分類
| 分類 | 例 | 対応優先度 |
|-----|---|----------|
| 重大 | データ漏洩、サービス停止 | 最優先（即時対応） |
| 高 | 不正アクセス、DoS攻撃 | 優先（4時間以内） |
| 中 | 脆弱性発見、不審な活動 | 標準（24時間以内） |
| 低 | 軽微なポリシー違反 | 低（計画的に対応） |

#### 8.1.3 エスカレーションフロー
1. 検知・報告
2. 初期評価と分類
3. 対応チーム編成
4. 対応と封じ込め
5. 根本原因分析
6. 復旧
7. 報告と再発防止

### 8.2 フォレンジック

- 証拠保全手順の確立
- インシデント分析ツールの準備
- 外部専門家との連携体制

### 8.3 事業継続計画（BCP）

- 重大インシデント時の代替システム切り替え手順
- データ復旧手順
- 通信手段の確保

## 9. セキュリティ運用

### 9.1 脆弱性管理

#### 9.1.1 脆弱性スキャン
- 定期的な脆弱性スキャン（月次）
- コードの静的解析（CI/CDパイプラインに組込み）
- サードパーティライブラリの脆弱性チェック

#### 9.1.2 パッチ管理
- セキュリティパッチの適用ポリシー
  - 重大：24時間以内
  - 高：1週間以内
  - 中：1ヶ月以内
  - 低：四半期ごと

### 9.2 変更管理

- セキュリティ設定変更の承認フロー
- 変更前後の脆弱性評価
- ロールバック計画の策定

### 9.3 セキュリティ教育

- 開発者向けセキュアコーディングトレーニング（年2回）
- 運用者向けセキュリティ運用トレーニング（年2回）
- セキュリティ意識向上キャンペーン（四半期ごと）

## 10. 機能要件とセキュリティ対策の対応

### 10.1 認証・認可関連

| 機能ID | 機能名 | セキュリティ対策 |
|-------|------|--------------|
| 13 | ログイン状態確認 | JWT検証、セッション管理、CSRF対策 |
| 14 | 会員登録 | 入力検証、パスワード強度確認、CAPTCHA |
| 17 | SNSアカウント連携登録 | OAuth 2.0、スコープ制限、状態検証 |
| 19 | 会員登録認証メール送信 | メール送信制限、URLの有効期限設定 |

### 10.2 決済関連

| 機能ID | 機能名 | セキュリティ対策 |
|-------|------|--------------|
| 44 | クレジットカード情報入力 | PCI DSS準拠フォーム、トークナイゼーション |
| 50 | 決済処理実行 | 二重決済防止、トランザクション制御、監査ログ |
| 43 | 支払い方法選択 | 入力検証、セッション管理 |

### 10.3 個人情報関連

| 機能ID | 機能名 | セキュリティ対策 |
|-------|------|--------------|
| 22 | プロフィール情報表示 | アクセス制御、データマスキング |
| 23 | プロフィール情報更新 | 入力検証、変更監査ログ |
| 24-27 | 配送先住所管理 | アクセス制御、入力検証、CSRF対策 |

### 10.4 注文・カート関連

| 機能ID | 機能名 | セキュリティ対策 |
|-------|------|--------------|
| 32 | カート追加 | セッション管理、CSRF対策 |
| 48 | 注文確定 | トランザクション管理、二重送信防止 |
| 49 | 在庫確保処理 | 競合制御、デッドロック対策 |

### 10.5 検索・表示関連

| 機能ID | 機能名 | セキュリティ対策 |
|-------|------|--------------|
| 1 | 商品検索 | SQLインジェクション対策、入力検証 |
| 2 | オートコンプリート候補表示 | XSS対策、入力検証 |
| 7 | 商品レビュー表示 | XSS対策、コンテンツセキュリティポリシー |

## 11. セキュリティテスト計画

### 11.1 セキュリティテスト種別

#### 11.1.1 静的アプリケーションセキュリティテスト（SAST）
- コードレビュー
- 静的解析ツールの使用

#### 11.1.2 動的アプリケーションセキュリティテスト（DAST）
- 脆弱性スキャナーによる検査
- ペネトレーションテスト

#### 11.1.3 インフラセキュリティテスト
- AWS Config Rulesによる設定チェック
- クラウドインフラ脆弱性スキャン

### 11.2 テスト頻度と実施タイミング

| テスト種別 | 頻度 | 実施タイミング |
|----------|-----|-------------|
| SAST | 常時 | コミット時、PR作成時 |
| DAST | 週次 | 開発環境、リリース前 |
| ペネトレーションテスト | 半年ごと | メジャーリリース前 |
| インフラセキュリティテスト | 月次 | 定期実行 |

## 12. まとめ

本設計書では、ECサイトにおけるセキュリティ要件と対策を多層防御の考え方に基づいて定義しました。ネットワークセキュリティ、アプリケーションセキュリティ、データセキュリティ、アクセス制御、監視とログ管理、インシデント対応など、包括的なセキュリティ対策を設計しています。

定期的なセキュリティ評価と継続的な改善により、変化するセキュリティ脅威に対応し、ユーザーデータと事業を保護します。また、セキュリティはテクノロジーだけでなく、人とプロセスも含めた総合的な取り組みであることを認識し、教育とトレーニングを重視します。
