# ECサイトバッチ設計書

## 概要・目的

本ドキュメントは、ECサイトシステムにおけるバッチ処理の設計仕様を定義したものである。バッチ処理は、リアルタイム処理では対応が難しい大量データ処理や定期的な処理を実行するために必要となる。本設計書では、ECサイト運営に必要なデータ集計・更新・メンテナンス等のバッチ処理について、その目的、処理内容、実行条件などを詳細に記述する。

本設計に基づき実装されるバッチ処理により、以下の効果を得ることを目的とする：
- 顧客体験の向上（パーソナライズ推奨、在庫情報の正確性確保等）
- 運用効率の向上（自動メール送信、定期的なデータ更新等）
- データ分析基盤の整備（顧客行動データの集計・蓄積等）
- システム安定性の確保（定期的なメンテナンス処理等）

## バッチ一覧

| No. | 機能名 | 機能概要 | 実行頻度 | 実行時刻 | 依存関係 |
|-----|--------|----------|----------|----------|----------|
| 1 | 顧客行動データ収集バッチ | ユーザーの閲覧履歴、検索履歴、購買履歴などを収集し、AI推奨のためのデータセットを構築する | 1時間ごと | 毎時00分 | なし |
| 2 | 商品レコメンデーションモデル更新バッチ | 収集した行動データを基に、AIレコメンデーションモデルを更新する | 日次 | 03:00 | 顧客行動データ収集バッチ |
| 3 | 注文確認メール送信バッチ | 注文完了時に注文内容の確認メールをユーザーに送信する | 10分ごと | 毎時 00, 10, 20, 30, 40, 50分 | なし |
| 4 | 発送完了メール送信バッチ | 商品発送時に発送完了メールをユーザーに送信する | 1時間ごと | 毎時30分 | なし |
| 5 | 返金完了通知送信バッチ | 返金処理完了時にユーザーへ通知メールを送信する | 1時間ごと | 毎時45分 | なし |
| 6 | ポイント期限通知バッチ | 有効期限が近いポイントを保有するユーザーに通知メールを送信する | 日次 | 10:00 | なし |
| 7 | ポイント失効バッチ | 有効期限切れのポイントを失効させる | 日次 | 04:00 | なし |
| 8 | カート放置リマインドバッチ | カートに商品を入れたまま一定時間経過したユーザーにリマインドメールを送信する | 日次 | 15:00 | なし |
| 9 | 在庫情報更新バッチ | 在庫管理システムと連携して商品の在庫情報を更新する | 30分ごと | 毎時 00, 30分 | なし |
| 10 | 商品情報一括更新バッチ | 商品マスタの一括更新を行う | 日次 | 02:00 | なし |
| 11 | アクセスログ集計バッチ | サイトへのアクセスログを集計し、分析用データを作成する | 日次 | 05:00 | なし |
| 12 | 売上レポート生成バッチ | 日次/週次/月次の売上レポートを生成する | 日次 | 06:00 | なし |
| 13 | 検索キーワード分析バッチ | ユーザーの検索キーワードを分析し、検索精度向上のためのデータを作成する | 日次 | 04:30 | なし |
| 14 | データバックアップバッチ | システムデータのバックアップを作成する | 日次 | 01:00 | なし |
| 15 | 不要データ削除バッチ | 一時データや期限切れデータを削除する | 週次 | 日曜 02:00 | なし |

## 各バッチ詳細

### 1. 顧客行動データ収集バッチ

#### 1-1 機能概要
ユーザーの閲覧履歴、検索履歴、購買履歴などを収集し、AI推奨のためのデータセットを構築する機能。ECサイト上でのユーザーの行動データを収集・蓄積することで、パーソナライズされたレコメンデーション機能の基盤となるデータを整備する。

#### 1-2 処理フロー
1. アクセスログデータベースからユーザー行動データを抽出
   - 閲覧履歴（商品詳細ページの閲覧）
   - 検索履歴（検索キーワード、絞り込み条件）
   - カート操作履歴（カートへの追加、削除、数量変更）
   - 購買履歴（購入商品、購入日時、金額）
   - お気に入り登録履歴
2. ユーザーIDごとにデータを集約
3. データクレンジング処理（異常値の除外、重複の除去）
4. 行動分析データの生成（ユーザーの傾向、好みのカテゴリなど）
5. 学習用データセットの更新
6. 処理結果をログに出力

#### 1-3 入力データ仕様
- アクセスログテーブル
  - user_id: ユーザーID（未ログイン時は匿名ID）
  - session_id: セッションID
  - action_type: 行動タイプ（閲覧、検索、カート操作、購入、お気に入り）
  - target_id: 対象ID（商品ID、カテゴリIDなど）
  - timestamp: 実行時刻
  - params: 追加パラメータ（JSONフォーマット）

#### 1-4 出力データ仕様
- 行動分析データ（iiz77vlkze_ry8xd）
  - user_id: ユーザーID
  - favorite_categories: 好みのカテゴリ（JSON配列）
  - favorite_brands: 好みのブランド（JSON配列）
  - price_range: 購入価格帯
  - visit_frequency: 訪問頻度
  - last_visit_date: 最終訪問日
  - update_date: 更新日時

- 学習用データセット（ntc2uxdka_j1bey2）
  - user_id: ユーザーID
  - product_id: 商品ID
  - action_type: 行動タイプ
  - timestamp: 実行時刻
  - weight: 重み付け値

#### 1-5 エラー処理
- データベース接続エラー発生時：ログ出力後、管理者へメール通知
- データ抽出エラー発生時：エラー内容をログに記録し、処理を継続
- 出力ファイル作成エラー発生時：ログ出力後、リトライ

#### 1-6 実行条件
- 実行頻度：1時間ごと
- 実行時刻：毎時00分
- 前提条件：なし

#### 1-7 ログ出力仕様
- ログレベル：INFO, WARN, ERROR
- 出力内容：
  - 処理開始・終了時刻
  - 処理件数（抽出件数、更新件数）
  - エラー内容（発生時）
  - 処理時間

#### 1-8 リトライ設計
- 最大リトライ回数：3回
- リトライ間隔：5分
- リトライ対象エラー：データベース接続エラー、一時的なファイル書き込みエラー

### 2. 商品レコメンデーションモデル更新バッチ

#### 2-1 機能概要
収集した顧客行動データを基に、AIレコメンデーションモデルを更新する機能。パーソナライズされた商品推奨、関連商品推奨、アップセル商品推奨などを行うためのAIモデルを最新のデータで再学習させる。

#### 2-2 処理フロー
1. 学習用データセットを読み込み
2. 以下の各モデルを更新
   - パーソナライズ推奨モデル（個人の好みに合わせた商品推奨）
   - 関連商品推奨モデル（閲覧中商品に関連する商品推奨）
   - アップセル推奨モデル（カート内商品に合わせた追加購入推奨）
   - 検索パーソナライズモデル（検索結果のパーソナライズ）
3. モデル評価（精度検証）
4. モデルの保存
5. モデル切り替え
6. 処理結果をログに出力

#### 2-3 入力データ仕様
- 学習用データセット（ntc2uxdka_j1bey2）
  - user_id: ユーザーID
  - product_id: 商品ID
  - action_type: 行動タイプ
  - timestamp: 実行時刻
  - weight: 重み付け値

- 商品マスタ
  - product_id: 商品ID
  - category_id: カテゴリID
  - brand_id: ブランドID
  - price: 価格
  - attributes: 商品属性（JSONフォーマット）

#### 2-4 出力データ仕様
- レコメンデーションモデルファイル
  - personalized_model.bin: パーソナライズ推奨モデル
  - related_model.bin: 関連商品推奨モデル
  - upsell_model.bin: アップセル推奨モデル
  - search_model.bin: 検索パーソナライズモデル

- モデル評価レポート
  - model_name: モデル名
  - accuracy: 精度
  - recall: 再現率
  - precision: 適合率
  - f1_score: F1スコア
  - update_date: 更新日時

#### 2-5 エラー処理
- データ読み込みエラー発生時：ログ出力後、前回のモデルを維持
- モデル学習エラー発生時：エラー内容をログに記録し、該当モデルのみ前回版を維持
- モデル評価で精度低下検出時：警告をログに出力し、管理者へメール通知

#### 2-6 実行条件
- 実行頻度：日次
- 実行時刻：03:00
- 前提条件：顧客行動データ収集バッチの正常完了

#### 2-7 ログ出力仕様
- ログレベル：INFO, WARN, ERROR
- 出力内容：
  - 処理開始・終了時刻
  - 各モデルの学習データ件数
  - 各モデルの評価指標
  - エラー内容（発生時）
  - 処理時間

#### 2-8 リトライ設計
- 最大リトライ回数：2回
- リトライ間隔：30分
- リトライ対象エラー：データ読み込みエラー、一時的なリソース不足エラー
- リトライ非対象：モデル学習アルゴリズムのエラー（開発者の確認が必要）

### 3. 注文確認メール送信バッチ

#### 3-1 機能概要
注文完了時に注文内容の確認メールをユーザーに送信する機能。注文番号、商品詳細、金額、配送先、配送予定日などの情報を含むメールを自動送信する。

#### 3-2 処理フロー
1. 未送信の注文データを抽出
2. 注文ごとに以下の処理を実行
   - 注文詳細情報の取得（商品、金額、配送先など）
   - メールテンプレートの取得と変数置換
   - メール送信
   - 送信ステータスの更新
3. 処理結果をログに出力

#### 3-3 入力データ仕様
- 注文テーブル
  - order_id: 注文ID
  - user_id: ユーザーID
  - order_date: 注文日時
  - total_amount: 合計金額
  - shipping_address_id: 配送先住所ID
  - payment_method: 支払い方法
  - email_sent_flag: メール送信フラグ（0:未送信, 1:送信済）

- 注文詳細テーブル
  - order_detail_id: 注文詳細ID
  - order_id: 注文ID
  - product_id: 商品ID
  - quantity: 数量
  - price: 価格
  - discount: 割引額

- ユーザーテーブル
  - user_id: ユーザーID
  - email: メールアドレス
  - name: 氏名

- メールテンプレートマスタ
  - template_id: テンプレートID
  - subject: 件名
  - body: 本文（HTMLフォーマット）
  - from_address: 送信元アドレス

#### 3-4 出力データ仕様
- メール送信ログ
  - log_id: ログID
  - order_id: 注文ID
  - email: 送信先メールアドレス
  - subject: 件名
  - send_date: 送信日時
  - status: ステータス（成功/失敗）
  - error_message: エラーメッセージ（失敗時）

#### 3-5 エラー処理
- メール送信エラー発生時：エラー内容をログに記録し、次回バッチで再送信
- テンプレート取得エラー発生時：デフォルトテンプレートを使用
- ユーザー情報取得エラー発生時：エラー内容をログに記録し、次の注文処理へ

#### 3-6 実行条件
- 実行頻度：10分ごと
- 実行時刻：毎時 00, 10, 20, 30, 40, 50分
- 前提条件：なし

#### 3-7 ログ出力仕様
- ログレベル：INFO, WARN, ERROR
- 出力内容：
  - 処理開始・終了時刻
  - 処理対象注文数
  - 成功/失敗件数
  - エラー内容（発生時）
  - 処理時間

#### 3-8 リトライ設計
- 個別メール送信失敗時：
  - 最大リトライ回数：次回バッチ実行時に再処理（最大24時間）
  - 24時間経過後も送信できない場合：管理者へ通知
- バッチ全体失敗時：
  - 最大リトライ回数：3回
  - リトライ間隔：1分
  - リトライ対象エラー：メールサーバー接続エラー、一時的なリソース不足エラー

### 4. 発送完了メール送信バッチ

#### 4-1 機能概要
商品発送時に発送完了メールをユーザーに送信する機能。追跡番号や配送予定日などの情報を含むメールを自動送信する。

#### 4-2 処理フロー
1. 発送済みかつメール未送信の注文データを抽出
2. 注文ごとに以下の処理を実行
   - 注文詳細情報の取得
   - 配送情報の取得（追跡番号、配送会社など）
   - メールテンプレートの取得と変数置換
   - メール送信
   - 送信ステータスの更新
3. 処理結果をログに出力

#### 4-3 入力データ仕様
- 注文テーブル
  - order_id: 注文ID
  - user_id: ユーザーID
  - order_date: 注文日時
  - status: 注文ステータス

- 配送テーブル
  - shipping_id: 配送ID
  - order_id: 注文ID
  - shipping_company: 配送会社
  - tracking_number: 追跡番号
  - shipped_date: 発送日
  - estimated_delivery_date: 配送予定日
  - shipping_email_sent_flag: メール送信フラグ（0:未送信, 1:送信済）

- ユーザーテーブル
  - user_id: ユーザーID
  - email: メールアドレス
  - name: 氏名

- メールテンプレートマスタ
  - template_id: テンプレートID
  - subject: 件名
  - body: 本文（HTMLフォーマット）
  - from_address: 送信元アドレス

#### 4-4 出力データ仕様
- メール送信ログ
  - log_id: ログID
  - order_id: 注文ID
  - email: 送信先メールアドレス
  - subject: 件名
  - send_date: 送信日時
  - status: ステータス（成功/失敗）
  - error_message: エラーメッセージ（失敗時）

#### 4-5 エラー処理
- メール送信エラー発生時：エラー内容をログに記録し、次回バッチで再送信
- テンプレート取得エラー発生時：デフォルトテンプレートを使用
- 配送情報取得エラー発生時：エラー内容をログに記録し、次の注文処理へ

#### 4-6 実行条件
- 実行頻度：1時間ごと
- 実行時刻：毎時30分
- 前提条件：なし

#### 4-7 ログ出力仕様
- ログレベル：INFO, WARN, ERROR
- 出力内容：
  - 処理開始・終了時刻
  - 処理対象注文数
  - 成功/失敗件数
  - エラー内容（発生時）
  - 処理時間

#### 4-8 リトライ設計
- 個別メール送信失敗時：
  - 最大リトライ回数：次回バッチ実行時に再処理（最大24時間）
  - 24時間経過後も送信できない場合：管理者へ通知
- バッチ全体失敗時：
  - 最大リトライ回数：3回
  - リトライ間隔：5分
  - リトライ対象エラー：メールサーバー接続エラー、一時的なリソース不足エラー

### 5. 返金完了通知送信バッチ

#### 5-1 機能概要
返金処理完了時にユーザーへ通知メールを送信する機能。返金金額、返金方法、反映予定日などの情報を含むメールを自動送信する。

#### 5-2 処理フロー
1. 返金処理完了かつメール未送信の返品/キャンセルデータを抽出
2. 各データごとに以下の処理を実行
   - 返金情報の取得（金額、方法、反映日など）
   - ユーザー情報の取得
   - メールテンプレートの取得と変数置換
   - メール送信
   - 送信ステータスの更新
3. 処理結果をログに出力

#### 5-3 入力データ仕様
- 返品/キャンセルテーブル
  - return_id: 返品/キャンセルID
  - order_id: 注文ID
  - user_id: ユーザーID
  - reason: 理由
  - status: ステータス
  - created_date: 申請日

- 返金テーブル
  - refund_id: 返金ID
  - return_id: 返品/キャンセルID
  - amount: 返金額
  - method: 返金方法
  - status: ステータス（完了/処理中）
  - processed_date: 処理日
  - expected_date: 反映予定日
  - notification_sent_flag: 通知送信フラグ（0:未送信, 1:送信済）

- ユーザーテーブル
  - user_id: ユーザーID
  - email: メールアドレス
  - name: 氏名

- メールテンプレートマスタ
  - template_id: テンプレートID
  - subject: 件名
  - body: 本文（HTMLフォーマット）
  - from_address: 送信元アドレス

#### 5-4 出力データ仕様
- メール送信ログ
  - log_id: ログID
  - refund_id: 返金ID
  - email: 送信先メールアドレス
  - subject: 件名
  - send_date: 送信日時
  - status: ステータス（成功/失敗）
  - error_message: エラーメッセージ（失敗時）

#### 5-5 エラー処理
- メール送信エラー発生時：エラー内容をログに記録し、次回バッチで再送信
- テンプレート取得エラー発生時：デフォルトテンプレートを使用
- 返金情報取得エラー発生時：エラー内容をログに記録し、次のデータ処理へ

#### 5-6 実行条件
- 実行頻度：1時間ごと
- 実行時刻：毎時45分
- 前提条件：なし

#### 5-7 ログ出力仕様
- ログレベル：INFO, WARN, ERROR
- 出力内容：
  - 処理開始・終了時刻
  - 処理対象件数
  - 成功/失敗件数
  - エラー内容（発生時）
  - 処理時間

#### 5-8 リトライ設計
- 個別メール送信失敗時：
  - 最大リトライ回数：次回バッチ実行時に再処理（最大24時間）
  - 24時間経過後も送信できない場合：管理者へ通知
- バッチ全体失敗時：
  - 最大リトライ回数：3回
  - リトライ間隔：5分
  - リトライ対象エラー：メールサーバー接続エラー、一時的なリソース不足エラー

### 6. ポイント期限通知バッチ

#### 6-1 機能概要
有効期限が近いポイントを保有するユーザーに通知メールを送信する機能。ユーザーの保有ポイントの中で、30日以内に失効するポイントがある場合に通知を行う。

#### 6-2 処理フロー
1. 30日以内に期限切れとなるポイントを持つユーザーを抽出
2. ユーザーごとに以下の処理を実行
   - ポイント情報の取得（残高、期限切れ予定日、期限切れポイント数）
   - ユーザー情報の取得
   - メールテンプレートの取得と変数置換
   - メール送信
   - 通知履歴の記録
3. 処理結果をログに出力

#### 6-3 入力データ仕様
- ユーザーポイントテーブル
  - user_point_id: ユーザーポイントID
  - user_id: ユーザーID
  - point_amount: ポイント数
  - expire_date: 有効期限
  - status: ステータス（有効/使用済/失効）

- ユーザーテーブル
  - user_id: ユーザーID
  - email: メールアドレス
  - name: 氏名
  - point_notification_preference: ポイント通知設定（0:通知しない, 1:通知する）

- メールテンプレートマスタ
  - template_id: テンプレートID
  - subject: 件名
  - body: 本文（HTMLフォーマット）
  - from_address: 送信元アドレス

#### 6-4 出力データ仕様
- メール送信ログ
  - log_id: ログID
  - user_id: ユーザーID
  - email: 送信先メールアドレス
  - subject: 件名
  - send_date: 送信日時
  - status: ステータス（成功/失敗）
  - error_message: エラーメッセージ（失敗時）

- ポイント通知履歴テーブル
  - notification_id: 通知ID
  - user_id: ユーザーID
  - point_amount: 通知ポイント数
  - expire_date: 有効期限
  - notification_date: 通知日

#### 6-5 エラー処理
- メール送信エラー発生時：エラー内容をログに記録し、次回バッチで再送信
- テンプレート取得エラー発生時：デフォルトテンプレートを使用
- ユーザー情報取得エラー発生時：エラー内容をログに記録し、次のユーザー処理へ

#### 6-6 実行条件
- 実行頻度：日次
- 実行時刻：10:00
- 前提条件：なし

#### 6-7 ログ出力仕様
- ログレベル：INFO, WARN, ERROR
- 出力内容：
  - 処理開始・終了時刻
  - 処理対象ユーザー数
  - 成功/失敗件数
  - エラー内容（発生時）
  - 処理時間

#### 6-8 リトライ設計
- 個別メール送信失敗時：
  - 最大リトライ回数：次回バッチ実行時に再処理（最大3日間）
  - 3日経過後も送信できない場合：処理をスキップ
- バッチ全体失敗時：
  - 最大リトライ回数：3回
  - リトライ間隔：10分
  - リトライ対象エラー：メールサーバー接続エラー、一時的なリソース不足エラー

### 7. ポイント失効バッチ

#### 7-1 機能概要
有効期限切れのポイントを失効させる機能。期限が過ぎたポイントのステータスを「失効」に更新し、ユーザーの有効ポイント残高を更新する。

#### 7-2 処理フロー
1. 当日が有効期限のポイントデータを抽出
2. 抽出したポイントデータのステータスを「失効」に更新
3. 該当ユーザーの有効ポイント残高を再計算
4. 処理結果をログに出力

#### 7-3 入力データ仕様
- ユーザーポイントテーブル
  - user_point_id: ユーザーポイントID
  - user_id: ユーザーID
  - point_amount: ポイント数
  - expire_date: 有効期限
  - status: ステータス（有効/使用済/失効）
  - source: ポイント獲得元（購入/キャンペーン/会員登録など）
  - created_date: 作成日

- ユーザーポイント集計テーブル
  - user_id: ユーザーID
  - total_point: 合計ポイント
  - available_point: 有効ポイント
  - used_point: 使用済みポイント
  - expired_point: 失効ポイント
  - last_updated: 最終更新日時

#### 7-4 出力データ仕様
- 更新されたユーザーポイントテーブル
  - 失効したポイントのステータスが「失効」に更新される

- 更新されたユーザーポイント集計テーブル
  - 失効ポイントが増加し、有効ポイントが減少する

- ポイント失効履歴テーブル
  - expiration_id: 失効ID
  - user_id: ユーザーID
  - point_amount: 失効ポイント数
  - expire_date: 有効期限
  - processed_date: 処理日

#### 7-5 エラー処理
- データベース更新エラー発生時：トランザクションをロールバックし、エラー内容をログに記録
- 部分的な更新エラー発生時：正常に処理できたデータまでコミットし、エラーが発生したデータはスキップして次回処理

#### 7-6 実行条件
- 実行頻度：日次
- 実行時刻：04:00
- 前提条件：なし

#### 7-7 ログ出力仕様
- ログレベル：INFO, WARN, ERROR
- 出力内容：
  - 処理開始・終了時刻
  - 処理対象ポイント数
  - 更新成功件数
  - 影響を受けたユーザー数
  - エラー内容（発生時）
  - 処理時間

#### 7-8 リトライ設計
- 最大リトライ回数：3回
- リトライ間隔：10分
- リトライ対象エラー：データベース接続エラー、ロック競合エラー、一時的なリソース不足エラー

### 8. カート放置リマインドバッチ

#### 8-1 機能概要
カートに商品を入れたまま一定時間経過したユーザーにリマインドメールを送信する機能。購入完了していないカートの商品情報や特典情報を含むメールを送信し、購入を促す。

#### 8-2 処理フロー
1. 24時間以上経過したアクティブなカートデータを抽出（購入未完了）
2. ユーザーごとに以下の処理を実行
   - カート内商品情報の取得
   - ユーザー情報の取得
   - リマインドメールの送信履歴確認（重複送信防止）
   - メールテンプレートの取得と変数置換
   - メール送信
   - 送信履歴の記録
3. 処理結果をログに出力

#### 8-3 入力データ仕様
- カートテーブル
  - cart_id: カートID
  - user_id: ユーザーID（未ログイン時は匿名ID）
  - created_date: 作成日時
  - last_updated: 最終更新日時
  - status: ステータス（アクティブ/購入済/期限切れ）

- カート商品テーブル
  - cart_item_id: カート商品ID
  - cart_id: カートID
  - product_id: 商品ID
  - quantity: 数量
  - added_date: 追加日時

- 商品マスタ
  - product_id: 商品ID
  - name: 商品名
  - price: 価格
  - image_url: 画像URL
  - stock_status: 在庫状態

- ユーザーテーブル
  - user_id: ユーザーID
  - email: メールアドレス
  - name: 氏名
  - cart_reminder_preference: カートリマインド設定（0:通知しない, 1:通知する）

- リマインド送信履歴テーブル
  - reminder_id: リマインドID
  - cart_id: カートID
  - user_id: ユーザーID
  - sent_date: 送信日時

#### 8-4 出力データ仕様
- メール送信ログ
  - log_id: ログID
  - user_id: ユーザーID
  - email: 送信先メールアドレス
  - subject: 件名
  - send_date: 送信日時
  - status: ステータス（成功/失敗）
  - error_message: エラーメッセージ（失敗時）

- リマインド送信履歴テーブル（新規レコード追加）
  - reminder_id: リマインドID
  - cart_id: カートID
  - user_id: ユーザーID
  - sent_date: 送信日時

#### 8-5 エラー処理
- メール送信エラー発生時：エラー内容をログに記録し、次回バッチで再送信
- テンプレート取得エラー発生時：デフォルトテンプレートを使用
- 商品情報取得エラー発生時：エラー内容をログに記録し、次のカート処理へ

#### 8-6 実行条件
- 実行頻度：日次
- 実行時刻：15:00
- 前提条件：なし
- 除外条件：
  - 過去7日以内にリマインドメールを送信済みのカート
  - カートリマインド設定が「通知しない」のユーザー
  - 匿名ユーザーでメールアドレスが不明の場合

#### 8-7 ログ出力仕様
- ログレベル：INFO, WARN, ERROR
- 出力内容：
  - 処理開始・終了時刻
  - 処理対象カート数
  - 成功/失敗件数
  - エラー内容（発生時）
  - 処理時間

#### 8-8 リトライ設計
- 個別メール送信失敗時：
  - 最大リトライ回数：次回バッチ実行時に再処理（最大3日間）
  - 3日経過後も送信できない場合：処理をスキップ
- バッチ全体失敗時：
  - 最大リトライ回数：3回
  - リトライ間隔：10分
  - リトライ対象エラー：メールサーバー接続エラー、一時的なリソース不足エラー

### 9. 在庫情報更新バッチ

#### 9-1 機能概要
在庫管理システムと連携して商品の在庫情報を更新する機能。ECサイト上で表示される在庫情報を最新の状態に保ち、在庫切れによる注文キャンセルを防止する。

#### 9-2 処理フロー
1. 在庫管理システムからAPI経由で在庫データを取得
2. 現在のECサイトの在庫データと比較
3. 差分があるレコードを抽出
4. 在庫情報を更新
5. 在庫切れになった商品の表示ステータスを更新
6. 処理結果をログに出力

#### 9-3 入力データ仕様
- 在庫管理システムAPI
  - product_id: 商品ID
  - sku: SKUコード
  - stock_quantity: 在庫数量
  - last_updated: 最終更新日時

- 商品在庫テーブル
  - stock_id: 在庫ID
  - product_id: 商品ID
  - sku: SKUコード
  - quantity: 在庫数量
  - reserved_quantity: 予約数量
  - available_quantity: 有効在庫数量（quantity - reserved_quantity）
  - status: ステータス（在庫あり/残りわずか/在庫切れ）
  - last_updated: 最終更新日時

#### 9-4 出力データ仕様
- 更新された商品在庫テーブル
  - 在庫数量と在庫ステータスが更新される

- 在庫更新履歴テーブル
  - update_id: 更新ID
  - product_id: 商品ID
  - sku: SKUコード
  - old_quantity: 更新前数量
  - new_quantity: 更新後数量
  - update_date: 更新日時

- 在庫切れアラートテーブル（在庫切れになった商品）
  - alert_id: アラートID
  - product_id: 商品ID
  - sku: SKUコード
  - alert_date: アラート日時
  - status: ステータス（新規/確認済）

#### 9-5 エラー処理
- API接続エラー発生時：ログ出力後、前回のデータを維持
- データ取得エラー発生時：エラー内容をログに記録し、処理を中断
- 部分的な更新エラー発生時：正常に処理できた商品まで更新し、エラーが発生した商品はスキップ

#### 9-6 実行条件
- 実行頻度：30分ごと
- 実行時刻：毎時 00, 30分
- 前提条件：在庫管理システムが稼働中であること

#### 9-7 ログ出力仕様
- ログレベル：INFO, WARN, ERROR
- 出力内容：
  - 処理開始・終了時刻
  - 取得商品数
  - 更新商品数
  - 在庫切れになった商品数
  - エラー内容（発生時）
  - 処理時間

#### 9-8 リトライ設計
- 最大リトライ回数：5回
- リトライ間隔：1分
- リトライ対象エラー：API接続エラー、一時的なネットワークエラー

### 10. 商品情報一括更新バッチ

#### 10-1 機能概要
商品マスタの一括更新を行う機能。新商品の追加、既存商品の情報更新、販売終了商品の非表示化などを一括で処理する。

#### 10-2 処理フロー
1. 商品管理システムからAPI経由で商品データを取得
   - 新規商品データ
   - 更新商品データ
   - 販売終了商品データ
2. 各データ種別に応じて処理を実行
   - 新規商品：商品マスタに追加
   - 更新商品：既存レコードを更新
   - 販売終了商品：表示ステータスを非表示に更新
3. 関連テーブル（カテゴリ関連、価格履歴など）の更新
4. 処理結果をログに出力

#### 10-3 入力データ仕様
- 商品管理システムAPI
  - product_id: 商品ID
  - name: 商品名
  - description: 商品説明
  - price: 価格
  - category_ids: カテゴリID配列
  - brand_id: ブランドID
  - attributes: 商品属性（JSONフォーマット）
  - images: 画像URL配列
  - status: ステータス（新規/更新/販売終了）
  - update_date: 更新日時

- 商品マスタ
  - product_id: 商品ID
  - name: 商品名
  - description: 商品説明
  - short_description: 短い説明
  - price: 価格
  - brand_id: ブランドID
  - display_status: 表示ステータス（表示/非表示）
  - created_date: 作成日時
  - last_updated: 最終更新日時

- 商品属性テーブル
  - attribute_id: 属性ID
  - product_id: 商品ID
  - attribute_name: 属性名
  - attribute_value: 属性値

- 商品カテゴリマッピングテーブル
  - mapping_id: マッピングID
  - product_id: 商品ID
  - category_id: カテゴリID

- 商品画像テーブル
  - image_id: 画像ID
  - product_id: 商品ID
  - image_url: 画像URL
  - sort_order: 表示順

#### 10-4 出力データ仕様
- 更新された商品マスタ
- 更新された商品属性テーブル
- 更新された商品カテゴリマッピングテーブル
- 更新された商品画像テーブル

- 商品更新履歴テーブル
  - history_id: 履歴ID
  - product_id: 商品ID
  - update_type: 更新タイプ（新規/更新/販売終了）
  - update_date: 更新日時
  - details: 更新詳細（JSONフォーマット）

#### 10-5 エラー処理
- API接続エラー発生時：ログ出力後、処理を中断
- データ取得エラー発生時：エラー内容をログに記録し、処理を中断
- 部分的な更新エラー発生時：トランザクション単位でロールバックし、エラーが発生した商品はスキップ

#### 10-6 実行条件
- 実行頻度：日次
- 実行時刻：02:00
- 前提条件：商品管理システムが稼働中であること

#### 10-7 ログ出力仕様
- ログレベル：INFO, WARN, ERROR
- 出力内容：
  - 処理開始・終了時刻
  - 新規商品数
  - 更新商品数
  - 販売終了商品数
  - エラー内容（発生時）
  - 処理時間

#### 10-8 リトライ設計
- 最大リトライ回数：3回
- リトライ間隔：10分
- リトライ対象エラー：API接続エラー、一時的なネットワークエラー
- リトライ非対象：データ整合性エラー（開発者の確認が必要）

### 11. アクセスログ集計バッチ

#### 11-1 機能概要
サイトへのアクセスログを集計し、分析用データを作成する機能。アクセス元、流入経路、ユーザー属性などを分析し、マーケティング施策の効果測定や改善に活用する。

#### 11-2 処理フロー
1. 前日のアクセスログデータを抽出
2. 以下の観点で集計処理を実行
   - 時間帯別アクセス数
   - 流入経路別アクセス数（SNS広告、Web広告、検索エンジン、メールマガジン、直接アクセス）
   - デバイス別アクセス数（PC、スマートフォン、タブレット）
   - ページ別アクセス数
   - コンバージョン率（商品ページ閲覧→カート追加→購入完了）
3. 集計結果をデータウェアハウスに格納
4. 処理結果をログに出力

#### 11-3 入力データ仕様
- アクセスログテーブル
  - log_id: ログID
  - session_id: セッションID
  - user_id: ユーザーID（未ログイン時は匿名ID）
  - ip_address: IPアドレス
  - user_agent: ユーザーエージェント
  - referrer: リファラー
  - landing_page: ランディングページ
  - access_date: アクセス日時
  - device_type: デバイスタイプ
  - utm_source: UTMソース
  - utm_medium: UTMメディア
  - utm_campaign: UTMキャンペーン

- ページビューログテーブル
  - view_id: ビューID
  - session_id: セッションID
  - page_url: ページURL
  - page_type: ページタイプ（トップ、カテゴリ、商品詳細、カートなど）
  - view_date: 閲覧日時
  - duration: 滞在時間（秒）

#### 11-4 出力データ仕様
- アクセス集計テーブル
  - summary_date: 集計日
  - hour: 時間帯（0-23）
  - total_sessions: セッション総数
  - unique_users: ユニークユーザー数
  - new_users: 新規ユーザー数
  - returning_users: リピートユーザー数

- 流入経路集計テーブル
  - summary_date: 集計日
  - source: 流入元（SNS広告、Web広告、検索エンジン、メールマガジン、直接アクセス）
  - medium: メディア
  - campaign: キャンペーン名
  - sessions: セッション数
  - conversion_rate: コンバージョン率

- デバイス集計テーブル
  - summary_date: 集計日
  - device_type: デバイスタイプ
  - sessions: セッション数
  - avg_duration: 平均滞在時間
  - bounce_rate: 直帰率

- ページ集計テーブル
  - summary_date: 集計日
  - page_type: ページタイプ
  - page_url: ページURL
  - views: ビュー数
  - unique_views: ユニークビュー数
  - avg_duration: 平均滞在時間

#### 11-5 エラー処理
- データ抽出エラー発生時：エラー内容をログに記録し、処理を中断
- 集計処理エラー発生時：エラー内容をログに記録し、該当の集計をスキップして次の集計へ
- データ格納エラー発生時：トランザクションをロールバックし、エラー内容をログに記録

#### 11-6 実行条件
- 実行頻度：日次
- 実行時刻：05:00
- 前提条件：前日のアクセスログデータが完全であること

#### 11-7 ログ出力仕様
- ログレベル：INFO, WARN, ERROR
- 出力内容：
  - 処理開始・終了時刻
  - 処理対象日
  - 処理対象レコード数
  - 集計テーブルごとの出力件数
  - エラー内容（発生時）
  - 処理時間

#### 11-8 リトライ設計
- 最大リトライ回数：3回
- リトライ間隔：15分
- リトライ対象エラー：データベース接続エラー、一時的なリソース不足エラー
- リトライ非対象：データ整合性エラー（開発者の確認が必要）

### 12. 売上レポート生成バッチ

#### 12-1 機能概要
日次/週次/月次の売上レポートを生成する機能。売上金額、注文数、商品別売上、カテゴリ別売上などの情報をレポート化し、経営判断や在庫管理の基礎データとする。

#### 12-2 処理フロー
1. 対象期間のデータを抽出
   - 日次：前日の売上データ
   - 週次：前週（月曜〜日曜）の売上データ（月曜日実行時）
   - 月次：前月の売上データ（月初実行時）
2. 以下の観点で集計処理を実行
   - 総売上金額、総注文数
   - 商品別売上金額、販売数
   - カテゴリ別売上金額、販売数
   - 時間帯別売上金額、注文数
   - 支払い方法別売上金額、注文数
3. レポートデータをデータウェアハウスに格納
4. レポートファイル（CSV, Excel）を生成
5. 管理者へレポート生成通知メールを送信
6. 処理結果をログに出力

#### 12-3 入力データ仕様
- 注文テーブル
  - order_id: 注文ID
  - user_id: ユーザーID
  - order_date: 注文日時
  - total_amount: 合計金額
  - discount_amount: 割引金額
  - shipping_fee: 配送料
  - payment_method: 支払い方法
  - status: 注文ステータス

- 注文詳細テーブル
  - order_detail_id: 注文詳細ID
  - order_id: 注文ID
  - product_id: 商品ID
  - quantity: 数量
  - price: 価格
  - discount: 割引額

- 商品マスタ
  - product_id: 商品ID
  - name: 商品名
  - category_id: カテゴリID
  - brand_id: ブランドID

- カテゴリマスタ
  - category_id: カテゴリID
  - name: カテゴリ名
  - parent_id: 親カテゴリID

#### 12-4 出力データ仕様
- 日次売上集計テーブル
  - summary_date: 集計日
  - total_sales: 総売上金額
  - total_orders: 総注文数
  - average_order_value: 平均注文金額
  - new_customer_orders: 新規顧客注文数
  - repeat_customer_orders: リピート顧客注文数

- 商品別売上テーブル
  - summary_date: 集計日
  - product_id: 商品ID
  - product_name: 商品名
  - quantity_sold: 販売数
  - sales_amount: 売上金額
  - discount_amount: 割引金額

- カテゴリ別売上テーブル
  - summary_date: 集計日
  - category_id: カテゴリID
  - category_name: カテゴリ名
  - quantity_sold: 販売数
  - sales_amount: 売上金額
  - order_count: 注文数

- 時間帯別売上テーブル
  - summary_date: 集計日
  - hour: 時間帯（0-23）
  - sales_amount: 売上金額
  - order_count: 注文数

- 支払い方法別売上テーブル
  - summary_date: 集計日
  - payment_method: 支払い方法
  - sales_amount: 売上金額
  - order_count: 注文数

- 売上レポートファイル
  - daily_sales_YYYYMMDD.xlsx: 日次売上レポート
  - weekly_sales_YYYYMMDD.xlsx: 週次売上レポート（月曜日のみ）
  - monthly_sales_YYYYMM.xlsx: 月次売上レポート（月初のみ）

#### 12-5 エラー処理
- データ抽出エラー発生時：エラー内容をログに記録し、処理を中断
- 集計処理エラー発生時：エラー内容をログに記録し、該当の集計をスキップして次の集計へ
- レポートファイル生成エラー発生時：エラー内容をログに記録し、管理者に通知

#### 12-6 実行条件
- 実行頻度：日次
- 実行時刻：06:00
- 追加条件：
  - 週次レポート：月曜日のみ生成
  - 月次レポート：月初（1日）のみ生成

#### 12-7 ログ出力仕様
- ログレベル：INFO, WARN, ERROR
- 出力内容：
  - 処理開始・終了時刻
  - 処理対象期間
  - 処理対象レコード数
  - 生成したレポートファイル名
  - エラー内容（発生時）
  - 処理時間

#### 12-8 リトライ設計
- 最大リトライ回数：3回
- リトライ間隔：15分
- リトライ対象エラー：データベース接続エラー、一時的なファイルシステムエラー
- リトライ非対象：データ整合性エラー（開発者の確認が必要）

### 13. 検索キーワード分析バッチ

#### 13-1 機能概要
ユーザーの検索キーワードを分析し、検索精度向上のためのデータを作成する機能。検索キーワードの頻度、検索後の行動パターン、検索結果の適合性などを分析し、検索アルゴリズムの改善に活用する。

#### 13-2 処理フロー
1. 前日の検索ログデータを抽出
2. 以下の観点で分析処理を実行
   - キーワード頻度分析（よく使われる検索ワード）
   - 検索結果クリック率分析（検索結果の適合性）
   - 検索後行動分析（検索後の購入率、カート追加率）
   - ゼロヒット検索分析（検索結果がなかったキーワード）
   - 類義語・同義語分析（似た意味で検索されているキーワード）
3. 分析結果をデータウェアハウスに格納
4. 検索インデックス最適化のためのデータを生成
5. 処理結果をログに出力

#### 13-3 入力データ仕様
- 検索ログテーブル
  - search_id: 検索ID
  - session_id: セッションID
  - user_id: ユーザーID（未ログイン時は匿名ID）
  - keyword: 検索キーワード
  - filter_params: 絞り込み条件（JSONフォーマット）
  - result_count: 検索結果件数
  - search_date: 検索日時
  - device_type: デバイスタイプ

- 検索結果クリックログテーブル
  - click_id: クリックID
  - search_id: 検索ID
  - product_id: 商品ID
  - position: 検索結果での表示位置
  - click_date: クリック日時

- ユーザー行動ログテーブル
  - log_id: ログID
  - user_id: ユーザーID
  - session_id: セッションID
  - action_type: 行動タイプ（商品閲覧、カート追加、購入など）
  - target_id: 対象ID（商品ID、カートIDなど）
  - action_date: 行動日時

#### 13-4 出力データ仕様
- キーワード頻度分析テーブル
  - analysis_date: 分析日
  - keyword: 検索キーワード
  - search_count: 検索回数
  - unique_users: ユニークユーザー数
  - zero_hit_rate: ゼロヒット率

- 検索結果クリック分析テーブル
  - analysis_date: 分析日
  - keyword: 検索キーワード
  - click_through_rate: クリック率
  - avg_click_position: 平均クリック位置
  - conversion_rate: コンバージョン率

- ゼロヒット検索テーブル
  - analysis_date: 分析日
  - keyword: 検索キーワード
  - search_count: 検索回数
  - suggested_mappings: 推奨マッピング（商品カテゴリなど）

- 類義語・同義語テーブル
  - base_keyword: 基本キーワード
  - synonym: 同義語
  - similarity_score: 類似度スコア
  - update_date: 更新日

- 検索インデックス最適化データ
  - keyword_mapping.json: 検索キーワードマッピングファイル
  - synonym_dictionary.json: 同義語辞書ファイル
  - boost_rules.json: 検索結果ブーストルールファイル

#### 13-5 エラー処理
- データ抽出エラー発生時：エラー内容をログに記録し、処理を中断
- 分析処理エラー発生時：エラー内容をログに記録し、該当の分析をスキップして次の分析へ
- データ格納エラー発生時：トランザクションをロールバックし、エラー内容をログに記録

#### 13-6 実行条件
- 実行頻度：日次
- 実行時刻：04:30
- 前提条件：前日の検索ログデータが完全であること

#### 13-7 ログ出力仕様
- ログレベル：INFO, WARN, ERROR
- 出力内容：
  - 処理開始・終了時刻
  - 処理対象日
  - 処理対象検索ログ数
  - 分析テーブルごとの出力件数
  - エラー内容（発生時）
  - 処理時間

#### 13-8 リトライ設計
- 最大リトライ回数：3回
- リトライ間隔：10分
- リトライ対象エラー：データベース接続エラー、一時的なリソース不足エラー
- リトライ非対象：データ整合性エラー、アルゴリズムエラー（開発者の確認が必要）

### 14. データバックアップバッチ

#### 14-1 機能概要
システムデータのバックアップを作成する機能。重要なデータを定期的にバックアップし、システム障害や人為的ミスによるデータ損失からの復旧を可能にする。

#### 14-2 処理フロー
1. バックアップ対象テーブルの特定
2. 以下のバックアップを作成
   - データベース完全バックアップ
   - 重要テーブルの個別バックアップ
   - 設定ファイルのバックアップ
3. バックアップファイルの圧縮
4. バックアップファイルの外部ストレージ（クラウドストレージ）への転送
5. 古いバックアップファイルの削除（保存期間を超えたもの）
6. バックアップ結果の通知
7. 処理結果をログに出力

#### 14-3 入力データ仕様
- バックアップ対象テーブル
  - ユーザーテーブル
  - 注文テーブル
  - 注文詳細テーブル
  - 商品マスタ
  - 在庫テーブル
  - ポイントテーブル
  - その他重要テーブル

- バックアップ設定ファイル
  - backup_config.json: バックアップ設定（対象テーブル、保存期間など）

#### 14-4 出力データ仕様
- データベースバックアップファイル
  - ec_site_full_YYYYMMDD.sql: データベース完全バックアップ

- テーブル別バックアップファイル
  - ec_site_users_YYYYMMDD.sql: ユーザーテーブルバックアップ
  - ec_site_orders_YYYYMMDD.sql: 注文テーブルバックアップ
  - ec_site_products_YYYYMMDD.sql: 商品テーブルバックアップ
  - その他重要テーブルのバックアップ

- 設定ファイルバックアップ
  - ec_site_config_YYYYMMDD.tar.gz: 設定ファイルバックアップ

- バックアップ実行ログ
  - backup_id: バックアップID
  - backup_date: バックアップ日時
  - backup_type: バックアップタイプ（完全/差分）
  - file_path: ファイルパス
  - file_size: ファイルサイズ
  - status: ステータス（成功/失敗）
  - retention_period: 保存期間（日数）

#### 14-5 エラー処理
- バックアップ作成エラー発生時：エラー内容をログに記録し、管理者に通知
- ファイル転送エラー発生時：ローカルにバックアップを保持し、次回バッチで再転送
- 古いファイル削除エラー発生時：エラー内容をログに記録し、管理者に通知

#### 14-6 実行条件
- 実行頻度：日次
- 実行時刻：01:00
- 前提条件：十分なディスク容量があること

#### 14-7 ログ出力仕様
- ログレベル：INFO, WARN, ERROR
- 出力内容：
  - 処理開始・終了時刻
  - バックアップファイル名
  - ファイルサイズ
  - 転送先情報
  - 削除したファイル数
  - エラー内容（発生時）
  - 処理時間

#### 14-8 リトライ設計
- 最大リトライ回数：5回
- リトライ間隔：5分
- リトライ対象エラー：データベース接続エラー、ファイル転送エラー、一時的なディスク容量不足
- リトライ非対象：致命的なシステムエラー（管理者の確認が必要）

### 15. 不要データ削除バッチ

#### 15-1 機能概要
一時データや期限切れデータを削除する機能。システムのパフォーマンス維持と不要なデータによるディスク容量の圧迫を防止するため、定期的にクリーンアップを行う。

#### 15-2 処理フロー
1. 削除対象データの特定
   - 期限切れのセッションデータ（30日以上経過）
   - 期限切れのカートデータ（30日以上放置かつ未購入）
   - 古いアクセスログ（90日以上経過）
   - 古い検索ログ（90日以上経過）
   - 期限切れの一時ファイル
2. 各データ種別に応じて削除処理を実行
3. 削除前にバックアップを作成（必要に応じて）
4. 削除結果の集計
5. 処理結果をログに出力

#### 15-3 入力データ仕様
- セッションテーブル
  - session_id: セッションID
  - user_id: ユーザーID
  - created_date: 作成日時
  - last_access_date: 最終アクセス日時
  - data: セッションデータ（JSONフォーマット）

- カートテーブル
  - cart_id: カートID
  - user_id: ユーザーID
  - created_date: 作成日時
  - last_updated: 最終更新日時
  - status: ステータス（アクティブ/購入済/期限切れ）

- アクセスログテーブル
  - log_id: ログID
  - session_id: セッションID
  - access_date: アクセス日時
  - その他ログ情報

- 検索ログテーブル
  - search_id: 検索ID
  - session_id: セッションID
  - search_date: 検索日時
  - その他検索情報

- 一時ファイルディレクトリ
  - /tmp/ec_site/: 一時ファイル格納ディレクトリ

#### 15-4 出力データ仕様
- 削除ログテーブル
  - deletion_id: 削除ID
  - target_type: 削除対象タイプ（セッション/カート/ログなど）
  - deletion_date: 削除日時
  - record_count: 削除レコード数
  - backup_file: バックアップファイル名（バックアップ作成時）
  - status: ステータス（成功/失敗）

- 削除前バックアップファイル（必要に応じて）
  - ec_site_expired_carts_YYYYMMDD.csv: 期限切れカートデータ
  - ec_site_old_logs_YYYYMMDD.csv: 古いログデータ

#### 15-5 エラー処理
- データ削除エラー発生時：エラー内容をログに記録し、該当のデータ種別をスキップして次の処理へ
- バックアップ作成エラー発生時：管理者に通知し、削除処理を中断
- 一部データの削除失敗時：成功した削除はコミットし、失敗したデータは次回処理

#### 15-6 実行条件
- 実行頻度：週次
- 実行時刻：日曜 02:00
- 前提条件：システム負荷が低い時間帯であること

#### 15-7 ログ出力仕様
- ログレベル：INFO, WARN, ERROR
- 出力内容：
  - 処理開始・終了時刻
  - 各データ種別の削除対象件数
  - 各データ種別の削除成功件数
  - 解放されたディスク容量
  - エラー内容（発生時）
  - 処理時間

#### 15-8 リトライ設計
- 最大リトライ回数：3回
- リトライ間隔：10分
- リトライ対象エラー：データベース接続エラー、一時的なロックエラー
- リトライ非対象：データ整合性エラー（開発者の確認が必要）
