# ECサイト 画面設計書

## 概要・目的

本ドキュメントは、ECサイトのユーザーインターフェースとなる各画面の設計仕様を定義するものです。ECサイトの主要な機能である商品検索・閲覧、会員登録、購入処理、返品・キャンセル処理などの各画面について、表示項目や入力仕様、メッセージ仕様を詳細に記載しています。本設計書は開発者、デザイナー、テスターなど関係者間で共通の認識を持つための基準となります。

## 画面遷移図

```mermaid
graph TD
    TP[トップページ画面] --> SC[商品検索画面]
    TP --> CL[カテゴリ一覧画面]
    TP --> FT[特集ページ画面]
    TP --> RK[ランキング画面]
    TP --> LS[ログイン状態確認画面]
    
    SC --> SR[検索結果一覧画面]
    SR --> PD[商品詳細画面]
    CL --> SR
    FT --> SR
    RK --> PD
    
    PD --> CT[カート画面]
    PD --> FV[お気に入り商品一覧画面]
    PD --> LS
    
    LS --> LG[ログイン画面]
    LS --> RG[会員登録画面]
    LS --> MP[マイページ画面]
    
    RG --> MT[会員特典確認画面]
    RG --> MP
    
    MP --> OH[注文履歴画面]
    MP --> PP[ポイント履歴画面]
    MP --> PF[プロフィール編集画面]
    MP --> AD[配送先住所管理画面]
    MP --> FV
    
    CT --> PU[ポイント利用設定画面]
    PU --> PM[支払い方法選択画面]
    PM --> DS[配送方法選択画面]
    DS --> CF[注文内容確認画面]
    CF --> CP[注文完了画面]
    
    OH --> OD[注文詳細画面]
    OD --> RT[返品申請画面]
    RT --> RS[返送方法選択画面]
    RS --> RC[返金処理状況確認画面]
    RC --> PP
    
    PP --> CP[キャンペーン情報画面]
```

## 各画面詳細

### 1. トップページ画面

#### 1-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| TP-001 | ヘッダーナビゲーション | 常時 | ロゴ、検索バー、カートアイコン、お気に入りアイコン、ログイン/会員登録リンク |
| TP-002 | メインビジュアル | 常時 | 季節やキャンペーンに応じたメインバナー画像 |
| TP-003 | カテゴリナビゲーション | 常時 | 商品カテゴリへのリンク一覧 |
| TP-004 | 特集バナーエリア | 常時 | 季節の特集やテーマ別コレクションへのバナー |
| TP-005 | おすすめ商品一覧 | 常時 | 人気商品のサムネイル画像、商品名、価格 |
| TP-006 | ランキング情報 | 常時 | カテゴリ別や全体の人気商品ランキング |
| TP-007 | 新着商品一覧 | 常時 | 新着商品のサムネイル画像、商品名、価格 |
| TP-008 | フッターナビゲーション | 常時 | 会社情報、お問い合わせ、利用規約等へのリンク |
| TP-009 | パーソナライズ推奨商品 | ログイン時 | ユーザーの閲覧・購買履歴に基づいた商品推奨 |

#### 1-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| TP-101 | 検索キーワード | テキスト | 最大50文字 | 商品検索用のキーワード入力欄 |

#### 1-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| TP-M001 | 「ようこそ、[ユーザー名]さん」 | ログイン時 | 通知 |
| TP-M002 | 「カートに[X]点の商品があります」 | カート内商品あり | 通知 |
| TP-M003 | 「[X]ポイント有効期限が近づいています」 | ポイント期限切れ30日前 | 警告 |

### 2. 商品検索画面

#### 2-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| SC-001 | 検索フォーム | 常時 | キーワード入力欄と検索ボタン |
| SC-002 | オートコンプリート候補 | 入力中 | キーワード入力時に表示される検索候補 |
| SC-003 | 人気検索キーワード | 常時 | よく検索されるキーワードのリスト |
| SC-004 | 検索条件設定エリア | 常時 | 価格帯、カテゴリ、ブランド等の絞り込み条件 |
| SC-005 | 検索履歴 | ログイン時 | ユーザーの過去の検索履歴 |

#### 2-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| SC-101 | 検索キーワード | テキスト | 最大50文字 | 商品検索用のキーワード入力欄 |
| SC-102 | 価格範囲（最低） | 数値 | 0以上の整数 | 価格帯絞り込みの最低価格 |
| SC-103 | 価格範囲（最高） | 数値 | 0以上の整数 | 価格帯絞り込みの最高価格 |
| SC-104 | カテゴリ選択 | チェックボックス | - | 表示するカテゴリの選択 |
| SC-105 | ブランド選択 | チェックボックス | - | 表示するブランドの選択 |
| SC-106 | 色選択 | チェックボックス | - | 表示する色の選択 |
| SC-107 | サイズ選択 | チェックボックス | - | 表示するサイズの選択 |

#### 2-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| SC-M001 | 「検索条件に一致する商品が見つかりませんでした。検索条件を変更してお試しください。」 | 検索結果0件 | エラー |
| SC-M002 | 「検索キーワードを入力してください。」 | 未入力で検索ボタン押下 | エラー |
| SC-M003 | 「[X]件の商品が見つかりました。」 | 検索成功時 | 通知 |

### 3. 検索結果一覧画面

#### 3-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| SR-001 | 検索結果件数 | 常時 | 検索条件に合致した商品の総件数 |
| SR-002 | 検索結果並び替え | 常時 | 人気順、新着順、価格高い順などの並び替えオプション |
| SR-003 | 商品リスト | 常時 | 商品画像、商品名、価格、評価などのリスト |
| SR-004 | 絞り込み条件パネル | 常時 | 価格帯、カテゴリ、ブランドなどの絞り込み条件 |
| SR-005 | ページネーション | 常時 | ページ切り替えのためのナビゲーション |
| SR-006 | パーソナライズ検索結果 | ログイン時 | ユーザーの行動履歴に基づいた検索結果 |

#### 3-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| SR-101 | 並び替え選択 | プルダウン | - | 検索結果の並び替え方法を選択 |
| SR-102 | 表示件数選択 | プルダウン | - | 1ページあたりの表示件数を選択 |
| SR-103 | 絞り込み条件 | チェックボックス | - | 検索結果をさらに絞り込む条件 |
| SR-104 | ページ選択 | ボタン | - | 表示するページを選択 |

#### 3-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| SR-M001 | 「絞り込み条件を適用しました。」 | 絞り込み適用時 | 通知 |
| SR-M002 | 「絞り込み条件に一致する商品が見つかりませんでした。条件を変更してお試しください。」 | 絞り込み後0件 | 警告 |
| SR-M003 | 「[X]件の商品が見つかりました。」 | 検索成功時 | 通知 |

### 4. 商品詳細画面

#### 4-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| PD-001 | 商品画像 | 常時 | 複数の商品画像（メイン画像、サブ画像） |
| PD-002 | 商品名 | 常時 | 商品の名称 |
| PD-003 | 価格情報 | 常時 | 通常価格、セール価格、割引率 |
| PD-004 | サイズ・カラー選択 | 常時 | 購入可能なサイズとカラーの選択肢 |
| PD-005 | 在庫状況 | 常時 | 選択したサイズ・カラーの在庫有無 |
| PD-006 | 数量選択 | 常時 | 購入する数量の選択 |
| PD-007 | 商品説明 | 常時 | 商品の詳細説明文 |
| PD-008 | 素材・サイズ情報 | 常時 | 商品の素材、サイズ詳細情報 |
| PD-009 | お気に入りボタン | 常時 | お気に入りリストへの追加ボタン |
| PD-010 | カートに入れるボタン | 常時 | 商品をカートに追加するボタン |
| PD-011 | レビュー一覧 | 常時 | 他ユーザーのレビューと評価 |
| PD-012 | Q&A一覧 | 常時 | 商品に関する質問と回答 |
| PD-013 | 着用例画像 | 条件付き | 他ユーザーがアップロードした着用画像 |
| PD-014 | ポイント・キャンペーン情報 | 常時 | 購入で獲得できるポイントやキャンペーン情報 |
| PD-015 | 関連商品 | 常時 | この商品を見た人におすすめの関連商品 |
| PD-016 | AI推奨関連商品 | ログイン時 | AIが推奨する個人向け関連商品 |

#### 4-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| PD-101 | サイズ選択 | ラジオボタン | 必須 | 購入するサイズを選択 |
| PD-102 | カラー選択 | ラジオボタン | 必須 | 購入するカラーを選択 |
| PD-103 | 数量選択 | プルダウン | 1以上、在庫数以下 | 購入する数量を選択 |

#### 4-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| PD-M001 | 「カートに追加しました。」 | カート追加成功時 | 通知 |
| PD-M002 | 「サイズとカラーを選択してください。」 | サイズ・カラー未選択でカート追加時 | エラー |
| PD-M003 | 「この商品は現在在庫がありません。」 | 在庫切れ商品 | 警告 |
| PD-M004 | 「お気に入りに追加しました。」 | お気に入り追加成功時 | 通知 |
| PD-M005 | 「お気に入りに追加するにはログインが必要です。」 | 未ログイン時のお気に入り追加 | 警告 |
| PD-M006 | 「選択したサイズ・カラーの組み合わせは在庫がありません。」 | 在庫なしの組み合わせ選択時 | 警告 |

### 5. カート画面

#### 5-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| CT-001 | カート商品リスト | 常時 | カート内の商品一覧（画像、商品名、サイズ、カラー、単価、数量、小計） |
| CT-002 | 数量変更UI | 常時 | 商品ごとの数量変更インターフェース |
| CT-003 | 商品削除ボタン | 常時 | カートから商品を削除するボタン |
| CT-004 | 小計金額 | 常時 | 税抜き商品合計金額 |
| CT-005 | 消費税額 | 常時 | 消費税の金額 |
| CT-006 | 送料 | 常時 | 配送料の金額（条件によって変動） |
| CT-007 | 合計金額 | 常時 | 税込み合計金額 |
| CT-008 | クーポンコード入力欄 | 常時 | クーポンコードを入力するフォーム |
| CT-009 | 獲得予定ポイント | 常時 | 購入で獲得できるポイント数 |
| CT-010 | AI推奨アップセル商品 | ログイン時 | カート内容に基づくアップセル商品提案 |
| CT-011 | 購入手続きへ進むボタン | カート内商品あり | 購入手続きに進むためのボタン |
| CT-012 | ショッピングを続けるリンク | 常時 | 買い物を続けるためのリンク |

#### 5-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| CT-101 | 数量変更 | プルダウン | 1以上、在庫数以下 | 商品の数量を変更 |
| CT-102 | クーポンコード | テキスト | 英数字 | 割引クーポンのコードを入力 |

#### 5-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| CT-M001 | 「カートを更新しました。」 | 数量変更成功時 | 通知 |
| CT-M002 | 「商品をカートから削除しました。」 | 商品削除成功時 | 通知 |
| CT-M003 | 「クーポンを適用しました。[X]円割引されます。」 | クーポン適用成功時 | 通知 |
| CT-M004 | 「入力されたクーポンコードは無効です。」 | 無効なクーポンコード入力時 | エラー |
| CT-M005 | 「カートが空です。商品をお選びください。」 | カートが空の場合 | 通知 |
| CT-M006 | 「あと[X]円のお買い上げで送料無料になります。」 | 送料無料条件に満たない場合 | 通知 |
| CT-M007 | 「この商品の在庫が不足しています。数量を調整してください。」 | 在庫数以上の数量指定時 | エラー |

### 6. ポイント利用設定画面

#### 6-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| PU-001 | 利用可能ポイント | ログイン時 | ユーザーが使用可能なポイント数 |
| PU-002 | ポイント使用スライダー | ログイン時 | 使用するポイント数を調整するスライダー |
| PU-003 | ポイント入力欄 | ログイン時 | 使用するポイント数を直接入力する欄 |
| PU-004 | ポイント使用後金額 | ログイン時 | ポイント適用後の支払金額 |
| PU-005 | ポイント有効期限情報 | ログイン時 | ポイントの有効期限に関する情報 |

#### 6-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| PU-101 | 使用ポイント | スライダー/テキスト | 0以上、保有ポイント以下、1ポイント単位 | 使用するポイント数を指定 |

#### 6-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| PU-M001 | 「[X]ポイントを使用します。」 | ポイント設定時 | 通知 |
| PU-M002 | 「ポイント数は保有ポイント以下にしてください。」 | 保有ポイント以上入力時 | エラー |
| PU-M003 | 「ポイントは1ポイント単位で使用できます。」 | 小数点入力時 | エラー |
| PU-M004 | 「[X]ポイントが間もなく期限切れとなります。」 | 期限切れ間近のポイントがある場合 | 警告 |

### 7. 支払い方法選択画面

#### 7-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| PM-001 | 支払い方法リスト | 常時 | 利用可能な支払い方法の一覧 |
| PM-002 | クレジットカード情報入力フォーム | クレジットカード選択時 | カード番号、有効期限、セキュリティコード入力欄 |
| PM-003 | 登録済みクレジットカード | ログイン時かつ登録済み | 以前に登録したクレジットカード情報 |
| PM-004 | コンビニ決済情報 | コンビニ決済選択時 | コンビニ決済の説明と選択可能なコンビニ一覧 |
| PM-005 | 銀行振込情報 | 銀行振込選択時 | 振込先口座情報と注意事項 |
| PM-006 | 代金引換情報 | 代金引換選択時 | 代引き手数料と注意事項 |
| PM-007 | 次へ進むボタン | 常時 | 配送方法選択画面へ進むボタン |

#### 7-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| PM-101 | 支払い方法選択 | ラジオボタン | 必須 | 支払い方法を選択 |
| PM-102 | クレジットカード番号 | テキスト | 13～19桁の数字 | クレジットカードの番号 |
| PM-103 | 有効期限（月） | プルダウン | 1～12 | カードの有効期限（月） |
| PM-104 | 有効期限（年） | プルダウン | 現在年から10年後まで | カードの有効期限（年） |
| PM-105 | セキュリティコード | テキスト | 3～4桁の数字 | カードのセキュリティコード |
| PM-106 | カード名義人 | テキスト | 英字 | カードの名義人名 |
| PM-107 | カード情報を保存する | チェックボックス | - | 次回以降の利用のためにカード情報を保存 |

#### 7-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| PM-M001 | 「支払い方法を選択してください。」 | 未選択で次へ進む時 | エラー |
| PM-M002 | 「クレジットカード情報が不正です。再度確認してください。」 | カード情報の検証エラー時 | エラー |
| PM-M003 | 「このカードは有効期限が切れています。」 | 有効期限切れのカード入力時 | エラー |
| PM-M004 | 「セキュリティコードは裏面に記載されている3～4桁の番号です。」 | セキュリティコード入力時の説明 | 情報 |
| PM-M005 | 「クレジットカード情報は安全に保管されます。」 | クレジットカード情報入力時 | 情報 |

### 8. 配送方法選択画面

#### 8-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| DS-001 | 配送先住所一覧 | ログイン時 | 登録済みの配送先住所一覧 |
| DS-002 | 新規配送先入力フォーム | 新規配送先選択時 | 氏名、住所、電話番号などの入力フォーム |
| DS-003 | 配送方法一覧 | 常時 | 通常配送、速達、メール便などの選択肢 |
| DS-004 | 配送料金情報 | 常時 | 選択した配送方法の料金 |
| DS-005 | 配送日時指定UI | 配送方法による | 希望配送日と時間帯の選択UI |
| DS-006 | ギフトラッピングオプション | 常時 | ギフトラッピングの有無と種類の選択 |
| DS-007 | 次へ進むボタン | 常時 | 注文内容確認画面へ進むボタン |

#### 8-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| DS-101 | 配送先選択 | ラジオボタン | 必須 | 既存の配送先か新規配送先かを選択 |
| DS-102 | 氏名 | テキスト | 必須、100文字以内 | 配送先の氏名 |
| DS-103 | 郵便番号 | テキスト | 必須、7桁の数字 | 配送先の郵便番号 |
| DS-104 | 都道府県 | プルダウン | 必須 | 配送先の都道府県 |
| DS-105 | 市区町村 | テキスト | 必須、100文字以内 | 配送先の市区町村 |
| DS-106 | 番地・建物名 | テキスト | 必須、200文字以内 | 配送先の番地・建物名 |
| DS-107 | 電話番号 | テキスト | 必須、10～11桁の数字 | 配送先の電話番号 |
| DS-108 | 配送方法選択 | ラジオボタン | 必須 | 配送方法を選択 |
| DS-109 | 配送希望日 | カレンダー | 条件付き | 配送を希望する日付 |
| DS-110 | 配送希望時間帯 | プルダウン | 条件付き | 配送を希望する時間帯 |
| DS-111 | ギフトラッピング | ラジオボタン | - | ギフトラッピングの有無 |
| DS-112 | ラッピング種類 | プルダウン | ラッピング「あり」の場合 | ラッピングの種類を選択 |
| DS-113 | ギフトメッセージ | テキストエリア | 200文字以内 | ギフトに添えるメッセージ |

#### 8-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| DS-M001 | 「配送先情報を入力してください。」 | 必須項目未入力時 | エラー |
| DS-M002 | 「郵便番号が正しくありません。」 | 郵便番号形式不正時 | エラー |
| DS-M003 | 「電話番号が正しくありません。」 | 電話番号形式不正時 | エラー |
| DS-M004 | 「配送方法を選択してください。」 | 配送方法未選択時 | エラー |
| DS-M005 | 「選択された日付は配送指定可能日ではありません。」 | 無効な配送希望日選択時 | エラー |
| DS-M006 | 「ギフトラッピングには追加料金[X]円がかかります。」 | ギフトラッピング選択時 | 情報 |
| DS-M007 | 「住所から郵便番号を自動入力しました。」 | 住所から郵便番号自動入力時 | 通知 |

### 9. 注文内容確認画面

#### 9-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| CF-001 | 注文商品リスト | 常時 | 注文する商品の一覧（画像、商品名、サイズ、カラー、単価、数量、小計） |
| CF-002 | 配送先情報 | 常時 | 選択した配送先の住所情報 |
| CF-003 | 配送方法情報 | 常時 | 選択した配送方法と配送希望日時 |
| CF-004 | 支払い方法情報 | 常時 | 選択した支払い方法の詳細 |
| CF-005 | 小計金額 | 常時 | 税抜き商品合計金額 |
| CF-006 | 消費税額 | 常時 | 消費税の金額 |
| CF-007 | 送料 | 常時 | 配送料の金額 |
| CF-008 | ギフトラッピング料 | ラッピング選択時 | ギフトラッピングの料金 |
| CF-009 | 使用ポイント | ポイント使用時 | 使用するポイント数と割引額 |
| CF-010 | クーポン割引額 | クーポン使用時 | クーポンによる割引額 |
| CF-011 | 合計金額 | 常時 | 税込み最終支払金額 |
| CF-012 | 獲得予定ポイント | 常時 | 購入で獲得できるポイント数 |
| CF-013 | 注文確定ボタン | 常時 | 注文を確定するボタン |
| CF-014 | 注文内容を変更するリンク | 常時 | 前の画面に戻るためのリンク |

#### 9-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| CF-101 | 利用規約同意 | チェックボックス | 必須 | 利用規約とプライバシーポリシーへの同意 |

#### 9-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| CF-M001 | 「注文内容をご確認ください。」 | 常時 | 情報 |
| CF-M002 | 「利用規約とプライバシーポリシーに同意してください。」 | 同意なしで注文確定時 | エラー |
| CF-M003 | 「注文が完了すると、キャンセルはできません。よろしいですか？」 | 注文確定ボタン押下時 | 確認 |
| CF-M004 | 「在庫状況を最終確認しています...」 | 注文処理中 | 情報 |

### 10. 注文完了画面

#### 10-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| CP-001 | 注文完了メッセージ | 常時 | 注文が正常に完了したことを示すメッセージ |
| CP-002 | 注文番号 | 常時 | 発行された注文番号 |
| CP-003 | 注文日時 | 常時 | 注文が確定した日時 |
| CP-004 | 注文商品サマリー | 常時 | 注文した商品の簡易一覧 |
| CP-005 | 合計金額 | 常時 | 確定した支払総額 |
| CP-006 | 配送予定日 | 常時 | 商品の配送予定日 |
| CP-007 | 獲得ポイント | 常時 | 今回の購入で獲得したポイント数 |
| CP-008 | 注文確認メール送信通知 | 常時 | 注文確認メールを送信した旨の通知 |
| CP-009 | マイページへのリンク | 常時 | マイページで注文履歴を確認するためのリンク |
| CP-010 | ショッピングを続けるリンク | 常時 | トップページに戻るためのリンク |

#### 10-2 入力仕様

なし

#### 10-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| CP-M001 | 「ご注文ありがとうございます。注文が正常に完了しました。」 | 常時 | 通知 |
| CP-M002 | 「注文確認メールを[メールアドレス]に送信しました。」 | 常時 | 通知 |
| CP-M003 | 「[X]ポイントが付与されました。」 | 常時 | 通知 |
| CP-M004 | 「お支払い方法によっては、決済完了までお時間がかかる場合があります。」 | コンビニ決済・銀行振込選択時 | 情報 |

### 11. ログイン状態確認画面

#### 11-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| LS-001 | ログイン状態メッセージ | 常時 | 現在のログイン状態を示すメッセージ |
| LS-002 | ログインフォーム | 未ログイン時 | メールアドレス・パスワード入力フォーム |
| LS-003 | SNSログインボタン | 未ログイン時 | 外部SNSアカウントでログインするボタン |
| LS-004 | 会員登録リンク | 未ログイン時 | 新規会員登録へのリンク |
| LS-005 | パスワード忘れリンク | 未ログイン時 | パスワード再設定へのリンク |
| LS-006 | ユーザー情報 | ログイン時 | ログイン中のユーザー情報 |
| LS-007 | マイページリンク | ログイン時 | マイページへのリンク |
| LS-008 | ログアウトボタン | ログイン時 | ログアウトするためのボタン |

#### 11-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| LS-101 | メールアドレス | テキスト | 必須、メール形式 | ログイン用メールアドレス |
| LS-102 | パスワード | パスワード | 必須、8文字以上 | ログイン用パスワード |
| LS-103 | ログイン状態を保持 | チェックボックス | - | ログイン状態を一定期間保持するかどうか |

#### 11-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| LS-M001 | 「ログインしてください。」 | 未ログイン時 | 情報 |
| LS-M002 | 「メールアドレスまたはパスワードが正しくありません。」 | ログイン失敗時 | エラー |
| LS-M003 | 「ようこそ、[ユーザー名]さん」 | ログイン時 | 通知 |
| LS-M004 | 「ログアウトしました。」 | ログアウト後 | 通知 |
| LS-M005 | 「この機能を利用するにはログインが必要です。」 | 未ログイン時の機能制限 | 警告 |

### 12. 会員登録画面

#### 12-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| RG-001 | 登録方法選択 | 常時 | メールアドレス登録かSNS連携登録かの選択 |
| RG-002 | メールアドレス登録フォーム | メールアドレス登録選択時 | メールアドレス、パスワード等の入力フォーム |
| RG-003 | SNSアカウント連携ボタン | SNS連携登録選択時 | 各SNSアカウントでの登録ボタン |
| RG-004 | 利用規約同意チェック | 常時 | 利用規約とプライバシーポリシーへの同意チェック |
| RG-005 | 会員特典情報 | 常時 | 新規会員登録特典の説明 |
| RG-006 | 登録ボタン | 常時 | 会員登録を実行するボタン |
| RG-007 | ログインページリンク | 常時 | 既に会員の方向けのログインページへのリンク |

#### 12-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| RG-101 | 登録方法 | ラジオボタン | 必須 | メールアドレス登録かSNS連携登録かを選択 |
| RG-102 | メールアドレス | テキスト | 必須、メール形式、重複不可 | 登録用メールアドレス |
| RG-103 | パスワード | パスワード | 必須、8文字以上、英数字混在 | 登録用パスワード |
| RG-104 | パスワード（確認） | パスワード | 必須、パスワードと一致 | 確認用パスワード再入力 |
| RG-105 | 氏名 | テキスト | 必須、100文字以内 | 登録者の氏名 |
| RG-106 | 生年月日 | 日付選択 | 任意 | 登録者の生年月日 |
| RG-107 | 性別 | ラジオボタン | 任意 | 登録者の性別 |
| RG-108 | 利用規約同意 | チェックボックス | 必須 | 利用規約とプライバシーポリシーへの同意 |
| RG-109 | メールマガジン購読 | チェックボックス | 任意 | メールマガジンの購読希望 |

#### 12-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| RG-M001 | 「会員登録を受け付けました。認証メールをご確認ください。」 | 登録成功時 | 通知 |
| RG-M002 | 「このメールアドレスは既に登録されています。」 | メールアドレス重複時 | エラー |
| RG-M003 | 「パスワードは8文字以上で、英字と数字を含めてください。」 | パスワード形式不正時 | エラー |
| RG-M004 | 「パスワードと確認用パスワードが一致しません。」 | パスワード不一致時 | エラー |
| RG-M005 | 「必須項目を入力してください。」 | 必須項目未入力時 | エラー |
| RG-M006 | 「利用規約とプライバシーポリシーに同意してください。」 | 同意なしで登録時 | エラー |
| RG-M007 | 「SNSアカウントでの連携登録に成功しました。」 | SNS連携登録成功時 | 通知 |

### 13. 会員特典確認画面

#### 13-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| MT-001 | 会員登録特典ポイント情報 | 常時 | 付与された特典ポイントの詳細 |
| MT-002 | ポイント付与日 | 常時 | ポイントが付与された日付 |
| MT-003 | ポイント有効期限 | 常時 | ポイントの有効期限 |
| MT-004 | 会員特典説明 | 常時 | 会員特典の詳細説明 |
| MT-005 | キャンペーン情報 | 常時 | 現在実施中のキャンペーン情報 |
| MT-006 | マイページへのリンク | 常時 | マイページへ移動するためのリンク |
| MT-007 | ショッピングを始めるリンク | 常時 | 商品閲覧を始めるためのリンク |

#### 13-2 入力仕様

なし

#### 13-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| MT-M001 | 「会員登録特典として[X]ポイントが付与されました！」 | 常時 | 通知 |
| MT-M002 | 「ポイントの有効期限は[日付]までです。」 | 常時 | 情報 |
| MT-M003 | 「初回購入で使える500円クーポンも発行されました！」 | 常時 | 通知 |

### 14. マイページ画面

#### 14-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| MP-001 | ユーザー基本情報 | 常時 | 氏名、会員ランク、登録日などの基本情報 |
| MP-002 | 保有ポイント情報 | 常時 | 現在の保有ポイント数と有効期限 |
| MP-003 | 最近の注文履歴 | 常時 | 直近の注文情報（最大5件） |
| MP-004 | お気に入り商品サマリー | 常時 | お気に入り登録した商品の一部（最大3件） |
| MP-005 | クーポン情報 | クーポン保有時 | 保有しているクーポンの一覧と有効期限 |
| MP-006 | 注文履歴リンク | 常時 | 注文履歴の詳細ページへのリンク |
| MP-007 | お気に入りリンク | 常時 | お気に入り商品一覧ページへのリンク |
| MP-008 | ポイント履歴リンク | 常時 | ポイント履歴ページへのリンク |
| MP-009 | プロフィール編集リンク | 常時 | プロフィール編集ページへのリンク |
| MP-010 | 配送先住所管理リンク | 常時 | 配送先住所管理ページへのリンク |
| MP-011 | パーソナライズレコメンド | 常時 | AIによるパーソナライズされた商品推奨 |

#### 14-2 入力仕様

なし

#### 14-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| MP-M001 | 「ようこそ、[ユーザー名]さん」 | 常時 | 通知 |
| MP-M002 | 「[X]ポイントが間もなく期限切れとなります。」 | 期限切れ間近のポイントがある場合 | 警告 |
| MP-M003 | 「新着のお知らせが[X]件あります。」 | 未読お知らせがある場合 | 通知 |
| MP-M004 | 「[X]件の注文が発送されました。」 | 発送済み未確認の注文がある場合 | 通知 |

### 15. プロフィール編集画面

#### 15-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| PF-001 | 現在のプロフィール情報 | 常時 | 現在登録されているプロフィール情報 |
| PF-002 | 氏名編集フォーム | 常時 | 氏名を編集するフォーム |
| PF-003 | メールアドレス編集フォーム | 常時 | メールアドレスを編集するフォーム |
| PF-004 | パスワード変更リンク | 常時 | パスワード変更ページへのリンク |
| PF-005 | 生年月日編集UI | 常時 | 生年月日を編集するUI |
| PF-006 | 性別選択UI | 常時 | 性別を選択するUI |
| PF-007 | 電話番号編集フォーム | 常時 | 電話番号を編集するフォーム |
| PF-008 | メール配信設定 | 常時 | メールマガジン等の配信設定 |
| PF-009 | 保存ボタン | 常時 | 変更内容を保存するボタン |
| PF-010 | キャンセルボタン | 常時 | 変更をキャンセルするボタン |

#### 15-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| PF-101 | 氏名 | テキスト | 必須、100文字以内 | ユーザーの氏名 |
| PF-102 | メールアドレス | テキスト | 必須、メール形式、重複不可 | 連絡用メールアドレス |
| PF-103 | 生年月日 | 日付選択 | 任意 | ユーザーの生年月日 |
| PF-104 | 性別 | ラジオボタン | 任意 | ユーザーの性別 |
| PF-105 | 電話番号 | テキスト | 必須、10～11桁の数字 | 連絡用電話番号 |
| PF-106 | メールマガジン購読 | チェックボックス | 任意 | メールマガジンの購読希望 |
| PF-107 | セール情報通知 | チェックボックス | 任意 | セール情報の通知希望 |
| PF-108 | 新商品情報通知 | チェックボックス | 任意 | 新商品情報の通知希望 |

#### 15-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| PF-M001 | 「プロフィール情報を更新しました。」 | 更新成功時 | 通知 |
| PF-M002 | 「このメールアドレスは既に使用されています。」 | メールアドレス重複時 | エラー |
| PF-M003 | 「必須項目を入力してください。」 | 必須項目未入力時 | エラー |
| PF-M004 | 「電話番号の形式が正しくありません。」 | 電話番号形式不正時 | エラー |
| PF-M005 | 「変更内容は保存されていません。このページを離れますか？」 | 未保存で画面遷移時 | 確認 |

### 16. 配送先住所管理画面

#### 16-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| AD-001 | 登録済み住所一覧 | 常時 | 登録されている配送先住所の一覧 |
| AD-002 | デフォルト住所表示 | 常時 | 現在のデフォルト配送先住所 |
| AD-003 | 新規住所追加フォーム | 常時 | 新しい住所を追加するためのフォーム |
| AD-004 | 住所編集ボタン | 常時 | 各住所の編集を開始するボタン |
| AD-005 | 住所削除ボタン | 常時 | 住所を削除するボタン |
| AD-006 | デフォルト設定ボタン | 常時 | 選択した住所をデフォルトに設定するボタン |
| AD-007 | 保存ボタン | 編集時 | 編集内容を保存するボタン |
| AD-008 | キャンセルボタン | 編集時 | 編集をキャンセルするボタン |

#### 16-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| AD-101 | 宛名 | テキスト | 必須、100文字以内 | 配送先の宛名 |
| AD-102 | 郵便番号 | テキスト | 必須、7桁の数字 | 配送先の郵便番号 |
| AD-103 | 都道府県 | プルダウン | 必須 | 配送先の都道府県 |
| AD-104 | 市区町村 | テキスト | 必須、100文字以内 | 配送先の市区町村 |
| AD-105 | 番地・建物名 | テキスト | 必須、200文字以内 | 配送先の番地・建物名 |
| AD-106 | 電話番号 | テキスト | 必須、10～11桁の数字 | 配送先の電話番号 |
| AD-107 | 住所名称 | テキスト | 任意、50文字以内 | 住所を識別するための名称（自宅、実家など） |
| AD-108 | デフォルト設定 | チェックボックス | 任意 | この住所をデフォルトに設定するかどうか |

#### 16-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| AD-M001 | 「配送先住所を追加しました。」 | 住所追加成功時 | 通知 |
| AD-M002 | 「配送先住所を更新しました。」 | 住所更新成功時 | 通知 |
| AD-M003 | 「配送先住所を削除しました。」 | 住所削除成功時 | 通知 |
| AD-M004 | 「デフォルト配送先を変更しました。」 | デフォルト変更時 | 通知 |
| AD-M005 | 「必須項目を入力してください。」 | 必須項目未入力時 | エラー |
| AD-M006 | 「郵便番号が正しくありません。」 | 郵便番号形式不正時 | エラー |
| AD-M007 | 「電話番号が正しくありません。」 | 電話番号形式不正時 | エラー |
| AD-M008 | 「この住所を削除してもよろしいですか？」 | 住所削除時 | 確認 |

### 17. ポイント履歴画面

#### 17-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| PP-001 | 現在の保有ポイント | 常時 | 現在使用可能なポイント数 |
| PP-002 | 期限切れ予定ポイント | 常時 | 30日以内に期限切れとなるポイント数と日付 |
| PP-003 | ポイント履歴リスト | 常時 | ポイントの獲得・利用履歴の一覧 |
| PP-004 | 履歴日付 | 常時 | ポイント増減があった日付 |
| PP-005 | 取引内容 | 常時 | ポイント増減の理由（購入、特典、期限切れなど） |
| PP-006 | 増減ポイント | 常時 | 増加または減少したポイント数 |
| PP-007 | 残高ポイント | 常時 | 取引後のポイント残高 |
| PP-008 | 期間指定フィルター | 常時 | 履歴を表示する期間を指定するフィルター |
| PP-009 | ポイント獲得方法案内 | 常時 | ポイントを獲得する方法の説明 |
| PP-010 | ポイント返還状況 | 返品処理後 | 返品に伴うポイント返還の状況 |

#### 17-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| PP-101 | 開始日 | 日付選択 | - | 履歴表示の開始日 |
| PP-102 | 終了日 | 日付選択 | 開始日以降 | 履歴表示の終了日 |
| PP-103 | 取引種別 | プルダウン | - | 表示する取引種別（全て、獲得のみ、利用のみなど） |

#### 17-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| PP-M001 | 「[X]ポイントが間もなく期限切れとなります。」 | 期限切れ間近のポイントがある場合 | 警告 |
| PP-M002 | 「指定期間内の履歴はありません。」 | 期間指定で履歴がない場合 | 情報 |
| PP-M003 | 「終了日は開始日より後の日付を指定してください。」 | 終了日が開始日より前の場合 | エラー |
| PP-M004 | 「返品処理に伴い[X]ポイントが返還されました。」 | ポイント返還処理完了時 | 通知 |

### 18. 注文履歴画面

#### 18-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| OH-001 | 注文履歴リスト | 常時 | 過去の注文一覧 |
| OH-002 | 注文番号 | 常時 | 各注文に割り当てられた注文番号 |
| OH-003 | 注文日 | 常時 | 注文が確定した日付 |
| OH-004 | 注文金額 | 常時 | 注文の合計金額 |
| OH-005 | 注文状況 | 常時 | 注文の現在のステータス（処理中、発送済みなど） |
| OH-006 | 商品サムネイル | 常時 | 注文した商品のサムネイル画像 |
| OH-007 | 詳細表示ボタン | 常時 | 注文の詳細情報を表示するボタン |
| OH-008 | 期間指定フィルター | 常時 | 履歴を表示する期間を指定するフィルター |
| OH-009 | 注文状況フィルター | 常時 | 表示する注文状況を指定するフィルター |
| OH-010 | ページネーション | 常時 | ページ切り替えのためのナビゲーション |

#### 18-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| OH-101 | 開始日 | 日付選択 | - | 履歴表示の開始日 |
| OH-102 | 終了日 | 日付選択 | 開始日以降 | 履歴表示の終了日 |
| OH-103 | 注文状況 | プルダウン | - | 表示する注文状況（全て、処理中、発送済みなど） |

#### 18-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| OH-M001 | 「指定期間内の注文履歴はありません。」 | 期間指定で履歴がない場合 | 情報 |
| OH-M002 | 「終了日は開始日より後の日付を指定してください。」 | 終了日が開始日より前の場合 | エラー |
| OH-M003 | 「[X]件の注文が発送されました。」 | 発送済み未確認の注文がある場合 | 通知 |

### 19. 注文詳細画面

#### 19-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| OD-001 | 注文番号 | 常時 | 注文に割り当てられた注文番号 |
| OD-002 | 注文日 | 常時 | 注文が確定した日付と時刻 |
| OD-003 | 注文状況 | 常時 | 注文の現在のステータス |
| OD-004 | 商品リスト | 常時 | 注文した商品の詳細一覧 |
| OD-005 | 商品画像 | 常時 | 各商品の画像 |
| OD-006 | 商品名 | 常時 | 各商品の名称 |
| OD-007 | 商品オプション | 常時 | サイズ、カラーなどのオプション情報 |
| OD-008 | 単価 | 常時 | 各商品の単価 |
| OD-009 | 数量 | 常時 | 各商品の注文数量 |
| OD-010 | 小計 | 常時 | 各商品の小計金額 |
| OD-011 | 配送先情報 | 常時 | 配送先の住所情報 |
| OD-012 | 配送方法 | 常時 | 選択された配送方法 |
| OD-013 | 支払い方法 | 常時 | 選択された支払い方法 |
| OD-014 | 小計金額 | 常時 | 税抜き商品合計金額 |
| OD-015 | 消費税額 | 常時 | 消費税の金額 |
| OD-016 | 送料 | 常時 | 配送料の金額 |
| OD-017 | 使用ポイント | ポイント使用時 | 使用されたポイント数と割引額 |
| OD-018 | クーポン割引額 | クーポン使用時 | クーポンによる割引額 |
| OD-019 | 合計金額 | 常時 | 税込み最終支払金額 |
| OD-020 | 獲得ポイント | 常時 | 購入で獲得したポイント数 |
| OD-021 | 配送状況トラッキング | 発送後 | 配送状況の追跡情報 |
| OD-022 | 返品・キャンセルボタン | 返品可能期間内 | 返品またはキャンセルを申請するボタン |
| OD-023 | 注文履歴に戻るリンク | 常時 | 注文履歴一覧に戻るためのリンク |

#### 19-2 入力仕様

なし

#### 19-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| OD-M001 | 「この注文は返品・キャンセルの期間を過ぎています。」 | 返品不可期間の場合 | 情報 |
| OD-M002 | 「配送状況を確認するには追跡番号をクリックしてください。」 | 発送済みの場合 | 情報 |
| OD-M003 | 「返品・キャンセルの処理中です。」 | 返品・キャンセル処理中の場合 | 警告 |

### 20. 返品申請画面

#### 20-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| RT-001 | 注文情報サマリー | 常時 | 対象となる注文の基本情報 |
| RT-002 | 返品対象商品リスト | 常時 | 返品可能な商品の一覧 |
| RT-003 | 返品理由選択 | 常時 | 返品理由を選択するドロップダウン |
| RT-004 | 返品理由詳細入力欄 | 常時 | 返品理由の詳細を入力するテキストエリア |
| RT-005 | 返品方法選択 | 常時 | 返送方法（宅配便、店頭返品）の選択肢 |
| RT-006 | 返品ポリシー | 常時 | 返品に関するポリシーと注意事項 |
| RT-007 | 返金方法情報 | 常時 | 返金がどのように行われるかの説明 |
| RT-008 | 申請送信ボタン | 常時 | 返品申請を送信するボタン |
| RT-009 | キャンセルボタン | 常時 | 申請をキャンセルして前の画面に戻るボタン |

#### 20-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| RT-101 | 返品対象商品 | チェックボックス | 1つ以上必須 | 返品する商品を選択 |
| RT-102 | 返品理由 | プルダウン | 必須 | 返品理由を選択（サイズ不適合、商品不良など） |
| RT-103 | 返品理由詳細 | テキストエリア | 必須、500文字以内 | 返品理由の詳細説明 |
| RT-104 | 返送方法 | ラジオボタン | 必須 | 返送方法を選択 |

#### 20-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| RT-M001 | 「返品申請を受け付けました。」 | 申請送信成功時 | 通知 |
| RT-M002 | 「返品対象商品を選択してください。」 | 商品未選択で申請時 | エラー |
| RT-M003 | 「返品理由を選択してください。」 | 理由未選択で申請時 | エラー |
| RT-M004 | 「返品理由の詳細を入力してください。」 | 理由詳細未入力で申請時 | エラー |
| RT-M005 | 「返送方法を選択してください。」 | 返送方法未選択で申請時 | エラー |
| RT-M006 | 「返品申請を送信してもよろしいですか？」 | 申請送信ボタン押下時 | 確認 |

### 21. 返送方法選択画面

#### 21-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| RS-001 | 返品申請サマリー | 常時 | 申請した返品の基本情報 |
| RS-002 | 宅配便返送情報 | 宅配便選択時 | 宅配便での返送方法の詳細説明 |
| RS-003 | 返送用ラベル | 宅配便選択時 | 印刷可能な返送用ラベル |
| RS-004 | 店頭返品情報 | 店頭返品選択時 | 店頭返品の手続き方法と対象店舗一覧 |
| RS-005 | 返送期限 | 常時 | 返送手続きの期限 |
| RS-006 | 注意事項 | 常時 | 返送時の梱包方法などの注意事項 |
| RS-007 | 返金処理の流れ | 常時 | 返品受付から返金までの流れの説明 |
| RS-008 | 戻るボタン | 常時 | 前の画面に戻るためのボタン |

#### 21-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| RS-101 | 店舗選択 | プルダウン | 店頭返品選択時 | 返品する店舗を選択 |

#### 21-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| RS-M001 | 「返送用ラベルをプリントアウトし、商品に同梱してください。」 | 宅配便選択時 | 情報 |
| RS-M002 | 「[日付]までに返送手続きを完了してください。」 | 常時 | 警告 |
| RS-M003 | 「店頭返品の場合、商品と一緒に注文番号をご提示ください。」 | 店頭返品選択時 | 情報 |
| RS-M004 | 「返送ラベルを印刷しました。」 | ラベル印刷時 | 通知 |

### 22. 返金処理状況確認画面

#### 22-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| RC-001 | 返品申請番号 | 常時 | 返品申請に割り当てられた番号 |
| RC-002 | 返品商品情報 | 常時 | 返品対象商品の情報 |
| RC-003 | 返品申請日 | 常時 | 返品を申請した日付 |
| RC-004 | 返品ステータス | 常時 | 返品処理の現在のステータス |
| RC-005 | ステータス履歴 | 常時 | 返品処理の各段階とその日時 |
| RC-006 | 返金予定額 | 常時 | 返金される予定の金額 |
| RC-007 | 返金方法 | 常時 | 返金が行われる方法（元の支払い方法に返金など） |
| RC-008 | 返金予定日 | 返品受付完了後 | 返金が予定されている日付 |
| RC-009 | ポイント返還情報 | ポイント使用時 | 購入時に使用したポイントの返還情報 |
| RC-010 | 問い合わせリンク | 常時 | カスタマーサポートへの問い合わせリンク |
| RC-011 | 注文履歴に戻るリンク | 常時 | 注文履歴一覧に戻るためのリンク |

#### 22-2 入力仕様

なし

#### 22-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| RC-M001 | 「返品商品を確認中です。」 | 返品商品確認中の場合 | 情報 |
| RC-M002 | 「返金処理を実行中です。」 | 返金処理中の場合 | 情報 |
| RC-M003 | 「返金処理が完了しました。」 | 返金完了時 | 通知 |
| RC-M004 | 「返金は[日付]頃に完了予定です。」 | 返金処理中の場合 | 情報 |
| RC-M005 | 「使用したポイントは[X]ポイント返還されます。」 | ポイント使用時 | 情報 |

### 23. お気に入り商品一覧画面

#### 23-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| FV-001 | お気に入り商品リスト | 常時 | お気に入りに登録した商品の一覧 |
| FV-002 | 商品画像 | 常時 | 各商品の画像 |
| FV-003 | 商品名 | 常時 | 各商品の名称 |
| FV-004 | 価格情報 | 常時 | 通常価格、セール価格、割引率 |
| FV-005 | 在庫状況 | 常時 | 商品の在庫有無 |
| FV-006 | 削除ボタン | 常時 | お気に入りから削除するボタン |
| FV-007 | カートに追加ボタン | 在庫あり時 | 商品をカートに追加するボタン |
| FV-008 | 並び替えオプション | 常時 | 登録日順、価格順などの並び替えオプション |
| FV-009 | AI関連商品推奨 | 常時 | お気に入り商品に基づくAI推奨商品 |
| FV-010 | ページネーション | 商品多数時 | ページ切り替えのためのナビゲーション |

#### 23-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| FV-101 | 並び替え選択 | プルダウン | - | お気に入りリストの並び替え方法を選択 |

#### 23-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| FV-M001 | 「商品をお気に入りから削除しました。」 | 削除成功時 | 通知 |
| FV-M002 | 「カートに追加しました。」 | カート追加成功時 | 通知 |
| FV-M003 | 「この商品は現在在庫がありません。」 | 在庫切れ商品 | 警告 |
| FV-M004 | 「お気に入りに登録されている商品はありません。」 | お気に入りが空の場合 | 情報 |
| FV-M005 | 「価格が変更された商品があります。」 | 価格変更商品がある場合 | 警告 |

### 24. キャンペーン情報画面

#### 24-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| CP-001 | キャンペーンバナー | 常時 | キャンペーンのメインビジュアル |
| CP-002 | キャンペーン名 | 常時 | キャンペーンの名称 |
| CP-003 | キャンペーン期間 | 常時 | キャンペーンの実施期間 |
| CP-004 | キャンペーン内容 | 常時 | キャンペーンの詳細説明 |
| CP-005 | 適用条件 | 常時 | キャンペーン適用のための条件 |
| CP-006 | 対象商品リスト | 常時 | キャンペーン対象商品の一覧 |
| CP-007 | クーポンコード | クーポン配布キャンペーン時 | キャンペーン用のクーポンコード |
| CP-008 | クーポン取得ボタン | クーポン配布キャンペーン時 | クーポンを取得するためのボタン |
| CP-009 | 関連キャンペーンリンク | 常時 | 他の実施中キャンペーンへのリンク |
| CP-010 | 商品一覧へのリンク | 常時 | 対象商品一覧ページへのリンク |

#### 24-2 入力仕様

なし

#### 24-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| CP-M001 | 「クーポンを取得しました。」 | クーポン取得成功時 | 通知 |
| CP-M002 | 「このキャンペーンは終了しました。」 | 期間外アクセス時 | 警告 |
| CP-M003 | 「クーポンの利用は1回限りです。」 | クーポン説明時 | 情報 |
| CP-M004 | 「あと[X]日でキャンペーンが終了します。」 | 終了間近の場合 | 警告 |

### 25. 問い合わせフォーム画面

#### 25-1 表示項目一覧

| 項目ID | 項目名 | 表示条件 | 説明 |
|--------|--------|----------|------|
| QF-001 | 問い合わせ種別選択 | 常時 | 問い合わせの種類を選択するドロップダウン |
| QF-002 | 注文番号入力欄 | 常時 | 関連する注文番号を入力する欄 |
| QF-003 | 件名入力欄 | 常時 | 問い合わせの件名を入力する欄 |
| QF-004 | 内容入力欄 | 常時 | 問い合わせ内容を入力するテキストエリア |
| QF-005 | 連絡先情報 | 未ログイン時 | 名前、メールアドレス、電話番号の入力欄 |
| QF-006 | 添付ファイル | 常時 | 画像などのファイルを添付するUI |
| QF-007 | 返信方法選択 | 常時 | 希望する返信方法（メール、電話）の選択 |
| QF-008 | よくある質問リンク | 常時 | よくある質問ページへのリンク |
| QF-009 | 送信ボタン | 常時 | 問い合わせを送信するボタン |

#### 25-2 入力仕様

| 項目ID | 項目名 | 入力形式 | 制約 | 説明 |
|--------|--------|----------|------|------|
| QF-101 | 問い合わせ種別 | プルダウン | 必須 | 問い合わせの種類を選択 |
| QF-102 | 注文番号 | テキスト | 任意、英数字 | 関連する注文の番号 |
| QF-103 | 件名 | テキスト | 必須、100文字以内 | 問い合わせの件名 |
| QF-104 | 内容 | テキストエリア | 必須、3000文字以内 | 問い合わせの詳細内容 |
| QF-105 | 氏名 | テキスト | 未ログイン時必須、100文字以内 | 問い合わせ者の氏名 |
| QF-106 | メールアドレス | テキスト | 未ログイン時必須、メール形式 | 連絡用メールアドレス |
| QF-107 | 電話番号 | テキスト | 任意、10～11桁の数字 | 連絡用電話番号 |
| QF-108 | 添付ファイル | ファイル | 任意、5MB以下、jpg/png/pdf | 問題の説明に必要なファイル |
| QF-109 | 返信方法 | ラジオボタン | 必須 | 希望する返信方法 |

#### 25-3 メッセージ仕様

| メッセージID | メッセージ内容 | 表示条件 | 種類 |
|--------------|----------------|----------|------|
| QF-M001 | 「お問い合わせを受け付けました。」 | 送信成功時 | 通知 |
| QF-M002 | 「必須項目を入力してください。」 | 必須項目未入力時 | エラー |
| QF-M003 | 「メールアドレスの形式が正しくありません。」 | メールアドレス形式不正時 | エラー |
| QF-M004 | 「添付ファイルは5MB以下にしてください。」 | ファイルサイズ超過時 | エラー |
| QF-M005 | 「お問い合わせ内容に対する回答は1～2営業日以内にご連絡いたします。」 | 送信成功時 | 情報 |

以上が、ECサイトの画面設計書です。この設計書に基づいて、ユーザーフレンドリーで機能的なECサイトを構築することができます。各画面は、ユーザーの行動パターンに合わせて設計され、商品検索から購入、アフターサポートまでの一連のプロセスをスムーズに行えるようになっています。