# ECサイトの論理データモデル

以下にECサイトの論理データモデルをmermaid形式で示します。このモデルは添付されたファイルに基づき、システムに必要なエンティティとその関連を表現しています。

```mermaid
erDiagram
    User ||--o{ UserAddress : "登録する"
    User ||--o{ Order : "発注する"
    User ||--o{ Favorite : "登録する"
    User ||--o{ Review : "投稿する"
    User ||--o{ UserPoint : "保有する"
    User ||--o{ UserWearingExample : "投稿する"
    User ||--o{ UserQA : "質問する"
    User ||--o{ UserLoginHistory : "記録する"
    User ||--o{ UserBrowsingHistory : "記録する"
    User ||--o{ UserSearchHistory : "記録する"
    User ||--o{ SNSConnection : "連携する"
    User ||--o{ CreditCard : "登録する"
    
    Product ||--o{ ProductVariant : "持つ"
    Product ||--o{ ProductImage : "持つ"
    Product ||--o{ ProductCategory : "分類される"
    Product ||--o{ Review : "受ける"
    Product ||--o{ Favorite : "登録される"
    Product ||--o{ UserQA : "対象となる"
    Product ||--o{ UserWearingExample : "対象となる"
    Product ||--o{ ProductTag : "持つ"
    Product ||--o{ RelatedProduct : "関連づけられる"
    
    ProductVariant ||--o{ OrderItem : "注文される"
    ProductVariant ||--o{ Inventory : "持つ"
    
    Order ||--o{ OrderItem : "含む"
    Order ||--o{ OrderStatus : "持つ"
    Order ||--o{ Payment : "持つ"
    Order ||--o{ Shipping : "持つ"
    Order ||--o{ OrderCoupon : "適用される"
    Order ||--o{ OrderPointUsage : "使用する"
    Order ||--o{ ReturnRequest : "発生する"
    
    Campaign ||--o{ CampaignProduct : "対象とする"
    Campaign ||--o{ Coupon : "発行する"
    
    Coupon ||--o{ OrderCoupon : "使用される"
    
    PointEvent ||--o{ UserPoint : "発生する"
    Order ||--o{ PointEvent : "発生させる"
    ReturnRequest ||--o{ PointEvent : "発生させる"
    Campaign ||--o{ PointEvent : "発生させる"
    
    Category ||--o{ ProductCategory : "分類する"
    Category ||--o{ SubCategory : "持つ"
    SubCategory ||--o{ ProductCategory : "分類する"
    
    User {
        string userId PK "ユーザーID"
        string email "メールアドレス"
        string passwordHash "パスワードハッシュ"
        string lastName "姓"
        string firstName "名"
        string phoneNumber "電話番号"
        boolean emailVerified "メール認証済みフラグ"
        datetime registrationDate "登録日時"
        datetime lastLoginDate "最終ログイン日時"
        string membershipStatus "会員ステータス"
        boolean receiveMailMagazine "メールマガジン受信フラグ"
        string referralSource "登録経路"
    }
    
    UserAddress {
        string addressId PK "住所ID"
        string userId FK "ユーザーID"
        string addressName "住所名称"
        string recipientName "受取人名"
        string postalCode "郵便番号"
        string prefecture "都道府県"
        string city "市区町村"
        string streetAddress "番地・建物名"
        string phoneNumber "電話番号"
        boolean isDefault "デフォルト住所フラグ"
    }
    
    SNSConnection {
        string connectionId PK "連携ID"
        string userId FK "ユーザーID"
        string snsType "SNS種別"
        string snsUserId "SNSユーザーID"
        datetime connectionDate "連携日時"
        string accessToken "アクセストークン"
        datetime tokenExpireDate "トークン有効期限"
    }
    
    CreditCard {
        string cardId PK "カードID"
        string userId FK "ユーザーID"
        string cardholderName "カード名義"
        string maskedCardNumber "マスクされたカード番号"
        string cardType "カード種別"
        string expiryMonth "有効期限(月)"
        string expiryYear "有効期限(年)"
        boolean isDefault "デフォルトカードフラグ"
        datetime registrationDate "登録日時"
    }
    
    Product {
        string productId PK "商品ID"
        string productName "商品名"
        string brandName "ブランド名"
        text description "商品説明"
        decimal basePrice "基本価格"
        datetime releaseDate "発売日"
        boolean isPublished "公開フラグ"
        string productStatus "商品ステータス"
        text material "素材"
        text careInstructions "お手入れ方法"
        decimal averageRating "平均評価"
        integer reviewCount "レビュー数"
    }
    
    ProductVariant {
        string variantId PK "商品バリエーションID"
        string productId FK "商品ID"
        string color "色"
        string size "サイズ"
        decimal price "価格"
        string sku "SKU"
        boolean isAvailable "利用可能フラグ"
        string imageUrl "バリエーション画像URL"
    }
    
    ProductImage {
        string imageId PK "画像ID"
        string productId FK "商品ID"
        string imageUrl "画像URL"
        integer displayOrder "表示順"
        string imageType "画像種別"
        string altText "代替テキスト"
    }
    
    Category {
        string categoryId PK "カテゴリID"
        string categoryName "カテゴリ名"
        string description "説明"
        integer displayOrder "表示順"
        string imageUrl "カテゴリ画像URL"
    }
    
    SubCategory {
        string subCategoryId PK "サブカテゴリID"
        string categoryId FK "親カテゴリID"
        string subCategoryName "サブカテゴリ名"
        string description "説明"
        integer displayOrder "表示順"
    }
    
    ProductCategory {
        string productCategoryId PK "商品カテゴリID"
        string productId FK "商品ID"
        string categoryId FK "カテゴリID"
        string subCategoryId FK "サブカテゴリID"
    }
    
    ProductTag {
        string tagId PK "タグID"
        string productId FK "商品ID"
        string tagName "タグ名"
    }
    
    RelatedProduct {
        string relatedId PK "関連ID"
        string productId FK "商品ID"
        string relatedProductId FK "関連商品ID"
        string relationType "関連タイプ"
        integer displayOrder "表示順"
    }
    
    Inventory {
        string inventoryId PK "在庫ID"
        string variantId FK "商品バリエーションID"
        integer stockQuantity "在庫数量"
        integer reservedQuantity "予約済数量"
        integer reorderLevel "再発注レベル"
        datetime lastRestockDate "最終入荷日"
        datetime estimatedRestockDate "入荷予定日"
        string warehouseLocation "倉庫ロケーション"
    }
    
    Favorite {
        string favoriteId PK "お気に入りID"
        string userId FK "ユーザーID"
        string productId FK "商品ID"
        datetime addedDate "追加日時"
    }
    
    Review {
        string reviewId PK "レビューID"
        string userId FK "ユーザーID"
        string productId FK "商品ID"
        string orderId FK "注文ID"
        integer rating "評価"
        text comment "コメント"
        datetime reviewDate "レビュー日時"
        boolean isVerifiedPurchase "購入確認済みフラグ"
        boolean isPublished "公開フラグ"
        integer helpfulCount "役立った数"
    }
    
    UserWearingExample {
        string exampleId PK "着用例ID"
        string userId FK "ユーザーID"
        string productId FK "商品ID"
        string imageUrl "画像URL"
        text comment "コメント"
        datetime postDate "投稿日時"
        boolean isApproved "承認済みフラグ"
        string userHeight "ユーザー身長"
        string userWeight "ユーザー体重"
        string wornSize "着用サイズ"
    }
    
    UserQA {
        string qaId PK "Q&A ID"
        string productId FK "商品ID"
        string userId FK "質問ユーザーID"
        text question "質問内容"
        datetime questionDate "質問日時"
        text answer "回答内容"
        string answeredBy "回答者"
        datetime answerDate "回答日時"
        boolean isPublished "公開フラグ"
    }
    
    Order {
        string orderId PK "注文ID"
        string userId FK "ユーザーID"
        datetime orderDate "注文日時"
        decimal subtotal "小計"
        decimal shippingFee "送料"
        decimal tax "税額"
        decimal discount "割引額"
        decimal totalAmount "合計金額"
        string orderNotes "注文メモ"
        string deviceInfo "注文デバイス情報"
        string referralSource "注文経路"
    }
    
    OrderItem {
        string orderItemId PK "注文商品ID"
        string orderId FK "注文ID"
        string variantId FK "商品バリエーションID"
        integer quantity "数量"
        decimal unitPrice "単価"
        decimal subtotal "小計"
        string itemStatus "商品ステータス"
    }
    
    OrderStatus {
        string statusId PK "ステータスID"
        string orderId FK "注文ID"
        string status "ステータス"
        datetime statusDate "ステータス日時"
        string statusReason "ステータス理由"
        string updatedBy "更新者"
    }
    
    Payment {
        string paymentId PK "支払いID"
        string orderId FK "注文ID"
        string paymentMethod "支払い方法"
        decimal amount "支払い金額"
        string paymentStatus "支払いステータス"
        datetime paymentDate "支払い日時"
        string transactionId "取引ID"
        string cardId FK "カードID"
    }
    
    Shipping {
        string shippingId PK "配送ID"
        string orderId FK "注文ID"
        string addressId FK "配送先住所ID"
        string shippingMethod "配送方法"
        datetime estimatedDeliveryDate "配送予定日"
        string trackingNumber "追跡番号"
        string shippingStatus "配送ステータス"
        datetime shippedDate "発送日"
        datetime deliveredDate "配達完了日"
        string carrierName "配送業者名"
    }
    
    ReturnRequest {
        string returnId PK "返品ID"
        string orderId FK "注文ID"
        string userId FK "ユーザーID"
        datetime requestDate "申請日時"
        string returnReason "返品理由"
        string returnMethod "返送方法"
        string returnStatus "返品ステータス"
        datetime processingDate "処理日時"
        decimal refundAmount "返金額"
        text adminNotes "管理者メモ"
    }
    
    ReturnItem {
        string returnItemId PK "返品商品ID"
        string returnId FK "返品ID"
        string orderItemId FK "注文商品ID"
        integer quantity "数量"
        string itemCondition "商品状態"
        text returnReason "返品理由"
    }
    
    Campaign {
        string campaignId PK "キャンペーンID"
        string campaignName "キャンペーン名"
        text description "説明"
        datetime startDate "開始日時"
        datetime endDate "終了日時"
        string campaignType "キャンペーンタイプ"
        boolean isActive "有効フラグ"
        string targetUserSegment "対象ユーザーセグメント"
        decimal discountRate "割引率"
        decimal discountAmount "割引額"
        integer pointMultiplier "ポイント倍率"
    }
    
    CampaignProduct {
        string campaignProductId PK "キャンペーン商品ID"
        string campaignId FK "キャンペーンID"
        string productId FK "商品ID"
        decimal specialPrice "特別価格"
        integer bonusPoints "ボーナスポイント"
    }
    
    Coupon {
        string couponId PK "クーポンID"
        string campaignId FK "キャンペーンID"
        string couponCode "クーポンコード"
        string couponType "クーポンタイプ"
        decimal discountRate "割引率"
        decimal discountAmount "割引額"
        decimal minimumPurchase "最低購入金額"
        datetime validFrom "有効開始日時"
        datetime validTo "有効終了日時"
        integer usageLimit "使用制限回数"
        integer usageCount "使用回数"
        string applicableProducts "適用商品範囲"
    }
    
    OrderCoupon {
        string orderCouponId PK "注文クーポンID"
        string orderId FK "注文ID"
        string couponId FK "クーポンID"
        decimal discountAmount "割引額"
    }
    
    PointEvent {
        string pointEventId PK "ポイントイベントID"
        string eventType "イベントタイプ"
        string relatedId "関連ID"
        string description "説明"
        integer points "ポイント数"
        datetime expiryDate "有効期限"
    }
    
    UserPoint {
        string userPointId PK "ユーザーポイントID"
        string userId FK "ユーザーID"
        string pointEventId FK "ポイントイベントID"
        integer pointsEarned "獲得ポイント"
        integer pointsUsed "使用ポイント"
        integer pointsBalance "ポイント残高"
        datetime transactionDate "取引日時"
        datetime expiryDate "有効期限"
        string transactionType "取引タイプ"
    }
    
    OrderPointUsage {
        string pointUsageId PK "ポイント使用ID"
        string orderId FK "注文ID"
        integer pointsUsed "使用ポイント"
        decimal pointsValue "ポイント価値"
    }
    
    UserLoginHistory {
        string loginHistoryId PK "ログイン履歴ID"
        string userId FK "ユーザーID"
        datetime loginDate "ログイン日時"
        string ipAddress "IPアドレス"
        string deviceInfo "デバイス情報"
        string loginStatus "ログインステータス"
    }
    
    UserBrowsingHistory {
        string browsingId PK "閲覧履歴ID"
        string userId FK "ユーザーID"
        string productId FK "商品ID"
        datetime viewDate "閲覧日時"
        integer viewDuration "閲覧時間"
        string referralPage "参照元ページ"
        string deviceInfo "デバイス情報"
    }
    
    UserSearchHistory {
        string searchId PK "検索履歴ID"
        string userId FK "ユーザーID"
        string searchKeyword "検索キーワード"
        datetime searchDate "検索日時"
        integer resultCount "検索結果数"
        string filterApplied "適用フィルター"
        string sortOrder "ソート順"
    }
    
    Banner {
        string bannerId PK "バナーID"
        string bannerName "バナー名"
        string imageUrl "画像URL"
        string linkUrl "リンクURL"
        string bannerLocation "表示位置"
        integer displayOrder "表示順"
        datetime startDate "表示開始日時"
        datetime endDate "表示終了日時"
        boolean isActive "有効フラグ"
        string targetDevice "対象デバイス"
    }
```

## エンティティの説明

### User (ユーザー)
ECサイトのユーザー情報を管理するエンティティ。会員登録したユーザーの個人情報、認証情報、会員ステータスなどを保持します。メールアドレスによる登録やSNSアカウント連携での登録に対応しています。

### UserAddress (ユーザー住所)
ユーザーの配送先住所情報を管理するエンティティ。複数の配送先を登録でき、デフォルト住所を設定可能です。注文時に選択される配送先として使用されます。

### SNSConnection (SNS連携)
ユーザーのSNSアカウント連携情報を管理するエンティティ。Facebook、Twitter、Googleなどの外部SNSアカウントとの連携情報を保持し、ソーシャルログインを可能にします。

### CreditCard (クレジットカード)
ユーザーが登録したクレジットカード情報を管理するエンティティ。セキュリティ上、カード番号はマスクして保存し、PCI DSS準拠の安全な管理を行います。

### Product (商品)
ECサイトで販売される商品の基本情報を管理するエンティティ。商品名、説明、ブランド、価格などの基本情報を保持します。商品はバリエーション（色・サイズ）を持つことができます。

### ProductVariant (商品バリエーション)
商品の色やサイズなどのバリエーション情報を管理するエンティティ。各バリエーションは独自の価格や在庫を持ち、注文時に選択される実際の商品単位となります。

### ProductImage (商品画像)
商品に関連する画像情報を管理するエンティティ。メイン画像やサブ画像など複数の画像を登録でき、表示順序を指定できます。

### Category (カテゴリ)
商品のメインカテゴリを管理するエンティティ。「メンズ」「レディース」「キッズ」などの大分類として使用されます。

### SubCategory (サブカテゴリ)
カテゴリの下位分類を管理するエンティティ。「トップス」「ボトムス」「アウター」などの中分類として使用されます。

### ProductCategory (商品カテゴリ)
商品とカテゴリ・サブカテゴリの関連付けを管理するエンティティ。一つの商品が複数のカテゴリに属することを可能にします。

### ProductTag (商品タグ)
商品に付与されるタグ情報を管理するエンティティ。「新作」「セール」「限定品」などのタグを商品に付与し、検索や絞り込みに使用します。

### RelatedProduct (関連商品)
商品間の関連付けを管理するエンティティ。「よく一緒に購入される商品」「この商品を見た人はこんな商品も見ています」などの関連商品表示に使用します。

### Inventory (在庫)
商品バリエーションごとの在庫情報を管理するエンティティ。現在の在庫数、予約済数量、再入荷情報などを保持します。

### Favorite (お気に入り)
ユーザーがお気に入り登録した商品情報を管理するエンティティ。ユーザーと商品の関連付けを保存し、お気に入りリスト表示に使用します。

### Review (レビュー)
商品に対するユーザーのレビュー情報を管理するエンティティ。評価点数、コメント、購入確認情報などを保持し、商品詳細ページに表示されます。

### UserWearingExample (ユーザー着用例)
ユーザーが投稿した商品の着用画像や情報を管理するエンティティ。実際の着用イメージや着用感のレビューとして活用されます。

### UserQA (ユーザーQ&A)
商品に関するユーザーからの質問と回答を管理するエンティティ。他のユーザーの購入判断材料として表示されます。

### Order (注文)
ユーザーの注文情報を管理するエンティティ。注文日時、金額情報、配送情報、支払い情報など注文の基本情報を保持します。

### OrderItem (注文商品)
注文に含まれる個々の商品情報を管理するエンティティ。商品バリエーション、数量、単価などの情報を保持します。

### OrderStatus (注文ステータス)
注文の状態と履歴を管理するエンティティ。「注文受付」「支払い完了」「発送準備中」「発送済み」「配達完了」などの状態変化を記録します。

### Payment (支払い)
注文に関連する支払い情報を管理するエンティティ。支払い方法、金額、支払い状態、トランザクション情報などを保持します。

### Shipping (配送)
注文の配送情報を管理するエンティティ。配送先、配送方法、配送状態、追跡番号などの情報を保持します。

### ReturnRequest (返品申請)
商品の返品申請情報を管理するエンティティ。返品理由、返送方法、処理状況、返金情報などを保持します。

### ReturnItem (返品商品)
返品申請に含まれる個々の商品情報を管理するエンティティ。返品対象の商品、数量、状態などの情報を保持します。

### Campaign (キャンペーン)
ECサイトで実施されるキャンペーン情報を管理するエンティティ。期間限定セール、ポイント倍付け、特典付与などのキャンペーン情報を保持します。

### CampaignProduct (キャンペーン対象商品)
キャンペーンの対象となる商品情報を管理するエンティティ。キャンペーン価格やボーナスポイントなどの特典情報を保持します。

### Coupon (クーポン)
ECサイトで使用できるクーポン情報を管理するエンティティ。割引率、割引額、使用条件、有効期限などの情報を保持します。

### OrderCoupon (注文クーポン)
注文時に適用されたクーポン情報を管理するエンティティ。どの注文にどのクーポンが使用され、どれだけ割引されたかを記録します。

### PointEvent (ポイントイベント)
ポイント付与や使用のイベント情報を管理するエンティティ。購入、返品、キャンペーンなどによるポイントの増減イベントを記録します。

### UserPoint (ユーザーポイント)
ユーザーのポイント情報を管理するエンティティ。獲得ポイント、使用ポイント、残高、有効期限などの情報を保持します。

### OrderPointUsage (注文ポイント使用)
注文時に使用されたポイント情報を管理するエンティティ。どの注文にどれだけのポイントが使用されたかを記録します。

### UserLoginHistory (ユーザーログイン履歴)
ユーザーのログイン履歴を管理するエンティティ。セキュリティ監視や行動分析に使用されます。

### UserBrowsingHistory (ユーザー閲覧履歴)
ユーザーの商品閲覧履歴を管理するエンティティ。パーソナライズされた商品推奨やリマーケティングに使用されます。

### UserSearchHistory (ユーザー検索履歴)
ユーザーの検索履歴を管理するエンティティ。検索キーワード、フィルター条件、結果数などを記録し、検索機能の改善やレコメンデーションに使用されます。

### Banner (バナー)
ECサイトに表示されるバナー広告情報を管理するエンティティ。トップページやカテゴリページに表示される広告バナーの画像、リンク、表示期間などを保持します。
