# ECサイト 通知設計書

## 概要・目的

本ドキュメントは、ECサイトにおける各種通知機能の設計を定義するものです。ユーザーに対して適切なタイミングで必要な情報を提供し、ショッピング体験を向上させるとともに、重要な取引情報を確実に伝達することを目的としています。通知は主にメール形式で提供され、ユーザーの行動やシステムイベントに基づいて送信されます。

本設計書では、各通知の種類、送信タイミング、内容テンプレート、処理フロー、および例外処理について詳細に定義しています。これにより、開発チームは一貫性のある通知システムを実装し、ユーザー体験の向上と業務効率化を図ることができます。

## 通知一覧

| 通知名 | 種別 | 説明 | 送信タイミング | 送信先 |
|--------|------|------|--------------|--------|
| 会員登録認証メール | メール | 新規会員登録時のメールアドレス認証用 | 会員登録フォーム送信直後 | 登録メールアドレス |
| 会員登録完了通知 | メール | 会員登録完了の通知と特典案内 | メールアドレス認証完了時 | 登録メールアドレス |
| 注文確認メール | メール | 注文内容の確認と決済情報の通知 | 注文確定・決済処理完了時 | 購入者メールアドレス |
| 発送完了メール | メール | 商品発送完了の通知と配送情報 | 商品発送処理完了時 | 購入者メールアドレス |
| 返金完了通知 | メール | 返品・キャンセルに伴う返金処理の完了通知 | 返金処理完了時 | 購入者メールアドレス |
| ポイント付与通知 | メール | 購入や特典によるポイント付与の通知 | ポイント付与処理完了時 | 会員メールアドレス |
| ポイント失効予告 | メール | 保有ポイントの失効予定の事前通知 | ポイント失効の30日前 | 会員メールアドレス |
| 在庫切れ通知 | メール | お気に入り商品の在庫切れ通知 | 商品在庫が0になった時 | 該当商品をお気に入り登録したユーザー |
| 再入荷通知 | メール | お気に入り商品の再入荷通知 | 在庫切れ商品の入荷時 | 該当商品をお気に入り登録したユーザー |
| カート放置リマインド | メール | カートに商品を追加後、一定時間経過した場合のリマインド | カート追加後24時間経過時 | カート放置ユーザー |
| メールマガジン | メール | キャンペーン情報や新商品情報の定期配信 | 定期配信（週1回）または特別配信 | 配信同意済み会員 |
| 問い合わせ受付確認 | メール | CS問い合わせフォームからの問い合わせ受付確認 | 問い合わせフォーム送信時 | 問い合わせユーザー |

## 各通知詳細

### 1. 会員登録認証メール

#### 1-1 通知テンプレート

```
件名: 【ECサイト】メールアドレス認証のお願い

本文:
──────────────────────────
　　　ECサイト メールアドレス認証
──────────────────────────

{お客様名}様

この度は、ECサイトにご登録いただき誠にありがとうございます。
メールアドレスの認証を完了するために、下記のURLをクリックしてください。

▼メールアドレス認証URL
{認証URL}
（有効期限：24時間）

※上記URLが機能しない場合は、以下のURLにアクセスし、認証コードを入力してください。
認証ページURL: {認証ページURL}
認証コード: {認証コード}

このメールに心当たりがない場合は、お手数ですが本メールを破棄していただきますようお願いいたします。

───────────────────────
ECサイト カスタマーサポート
URL: https://www.ecsite.co.jp
E-mail: support@ecsite.co.jp
電話: 0120-xxx-xxx（平日 10:00〜18:00）
───────────────────────
```

#### 1-2 通知処理フロー

1. ユーザーが会員登録フォームを送信
2. システムがユーザー情報を一時保存
3. 認証用トークンを生成し、有効期限（24時間）を設定
4. 認証URLを生成（認証トークンを含む）
5. メールテンプレートに必要情報を埋め込み
6. メール送信処理を実行
7. 送信結果をログに記録

#### 1-3 例外処理

- メール送信失敗時：
  - 送信失敗をログに記録
  - 最大3回まで再送を試行
  - 3回失敗後、管理者に通知
  - ユーザーには会員登録画面で「メール送信に失敗しました。しばらく経ってから再度お試しください」と表示

- メールアドレス不正時：
  - 会員登録画面でバリデーションエラーを表示
  - 登録処理を中断

- 認証URL有効期限切れ時：
  - 「認証の有効期限が切れています。再度会員登録を行ってください」というページを表示
  - 再認証メール送信ボタンを表示

### 2. 会員登録完了通知

#### 2-1 通知テンプレート

```
件名: 【ECサイト】会員登録完了のお知らせ

本文:
──────────────────────────
　　　ECサイト 会員登録完了
──────────────────────────

{お客様名}様

ECサイトの会員登録が完了しました。
ご登録いただきありがとうございます。

▼会員情報
会員ID: {会員ID}
登録メールアドレス: {登録メールアドレス}

▼新規会員登録特典
会員登録特典として、{特典ポイント}ポイントをプレゼントいたしました！
ポイントの有効期限: {ポイント有効期限}

▼現在開催中のキャンペーン
{キャンペーン情報}

マイページでは、注文履歴の確認やポイント残高の確認、
お気に入り商品の管理などができます。

マイページURL: {マイページURL}

今後ともECサイトをよろしくお願いいたします。

───────────────────────
ECサイト カスタマーサポート
URL: https://www.ecsite.co.jp
E-mail: support@ecsite.co.jp
電話: 0120-xxx-xxx（平日 10:00〜18:00）
───────────────────────
```

#### 2-2 通知処理フロー

1. ユーザーがメールアドレス認証を完了
2. 一時保存していたユーザー情報を本登録
3. 会員IDを発行
4. 会員登録特典ポイントを付与
5. 現在開催中のキャンペーン情報を取得
6. メールテンプレートに必要情報を埋め込み
7. メール送信処理を実行
8. 送信結果をログに記録

#### 2-3 例外処理

- メール送信失敗時：
  - 送信失敗をログに記録
  - 会員登録自体は完了しているため、マイページでメールの再送信機能を提供
  - 管理者に通知

- 特典ポイント付与失敗時：
  - エラーをログに記録
  - バッチ処理で後日付与を試行
  - メール本文内のポイント情報を「特典ポイントは後日付与されます」に変更

- キャンペーン情報取得失敗時：
  - エラーをログに記録
  - メール本文内のキャンペーン情報を「現在準備中です」に変更

### 3. 注文確認メール

#### 3-1 通知テンプレート

```
件名: 【ECサイト】ご注文ありがとうございます（注文番号：{注文番号}）

本文:
──────────────────────────
　　　ECサイト ご注文確認
──────────────────────────

{お客様名}様

この度はECサイトでのご注文ありがとうございます。
ご注文内容を以下にご案内いたします。

▼注文情報
注文番号: {注文番号}
注文日時: {注文日時}
お支払い方法: {お支払い方法}
{お支払い方法に関する詳細情報}

▼配送情報
配送先: 
　{お届け先郵便番号}
　{お届け先住所}
　{お届け先氏名} 様
　{お届け先電話番号}
配送方法: {配送方法}
お届け予定日: {お届け予定日}
お届け時間帯: {お届け時間帯}

▼注文商品
{商品情報テーブル}
商品名 | 単価 | 数量 | 小計
{商品名} | {単価} | {数量} | {小計}
...

▼注文金額
商品合計: {商品合計}円
送料: {送料}円
消費税: {消費税}円
クーポン割引: -{クーポン割引額}円
ポイント利用: -{利用ポイント}ポイント（-{利用ポイント相当額}円）
合計金額: {合計金額}円

▼獲得ポイント
今回の獲得ポイント: {獲得ポイント}ポイント
反映予定日: {ポイント反映予定日}

商品の発送準備が整い次第、発送完了メールをお送りいたします。
なお、注文内容の確認・変更はマイページからも可能です。

マイページURL: {マイページURL}

※商品の在庫状況により、複数回に分けて発送する場合がございます。
※注文のキャンセルをご希望の場合は、商品発送前であればマイページより手続き可能です。

───────────────────────
ECサイト カスタマーサポート
URL: https://www.ecsite.co.jp
E-mail: support@ecsite.co.jp
電話: 0120-xxx-xxx（平日 10:00〜18:00）
───────────────────────
```

#### 3-2 通知処理フロー

1. ユーザーが注文を確定
2. システムが在庫確保と決済処理を実行
3. 注文情報をデータベースに保存
4. 注文番号を発行
5. ポイント計算処理を実行
6. メールテンプレートに必要情報を埋め込み
7. メール送信処理を実行
8. 送信結果をログに記録

#### 3-3 例外処理

- メール送信失敗時：
  - 送信失敗をログに記録
  - 最大3回まで再送を試行
  - 3回失敗後、管理者に通知
  - マイページで注文確認メールの再送機能を提供

- 決済処理失敗時：
  - 注文処理自体を中止
  - エラー内容に応じたエラーメッセージを画面に表示
  - メール送信は行わない

- 在庫確保失敗時：
  - 該当商品の在庫状況を再確認
  - 注文処理自体を中止
  - 「申し訳ございませんが、ご注文の商品が在庫切れとなりました」というエラーメッセージを表示
  - メール送信は行わない

### 4. 発送完了メール

#### 4-1 通知テンプレート

```
件名: 【ECサイト】商品発送のお知らせ（注文番号：{注文番号}）

本文:
──────────────────────────
　　　ECサイト 商品発送のお知らせ
──────────────────────────

{お客様名}様

ECサイトでご注文いただいた商品を発送いたしました。
商品の到着まで今しばらくお待ちください。

▼注文情報
注文番号: {注文番号}
注文日時: {注文日時}

▼発送情報
発送日: {発送日}
配送業者: {配送業者名}
追跡番号: {追跡番号}
追跡URL: {追跡URL}

▼配送先情報
{お届け先郵便番号}
{お届け先住所}
{お届け先氏名} 様
{お届け先電話番号}

▼発送商品
{商品情報テーブル}
商品名 | 数量
{商品名} | {数量}
...

※複数回に分けて発送する場合、残りの商品については別途発送完了メールをお送りいたします。

▼お届け予定
お届け予定日: {お届け予定日}
お届け時間帯: {お届け時間帯}

商品到着後、マイページから商品のレビューを投稿いただけます。
他のお客様のお買い物の参考になりますので、ぜひご協力ください。

マイページURL: {マイページURL}

───────────────────────
ECサイト カスタマーサポート
URL: https://www.ecsite.co.jp
E-mail: support@ecsite.co.jp
電話: 0120-xxx-xxx（平日 10:00〜18:00）
───────────────────────
```

#### 4-2 通知処理フロー

1. 管理者または自動連携システムが商品の発送処理を実行
2. 注文ステータスを「発送済み」に更新
3. 配送業者から追跡番号を取得
4. 発送情報をデータベースに保存
5. メールテンプレートに必要情報を埋め込み
6. メール送信処理を実行
7. 送信結果をログに記録

#### 4-3 例外処理

- メール送信失敗時：
  - 送信失敗をログに記録
  - 最大3回まで再送を試行
  - 3回失敗後、管理者に通知
  - マイページで発送完了メールの再送機能を提供

- 追跡番号取得失敗時：
  - エラーをログに記録
  - メール本文内の追跡番号欄を「準備中」に変更
  - 追跡URLは表示しない

- 一部商品のみ発送時：
  - 発送済み商品のみをメールに記載
  - 「残りの商品については別途発送完了メールをお送りいたします」というメッセージを表示

### 5. 返金完了通知

#### 5-1 通知テンプレート

```
件名: 【ECサイト】返金処理完了のお知らせ（返品番号：{返品番号}）

本文:
──────────────────────────
　　　ECサイト 返金処理完了のお知らせ
──────────────────────────

{お客様名}様

ECサイトをご利用いただきありがとうございます。
返品・キャンセルに伴う返金処理が完了しましたのでお知らせいたします。

▼返品・キャンセル情報
返品番号: {返品番号}
対象注文番号: {注文番号}
申請日: {申請日}
処理完了日: {処理完了日}

▼返金情報
返金方法: {返金方法}
返金金額: {返金金額}円
{返金方法に関する詳細情報}

▼対象商品
{商品情報テーブル}
商品名 | 単価 | 数量 | 小計
{商品名} | {単価} | {数量} | {小計}
...

▼ポイント返還情報
返還ポイント: {返還ポイント}ポイント
※商品購入時に利用されたポイントを返還いたしました。

▼獲得ポイント調整
調整ポイント: -{調整ポイント}ポイント
※商品購入時に獲得したポイントを調整いたしました。

返品・キャンセルの詳細はマイページからもご確認いただけます。
マイページURL: {マイページURL}

今後ともECサイトをよろしくお願いいたします。

───────────────────────
ECサイト カスタマーサポート
URL: https://www.ecsite.co.jp
E-mail: support@ecsite.co.jp
電話: 0120-xxx-xxx（平日 10:00〜18:00）
───────────────────────
```

#### 5-2 通知処理フロー

1. 管理者が返品・キャンセル申請を承認
2. システムが返金処理を実行
3. 返品ステータスを「返金完了」に更新
4. ポイント返還・調整処理を実行
5. メールテンプレートに必要情報を埋め込み
6. メール送信処理を実行
7. 送信結果をログに記録

#### 5-3 例外処理

- メール送信失敗時：
  - 送信失敗をログに記録
  - 最大3回まで再送を試行
  - 3回失敗後、管理者に通知
  - マイページで返金完了通知の再送機能を提供

- 返金処理失敗時：
  - エラーをログに記録
  - 管理者に通知
  - 返品ステータスを「返金処理エラー」に更新
  - メール送信は行わない

- ポイント返還・調整処理失敗時：
  - エラーをログに記録
  - バッチ処理で後日再試行
  - メール本文内のポイント情報を「ポイントの返還・調整は後日処理されます」に変更

### 6. ポイント付与通知

#### 6-1 通知テンプレート

```
件名: 【ECサイト】ポイント付与のお知らせ

本文:
──────────────────────────
　　　ECサイト ポイント付与のお知らせ
──────────────────────────

{お客様名}様

ECサイトをご利用いただきありがとうございます。
ポイントが付与されましたのでお知らせいたします。

▼ポイント情報
付与ポイント: {付与ポイント}ポイント
付与日: {付与日}
ポイント有効期限: {ポイント有効期限}
付与理由: {付与理由}

▼ポイント残高
現在の保有ポイント: {保有ポイント}ポイント

ポイントの詳細はマイページからご確認いただけます。
マイページURL: {マイページURL}

▼ポイントの使い方
・1ポイント＝1円として商品購入時にご利用いただけます
・ポイントは商品合計金額の最大{ポイント上限利用率}%までご利用可能です
・ポイントの有効期限にご注意ください

▼現在開催中のポイントキャンペーン
{ポイントキャンペーン情報}

今後ともECサイトをよろしくお願いいたします。

───────────────────────
ECサイト カスタマーサポート
URL: https://www.ecsite.co.jp
E-mail: support@ecsite.co.jp
電話: 0120-xxx-xxx（平日 10:00〜18:00）
───────────────────────
```

#### 6-2 通知処理フロー

1. 以下のいずれかのイベントが発生
   - 商品購入完了時のポイント付与
   - 会員登録特典ポイント付与
   - キャンペーンによるポイント付与
   - レビュー投稿によるポイント付与
2. ポイント付与処理を実行
3. ポイント履歴をデータベースに記録
4. 現在開催中のポイントキャンペーン情報を取得
5. メールテンプレートに必要情報を埋め込み
6. メール送信処理を実行
7. 送信結果をログに記録

#### 6-3 例外処理

- メール送信失敗時：
  - 送信失敗をログに記録
  - 最大3回まで再送を試行
  - 3回失敗後、管理者に通知
  - マイページでポイント通知の再送機能を提供

- ポイント付与処理失敗時：
  - エラーをログに記録
  - バッチ処理で後日再試行
  - メール送信は処理成功後に行う

- キャンペーン情報取得失敗時：
  - エラーをログに記録
  - メール本文内のキャンペーン情報を「現在準備中です」に変更

### 7. ポイント失効予告

#### 7-1 通知テンプレート

```
件名: 【ECサイト】ポイント失効間近のお知らせ

本文:
──────────────────────────
　　　ECサイト ポイント失効予告
──────────────────────────

{お客様名}様

ECサイトをご利用いただきありがとうございます。
間もなく失効を迎えるポイントがありますのでお知らせいたします。

▼失効予定ポイント
失効予定ポイント: {失効予定ポイント}ポイント
失効日: {失効日}

▼ポイント残高
現在の保有ポイント: {保有ポイント}ポイント

ポイントは有効期限内にご利用ください。
ポイントの詳細はマイページからご確認いただけます。
マイページURL: {マイページURL}

▼おすすめの使い道
{おすすめ商品情報}

▼現在開催中のポイントキャンペーン
{ポイントキャンペーン情報}

今後ともECサイトをよろしくお願いいたします。

───────────────────────
ECサイト カスタマーサポート
URL: https://www.ecsite.co.jp
E-mail: support@ecsite.co.jp
電話: 0120-xxx-xxx（平日 10:00〜18:00）
───────────────────────
```

#### 7-2 通知処理フロー

1. バッチ処理で30日以内に失効するポイントを持つユーザーを抽出
2. ユーザーごとに失効予定ポイント情報を集計
3. ユーザーの購買履歴に基づいたおすすめ商品情報を取得
4. 現在開催中のポイントキャンペーン情報を取得
5. メールテンプレートに必要情報を埋め込み
6. メール送信処理を実行
7. 送信結果をログに記録

#### 7-3 例外処理

- メール送信失敗時：
  - 送信失敗をログに記録
  - 最大3回まで再送を試行
  - 3回失敗後、管理者に通知

- おすすめ商品情報取得失敗時：
  - エラーをログに記録
  - メール本文内のおすすめ商品情報を「新着商品をチェックしてみてください」というメッセージに変更

- キャンペーン情報取得失敗時：
  - エラーをログに記録
  - メール本文内のキャンペーン情報を「現在準備中です」に変更

### 8. 在庫切れ通知

#### 8-1 通知テンプレート

```
件名: 【ECサイト】お気に入り商品の在庫切れのお知らせ

本文:
──────────────────────────
　　　ECサイト 在庫切れのお知らせ
──────────────────────────

{お客様名}様

ECサイトをご利用いただきありがとうございます。
お気に入りに登録されている以下の商品が在庫切れとなりましたのでお知らせいたします。

▼在庫切れ商品
商品名: {商品名}
商品コード: {商品コード}
価格: {価格}円
商品URL: {商品URL}

再入荷をお待ちの場合は、商品ページの「再入荷通知を受け取る」ボタンを
クリックしていただくと、商品が再入荷した際にお知らせメールをお送りいたします。

▼類似商品のご紹介
以下の商品も人気です。ぜひチェックしてみてください。

{類似商品情報}

今後ともECサイトをよろしくお願いいたします。

───────────────────────
ECサイト カスタマーサポート
URL: https://www.ecsite.co.jp
E-mail: support@ecsite.co.jp
電話: 0120-xxx-xxx（平日 10:00〜18:00）
───────────────────────
```

#### 8-2 通知処理フロー

1. 商品の在庫数が0になった時点で検知
2. 該当商品をお気に入り登録しているユーザーを抽出
3. 類似商品情報を取得（AIレコメンデーションシステムを利用）
4. ユーザーごとにメールテンプレートに必要情報を埋め込み
5. メール送信処理を実行
6. 送信結果をログに記録

#### 8-3 例外処理

- メール送信失敗時：
  - 送信失敗をログに記録
  - 最大3回まで再送を試行
  - 3回失敗後、管理者に通知

- 類似商品情報取得失敗時：
  - エラーをログに記録
  - メール本文内の類似商品情報を「新着商品をチェックしてみてください」というメッセージに変更

- お気に入りユーザー多数時（1000人以上）：
  - バッチ処理に切り替え
  - 一度に送信するメール数を制限（1時間あたり300件など）
  - 送信状況を監視し、サーバー負荷に応じて送信速度を調整

### 9. 再入荷通知

#### 9-1 通知テンプレート

```
件名: 【ECサイト】お待たせしました！お気に入り商品が再入荷しました

本文:
──────────────────────────
　　　ECサイト 商品再入荷のお知らせ
──────────────────────────

{お客様名}様

ECサイトをご利用いただきありがとうございます。
お気に入りに登録されている以下の商品が再入荷しましたのでお知らせいたします。

▼再入荷商品
商品名: {商品名}
商品コード: {商品コード}
価格: {価格}円
商品URL: {商品URL}

再入荷商品は在庫に限りがございます。
お早めにご検討ください。

▼その他のおすすめ商品
{おすすめ商品情報}

今後ともECサイトをよろしくお願いいたします。

───────────────────────
ECサイト カスタマーサポート
URL: https://www.ecsite.co.jp
E-mail: support@ecsite.co.jp
電話: 0120-xxx-xxx（平日 10:00〜18:00）
───────────────────────
```

#### 9-2 通知処理フロー

1. 在庫切れ商品の入荷処理が実行された時点で検知
2. 該当商品の再入荷通知を希望しているユーザーを抽出
3. おすすめ商品情報を取得（AIレコメンデーションシステムを利用）
4. ユーザーごとにメールテンプレートに必要情報を埋め込み
5. メール送信処理を実行
6. 送信結果をログに記録
7. 再入荷通知希望リストからユーザーを削除

#### 9-3 例外処理

- メール送信失敗時：
  - 送信失敗をログに記録
  - 最大3回まで再送を試行
  - 3回失敗後、管理者に通知

- おすすめ商品情報取得失敗時：
  - エラーをログに記録
  - メール本文内のおすすめ商品情報を「新着商品をチェックしてみてください」というメッセージに変更

- 再入荷数が通知希望者数より少ない場合：
  - 通知希望登録の古い順にメールを送信
  - 残りのユーザーには「ご希望の商品は再入荷しましたが、ご案内前に完売いたしました」というメールを送信

### 10. カート放置リマインド

#### 10-1 通知テンプレート

```
件名: 【ECサイト】カートに商品が残っています

本文:
──────────────────────────
　　　ECサイト カートの商品について
──────────────────────────

{お客様名}様

ECサイトをご利用いただきありがとうございます。
カートに商品が追加されたままとなっておりますので、お知らせいたします。

▼カート内商品
{商品情報テーブル}
商品名 | 単価 | 数量
{商品名} | {単価} | {数量}
...

カートの商品は、在庫状況により購入できなくなる場合がございます。
ご購入をご検討の場合は、お早めにお手続きください。

▼カートに戻る
{カートURL}

▼クーポンのご案内
今なら初回購入{初回購入割引}%OFFクーポン「{クーポンコード}」をご利用いただけます。
※クーポンの有効期限: {クーポン有効期限}

今後ともECサイトをよろしくお願いいたします。

───────────────────────
ECサイト カスタマーサポート
URL: https://www.ecsite.co.jp
E-mail: support@ecsite.co.jp
電話: 0120-xxx-xxx（平日 10:00〜18:00）
───────────────────────
```

#### 10-2 通知処理フロー

1. バッチ処理で24時間以上カートに商品が放置されているケースを抽出
2. 対象ユーザーに対して、カート内商品情報を取得
3. ユーザーの購入履歴に基づいて適用可能なクーポン情報を取得
4. メールテンプレートに必要情報を埋め込み
5. メール送信処理を実行
6. 送信結果をログに記録

#### 10-3 例外処理

- メール送信失敗時：
  - 送信失敗をログに記録
  - 再送はしない（重要度が低いため）

- カート内商品が在庫切れになっている場合：
  - メール本文に「一部商品は在庫切れとなっております」という注意書きを追加
  - 在庫切れ商品には「在庫切れ」と表示

- クーポン情報取得失敗時：
  - エラーをログに記録
  - メール本文内のクーポン情報を省略

### 11. メールマガジン

#### 11-1 通知テンプレート

```
件名: 【ECサイト】{メルマガタイトル}

本文:
──────────────────────────
　　　ECサイト メールマガジン
──────────────────────────

{お客様名}様

ECサイトをご利用いただきありがとうございます。
今週のおすすめ情報をお届けします。

▼今週のトピックス
{トピックス内容}

▼新着商品のご紹介
{新着商品情報}

▼おすすめ特集
{特集情報}

▼お得なキャンペーン情報
{キャンペーン情報}

▼限定クーポン
今週の限定クーポン: 「{クーポンコード}」
割引内容: {割引内容}
有効期限: {クーポン有効期限}
※クーポンのご利用は会員様限定となります

▼ECサイトをチェック
{サイトURL}

───────────────────────
ECサイト カスタマーサポート
URL: https://www.ecsite.co.jp
E-mail: support@ecsite.co.jp
電話: 0120-xxx-xxx（平日 10:00〜18:00）

※メールマガジンの配信停止をご希望の場合は、
　以下のURLからお手続きください。
　{配信停止URL}
───────────────────────
```

#### 11-2 通知処理フロー

1. 配信スケジュールに基づき、メールマガジン配信処理を開始
2. メールマガジン配信同意済みのユーザーを抽出
3. メールマガジンコンテンツを作成（管理者が事前に準備）
4. ユーザーの購買履歴に基づいたパーソナライズコンテンツを生成（オプション）
5. メールテンプレートに必要情報を埋め込み
6. メール送信処理を実行（大量送信のため分散して実行）
7. 送信結果をログに記録

#### 11-3 例外処理

- メール送信失敗時：
  - 送信失敗をログに記録
  - 再送はしない（定期配信のため）

- パーソナライズコンテンツ生成失敗時：
  - エラーをログに記録
  - 一般的なコンテンツに切り替え

- 配信停止リクエスト受信時：
  - ユーザーの配信設定を即時更新
  - 配信停止完了メールを送信

### 12. 問い合わせ受付確認

#### 12-1 通知テンプレート

```
件名: 【ECサイト】お問い合わせを受け付けました（受付番号：{受付番号}）

本文:
──────────────────────────
　　　ECサイト お問い合わせ受付確認
──────────────────────────

{お客様名}様

ECサイトをご利用いただきありがとうございます。
以下の内容でお問い合わせを受け付けました。

▼お問い合わせ情報
受付番号: {受付番号}
受付日時: {受付日時}
問い合わせ種別: {問い合わせ種別}

▼お問い合わせ内容
{問い合わせ内容}

▼ご回答について
内容を確認の上、{回答予定日数}営業日以内にご回答いたします。
※お問い合わせ内容によっては、回答までにお時間をいただく場合がございます。

▼お問い合わせ履歴の確認
マイページから過去のお問い合わせ履歴や回答状況をご確認いただけます。
マイページURL: {マイページURL}

※このメールは自動送信されています。
　このメールに返信いただいてもお答えできませんのでご了承ください。

───────────────────────
ECサイト カスタマーサポート
URL: https://www.ecsite.co.jp
E-mail: support@ecsite.co.jp
電話: 0120-xxx-xxx（平日 10:00〜18:00）
───────────────────────
```

#### 12-2 通知処理フロー

1. ユーザーがCS問い合わせフォームを送信
2. 問い合わせ内容をデータベースに保存
3. 受付番号を発行
4. 問い合わせ種別に基づいて回答予定日数を設定
5. メールテンプレートに必要情報を埋め込み
6. メール送信処理を実行
7. 送信結果をログに記録

#### 12-3 例外処理

- メール送信失敗時：
  - 送信失敗をログに記録
  - 最大3回まで再送を試行
  - 3回失敗後、管理者に通知
  - 問い合わせ自体はデータベースに保存されているため、対応は継続

- 問い合わせ内容が不適切な場合（自動検知）：
  - 管理者に通知し、確認を依頼
  - 通常の受付確認メールは送信

- 非会員からの問い合わせの場合：
  - マイページURLの代わりに「お問い合わせに対する回答は登録いただいたメールアドレスにお送りいたします」というメッセージを表示
