# ECサイト 非機能要件定義書

## 概要・目的

本文書はECサイトシステムにおける非機能要件を定義するものである。本システムは商品探索から購入、返品までの一連のフローをオンラインで実現し、顧客に快適なショッピング体験を提供することを目的としている。AIレコメンデーションシステムを活用した個人最適化機能を備え、顧客の購買行動や嗜好を分析し、最適な商品提案を行うことで顧客満足度向上と売上増加を図る。

本非機能要件定義書は、システムの可用性、性能・拡張性、運用・保守性、移行性、セキュリティ、環境・エコロジーの観点から要件を定義し、安定的かつ安全なECサイト運営を実現するための指針となる。

### システムの主要機能
- 商品検索・閲覧機能
- 会員登録・管理機能
- カート管理・購入機能
- 返品・キャンセル処理機能
- AIレコメンデーション機能
- ポイント・キャンペーン管理機能

## 可用性

### サービスレベル

| 項目 | 要件 | 備考 |
|------|------|------|
| サービス提供時間 | 24時間365日 | 計画停止を除く |
| 計画停止 | 月1回（深夜1時〜5時） | バッチ処理、メンテナンス等 |
| 稼働率 | 99.9%以上（月間） | 計画停止を除く |
| 目標復旧時間（RTO） | 重大障害時：2時間以内<br>通常障害時：4時間以内 | |
| 目標復旧ポイント（RPO） | 15分以内 | データ損失許容範囲 |

### 障害対策

#### システム冗長化

1. **Webサーバー/APサーバー**
   - 複数サーバーによる冗長構成
   - ロードバランサーによる負荷分散
   - 自動フェイルオーバー機能の実装

2. **データベースサーバー**
   - マスター/スレーブ構成
   - リアルタイムレプリケーション
   - 自動フェイルオーバー機能の実装

3. **ストレージ**
   - RAID構成によるディスク冗長化
   - 定期的なバックアップ

#### バックアップ要件

| バックアップ種別 | 頻度 | 保存期間 | 方式 |
|----------------|------|---------|------|
| フルバックアップ | 日次（深夜） | 30日間 | オフラインストレージ |
| 差分バックアップ | 6時間毎 | 7日間 | オンラインストレージ |
| トランザクションログ | 15分毎 | 24時間 | オンラインストレージ |
| 構成情報 | 変更時 | 最新5世代 | バージョン管理システム |

#### 災害対策

1. **データセンター**
   - 地理的に離れた複数のデータセンターでの運用
   - データセンター間のデータレプリケーション（準リアルタイム）

2. **DR（災害復旧）サイト**
   - メインサイト障害時の切り替え手順の整備
   - 定期的なDR訓練の実施（年2回以上）

### 監視要件

1. **システム監視**
   - サーバーリソース（CPU、メモリ、ディスク）監視
   - ネットワーク監視
   - プロセス監視
   - ログ監視

2. **アプリケーション監視**
   - トランザクション監視
   - エラー監視
   - レスポンスタイム監視
   - 在庫同期状態監視

3. **外部サービス連携監視**
   - 決済サービス連携状況
   - 外部APIの応答監視
   - SNS連携状態監視

4. **アラート体制**
   - 重要度に応じた通知ルートの設定
   - エスカレーションルールの整備
   - 24時間365日の監視体制

## 性能・拡張性

### 性能要件

#### レスポンスタイム

| 処理内容 | 目標値 | 測定条件 |
|---------|-------|---------|
| トップページ表示 | 1.5秒以内 | 95%タイル値 |
| 商品一覧表示 | 2.0秒以内 | 95%タイル値 |
| 商品詳細表示 | 2.0秒以内 | 95%タイル値 |
| 検索結果表示 | 2.5秒以内 | 95%タイル値 |
| カート操作 | 1.0秒以内 | 95%タイル値 |
| 注文確定処理 | 3.0秒以内 | 95%タイル値 |
| AIレコメンド表示 | 2.0秒以内 | 95%タイル値 |

#### スループット

| 処理内容 | 要件 | 備考 |
|---------|------|------|
| 同時接続ユーザー数 | 10,000ユーザー | 通常時 |
| ピーク時同時接続ユーザー数 | 30,000ユーザー | セール時など |
| トランザクション処理数 | 300トランザクション/秒 | ピーク時 |
| 商品検索リクエスト数 | 500リクエスト/秒 | ピーク時 |
| 注文処理数 | 50注文/秒 | ピーク時 |

#### データ量

| データ種別 | 初期データ量 | 年間増加量 | 保存期間 |
|-----------|------------|-----------|---------|
| 商品データ | 100,000件 | 50,000件 | 無期限 |
| 注文データ | 0件 | 1,000,000件 | 無期限 |
| 顧客データ | 0件 | 500,000件 | 無期限（退会後も保持） |
| 行動ログデータ | 0件 | 500GB | 2年間 |
| 画像データ | 500GB | 250GB | 商品販売終了後1年 |

### 拡張性要件

#### スケーラビリティ

1. **水平スケーリング**
   - Webサーバー/APサーバーの動的スケールアウト対応
   - コンテナ技術の活用によるリソース効率化
   - クラウドプラットフォームの活用（Auto Scaling設定）

2. **垂直スケーリング**
   - サーバーリソース（CPU、メモリ）の拡張容易性の確保
   - ストレージ容量の拡張性確保

3. **データベース**
   - シャーディング対応
   - 読み取り負荷分散のためのリードレプリカ構成
   - 将来的なNoSQLデータベース導入の考慮

#### キャパシティ計画

1. **リソースモニタリング**
   - リソース使用率の継続的な監視
   - トレンド分析による将来予測
   - 閾値（70%）到達時の拡張計画実施

2. **負荷テスト**
   - 定期的な負荷テストの実施（四半期ごと）
   - 大規模セール前の事前負荷テスト
   - 実際のアクセスパターンを模した現実的なシナリオ

3. **成長対応**
   - 年間30%のトラフィック増加に対応
   - 3年間の成長を見越したアーキテクチャ設計

### キャッシュ戦略

1. **アプリケーションキャッシュ**
   - 頻繁にアクセスされる商品データのキャッシュ
   - ユーザー別レコメンデーション結果のキャッシュ
   - セッションデータのキャッシュ

2. **CDN活用**
   - 商品画像のCDN配信
   - 静的コンテンツのCDN配信
   - エッジキャッシュの活用

3. **データベースキャッシュ**
   - 読み取り頻度の高いデータのキャッシュ層設置
   - クエリキャッシュの活用

## 運用・保守性

### 運用管理要件

#### システム管理機能

1. **管理画面**
   - 商品管理（登録、編集、削除）
   - 注文管理（確認、ステータス変更、キャンセル処理）
   - 顧客管理（情報確認、編集、対応履歴）
   - キャンペーン管理（設定、実施、効果測定）
   - ポイント管理（付与、調整、履歴確認）
   - 在庫管理（確認、調整、アラート設定）

2. **バッチ管理**
   - バッチジョブのスケジュール設定
   - 実行状況モニタリング
   - エラー発生時の通知・リカバリ

3. **マスタデータ管理**
   - カテゴリ、タグ等のマスタデータメンテナンス
   - CSVインポート/エクスポート機能
   - マスタデータ変更履歴管理

#### ログ管理

1. **ログ種別と保存期間**

   | ログ種別 | 保存期間 | 保存方法 |
   |---------|---------|---------|
   | アクセスログ | 1年間 | 3ヶ月：オンライン<br>1年：アーカイブ |
   | エラーログ | 2年間 | 6ヶ月：オンライン<br>2年：アーカイブ |
   | トランザクションログ | 7年間 | 1年：オンライン<br>7年：アーカイブ |
   | セキュリティログ | 7年間 | 1年：オンライン<br>7年：アーカイブ |
   | 操作ログ（管理者） | 7年間 | 1年：オンライン<br>7年：アーカイブ |

2. **ログフォーマット**
   - 標準化されたログフォーマット採用
   - タイムスタンプ、ユーザーID、IPアドレス、操作内容等の必須項目
   - JSON形式によるログ出力

3. **ログ分析**
   - リアルタイムログ監視
   - ログ集約・分析基盤の整備
   - 異常検知のためのアラート設定

#### バックアップ運用

1. **バックアップ取得スケジュール**
   - 日次フルバックアップ：毎日午前3時
   - 差分バックアップ：6時間ごと
   - トランザクションログ：15分ごと

2. **リストア手順**
   - リストア手順書の整備
   - リストア訓練の定期実施（四半期ごと）
   - 部分リストア、ポイントインタイムリカバリの手順確立

3. **バックアップ検証**
   - バックアップデータの定期検証（月1回）
   - リストア成功率100%の確保

### 保守性要件

#### システム保守

1. **定期メンテナンス**
   - 月1回の定期メンテナンス実施
   - セキュリティパッチ適用
   - ミドルウェアアップデート
   - パフォーマンスチューニング

2. **障害対応**
   - 障害対応フロー整備
   - 一次対応〜復旧までの手順書整備
   - 障害報告書テンプレート整備

3. **変更管理**
   - 変更管理プロセス整備
   - 変更影響範囲の評価手順
   - ロールバック手順の整備

#### 開発環境・テスト環境

1. **環境分離**
   - 開発環境、テスト環境、ステージング環境、本番環境の明確な分離
   - 環境間のデータ連携ルール整備

2. **テスト自動化**
   - 単体テスト、結合テスト、システムテストの自動化
   - 回帰テストの自動実行
   - テスト結果の自動レポート化

3. **CI/CD**
   - 継続的インテグレーション/継続的デリバリーパイプラインの整備
   - コード品質チェック自動化
   - デプロイ自動化

#### ドキュメント管理

1. **システムドキュメント**
   - システム設計書
   - 運用手順書
   - 障害対応マニュアル
   - バックアップ/リストア手順書
   - セキュリティ対応手順書

2. **ユーザーマニュアル**
   - 管理者向けマニュアル
   - 運用担当者向けマニュアル
   - ヘルプデスク向けFAQ

3. **ドキュメント管理ルール**
   - バージョン管理
   - 更新履歴管理
   - 定期レビュー（半年ごと）

## 移行性

### データ移行要件

#### 移行対象データ

| データ種別 | 想定データ量 | 移行方式 | 移行タイミング |
|-----------|------------|---------|--------------|
| 商品データ | 100,000件 | 一括移行 | カットオーバー前 |
| 顧客データ | 500,000件 | 一括移行 | カットオーバー時 |
| 注文履歴データ | 2,000,000件 | 段階的移行 | カットオーバー前〜後 |
| ポイントデータ | 500,000件 | 一括移行 | カットオーバー時 |
| お気に入りデータ | 1,000,000件 | 段階的移行 | カットオーバー前〜後 |

#### 移行方式

1. **データクレンジング**
   - 移行前データの整合性チェック
   - 不整合データの修正ルール策定
   - マスタデータの標準化

2. **データマッピング**
   - 旧システムと新システムのデータ項目マッピング
   - コード体系変換ルールの策定
   - 移行対象外データの特定

3. **移行ツール**
   - ETLツールの活用
   - 移行スクリプトの開発
   - 移行結果検証ツールの開発

#### 移行検証

1. **データ検証**
   - 件数一致確認
   - サンプリング検証
   - 整合性検証

2. **業務検証**
   - 移行後の業務シナリオテスト
   - 顧客影響範囲の検証

3. **リハーサル**
   - 移行リハーサルの実施（2回以上）
   - 本番環境を想定した移行時間計測
   - ロールバック手順の検証

### システム移行要件

#### 移行戦略

1. **移行アプローチ**
   - 段階的カットオーバー方式
   - 機能ごとの移行計画策定
   - 移行期間中の並行運用ルール

2. **カットオーバー計画**
   - カットオーバー時間：深夜（1:00〜5:00）
   - サービス停止告知：2週間前
   - リスク低減策の整備

3. **ロールバック計画**
   - ロールバック判断基準
   - ロールバック実行手順
   - 復旧時間目標：2時間以内

#### 移行体制

1. **移行チーム編成**
   - プロジェクトマネージャー
   - 移行責任者
   - システム担当
   - 業務担当
   - 検証担当
   - ヘルプデスク担当

2. **移行スケジュール**
   - 詳細スケジュール策定
   - マイルストーン設定
   - 進捗管理方法

3. **教育・トレーニング**
   - 管理者向けトレーニング
   - 運用担当者向けトレーニング
   - ヘルプデスク向けトレーニング

## セキュリティ

### 認証・認可

#### ユーザー認証

1. **認証方式**
   - ID/パスワード認証
   - 多要素認証（オプション）
   - SNSアカウント連携認証
   - 認証セッション管理

2. **パスワードポリシー**
   - 最低8文字以上
   - 英大文字、英小文字、数字、特殊文字を含む
   - 過去5回分のパスワード再利用禁止
   - 90日ごとの変更要求（管理者アカウント）

3. **アカウントロック**
   - 連続5回のログイン失敗でロック
   - 30分経過後の自動ロック解除
   - 管理者による手動ロック解除機能

#### アクセス制御

1. **権限管理**
   - ロールベースアクセス制御（RBAC）
   - 最小権限の原則に基づく権限設定
   - 権限変更履歴の保持

2. **管理者権限**
   - 複数レベルの管理者権限
   - 機能別の権限設定
   - 特権アカウント管理

3. **セッション管理**
   - セッションタイムアウト：一般ユーザー30分、管理者15分
   - セッションハイジャック対策
   - 同時ログイン制限（管理者アカウント）

### データ保護

#### 個人情報保護

1. **対象データ**
   - 氏名、住所、電話番号、メールアドレス
   - クレジットカード情報
   - 購買履歴
   - 行動履歴

2. **保護対策**
   - データマスキング
   - アクセスログ記録
   - 目的外利用の禁止
   - 利用規約・プライバシーポリシーの整備

3. **データ管理**
   - 個人情報取扱責任者の設置
   - 定期的な監査実施
   - インシデント対応手順の整備

#### 暗号化要件

1. **通信暗号化**
   - SSL/TLS 1.3以上の採用
   - 強力な暗号スイートの使用
   - 証明書の適切な管理

2. **保存データ暗号化**
   - 個人情報の暗号化保存
   - クレジットカード情報のトークン化
   - 暗号鍵の厳格な管理

3. **暗号化アルゴリズム**
   - 通信：TLS 1.3
   - データベース：AES-256
   - ハッシュ：SHA-256以上

### 脆弱性対策

#### セキュアコーディング

1. **開発ガイドライン**
   - セキュアコーディングガイドラインの整備
   - コードレビュー基準の策定
   - セキュリティテスト項目の標準化

2. **主要な対策**
   - SQLインジェクション対策
   - XSS対策
   - CSRF対策
   - パラメータ改ざん対策

3. **自動チェック**
   - 静的解析ツールの導入
   - 動的解析テストの定期実施
   - 依存ライブラリの脆弱性チェック

#### セキュリティテスト

1. **テスト種別**
   - 脆弱性診断（四半期ごと）
   - ペネトレーションテスト（年1回）
   - コード診断（リリース前）

2. **テスト環境**
   - 本番相当環境でのテスト実施
   - 本番データの匿名化コピーの使用
   - テスト結果の厳格な管理

3. **対応フロー**
   - 発見された脆弱性の重要度判定
   - 修正優先度の決定
   - 修正完了までのトラッキング

### インシデント対応

#### セキュリティインシデント

1. **検知体制**
   - IDS/IPSの導入
   - WAFの導入
   - ログ監視・分析
   - 異常検知の自動化

2. **対応体制**
   - CSIRT（Computer Security Incident Response Team）の設置
   - エスカレーションルートの整備
   - 外部専門家との連携体制

3. **対応手順**
   - 初動対応手順
   - 影響範囲調査手順
   - 復旧手順
   - 再発防止策立案手順

#### 情報開示

1. **顧客通知**
   - 通知基準の策定
   - 通知テンプレートの準備
   - 通知手段の整備

2. **監督官庁報告**
   - 報告基準の明確化
   - 報告フォーマットの準備
   - 報告責任者の指名

3. **公表対応**
   - 公表基準の策定
   - 公表文テンプレートの準備
   - 対外窓口の一本化

## 環境・エコロジー

### グリーンIT

#### 省電力対策

1. **ハードウェア選定**
   - 省電力サーバーの採用
   - 電力効率の高いストレージの採用
   - Energy Star認証取得製品の優先

2. **運用最適化**
   - 負荷に応じたサーバーの動的制御
   - 夜間・低負荷時の省電力モード活用
   - 仮想化技術の積極活用

3. **冷却効率**
   - 効率的なサーバールーム設計
   - 冷却システムの最適化
   - 温度モニタリングの徹底

#### データセンター選定

1. **環境配慮基準**
   - PUE（Power Usage Effectiveness）1.5以下
   - 再生可能エネルギーの活用率30%以上
   - ISO 14001取得施設

2. **省資源対策**
   - 水資源の効率的利用
   - 廃棄物削減策の実施
   - リサイクル率の高さ

3. **立地条件**
   - 自然災害リスクの低さ
   - 電力供給の安定性
   - 冷却に適した気候条件

### 持続可能性

#### ライフサイクル管理

1. **機器調達**
   - 環境負荷の少ない製品の選定
   - サプライチェーンの環境配慮状況確認
   - 長期使用可能な製品の優先

2. **運用期間**
   - 適切な保守による長期利用
   - 部分的な更新による全体寿命延長
   - エネルギー使用効率の定期評価

3. **廃棄処理**
   - 適正なリサイクル・廃棄処理
   - データ消去の徹底
   - 再利用可能部品の活用

#### 紙資源削除

1. **ペーパーレス化**
   - 電子帳票システムの導入
   - 電子契約の活用
   - オンラインマニュアル化

2. **必要書類の最適化**
   - 法的要件を満たす最小限の書類作成
   - 電子保存の活用
   - 印刷設定の最適化

### 環境貢献

#### 環境負荷モニタリング

1. **CO2排出量**
   - システム運用によるCO2排出量の測定
   - 削減目標の設定（年5%削減）
   - 定期的な実績評価

2. **エネルギー消費**
   - 電力使用量の継続的モニタリング
   - 省エネ施策の効果測定
   - エネルギー効率の改善活動

3. **レポーティング**
   - 環境負荷レポートの定期作成
   - ステークホルダーへの情報開示
   - 環境貢献活動の可視化

#### 社会的責任

1. **環境方針**
   - 環境負荷低減に関する方針策定
   - 全従業員への周知徹底
   - 取引先への方針共有

2. **教育・啓発**
   - 環境配慮に関する従業員教育
   - 環境貢献活動への参加促進
   - 好事例の社内共有

3. **地域貢献**
   - 地域の環境活動への参加
   - 環境技術の情報共有
   - 次世代育成への貢献

### 特記事項

1. **AIレコメンデーションシステムの環境配慮**
   - 処理効率の高いアルゴリズム採用によるエネルギー消費抑制
   - 学習処理の低負荷時間帯実行
   - モデルの軽量化による計算リソース削減

2. **顧客への環境配慮啓発**
   - 電子領収書・納品書の推奨
   - 環境に配慮した配送オプションの提供
   - 梱包材削減の取り組み

3. **持続可能なIT利用の推進**
   - クラウドリソースの効率的利用
   - マイクロサービス化による必要最小限のリソース利用
   - 技術的負債の定期的解消による長期運用効率化
